/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.Arrays;
import java.util.Objects;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="virtualMacAddress", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="nativeMacAddress", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT")})
public final class BBacnetVmacEntry
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property virtualMacAddress = BBacnetVmacEntry.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property nativeMacAddress = BBacnetVmacEntry.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetVmacEntry.class);
    private static final int MAX_VMAC_ADDRESS_SIZE = 6;

    @Generated
    public BBacnetOctetString getVirtualMacAddress() {
        return (BBacnetOctetString)this.get(virtualMacAddress);
    }

    @Generated
    public void setVirtualMacAddress(BBacnetOctetString v) {
        this.set(virtualMacAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getNativeMacAddress() {
        return (BBacnetOctetString)this.get(nativeMacAddress);
    }

    @Generated
    public void setNativeMacAddress(BBacnetOctetString v) {
        this.set(nativeMacAddress, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetVmacEntry() {
    }

    public BBacnetVmacEntry(byte[] virtualMac, byte[] nativeMac) {
        Objects.requireNonNull(virtualMac, "virtualMac must not be null");
        Objects.requireNonNull(nativeMac, "nativeMac must not be null");
        if (virtualMac.length > 6) {
            throw new IllegalArgumentException("virtualMac cannot be greater than length 6: " + Arrays.toString(virtualMac));
        }
        this.setVirtualMacAddress(BBacnetOctetString.make(virtualMac));
        this.setNativeMacAddress(BBacnetOctetString.make(nativeMac));
    }

    @Override
    public void writeAsn(AsnOutput out) {
        BBacnetOctetString virtualMacAddress = this.getVirtualMacAddress();
        if (virtualMacAddress.getBytes() == null || virtualMacAddress.length() > 6) {
            throw new IllegalStateException("Invalid virtualMacAddress: " + Arrays.toString(virtualMacAddress.getBytes()));
        }
        BBacnetOctetString nativeMacAddress = this.getNativeMacAddress();
        if (nativeMacAddress.getBytes() == null) {
            throw new IllegalStateException("Invalid nativeMacAddress: " + Arrays.toString(nativeMacAddress.getBytes()));
        }
        out.writeOctetString(0, virtualMacAddress);
        out.writeOctetString(1, nativeMacAddress);
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BBacnetOctetString virtualMacAddress = in.readBacnetOctetString(0);
        if (virtualMacAddress.length() > 6) {
            throw new OutOfRangeException("virtualMacAddress maximum length is 6: " + virtualMacAddress.length());
        }
        BBacnetOctetString nativeMacAddress = in.readBacnetOctetString(1);
        this.set(BBacnetVmacEntry.virtualMacAddress, (BValue)virtualMacAddress, noWrite);
        this.set(BBacnetVmacEntry.nativeMacAddress, (BValue)nativeMacAddress, noWrite);
    }

    public String toString(Context context) {
        return "VMAC: " + this.getVirtualMacAddress().toString(context) + ", Native: " + this.getNativeMacAddress().toString(context);
    }
}

