/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectReference;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetValueSourceChoice;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="choice", type="BBacnetValueSourceChoice", defaultValue="BBacnetValueSourceChoice.none"), @NiagaraProperty(name="object", type="BBacnetDeviceObjectReference", defaultValue="new BBacnetDeviceObjectReference()"), @NiagaraProperty(name="address", type="BBacnetAddress", defaultValue="BBacnetAddress.DEFAULT")})
public class BBacnetValueSource
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetValueSource.newProperty((int)0, (BValue)BBacnetValueSourceChoice.none, null);
    @Generated
    public static final Property object = BBacnetValueSource.newProperty((int)0, (BValue)new BBacnetDeviceObjectReference(), null);
    @Generated
    public static final Property address = BBacnetValueSource.newProperty((int)0, (BValue)BBacnetAddress.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetValueSource.class);

    @Generated
    public BBacnetValueSourceChoice getChoice() {
        return (BBacnetValueSourceChoice)this.get(choice);
    }

    @Generated
    public void setChoice(BBacnetValueSourceChoice v) {
        this.set(choice, (BValue)v, null);
    }

    @Generated
    public BBacnetDeviceObjectReference getObject() {
        return (BBacnetDeviceObjectReference)this.get(object);
    }

    @Generated
    public void setObject(BBacnetDeviceObjectReference v) {
        this.set(object, (BValue)v, null);
    }

    @Generated
    public BBacnetAddress getAddress() {
        return (BBacnetAddress)this.get(address);
    }

    @Generated
    public void setAddress(BBacnetAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetValueSource() {
        this.setChoice(BBacnetValueSourceChoice.none);
    }

    public BBacnetValueSource(BBacnetDeviceObjectReference object) {
        this.setObject((BBacnetDeviceObjectReference)object.newCopy(true));
        this.setChoice(BBacnetValueSourceChoice.object);
    }

    public BBacnetValueSource(BBacnetAddress address) {
        this.setAddress((BBacnetAddress)address.newCopy(true));
        this.setChoice(BBacnetValueSourceChoice.address);
    }

    public BBacnetValueSource(BBacnetDeviceObjectReference object, BBacnetAddress address) {
        this.setObject((BBacnetDeviceObjectReference)object.newCopy(true));
        this.setAddress((BBacnetAddress)address.newCopy(true));
        this.setChoice(BBacnetValueSourceChoice.object);
    }

    public String toString(Context cx) {
        switch (this.getChoice().getOrdinal()) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Object: " + this.getObject().toString(cx);
            }
            case 2: {
                return "Address: " + this.getAddress().toString(cx);
            }
        }
        return "BBacnetValueSource: ???";
    }

    public BValue getValueSource() {
        switch (this.getChoice().getOrdinal()) {
            case 0: {
                return BBacnetNull.DEFAULT;
            }
            case 1: {
                return this.getObject();
            }
            case 2: {
                return this.getAddress();
            }
        }
        throw new IllegalStateException("Invalid choice value: " + (Object)((Object)this.getChoice()));
    }

    public void setValueSource(BValue valueSource) {
        this.setValueSource(valueSource, null);
    }

    public void setValueSource(BValue valueSource, Context cx) {
        if (valueSource == null) {
            this.set(choice, (BValue)BBacnetValueSourceChoice.none, cx);
            return;
        }
        Type type = valueSource.getType();
        if (type == BBacnetNull.TYPE) {
            this.set(choice, (BValue)BBacnetValueSourceChoice.none, cx);
        } else if (type == BBacnetDeviceObjectReference.TYPE) {
            this.set(choice, (BValue)BBacnetValueSourceChoice.object, cx);
            this.set(object, valueSource.newCopy(), cx);
        } else if (type == BBacnetAddress.TYPE) {
            this.set(choice, (BValue)BBacnetValueSourceChoice.address, cx);
            this.set(address, valueSource.newCopy(), cx);
        } else {
            throw new IllegalArgumentException("Invalid type for BBacnetValueSource value: " + type);
        }
    }

    @Override
    public void writeAsn(AsnOutput out) {
        switch (this.getChoice().getOrdinal()) {
            case 0: {
                out.writeNull(0);
                break;
            }
            case 1: {
                out.writeOpeningTag(1);
                this.getObject().writeAsn(out);
                out.writeClosingTag(1);
                break;
            }
            case 2: {
                out.writeOpeningTag(2);
                this.getAddress().writeAsn(out);
                out.writeClosingTag(2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid choice value: " + (Object)((Object)this.getChoice()));
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BStruct value = null;
        int tag = in.peekTag();
        switch (tag) {
            case 0: {
                in.readNull(0);
                break;
            }
            case 1: {
                in.skipOpeningTag(tag);
                value = new BBacnetDeviceObjectReference();
                value.readAsn(in);
                in.skipClosingTag(tag);
                break;
            }
            case 2: {
                in.skipOpeningTag(tag);
                value = new BBacnetAddress();
                value.readAsn(in);
                in.skipClosingTag(tag);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + tag);
            }
        }
        this.setValueSource((BValue)value, noWrite);
    }
}

