/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLightingCommand;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="choice", type="BBacnetTimerStateChangeValueChoice", defaultValue="nullValue"), @NiagaraProperty(name="value", type="BValue", defaultValue="BBacnetNull.DEFAULT"), @NiagaraProperty(name="constructedValueType", type="BTypeSpec", defaultValue="BTypeSpec.NULL")})
public final class BBacnetTimerStateChangeValue
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetTimerStateChangeValue.newProperty((int)0, (BValue)BBacnetTimerStateChangeValueChoice.nullValue, null);
    @Generated
    public static final Property value = BBacnetTimerStateChangeValue.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    @Generated
    public static final Property constructedValueType = BBacnetTimerStateChangeValue.newProperty((int)0, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetTimerStateChangeValue.class);
    private static final int NO_VALUE_TAG = 0;
    private static final int CONSTRUCTED_VALUE_TAG = 1;
    private static final int DATE_TIME_TAG = 2;
    private static final int LIGHTING_COMMAND_TAG = 3;
    private static final Logger logger = Logger.getLogger("bacnet.datatypes");

    @Generated
    public BBacnetTimerStateChangeValueChoice getChoice() {
        return (BBacnetTimerStateChangeValueChoice)this.get(choice);
    }

    @Generated
    public void setChoice(BBacnetTimerStateChangeValueChoice v) {
        this.set(choice, (BValue)v, null);
    }

    @Generated
    public BValue getValue() {
        return this.get(value);
    }

    @Generated
    public void setValue(BValue v) {
        this.set(value, v, null);
    }

    @Generated
    public BTypeSpec getConstructedValueType() {
        return (BTypeSpec)this.get(constructedValueType);
    }

    @Generated
    public void setConstructedValueType(BTypeSpec v) {
        this.set(constructedValueType, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBacnetTimerStateChangeValue make(BValue value) {
        BBacnetTimerStateChangeValue result = new BBacnetTimerStateChangeValue();
        result.updateChoice(value, null);
        result.setValue((BValue)(value != null ? value : BBacnetNull.DEFAULT));
        if (result.getChoice().equals((Object)BBacnetTimerStateChangeValueChoice.constructedValue) && value instanceof BIBacnetDataType) {
            result.setConstructedValueType(value.getType().getTypeSpec());
        }
        return result;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        switch (this.getChoice().getOrdinal()) {
            case 0: {
                out.writeNull();
                break;
            }
            case 1: {
                out.writeBoolean((BBoolean)this.getValue());
                break;
            }
            case 2: {
                out.writeUnsigned((BBacnetUnsigned)this.getValue());
                break;
            }
            case 3: {
                out.writeSignedInteger((BInteger)this.getValue());
                break;
            }
            case 4: {
                out.writeReal((BNumber)((BFloat)this.getValue()));
                break;
            }
            case 5: {
                out.writeDouble((BNumber)((BDouble)this.getValue()));
                break;
            }
            case 6: {
                out.writeOctetString((BBacnetOctetString)this.getValue());
                break;
            }
            case 7: {
                out.writeCharacterString((BString)this.getValue());
                break;
            }
            case 8: {
                out.writeBitString((BBacnetBitString)this.getValue());
                break;
            }
            case 9: {
                out.writeEnumerated((BEnum)this.getValue());
                break;
            }
            case 10: {
                out.writeDate((BBacnetDate)this.getValue());
                break;
            }
            case 11: {
                out.writeTime((BBacnetTime)this.getValue());
                break;
            }
            case 12: {
                out.writeObjectIdentifier((BBacnetObjectIdentifier)this.getValue());
                break;
            }
            case 13: {
                out.writeOpeningTag(0);
                out.writeNull();
                out.writeClosingTag(0);
                break;
            }
            case 14: {
                out.writeEncodedValue(1, AsnUtil.toAsn(-1, this.getValue()));
                break;
            }
            case 15: {
                out.writeOpeningTag(2);
                BBacnetDateTime dateTime = new BBacnetDateTime((BAbsTime)this.getValue());
                dateTime.writeAsn(out);
                out.writeClosingTag(2);
                break;
            }
            case 16: {
                out.writeOpeningTag(3);
                BBacnetLightingCommand lightingCommand = (BBacnetLightingCommand)this.getValue();
                lightingCommand.writeAsn(out);
                out.writeClosingTag(3);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid choice value: " + this.getChoice().getOrdinal());
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        Object value;
        block24: {
            int tag;
            block25: {
                block23: {
                    tag = in.peekTag();
                    if (!in.isApplicationTag(tag)) break block23;
                    switch (tag) {
                        case 0: {
                            value = in.readNull();
                            break block24;
                        }
                        case 1: {
                            value = BBoolean.make((boolean)in.readBoolean());
                            break block24;
                        }
                        case 2: {
                            value = in.readUnsigned();
                            break block24;
                        }
                        case 3: {
                            value = in.readSigned();
                            break block24;
                        }
                        case 4: {
                            value = in.readFloat();
                            break block24;
                        }
                        case 5: {
                            value = BDouble.make((double)in.readDouble());
                            break block24;
                        }
                        case 6: {
                            value = in.readBacnetOctetString();
                            break block24;
                        }
                        case 7: {
                            value = BString.make((String)in.readCharacterString());
                            break block24;
                        }
                        case 8: {
                            value = in.readBitString();
                            break block24;
                        }
                        case 9: {
                            value = BDynamicEnum.make((int)in.readEnumerated());
                            break block24;
                        }
                        case 10: {
                            value = in.readDate();
                            break block24;
                        }
                        case 11: {
                            value = in.readTime();
                            break block24;
                        }
                        case 12: {
                            value = in.readObjectIdentifier();
                            break block24;
                        }
                        default: {
                            throw new AsnException("Invalid tag: " + tag);
                        }
                    }
                }
                if (!in.isOpeningTag(tag)) break block25;
                switch (tag) {
                    case 0: {
                        in.skipTag();
                        in.readNull();
                        in.skipClosingTag(tag);
                        this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.noValue, noWrite);
                        this.set(BBacnetTimerStateChangeValue.value, (BValue)BBacnetNull.DEFAULT, noWrite);
                        return;
                    }
                    case 1: {
                        BValue constructed = this.makeConstructedInstance();
                        if (constructed != null) {
                            in.skipTag();
                            ((BIBacnetDataType)constructed).readAsn(in);
                            in.skipClosingTag(tag);
                            value = constructed;
                        } else {
                            byte[] bytes = in.readEncodedValue(1);
                            value = AsnUtil.asnToValue(bytes);
                        }
                        break block24;
                    }
                    case 2: {
                        BBacnetDateTime dateTimeValue = new BBacnetDateTime();
                        in.skipTag();
                        dateTimeValue.readAsn(in);
                        in.skipClosingTag(tag);
                        value = dateTimeValue.toBAbsTime();
                        break block24;
                    }
                    case 3: {
                        value = new BBacnetLightingCommand();
                        in.skipTag();
                        ((BIBacnetDataType)value).readAsn(in);
                        in.skipClosingTag(tag);
                        break block24;
                    }
                    default: {
                        throw new AsnException("Invalid tag: " + tag);
                    }
                }
            }
            throw new AsnException("Invalid tag: " + tag);
        }
        this.updateChoice((BValue)value, noWrite);
        this.set(BBacnetTimerStateChangeValue.value, (BValue)value, noWrite);
    }

    private BValue makeConstructedInstance() {
        BTypeSpec constructedValueType = this.getConstructedValueType();
        if (constructedValueType.isNull()) {
            return null;
        }
        try {
            BObject object = constructedValueType.getInstance();
            if (object instanceof BIBacnetDataType) {
                return (BValue)object;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BBacnetTimerStateChangeValue: Type is not a BIBacnetDataType: " + constructedValueType);
            }
            return null;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "BBacnetTimerStateChangeValue: Could not create instance of type " + constructedValueType, e);
            }
            return null;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isMounted() || !this.isRunning()) {
            return;
        }
        if (property.equals(value)) {
            try {
                this.updateChoice(this.getValue(), context);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "BBacnetTimerStateChangeValue value property changed to unsupported type: " + this.getValue().getType(), logger.isLoggable(Level.FINE) ? e : null);
            }
        } else if (property.equals(choice)) {
            switch (this.getChoice().getOrdinal()) {
                case 0: {
                    this.set(value, (BValue)BBacnetNull.DEFAULT, context);
                    break;
                }
                case 1: {
                    this.set(value, (BValue)BBoolean.DEFAULT, context);
                    break;
                }
                case 2: {
                    this.set(value, (BValue)BBacnetUnsigned.DEFAULT, context);
                    break;
                }
                case 3: {
                    this.set(value, (BValue)BInteger.DEFAULT, context);
                    break;
                }
                case 4: {
                    this.set(value, (BValue)BFloat.DEFAULT, context);
                    break;
                }
                case 5: {
                    this.set(value, (BValue)BDouble.DEFAULT, context);
                    break;
                }
                case 6: {
                    this.set(value, (BValue)BBacnetOctetString.DEFAULT, context);
                    break;
                }
                case 7: {
                    this.set(value, (BValue)BString.DEFAULT, context);
                    break;
                }
                case 8: {
                    this.set(value, (BValue)BBacnetBitString.DEFAULT, context);
                    break;
                }
                case 9: {
                    this.set(value, (BValue)BDynamicEnum.DEFAULT, context);
                    break;
                }
                case 10: {
                    this.set(value, (BValue)BBacnetDate.DEFAULT, context);
                    break;
                }
                case 11: {
                    this.set(value, (BValue)BBacnetTime.DEFAULT, context);
                    break;
                }
                case 12: {
                    this.set(value, (BValue)BBacnetObjectIdentifier.DEFAULT, context);
                    break;
                }
                case 13: {
                    this.set(value, (BValue)BBacnetNull.DEFAULT, context);
                    break;
                }
                case 14: {
                    BValue constructed = this.makeConstructedInstance();
                    this.set(value, (BValue)(constructed != null ? constructed : new BComponent()), context);
                    break;
                }
                case 15: {
                    this.set(value, (BValue)new BBacnetDateTime().toBAbsTime(), context);
                    break;
                }
                case 16: {
                    this.set(value, (BValue)new BBacnetLightingCommand(), context);
                    break;
                }
                default: {
                    logger.warning("Unknown timer state change choice: " + (Object)((Object)this.getChoice()));
                    break;
                }
            }
        } else if (property.equals(constructedValueType) && this.getChoice().equals((Object)BBacnetTimerStateChangeValueChoice.constructedValue)) {
            BValue constructed = this.makeConstructedInstance();
            this.set(value, (BValue)(constructed != null ? constructed : new BComponent()), context);
        }
    }

    private void updateChoice(BValue value, Context context) {
        if (value == null) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.noValue, context);
            return;
        }
        Type type = value.getType();
        if (type == BBacnetNull.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.nullValue, context);
        } else if (type == BBoolean.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.booleanValue, context);
        } else if (type == BBacnetUnsigned.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.unsigned, context);
        } else if (type == BInteger.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.integer, context);
        } else if (type == BFloat.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.real, context);
        } else if (type == BDouble.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.doubleValue, context);
        } else if (type == BBacnetOctetString.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.octetString, context);
        } else if (type == BString.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.characterString, context);
        } else if (type == BBacnetBitString.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.bitString, context);
        } else if (type.is(BEnum.TYPE)) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.enumerated, context);
        } else if (type == BBacnetDate.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.date, context);
        } else if (type == BBacnetTime.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.time, context);
        } else if (type == BBacnetObjectIdentifier.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.objectIdentifier, context);
        } else if (type == BAbsTime.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.dateTime, context);
        } else if (type == BBacnetLightingCommand.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.lightingCommand, context);
        } else if (type.is(BIBacnetDataType.TYPE) || type == BComponent.TYPE) {
            this.set(choice, (BValue)BBacnetTimerStateChangeValueChoice.constructedValue, context);
        } else {
            throw new IllegalArgumentException("Invalid type for BBacnetTimerStateChange value: " + type);
        }
    }
}

