/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetHostNPort;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectionState", type="BBacnetScConnectionState", defaultValue="BBacnetScConnectionState.notConnected"), @NiagaraProperty(name="connectTimestamp", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="disconnectTimestamp", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="peerAddress", type="BBacnetHostNPort", defaultValue="new BBacnetHostNPort()"), @NiagaraProperty(name="peerVmac", type="BBacnetOctetString", defaultValue="BBacnetOctetString.make(new byte[] { 0, 0, 0, 0, 0, 0 })"), @NiagaraProperty(name="peerUuid", type="BBacnetOctetString", defaultValue="BBacnetOctetString.make(new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 })"), @NiagaraProperty(name="error", type="BErrorType", defaultValue="new BErrorType(-1, -1)"), @NiagaraProperty(name="errorDetails", type="String", defaultValue="")})
public class BBacnetScHubFunctionConnection
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property connectionState = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)BBacnetScConnectionState.notConnected, null);
    @Generated
    public static final Property connectTimestamp = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property disconnectTimestamp = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property peerAddress = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)new BBacnetHostNPort(), null);
    @Generated
    public static final Property peerVmac = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)BBacnetOctetString.make(new byte[]{0, 0, 0, 0, 0, 0}), null);
    @Generated
    public static final Property peerUuid = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)BBacnetOctetString.make(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), null);
    @Generated
    public static final Property error = BBacnetScHubFunctionConnection.newProperty((int)0, (BValue)new BErrorType(-1, -1), null);
    @Generated
    public static final Property errorDetails = BBacnetScHubFunctionConnection.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScHubFunctionConnection.class);

    @Generated
    public BBacnetScConnectionState getConnectionState() {
        return (BBacnetScConnectionState)this.get(connectionState);
    }

    @Generated
    public void setConnectionState(BBacnetScConnectionState v) {
        this.set(connectionState, (BValue)v, null);
    }

    @Generated
    public BBacnetDateTime getConnectTimestamp() {
        return (BBacnetDateTime)this.get(connectTimestamp);
    }

    @Generated
    public void setConnectTimestamp(BBacnetDateTime v) {
        this.set(connectTimestamp, (BValue)v, null);
    }

    @Generated
    public BBacnetDateTime getDisconnectTimestamp() {
        return (BBacnetDateTime)this.get(disconnectTimestamp);
    }

    @Generated
    public void setDisconnectTimestamp(BBacnetDateTime v) {
        this.set(disconnectTimestamp, (BValue)v, null);
    }

    @Generated
    public BBacnetHostNPort getPeerAddress() {
        return (BBacnetHostNPort)this.get(peerAddress);
    }

    @Generated
    public void setPeerAddress(BBacnetHostNPort v) {
        this.set(peerAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerVmac() {
        return (BBacnetOctetString)this.get(peerVmac);
    }

    @Generated
    public void setPeerVmac(BBacnetOctetString v) {
        this.set(peerVmac, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerUuid() {
        return (BBacnetOctetString)this.get(peerUuid);
    }

    @Generated
    public void setPeerUuid(BBacnetOctetString v) {
        this.set(peerUuid, (BValue)v, null);
    }

    @Generated
    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    @Generated
    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    @Generated
    public String getErrorDetails() {
        return this.getString(errorDetails);
    }

    @Generated
    public void setErrorDetails(String v) {
        this.setString(errorDetails, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BBacnetScConnectionState connectionState = BBacnetScConnectionState.make(in.readEnumerated(0));
        in.skipOpeningTag(1);
        BBacnetDateTime connectTimestamp = new BBacnetDateTime();
        connectTimestamp.readAsn(in);
        in.skipClosingTag(1);
        in.skipOpeningTag(2);
        BBacnetDateTime disconnectTimestamp = new BBacnetDateTime();
        disconnectTimestamp.readAsn(in);
        in.skipClosingTag(2);
        in.skipOpeningTag(3);
        BBacnetHostNPort peerAddress = new BBacnetHostNPort();
        peerAddress.readAsn(in);
        in.skipClosingTag(3);
        BBacnetOctetString peerVmac = in.readBacnetOctetString(4);
        if (peerVmac.length() != 6) {
            throw new OutOfRangeException("BACnetScHubFunctionConnection.peerVmac must be length 6; actual: " + peerVmac.length());
        }
        BBacnetOctetString peerUuid = in.readBacnetOctetString(5);
        if (peerUuid.length() != 16) {
            throw new OutOfRangeException("BACnetScHubFunctionConnection.peerUuid must be length 16; actual: " + peerUuid.length());
        }
        BErrorType error = new BErrorType();
        in.peekTag();
        if (in.isOpeningTag(6)) {
            in.skipTag();
            error.readAsn(in);
            in.skipClosingTag(6);
        }
        String errorDetails = "";
        in.peekTag();
        if (in.isContextTag(7)) {
            errorDetails = in.readCharacterString(7);
        }
        this.set(BBacnetScHubFunctionConnection.connectionState, (BValue)connectionState, noWrite);
        this.set(BBacnetScHubFunctionConnection.connectTimestamp, (BValue)connectTimestamp, noWrite);
        this.set(BBacnetScHubFunctionConnection.disconnectTimestamp, (BValue)disconnectTimestamp, noWrite);
        this.set(BBacnetScHubFunctionConnection.peerAddress, (BValue)peerAddress, noWrite);
        this.set(BBacnetScHubFunctionConnection.peerVmac, (BValue)peerVmac, noWrite);
        this.set(BBacnetScHubFunctionConnection.peerUuid, (BValue)peerUuid, noWrite);
        this.set(BBacnetScHubFunctionConnection.error, (BValue)error, noWrite);
        this.setString(BBacnetScHubFunctionConnection.errorDetails, errorDetails, noWrite);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        String errorDetails;
        out.writeEnumerated(0, (BEnum)this.getConnectionState());
        out.writeOpeningTag(1);
        this.getConnectTimestamp().writeAsn(out);
        out.writeClosingTag(1);
        out.writeOpeningTag(2);
        this.getDisconnectTimestamp().writeAsn(out);
        out.writeClosingTag(2);
        out.writeOpeningTag(3);
        this.getPeerAddress().writeAsn(out);
        out.writeClosingTag(3);
        BBacnetOctetString peerVmac = this.getPeerVmac();
        if (peerVmac.isNull() || peerVmac.length() != 6) {
            throw new IllegalArgumentException("BACnetScHubFunctionConnection.peerVmac must be length 6; actual: " + (peerVmac.isNull() ? -1 : peerVmac.length()));
        }
        out.writeOctetString(4, peerVmac);
        BBacnetOctetString peerUuid = this.getPeerUuid();
        if (peerUuid.isNull() || peerUuid.length() != 16) {
            throw new IllegalArgumentException("BACnetScHubFunctionConnection.peerUuid must be length 16; actual: " + (peerUuid.isNull() ? -1 : peerUuid.length()));
        }
        out.writeOctetString(5, peerUuid);
        BErrorType error = this.getError();
        if (!error.isDefault()) {
            out.writeOpeningTag(6);
            error.writeAsn(out);
            out.writeClosingTag(6);
        }
        if (!(errorDetails = this.getErrorDetails()).isEmpty()) {
            out.writeCharacterString(7, errorDetails);
        }
    }

    public String toString(Context context) {
        StringBuilder builder = new StringBuilder(this.getConnectionState().toString(context)).append(" [").append(ByteArrayUtil.toHexString((byte[])this.getPeerVmac().getAddr()).toUpperCase()).append(']');
        BErrorType error = this.getError();
        if (!error.isDefault()) {
            builder.append(' ').append(error.toString(context));
        }
        return builder.toString();
    }
}

