/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetHostNPort;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timestamp", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="peerAddress", type="BBacnetHostNPort", defaultValue="new BBacnetHostNPort()"), @NiagaraProperty(name="peerVmac", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="peerUuid", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="error", type="BErrorType", defaultValue="new BErrorType(-1, -1)"), @NiagaraProperty(name="errorDetails", type="String", defaultValue="")})
public class BBacnetScFailedConnectionRequest
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property timestamp = BBacnetScFailedConnectionRequest.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property peerAddress = BBacnetScFailedConnectionRequest.newProperty((int)0, (BValue)new BBacnetHostNPort(), null);
    @Generated
    public static final Property peerVmac = BBacnetScFailedConnectionRequest.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property peerUuid = BBacnetScFailedConnectionRequest.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property error = BBacnetScFailedConnectionRequest.newProperty((int)0, (BValue)new BErrorType(-1, -1), null);
    @Generated
    public static final Property errorDetails = BBacnetScFailedConnectionRequest.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScFailedConnectionRequest.class);

    @Generated
    public BBacnetDateTime getTimestamp() {
        return (BBacnetDateTime)this.get(timestamp);
    }

    @Generated
    public void setTimestamp(BBacnetDateTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    @Generated
    public BBacnetHostNPort getPeerAddress() {
        return (BBacnetHostNPort)this.get(peerAddress);
    }

    @Generated
    public void setPeerAddress(BBacnetHostNPort v) {
        this.set(peerAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerVmac() {
        return (BBacnetOctetString)this.get(peerVmac);
    }

    @Generated
    public void setPeerVmac(BBacnetOctetString v) {
        this.set(peerVmac, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerUuid() {
        return (BBacnetOctetString)this.get(peerUuid);
    }

    @Generated
    public void setPeerUuid(BBacnetOctetString v) {
        this.set(peerUuid, (BValue)v, null);
    }

    @Generated
    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    @Generated
    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    @Generated
    public String getErrorDetails() {
        return this.getString(errorDetails);
    }

    @Generated
    public void setErrorDetails(String v) {
        this.setString(errorDetails, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        BBacnetDateTime timestamp = new BBacnetDateTime();
        timestamp.readAsn(in);
        in.skipClosingTag(0);
        in.skipOpeningTag(1);
        BBacnetHostNPort peerAddress = new BBacnetHostNPort();
        peerAddress.readAsn(in);
        in.skipClosingTag(1);
        BBacnetOctetString peerVmac = BBacnetOctetString.DEFAULT;
        in.peekTag();
        if (in.isContextTag(2) && (peerVmac = in.readBacnetOctetString(2)).length() != 6) {
            throw new OutOfRangeException("BACnetScFailedConnectionRequest.peerVmac must be length 6; actual: " + peerVmac.length());
        }
        BBacnetOctetString peerUuid = BBacnetOctetString.DEFAULT;
        in.peekTag();
        if (in.isContextTag(3) && (peerUuid = in.readBacnetOctetString(3)).length() != 16) {
            throw new OutOfRangeException("BACnetScFailedConnectionRequest.peerUuid must be length 16; actual: " + peerUuid.length());
        }
        in.skipOpeningTag(4);
        BErrorType error = new BErrorType();
        error.readAsn(in);
        in.skipClosingTag(4);
        String errorDetails = "";
        in.peekTag();
        if (in.isContextTag(5)) {
            errorDetails = in.readCharacterString(5);
        }
        this.set(BBacnetScFailedConnectionRequest.timestamp, (BValue)timestamp, noWrite);
        this.set(BBacnetScFailedConnectionRequest.peerAddress, (BValue)peerAddress, noWrite);
        this.set(BBacnetScFailedConnectionRequest.peerVmac, (BValue)peerVmac, noWrite);
        this.set(BBacnetScFailedConnectionRequest.peerUuid, (BValue)peerUuid, noWrite);
        this.set(BBacnetScFailedConnectionRequest.error, (BValue)error, noWrite);
        this.setString(BBacnetScFailedConnectionRequest.errorDetails, errorDetails, noWrite);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        BBacnetOctetString peerUuid;
        out.writeOpeningTag(0);
        this.getTimestamp().writeAsn(out);
        out.writeClosingTag(0);
        out.writeOpeningTag(1);
        this.getPeerAddress().writeAsn(out);
        out.writeClosingTag(1);
        BBacnetOctetString peerVmac = this.getPeerVmac();
        if (!peerVmac.isNull()) {
            if (peerVmac.length() != 6) {
                throw new IllegalArgumentException("BACnetScFailedConnectionRequest.peerVmac length must be 6; actual: " + peerVmac.length());
            }
            out.writeOctetString(2, peerVmac);
        }
        if (!(peerUuid = this.getPeerUuid()).isNull()) {
            if (peerUuid.length() != 16) {
                throw new IllegalArgumentException("BACnetScFailedConnectionRequest.peerUuid length must be 16; actual: " + peerUuid.length());
            }
            out.writeOctetString(3, peerUuid);
        }
        out.writeOpeningTag(4);
        this.getError().writeAsn(out);
        out.writeClosingTag(4);
        String errorDetails = this.getErrorDetails();
        if (!errorDetails.isEmpty()) {
            out.writeCharacterString(5, errorDetails);
        }
    }

    public String toString(Context context) {
        return this.getPeerAddress().toString(context) + ' ' + this.getError().toString(context);
    }
}

