/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetHostAddressChoice;
import javax.baja.bacnet.datatypes.BBacnetHostNPort;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="uri", type="String", defaultValue=""), @NiagaraProperty(name="connectionState", type="BBacnetScConnectionState", defaultValue="BBacnetScConnectionState.notConnected"), @NiagaraProperty(name="connectTimestamp", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="disconnectTimestamp", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="peerAddress", type="BBacnetHostNPort", defaultValue="new BBacnetHostNPort()"), @NiagaraProperty(name="peerVmac", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="peerUuid", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="error", type="BErrorType", defaultValue="new BErrorType(-1, -1)"), @NiagaraProperty(name="errorDetails", type="String", defaultValue="")})
public class BBacnetScDirectConnection
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property uri = BBacnetScDirectConnection.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property connectionState = BBacnetScDirectConnection.newProperty((int)0, (BValue)BBacnetScConnectionState.notConnected, null);
    @Generated
    public static final Property connectTimestamp = BBacnetScDirectConnection.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property disconnectTimestamp = BBacnetScDirectConnection.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property peerAddress = BBacnetScDirectConnection.newProperty((int)0, (BValue)new BBacnetHostNPort(), null);
    @Generated
    public static final Property peerVmac = BBacnetScDirectConnection.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property peerUuid = BBacnetScDirectConnection.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property error = BBacnetScDirectConnection.newProperty((int)0, (BValue)new BErrorType(-1, -1), null);
    @Generated
    public static final Property errorDetails = BBacnetScDirectConnection.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScDirectConnection.class);

    @Generated
    public String getUri() {
        return this.getString(uri);
    }

    @Generated
    public void setUri(String v) {
        this.setString(uri, v, null);
    }

    @Generated
    public BBacnetScConnectionState getConnectionState() {
        return (BBacnetScConnectionState)this.get(connectionState);
    }

    @Generated
    public void setConnectionState(BBacnetScConnectionState v) {
        this.set(connectionState, (BValue)v, null);
    }

    @Generated
    public BBacnetDateTime getConnectTimestamp() {
        return (BBacnetDateTime)this.get(connectTimestamp);
    }

    @Generated
    public void setConnectTimestamp(BBacnetDateTime v) {
        this.set(connectTimestamp, (BValue)v, null);
    }

    @Generated
    public BBacnetDateTime getDisconnectTimestamp() {
        return (BBacnetDateTime)this.get(disconnectTimestamp);
    }

    @Generated
    public void setDisconnectTimestamp(BBacnetDateTime v) {
        this.set(disconnectTimestamp, (BValue)v, null);
    }

    @Generated
    public BBacnetHostNPort getPeerAddress() {
        return (BBacnetHostNPort)this.get(peerAddress);
    }

    @Generated
    public void setPeerAddress(BBacnetHostNPort v) {
        this.set(peerAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerVmac() {
        return (BBacnetOctetString)this.get(peerVmac);
    }

    @Generated
    public void setPeerVmac(BBacnetOctetString v) {
        this.set(peerVmac, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerUuid() {
        return (BBacnetOctetString)this.get(peerUuid);
    }

    @Generated
    public void setPeerUuid(BBacnetOctetString v) {
        this.set(peerUuid, (BValue)v, null);
    }

    @Generated
    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    @Generated
    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    @Generated
    public String getErrorDetails() {
        return this.getString(errorDetails);
    }

    @Generated
    public void setErrorDetails(String v) {
        this.setString(errorDetails, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        String uri = in.readCharacterString(0);
        BBacnetScConnectionState connectionState = BBacnetScConnectionState.make(in.readEnumerated(1));
        in.skipOpeningTag(2);
        BBacnetDateTime connectTimestamp = new BBacnetDateTime();
        connectTimestamp.readAsn(in);
        in.skipClosingTag(2);
        in.skipOpeningTag(3);
        BBacnetDateTime disconnectTimestamp = new BBacnetDateTime();
        disconnectTimestamp.readAsn(in);
        in.skipClosingTag(3);
        BBacnetHostNPort peerAddress = new BBacnetHostNPort();
        in.peekTag();
        if (in.isOpeningTag(4)) {
            in.skipTag();
            peerAddress.readAsn(in);
            in.skipClosingTag(4);
        }
        BBacnetOctetString peerVmac = BBacnetOctetString.DEFAULT;
        in.peekTag();
        if (in.isContextTag(5) && (peerVmac = in.readBacnetOctetString(5)).length() != 6) {
            throw new OutOfRangeException("BACnetScDirectConnection.peerVmac must be length 6; actual: " + peerVmac.length());
        }
        BBacnetOctetString peerUuid = BBacnetOctetString.DEFAULT;
        in.peekTag();
        if (in.isContextTag(6) && (peerUuid = in.readBacnetOctetString(6)).length() != 16) {
            throw new OutOfRangeException("BACnetScDirectConnection.peerUuid must be length 16; actual: " + peerUuid.length());
        }
        BErrorType error = new BErrorType();
        in.peekTag();
        if (in.isOpeningTag(7)) {
            in.skipTag();
            error.readAsn(in);
            in.skipClosingTag(7);
        }
        String errorDetails = "";
        in.peekTag();
        if (in.isContextTag(8)) {
            errorDetails = in.readCharacterString(8);
        }
        this.setString(BBacnetScDirectConnection.uri, uri, noWrite);
        this.set(BBacnetScDirectConnection.connectionState, (BValue)connectionState, noWrite);
        this.set(BBacnetScDirectConnection.connectTimestamp, (BValue)connectTimestamp, noWrite);
        this.set(BBacnetScDirectConnection.disconnectTimestamp, (BValue)disconnectTimestamp, noWrite);
        this.set(BBacnetScDirectConnection.peerAddress, (BValue)peerAddress, noWrite);
        this.set(BBacnetScDirectConnection.peerVmac, (BValue)peerVmac, noWrite);
        this.set(BBacnetScDirectConnection.peerUuid, (BValue)peerUuid, noWrite);
        this.set(BBacnetScDirectConnection.error, (BValue)error, noWrite);
        this.setString(BBacnetScDirectConnection.errorDetails, errorDetails, noWrite);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        String errorDetails;
        BErrorType error;
        BBacnetOctetString peerUuid;
        BBacnetOctetString peerVmac;
        out.writeCharacterString(0, this.getUri());
        out.writeEnumerated(1, (BEnum)this.getConnectionState());
        out.writeOpeningTag(2);
        this.getConnectTimestamp().writeAsn(out);
        out.writeClosingTag(2);
        out.writeOpeningTag(3);
        this.getDisconnectTimestamp().writeAsn(out);
        out.writeClosingTag(3);
        BBacnetHostNPort peerAddress = this.getPeerAddress();
        if (!peerAddress.getHostAddress().getChoice().equals((Object)BBacnetHostAddressChoice.none)) {
            out.writeOpeningTag(4);
            peerAddress.writeAsn(out);
            out.writeClosingTag(4);
        }
        if (!(peerVmac = this.getPeerVmac()).isNull()) {
            if (peerVmac.length() != 6) {
                throw new IllegalArgumentException("BACnetScDirectConnection.peerVmac must be length 6; actual: " + peerVmac.length());
            }
            out.writeOctetString(5, peerVmac);
        }
        if (!(peerUuid = this.getPeerUuid()).isNull()) {
            if (peerUuid.length() != 16) {
                throw new IllegalArgumentException("BACnetScDirectConnection.peerUuid must be length 16; actual: " + peerUuid.length());
            }
            out.writeOctetString(6, peerUuid);
        }
        if (!(error = this.getError()).isDefault()) {
            out.writeOpeningTag(7);
            error.writeAsn(out);
            out.writeClosingTag(7);
        }
        if (!(errorDetails = this.getErrorDetails()).isEmpty()) {
            out.writeCharacterString(8, errorDetails);
        }
    }

    public String toString(Context context) {
        String uri;
        StringBuilder builder = new StringBuilder(this.getConnectionState().toString(context));
        BBacnetOctetString peerVmac = this.getPeerVmac();
        if (!peerVmac.isNull()) {
            builder.append(" [").append(ByteArrayUtil.toHexString((byte[])this.getPeerVmac().getAddr()).toUpperCase()).append(']');
        }
        if (!(uri = this.getUri()).isEmpty()) {
            builder.append(' ').append(uri);
        }
        return builder.toString();
    }
}

