/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetRouterStatus;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnum;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkNumber", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT"), @NiagaraProperty(name="macAddress", type="BBacnetOctetString", defaultValue="BBacnetOctetString.EMPTY"), @NiagaraProperty(name="status", type="BBacnetRouterStatus", defaultValue="BBacnetRouterStatus.available"), @NiagaraProperty(name="performanceIndex", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.make(-1)")})
public final class BBacnetRoutingTableEntry
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property networkNumber = BBacnetRoutingTableEntry.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, null);
    @Generated
    public static final Property macAddress = BBacnetRoutingTableEntry.newProperty((int)0, (BValue)BBacnetOctetString.EMPTY, null);
    @Generated
    public static final Property status = BBacnetRoutingTableEntry.newProperty((int)0, (BValue)BBacnetRouterStatus.available, null);
    @Generated
    public static final Property performanceIndex = BBacnetRoutingTableEntry.newProperty((int)0, (BValue)BBacnetUnsigned.make(-1L), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetRoutingTableEntry.class);

    @Generated
    public BBacnetUnsigned getNetworkNumber() {
        return (BBacnetUnsigned)this.get(networkNumber);
    }

    @Generated
    public void setNetworkNumber(BBacnetUnsigned v) {
        this.set(networkNumber, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getMacAddress() {
        return (BBacnetOctetString)this.get(macAddress);
    }

    @Generated
    public void setMacAddress(BBacnetOctetString v) {
        this.set(macAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetRouterStatus getStatus() {
        return (BBacnetRouterStatus)this.get(status);
    }

    @Generated
    public void setStatus(BBacnetRouterStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getPerformanceIndex() {
        return (BBacnetUnsigned)this.get(performanceIndex);
    }

    @Generated
    public void setPerformanceIndex(BBacnetUnsigned v) {
        this.set(performanceIndex, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int networkNumber = this.getNetworkNumber().getInt();
        if (networkNumber < 0 || (long)networkNumber > 65535L) {
            throw new IllegalArgumentException("BACnetRouterEntry.NetworkNumber must be [0-65535]: " + networkNumber);
        }
        out.writeUnsignedInteger(0, networkNumber);
        out.writeOctetString(1, this.getMacAddress());
        out.writeEnumerated(2, (BEnum)this.getStatus());
        int performanceIndex = this.getPerformanceIndex().getInt();
        if (performanceIndex >= 0) {
            if ((long)performanceIndex > 255L) {
                throw new IllegalArgumentException("BACnetRouterEntry.PerformanceIndex must be [0-255]: " + performanceIndex);
            }
            out.writeUnsignedInteger(3, performanceIndex);
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int performanceIndex;
        int networkNumber = in.readUnsignedInt(0);
        if ((long)networkNumber > 65535L) {
            throw new OutOfRangeException("BACnetRouterEntry.NetworkNumber must be [0-65535]: " + networkNumber);
        }
        BBacnetOctetString macAddress = in.readBacnetOctetString(1);
        BBacnetRouterStatus status = BBacnetRouterStatus.make(in.readEnumerated(2));
        in.peekTag();
        int n = performanceIndex = in.isValueTag(3) ? in.readUnsignedInt(3) : -1;
        if ((long)performanceIndex > 255L) {
            throw new OutOfRangeException("BACnetRouterEntry.PerformanceIndex must be [0-255]: " + performanceIndex);
        }
        this.set(BBacnetRoutingTableEntry.networkNumber, (BValue)BBacnetUnsigned.make(networkNumber), noWrite);
        this.set(BBacnetRoutingTableEntry.macAddress, (BValue)macAddress, noWrite);
        this.set(BBacnetRoutingTableEntry.status, (BValue)status, noWrite);
        this.set(BBacnetRoutingTableEntry.performanceIndex, (BValue)BBacnetUnsigned.make(performanceIndex), noWrite);
    }

    public String toString(Context cx) {
        StringBuilder builder = new StringBuilder().append("network: ").append((Object)this.getNetworkNumber()).append(" mac: ").append((Object)this.getMacAddress()).append(" status: ").append((Object)this.getStatus());
        int performanceIndex = this.getPerformanceIndex().getInt();
        if (performanceIndex >= 0) {
            builder.append(" performance: ").append(performanceIndex);
        }
        return builder.toString();
    }
}

