/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BBacnetObjectIdentifier
extends BSimple
implements BIComparable {
    public static final int OBJECT_TYPE_MASK = -4194304;
    public static final int OBJECT_TYPE_MASK_SHIFTED = 1023;
    public static final int INSTANCE_NUMBER_MASK = 0x3FFFFF;
    public static final int OBJECT_TYPE_SHIFT = 22;
    public static final int MIN_INSTANCE_NUMBER = 0;
    public static final int MAX_INSTANCE_NUMBER = 0x3FFFFE;
    public static final int UNCONFIGURED_INSTANCE_NUMBER = 0x3FFFFF;
    private static final char SEP = ':';
    private static final char NAME_SEP = '_';
    public static final BBacnetObjectIdentifier DEFAULT = new BBacnetObjectIdentifier(0, -1);
    public static final BBacnetObjectIdentifier DEFAULT_DEVICE = new BBacnetObjectIdentifier(8, -1);
    public static final Type TYPE = Sys.loadType(BBacnetObjectIdentifier.class);
    private final int objectType;
    private final int instanceNumber;
    private final int hashCode;

    private BBacnetObjectIdentifier(int objectType, int instanceNumber) {
        this.objectType = objectType;
        this.instanceNumber = instanceNumber;
        this.hashCode = objectType << 22 & 0xFFC00000 | instanceNumber & 0x3FFFFF;
    }

    public static BBacnetObjectIdentifier make(int objectType) {
        return new BBacnetObjectIdentifier(objectType, -1);
    }

    public static BBacnetObjectIdentifier make(int objectType, int instanceNumber) {
        return new BBacnetObjectIdentifier(objectType, instanceNumber);
    }

    public static BBacnetObjectIdentifier make(BBacnetObjectType objectType, int instanceNumber) {
        return new BBacnetObjectIdentifier(objectType.getOrdinal(), instanceNumber);
    }

    public static BBacnetObjectIdentifier makeId(int objectId) {
        int objectType = objectId >> 22 & 0x3FF;
        int instanceNumber = objectId & 0x3FFFFF;
        return new BBacnetObjectIdentifier(objectType, instanceNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BBacnetObjectIdentifier) {
            return ((BBacnetObjectIdentifier)((Object)obj)).objectType == this.objectType && ((BBacnetObjectIdentifier)((Object)obj)).instanceNumber == this.instanceNumber;
        }
        return false;
    }

    public String toString(Context context) {
        if (context != null) {
            BEnumRange r;
            StringBuilder sb = new StringBuilder();
            char sep = ':';
            if (context.equals(BacnetConst.nameContext) || context.equals(BacnetConst.facetsContext)) {
                sep = '_';
            }
            if ((r = (BEnumRange)context.getFacet("range")) != null) {
                sb.append(r.getTag(this.objectType)).append(sep).append(this.instanceNumber);
            } else {
                sb.append(this.getObjectTypeTag()).append(sep).append(this.instanceNumber);
            }
            if (context.equals(BacnetConst.nameContext) || context.equals(BacnetConst.facetsContext)) {
                return SlotPath.escape((String)sb.toString());
            }
            return sb.toString();
        }
        return this.getObjectTypeTag() + ':' + this.instanceNumber;
    }

    private String getObjectTypeTag() {
        return this.objectType == 31 ? "timer" : BBacnetObjectType.tag(this.objectType);
    }

    public String toShortString() {
        if (this.instanceNumber == 0x3FFFFF) {
            return "";
        }
        return BBacnetObjectType.getShortTag(this.objectType) + this.instanceNumber;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.objectType);
        out.writeInt(this.instanceNumber);
    }

    public BObject decode(DataInput in) throws IOException {
        return new BBacnetObjectIdentifier(in.readInt(), in.readInt());
    }

    public String encodeToString() throws IOException {
        return BBacnetObjectType.tag(this.objectType) + ':' + String.valueOf(this.instanceNumber);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            StringTokenizer st = new StringTokenizer(s, ":_ ");
            int objectType = BBacnetObjectType.ordinal(st.nextToken());
            int instanceNumber = Integer.parseInt(st.nextToken());
            return new BBacnetObjectIdentifier(objectType, instanceNumber);
        }
        catch (Exception e) {
            throw new IOException("Error decoding BBacnetObjectIdentifier " + s);
        }
    }

    public boolean isValid() {
        return this.objectType >= 0 && this.instanceNumber >= 0 && this.instanceNumber < 0x3FFFFF;
    }

    public boolean isConfigured() {
        return this.instanceNumber >= 0 && this.instanceNumber < 0x3FFFFF;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public int getId() {
        return this.hashCode();
    }

    public BBacnetObjectIdentifier newId(int newInstanceNumber) {
        return new BBacnetObjectIdentifier(this.objectType, newInstanceNumber);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BBacnetObjectIdentifier)) {
            throw new ClassCastException();
        }
        BBacnetObjectIdentifier id = (BBacnetObjectIdentifier)((Object)o);
        long my = this.hashCode();
        long his = id.hashCode();
        return (int)(my - his);
    }

    public Type getType() {
        return TYPE;
    }
}

