/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.stack.link.ip.util.BacnetIpLinkUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.baja.bacnet.datatypes.BBacnetHostAddress;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostAddress", type="BBacnetHostAddress", defaultValue="new BBacnetHostAddress()"), @NiagaraProperty(name="port", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(null, (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE)")})})
public final class BBacnetHostNPort
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property hostAddress = BBacnetHostNPort.newProperty((int)0, (BValue)new BBacnetHostAddress(), null);
    @Generated
    public static final Property port = BBacnetHostNPort.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetHostNPort.class);

    @Generated
    public BBacnetHostAddress getHostAddress() {
        return (BBacnetHostAddress)this.get(hostAddress);
    }

    @Generated
    public void setHostAddress(BBacnetHostAddress v) {
        this.set(hostAddress, (BValue)v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetHostNPort() {
    }

    public BBacnetHostNPort(BBacnetHostAddress hostAddress, int port) {
        this.setHostAddress(hostAddress);
        this.setPort(port);
    }

    public static BBacnetHostNPort makeWithBacnetIpBytes(byte[] bacnetIpBytes) {
        BacnetIpLinkUtil.validateAddressLength(bacnetIpBytes, 6);
        return new BBacnetHostNPort(BBacnetHostAddress.makeWithIpAddress(BBacnetOctetString.make(Arrays.copyOf(bacnetIpBytes, 4))), BacnetIpLinkUtil.getPortFromBacnetIpBytes(bacnetIpBytes));
    }

    public static BBacnetHostNPort parseBacnetIpAddress(String string) {
        if (string == null || string.isEmpty() || string.equalsIgnoreCase("null")) {
            return new BBacnetHostNPort();
        }
        if (string.contains(".")) {
            String[] hostNPort = string.split(":");
            if (hostNPort.length != 2) {
                throw new IllegalArgumentException("String that contains dots must have host and port separated by a colon; string: " + string);
            }
            int port = Integer.decode(hostNPort[1]);
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Port value of a string that contains dots must be between 0 and 65535 inclusive; string: " + string);
            }
            if (BacnetIpLinkUtil.containsDotsAndDigitsOnly(hostNPort[0])) {
                String[] ipOctets = hostNPort[0].split("\\.");
                if (ipOctets.length != 4) {
                    throw new IllegalArgumentException("When string contains digits and dots only, it must contain 4 parts; string: " + string);
                }
                byte[] ipBytes = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    int octet = Integer.decode(ipOctets[i]);
                    if (octet < 0 || octet > 255) {
                        throw new IllegalArgumentException("When string contains digits and dots only, numbers must be between 0 and 255 inclusive; string: " + string);
                    }
                    ipBytes[i] = (byte)octet;
                }
                return new BBacnetHostNPort(BBacnetHostAddress.makeWithIpAddress(ipBytes), port);
            }
            return new BBacnetHostNPort(BBacnetHostAddress.makeWithHostName(hostNPort[0]), port);
        }
        StringTokenizer tokenizer = new StringTokenizer(string, " :");
        if (tokenizer.countTokens() < 6) {
            throw new IllegalArgumentException("When string contains no dots, it must contain 6 parts; string: " + string);
        }
        byte[] bacnetIpBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int value = Integer.parseInt(tokenizer.nextToken(), 16);
            if (value < 0 || value > 255) {
                throw new IllegalArgumentException("When string contains no dots, numbers must be between 0 and 255 inclusive; string: " + string);
            }
            bacnetIpBytes[i] = (byte)value;
        }
        return BBacnetHostNPort.makeWithBacnetIpBytes(bacnetIpBytes);
    }

    public byte[] getBacnetIpAddressBytes() {
        byte[] hostAddressBytes;
        switch (this.getHostAddress().getChoice().getOrdinal()) {
            case 2: {
                try {
                    hostAddressBytes = InetAddress.getByName(this.getHostAddress().getHostName()).getAddress();
                    break;
                }
                catch (UnknownHostException e) {
                    return null;
                }
            }
            case 1: {
                hostAddressBytes = this.getHostAddress().getIpAddress().getBytes();
                break;
            }
            default: {
                return null;
            }
        }
        if (hostAddressBytes == null || hostAddressBytes.length != 4) {
            return null;
        }
        byte[] macBytes = new byte[6];
        System.arraycopy(hostAddressBytes, 0, macBytes, 0, 4);
        int port = this.getPort();
        if (port < 0 || port > 65535) {
            return null;
        }
        macBytes[4] = (byte)(port >> 8 & 0xFF);
        macBytes[5] = (byte)(port & 0xFF);
        return macBytes;
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        BBacnetHostAddress hostAddress = new BBacnetHostAddress();
        hostAddress.readAsn(in);
        in.skipClosingTag(0);
        int port = in.readUnsignedInt(1);
        this.set(BBacnetHostNPort.hostAddress, (BValue)hostAddress, noWrite);
        this.setInt(BBacnetHostNPort.port, port, noWrite);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        this.getHostAddress().writeAsn(out);
        out.writeClosingTag(0);
        out.writeUnsignedInteger(1, this.getPort());
    }

    public String toString(Context context) {
        return this.getHostAddress().toString(context) + ":" + this.getPort();
    }
}

