/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetHostAddressChoice;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="choice", type="BBacnetHostAddressChoice", defaultValue="BBacnetHostAddressChoice.none"), @NiagaraProperty(name="ipAddress", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="hostName", type="String", defaultValue="")})
public class BBacnetHostAddress
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetHostAddress.newProperty((int)0, (BValue)BBacnetHostAddressChoice.none, null);
    @Generated
    public static final Property ipAddress = BBacnetHostAddress.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property hostName = BBacnetHostAddress.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetHostAddress.class);

    @Generated
    public BBacnetHostAddressChoice getChoice() {
        return (BBacnetHostAddressChoice)this.get(choice);
    }

    @Generated
    public void setChoice(BBacnetHostAddressChoice v) {
        this.set(choice, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getIpAddress() {
        return (BBacnetOctetString)this.get(ipAddress);
    }

    @Generated
    public void setIpAddress(BBacnetOctetString v) {
        this.set(ipAddress, (BValue)v, null);
    }

    @Generated
    public String getHostName() {
        return this.getString(hostName);
    }

    @Generated
    public void setHostName(String v) {
        this.setString(hostName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBacnetHostAddress makeNone() {
        BBacnetHostAddress hostAddress = new BBacnetHostAddress();
        hostAddress.setChoice(BBacnetHostAddressChoice.none);
        return hostAddress;
    }

    public static BBacnetHostAddress makeWithIpAddress(BBacnetOctetString ipAddress) {
        BBacnetHostAddress hostAddress = new BBacnetHostAddress();
        hostAddress.setChoice(BBacnetHostAddressChoice.ipAddress);
        hostAddress.setIpAddress(ipAddress);
        return hostAddress;
    }

    public static BBacnetHostAddress makeWithIpAddress(byte[] ipAddressBytes) {
        return BBacnetHostAddress.makeWithIpAddress(BBacnetOctetString.make(ipAddressBytes));
    }

    public static BBacnetHostAddress makeWithHostName(String hostName) {
        BBacnetHostAddress hostAddress = new BBacnetHostAddress();
        hostAddress.setChoice(BBacnetHostAddressChoice.name);
        hostAddress.setHostName(hostName);
        return hostAddress;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int choice = this.getChoice().getOrdinal();
        switch (choice) {
            case 0: {
                out.writeNull(0);
                break;
            }
            case 1: {
                byte[] bytes = this.getIpAddress().getBytes();
                if (bytes == null || bytes.length != 4 && bytes.length != 16) {
                    throw new IllegalStateException("Invalid BACnetHostAddress IpAddress length: " + (bytes != null ? Integer.valueOf(bytes.length) : "null"));
                }
                out.writeOctetString(1, bytes);
                break;
            }
            case 2: {
                out.writeCharacterString(2, this.getHostName());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid BBacnetHostAddress choice: " + choice);
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int choice = in.peekTag();
        BBacnetOctetString ipAddress = BBacnetOctetString.DEFAULT;
        String hostName = "";
        switch (choice) {
            case 0: {
                in.readNull(0);
                break;
            }
            case 1: {
                ipAddress = in.readBacnetOctetString(1);
                if (ipAddress.length() == 4 || ipAddress.length() == 16) break;
                throw new OutOfRangeException("Invalid BACnetHostAddress IpAddress length: " + ipAddress.length());
            }
            case 2: {
                hostName = in.readCharacterString(2);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + choice);
            }
        }
        this.set(BBacnetHostAddress.choice, (BValue)BBacnetHostAddressChoice.make(choice), noWrite);
        this.set(BBacnetHostAddress.ipAddress, (BValue)ipAddress, noWrite);
        this.setString(BBacnetHostAddress.hostName, hostName, noWrite);
    }

    public String toString(Context context) {
        switch (this.getChoice().getOrdinal()) {
            case 0: {
                return "none";
            }
            case 1: {
                BBacnetOctetString ipAddress = this.getIpAddress();
                if (!ipAddress.isNull() && ipAddress.length() == 4) {
                    return BBacnetAddress.bytesToString(2, ipAddress.getBytes());
                }
                return this.getIpAddress().toString(context);
            }
            case 2: {
                return this.getHostName();
            }
        }
        return "BACnetHostAddress choice unknown";
    }
}

