/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bacnetIpAddress", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT"), @NiagaraProperty(name="timeToLive", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(BUnit.getUnit(\"second\"), (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE)")}), @NiagaraProperty(name="remainingTimeToLive", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(BUnit.getUnit(\"second\"), (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE)")})})
public final class BBacnetFdtEntry
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property bacnetIpAddress = BBacnetFdtEntry.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property timeToLive = BBacnetFdtEntry.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"second"), (int)0, (int)65535));
    @Generated
    public static final Property remainingTimeToLive = BBacnetFdtEntry.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"second"), (int)0, (int)65535));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetFdtEntry.class);

    @Generated
    public BBacnetOctetString getBacnetIpAddress() {
        return (BBacnetOctetString)this.get(bacnetIpAddress);
    }

    @Generated
    public void setBacnetIpAddress(BBacnetOctetString v) {
        this.set(bacnetIpAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getTimeToLive() {
        return (BBacnetUnsigned)this.get(timeToLive);
    }

    @Generated
    public void setTimeToLive(BBacnetUnsigned v) {
        this.set(timeToLive, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getRemainingTimeToLive() {
        return (BBacnetUnsigned)this.get(remainingTimeToLive);
    }

    @Generated
    public void setRemainingTimeToLive(BBacnetUnsigned v) {
        this.set(remainingTimeToLive, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BBacnetOctetString bacnetIpAddress = BBacnetOctetString.make(in.readOctetString(0));
        int timeToLive = in.readUnsignedInt(1);
        int remainingTimeToLive = in.readUnsignedInt(2);
        this.set(BBacnetFdtEntry.bacnetIpAddress, (BValue)bacnetIpAddress, noWrite);
        this.set(BBacnetFdtEntry.timeToLive, (BValue)BBacnetUnsigned.make(timeToLive), noWrite);
        this.set(BBacnetFdtEntry.remainingTimeToLive, (BValue)BBacnetUnsigned.make(remainingTimeToLive), noWrite);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        long timeToLive = this.getTimeToLive().getLong();
        if (timeToLive < 0L || timeToLive > 65535L) {
            throw new IllegalStateException("BACnetFDTEntry TimeToLive must be 0-65535: " + timeToLive);
        }
        long remainingTimeToLive = this.getRemainingTimeToLive().getLong();
        if (remainingTimeToLive < 0L || remainingTimeToLive > 65535L) {
            throw new IllegalStateException("BACnetFDTEntry RemainingTimeToLive must be 0-65535: " + remainingTimeToLive);
        }
        out.writeOctetString(0, this.getBacnetIpAddress());
        out.writeUnsignedInteger(1, timeToLive);
        out.writeUnsignedInteger(2, remainingTimeToLive);
    }

    public String toString(Context context) {
        return "BBacnetFdtEntry: bacnetIpAddress=" + this.getBacnetIpAddress().toString(context) + "; timeToLive=" + (Object)((Object)this.getTimeToLive()) + "; remainingTimeToLive=" + (Object)((Object)this.getRemainingTimeToLive());
    }
}

