/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addTimeValue", parameterType="BBacnetTimeValue", defaultValue="new BBacnetTimeValue()"), @NiagaraAction(name="removeTimeValue", parameterType="BString", defaultValue="BString.make(\"\")")})
@NiagaraTopic(name="dailyScheduleChanged")
public class BBacnetDailySchedule
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Action addTimeValue = BBacnetDailySchedule.newAction((int)0, (BValue)new BBacnetTimeValue(), null);
    @Generated
    public static final Action removeTimeValue = BBacnetDailySchedule.newAction((int)0, (BValue)BString.make((String)""), null);
    @Generated
    public static final Topic dailyScheduleChanged = BBacnetDailySchedule.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDailySchedule.class);
    public static final int DAY_SCHEDULE_TAG = 0;

    @Generated
    public void addTimeValue(BBacnetTimeValue parameter) {
        this.invoke(addTimeValue, (BValue)parameter, null);
    }

    @Generated
    public void removeTimeValue(BString parameter) {
        this.invoke(removeTimeValue, (BValue)parameter, null);
    }

    @Generated
    public void fireDailyScheduleChanged(BValue event) {
        this.fire(dailyScheduleChanged, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void doAddTimeValue(BBacnetTimeValue tv) {
        this.add(null, (BValue)tv);
    }

    public final void doRemoveTimeValue(BString tvName) {
        Property property = this.getProperty(tvName.getString());
        if (property != null) {
            this.remove(property, null);
        }
    }

    @Override
    public final void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetTimeValue.class)) {
            ((BBacnetTimeValue)c.get()).writeAsn(out);
        }
        out.writeClosingTag(0);
    }

    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        ArrayList<BBacnetTimeValue> timeValues = new ArrayList<BBacnetTimeValue>();
        in.skipOpeningTag(0);
        int tag = in.peekTag();
        while (!in.isClosingTag(0)) {
            BSimple value;
            if (tag == -1) {
                throw new AsnException("Invalid tag: " + tag);
            }
            BBacnetTime time = in.readTime();
            int asnType = in.peekApplicationTag();
            switch (asnType) {
                case 0: {
                    value = in.readNull();
                    break;
                }
                case 1: {
                    value = BBoolean.make((boolean)in.readBoolean());
                    break;
                }
                case 2: {
                    value = in.readUnsigned();
                    break;
                }
                case 3: {
                    value = in.readSigned();
                    break;
                }
                case 4: {
                    value = in.readFloat();
                    break;
                }
                case 5: {
                    value = BDouble.make((double)in.readDouble());
                    break;
                }
                case 6: {
                    value = in.readBacnetOctetString();
                    break;
                }
                case 7: {
                    value = BString.make((String)in.readCharacterString());
                    break;
                }
                case 8: {
                    value = in.readBitString();
                    break;
                }
                case 9: {
                    value = BDynamicEnum.make((int)in.readEnumerated());
                    break;
                }
                case 10: {
                    value = in.readDate();
                    break;
                }
                case 11: {
                    value = in.readTime();
                    break;
                }
                case 12: {
                    value = in.readObjectIdentifier();
                    break;
                }
                default: {
                    throw new AsnException("Invalid tag: " + tag);
                }
            }
            timeValues.add(new BBacnetTimeValue(time, value));
            tag = in.peekTag();
        }
        in.skipClosingTag(0);
        this.removeAll(noWrite);
        int length = timeValues.size();
        for (int i = 0; i < length; ++i) {
            this.add("BacnetTimeValue" + (i + 1), (BValue)timeValues.get(i), noWrite);
        }
    }

    public String toString(Context cx) {
        if (cx != null && cx instanceof BasicContext) {
            return "BacnetDailySchedule{" + this.getPropertyInParent() + "}";
        }
        this.loadSlots();
        StringBuilder sb = new StringBuilder("{");
        SlotCursor sc = this.getProperties();
        while (sc.next()) {
            sb.append(sc.get()).append(',');
        }
        if (sb.length() == 1) {
            return "{}";
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public void started() {
        if (!BacnetVirtualUtil.isVirtual(this) && this.getParent() instanceof BBacnetArray) {
            ((BBacnetArray)this.getParent()).linkTo(this, (Slot)dailyScheduleChanged, (Slot)BBacnetArray.arrayPropertyChanged);
        }
    }

    public void added(Property p, Context cx) {
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (cx != noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            this.fireDailyScheduleChanged(null);
        }
    }

    public void removed(Property p, BValue v, Context cx) {
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (cx != noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            this.fireDailyScheduleChanged(null);
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (cx != noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            this.fireDailyScheduleChanged(null);
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public final BSimple getValue(BTime at) {
        BBacnetTimeValue tv = null;
        BBacnetTimeValue tvlast = null;
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetTimeValue.class)) {
            tv = (BBacnetTimeValue)c.get();
            if (!tv.getTime().toBTime().isBefore(at) || tvlast != null && !tv.isAfter(tvlast)) continue;
            tvlast = tv;
        }
        if (tvlast == null) {
            tvlast = tv;
        }
        if (tvlast == null) {
            return BBacnetNull.DEFAULT;
        }
        return tvlast.getValue().getAny();
    }

    private BBacnetTimeValue getTV(BBacnetTime t) {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetTimeValue.class)) {
            if (!((BBacnetTimeValue)c.get()).getTime().equals((Object)t)) continue;
            return (BBacnetTimeValue)c.get();
        }
        return null;
    }

    private void sort() {
        Property[] tvs = this.getPropertiesArray();
        for (int i = 0; i < tvs.length - 1; ++i) {
            int small = i;
            for (int j = i + 1; j < tvs.length; ++j) {
                BBacnetTimeValue tvsmall;
                BBacnetTimeValue tvj = (BBacnetTimeValue)this.get(tvs[j]);
                if (!tvj.isBefore(tvsmall = (BBacnetTimeValue)this.get(tvs[small]))) continue;
                small = j;
            }
            Property temp = tvs[i];
            tvs[i] = tvs[small];
            tvs[small] = temp;
        }
        this.reorder(tvs, null);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetDailySchedule", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }
}

