/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetPropertyReference;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFloat;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="monitoredProperty", type="BBacnetPropertyReference", defaultValue="new BBacnetPropertyReference()"), @NiagaraProperty(name="covIncrement", type="float", defaultValue="BFloat.NaN"), @NiagaraProperty(name="timestamped", type="boolean", defaultValue="false")})
public class BBacnetCovMultipleSubscriptionCovReference
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property monitoredProperty = BBacnetCovMultipleSubscriptionCovReference.newProperty((int)0, (BValue)new BBacnetPropertyReference(), null);
    @Generated
    public static final Property covIncrement = BBacnetCovMultipleSubscriptionCovReference.newProperty((int)0, (BValue)BFloat.NaN, null);
    @Generated
    public static final Property timestamped = BBacnetCovMultipleSubscriptionCovReference.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCovMultipleSubscriptionCovReference.class);

    @Generated
    public BBacnetPropertyReference getMonitoredProperty() {
        return (BBacnetPropertyReference)this.get(monitoredProperty);
    }

    @Generated
    public void setMonitoredProperty(BBacnetPropertyReference v) {
        this.set(monitoredProperty, (BValue)v, null);
    }

    @Generated
    public float getCovIncrement() {
        return this.getFloat(covIncrement);
    }

    @Generated
    public void setCovIncrement(float v) {
        this.setFloat(covIncrement, v, null);
    }

    @Generated
    public boolean getTimestamped() {
        return this.getBoolean(timestamped);
    }

    @Generated
    public void setTimestamped(boolean v) {
        this.setBoolean(timestamped, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private boolean isCovIncrementUsed() {
        return !Float.isNaN(this.getCovIncrement());
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        this.getMonitoredProperty().writeAsn(out);
        out.writeClosingTag(0);
        if (this.isCovIncrementUsed()) {
            out.writeReal(1, this.getCovIncrement());
        }
        out.writeBoolean(2, this.getTimestamped());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        BBacnetPropertyReference monitoredProperty = new BBacnetPropertyReference();
        monitoredProperty.readAsn(in);
        in.skipClosingTag(0);
        in.peekTag();
        float covIncrement = in.isValueTag(1) ? in.readReal(1) : Float.NaN;
        boolean timestamped = in.readBoolean(2);
        this.set(BBacnetCovMultipleSubscriptionCovReference.monitoredProperty, (BValue)monitoredProperty, noWrite);
        this.setFloat(BBacnetCovMultipleSubscriptionCovReference.covIncrement, covIncrement, noWrite);
        this.setBoolean(BBacnetCovMultipleSubscriptionCovReference.timestamped, timestamped, noWrite);
    }

    public String toString(Context context) {
        StringBuilder builder = new StringBuilder(this.getMonitoredProperty().toString(context));
        if (this.isCovIncrementUsed()) {
            builder.append(", increment: ").append(BFloat.toString((float)this.getCovIncrement(), (Context)context));
        }
        builder.append(", timestamped? ").append(this.getTimestamped());
        return builder.toString();
    }
}

