/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.function.Supplier;
import javax.baja.bacnet.datatypes.BBacnetCovMultipleSubscriptionSpecification;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="recipient", type="BBacnetRecipientProcess", defaultValue="new BBacnetRecipientProcess()"), @NiagaraProperty(name="issueConfirmedNotifications", type="boolean", defaultValue="false"), @NiagaraProperty(name="subscriptionEndTime", type="BAbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="maxNotificationDelay", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(BUnit.getUnit(\"second\"), 0, 3600)")})})
public class BBacnetCovMultipleSubscription
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property recipient = BBacnetCovMultipleSubscription.newProperty((int)0, (BValue)new BBacnetRecipientProcess(), null);
    @Generated
    public static final Property issueConfirmedNotifications = BBacnetCovMultipleSubscription.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property subscriptionEndTime = BBacnetCovMultipleSubscription.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    @Generated
    public static final Property maxNotificationDelay = BBacnetCovMultipleSubscription.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"second"), (int)0, (int)3600));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCovMultipleSubscription.class);
    private static Supplier<BAbsTime> nowSupplier = BAbsTime::now;

    @Generated
    public BBacnetRecipientProcess getRecipient() {
        return (BBacnetRecipientProcess)this.get(recipient);
    }

    @Generated
    public void setRecipient(BBacnetRecipientProcess v) {
        this.set(recipient, (BValue)v, null);
    }

    @Generated
    public boolean getIssueConfirmedNotifications() {
        return this.getBoolean(issueConfirmedNotifications);
    }

    @Generated
    public void setIssueConfirmedNotifications(boolean v) {
        this.setBoolean(issueConfirmedNotifications, v, null);
    }

    @Generated
    public BAbsTime getSubscriptionEndTime() {
        return (BAbsTime)this.get(subscriptionEndTime);
    }

    @Generated
    public void setSubscriptionEndTime(BAbsTime v) {
        this.set(subscriptionEndTime, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getMaxNotificationDelay() {
        return (BBacnetUnsigned)this.get(maxNotificationDelay);
    }

    @Generated
    public void setMaxNotificationDelay(BBacnetUnsigned v) {
        this.set(maxNotificationDelay, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        this.getRecipient().writeAsn(out);
        out.writeClosingTag(0);
        out.writeBoolean(1, this.getIssueConfirmedNotifications());
        out.writeUnsignedInteger(2, this.getTimeRemaining());
        out.writeUnsigned(3, this.getMaxNotificationDelay());
        out.writeOpeningTag(4);
        for (BBacnetCovMultipleSubscriptionSpecification entry : (BBacnetCovMultipleSubscriptionSpecification[])this.getChildren(BBacnetCovMultipleSubscriptionSpecification.class)) {
            entry.writeAsn(out);
        }
        out.writeClosingTag(4);
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        BBacnetRecipientProcess recipient = new BBacnetRecipientProcess();
        recipient.readAsn(in);
        in.skipClosingTag(0);
        boolean issueConfirmedNotifications = in.readBoolean(1);
        int timeRemaining = in.readUnsignedInt(2);
        int maxNotificationDelay = in.readUnsignedInt(3);
        ArrayList<BBacnetCovMultipleSubscriptionSpecification> specifications = new ArrayList<BBacnetCovMultipleSubscriptionSpecification>();
        in.skipOpeningTag(4);
        in.peekTag();
        while (!in.isClosingTag(4)) {
            BBacnetCovMultipleSubscriptionSpecification specification = new BBacnetCovMultipleSubscriptionSpecification();
            specification.readAsn(in);
            specifications.add(specification);
            in.peekTag();
        }
        in.skipClosingTag(4);
        this.set(BBacnetCovMultipleSubscription.recipient, (BValue)recipient, noWrite);
        this.setBoolean(BBacnetCovMultipleSubscription.issueConfirmedNotifications, issueConfirmedNotifications, noWrite);
        BAbsTime now = nowSupplier.get();
        BAbsTime subscriptionEndTime = now.add(BRelTime.make((long)((long)timeRemaining * 1000L)));
        this.set(BBacnetCovMultipleSubscription.subscriptionEndTime, (BValue)subscriptionEndTime, noWrite);
        this.set(BBacnetCovMultipleSubscription.maxNotificationDelay, (BValue)BBacnetUnsigned.make(maxNotificationDelay), noWrite);
        this.removeAll(noWrite);
        for (int i = 0; i < specifications.size(); ++i) {
            this.add("entry" + (i + 1), (BValue)specifications.get(i), noWrite);
        }
    }

    public String toString(Context context) {
        return this.getRecipient().toString(context) + (this.getIssueConfirmedNotifications() ? " C until " : " U until ") + this.getSubscriptionEndTime();
    }

    private int getTimeRemaining() {
        if (this.getSubscriptionEndTime().equals((Object)BAbsTime.NULL)) {
            return 0;
        }
        long now = nowSupplier.get().getMillis();
        int timeRemaining = (int)((this.getSubscriptionEndTime().getMillis() - now) / 1000L);
        return timeRemaining > 0 ? timeRemaining : -1;
    }
}

