/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;

public final class BacnetAlarmRecipientUtil {
    private static final Logger logger = Logger.getLogger("bacnet.server");

    private BacnetAlarmRecipientUtil() {
    }

    public static BBacnetObjectIdentifier getEventObjectId(BObject alarmSource) {
        BOrd alarmSourceOrd;
        if (alarmSource == null) {
            logger.fine("alarmSource is null");
            return null;
        }
        if (!(alarmSource instanceof BComponent)) {
            logger.fine("alarmSource is not a component");
            return null;
        }
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier eventEnrollmentId = localDevice.lookupBacnetObjectId(alarmSourceOrd = ((BComponent)alarmSource).getHandleOrd());
        if (eventEnrollmentId != null) {
            return eventEnrollmentId;
        }
        BComponent eventObject = ((BComponent)alarmSource).getParent().asComponent();
        BOrd eventObjectOrd = eventObject.getHandleOrd();
        BBacnetObjectIdentifier eventObjectId = localDevice.lookupBacnetObjectId(eventObjectOrd);
        if (eventObjectId != null) {
            return eventObjectId;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Either alarmSource's parent " + eventObject.getSlotPath() + " or alarmSource " + ((BComponent)alarmSource).getSlotPath() + " is required to be exported to BACnet");
        }
        return null;
    }
}

