/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.timers;

import com.tridium.bacnet.timers.TimerListener;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

public class Timers
implements Runnable {
    public static final int INVALID_TIMER_ID = -1;
    public static final long CANCEL_TIMER = 0L;
    private IntHashMap timerTable = new IntHashMap();
    private int nextTimerId = 0;
    private boolean alive = false;
    private long nextDeadline = Long.MAX_VALUE;
    private Thread myThread = new Thread((Runnable)this, "BnTmrs");
    private static Timers timers;

    public static void start() {
        if (timers == null) {
            timers = new Timers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        if (timers != null) {
            Timers timers = Timers.timers;
            synchronized (timers) {
                if (Timers.timers.myThread != null) {
                    try {
                        Timers.timers.myThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Timers.timers.myThread = null;
                    Timers.timers.timerTable = null;
                }
            }
        }
        timers = null;
    }

    public static int add(TimerListener listener, long msec) {
        return timers.addTimer(listener, msec, null);
    }

    public static int add(TimerListener listener, long msec, Object object) {
        return timers.addTimer(listener, msec, object);
    }

    public static void cancel(TimerListener listener) {
        timers.cancelTimer(listener);
    }

    public static Object cancel(int timerId) {
        return timers.cancelTimer(timerId);
    }

    public static synchronized Object reset(int timerId, long msec) {
        return timers.resetTimer(timerId, msec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"Timers", 2);
        Timers timers = Timers.timers;
        synchronized (timers) {
            out.prop((Object)"nextTimerId", Timers.timers.nextTimerId);
            out.prop((Object)"alive", Timers.timers.alive);
            out.prop((Object)"nextDeadline", (Object)("" + Timers.timers.nextDeadline));
            out.prop((Object)"timerTable size", Timers.timers.timerTable.size());
            IntHashMap.Iterator it = Timers.timers.timerTable.iterator();
            while (it.hasNext()) {
                TimerToken mgr = (TimerToken)it.next();
                out.prop((Object)("" + it.key()), mgr.userObject);
            }
        }
        out.endProps();
    }

    private Timers() {
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addTimer(TimerListener listener, long msec, Object object) {
        TimerToken newTimer = null;
        long deadline = Clock.ticks() + msec;
        Timers timers = this;
        synchronized (timers) {
            if (this.nextTimerId++ == -1) {
                ++this.nextTimerId;
            }
            newTimer = new TimerToken(deadline, this.nextTimerId, listener, object);
            this.timerTable.put(newTimer.timerId, (Object)newTimer);
            if (newTimer.deadline < this.nextDeadline) {
                this.nextDeadline = newTimer.deadline;
            }
            this.notifyAll();
        }
        return newTimer.timerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimer(TimerListener listener) {
        Timers timers = this;
        synchronized (timers) {
            for (TimerToken t : this.timerTable) {
                if (listener != t.listener) continue;
                this.timerTable.remove(t.timerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object cancelTimer(int timerId) {
        Timers timers = this;
        synchronized (timers) {
            TimerToken t = (TimerToken)this.timerTable.get(timerId);
            if (t == null) {
                return null;
            }
            this.timerTable.remove(timerId);
            return t.userObject;
        }
    }

    private synchronized Object resetTimer(int timerId, long msec) {
        long newDeadline;
        TimerToken t = (TimerToken)this.timerTable.get(timerId);
        if (t == null) {
            return null;
        }
        t.deadline = newDeadline = Clock.ticks() + msec;
        return t.userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.alive = true;
        while (this.alive) {
            try {
                Timers timers = this;
                synchronized (timers) {
                    while (this.timerTable != null && this.timerTable.size() < 1) {
                        this.wait();
                    }
                    long sleepTime = this.nextDeadline - Clock.ticks();
                    if (sleepTime > 0L) {
                        this.wait(sleepTime);
                    }
                }
            }
            catch (InterruptedException e) {
                break;
            }
            this.notifyListeners();
        }
    }

    private synchronized void notifyListeners() {
        long now = Clock.ticks();
        this.nextDeadline = Long.MAX_VALUE;
        long restartTime = 0L;
        if (this.timerTable == null) {
            return;
        }
        for (TimerToken t : this.timerTable) {
            if (t.deadline <= now) {
                restartTime = t.listener.timerExpired(t.timerId, t.userObject);
                if (restartTime == 0L) {
                    this.timerTable.remove(t.timerId);
                    continue;
                }
                t.deadline = Clock.ticks() + restartTime;
                if (t.deadline >= this.nextDeadline) continue;
                this.nextDeadline = t.deadline;
                continue;
            }
            if (t.deadline >= this.nextDeadline) continue;
            this.nextDeadline = t.deadline;
        }
    }

    static class TimerToken {
        public long deadline;
        public int timerId;
        public TimerListener listener;
        public Object userObject;

        public TimerToken(long deadline, int timerId, TimerListener listener, Object userObject) {
            this.deadline = deadline;
            this.timerId = timerId;
            this.listener = listener;
            this.userObject = userObject;
        }
    }
}

