/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackErrorCodes;
import com.tridium.bacnet.stack.BacnetStackException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;

public class IdManager
implements BacnetStackErrorCodes {
    public static final int MAX_INVOKE_ID = 255;
    public static final int INVALID_INVOKE_ID = -1;
    private int lastIndex = -1;
    private BBacnetAddress serverAddress;
    private BitSet ids = new BitSet(256);
    private static HashMap<Integer, Array<IdManager>> table = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInvokeId(BBacnetAddress server) throws BacnetStackException {
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            IdManager mgr = IdManager.getIdManager(server);
            if (mgr == null) {
                mgr = new IdManager(server);
                IdManager.setIdManager(server, mgr);
            }
            return mgr.nextId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseId(BBacnetAddress server, int invokeId) {
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            IdManager mgr = IdManager.getIdManager(server);
            if (mgr != null) {
                mgr.release(invokeId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(BBacnetAddress address) {
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            IdManager mgr = IdManager.getIdManager(address);
            if (mgr != null) {
                mgr.dump();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTable() {
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            for (Array<IdManager> networkMap : table.values()) {
                for (IdManager mgr : networkMap) {
                    if (mgr == null) continue;
                    mgr.dump();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdManager getIdManager(BBacnetAddress address) {
        if (address == null) {
            return null;
        }
        if (address.equals(BBacnetAddress.DEFAULT)) {
            return null;
        }
        IdManager idManager = null;
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            int networkNumber = address.getNetworkNumber();
            Array<IdManager> networkManager = table.get(networkNumber);
            byte[] addr = address.getMacAddress().getAddr();
            if (networkManager != null) {
                for (int i = 0; i < networkManager.size(); ++i) {
                    IdManager idm = (IdManager)networkManager.get(i);
                    if (!Arrays.equals(addr, idm.getAddress().getMacAddress().getAddr())) continue;
                    return idm;
                }
            }
        }
        return idManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIdManager(BBacnetAddress address, IdManager idManager) {
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            int networkNumber = address.getNetworkNumber();
            Array networkManager = table.get(networkNumber);
            if (networkManager == null) {
                networkManager = new Array(IdManager.class);
                table.put(networkNumber, (Array<IdManager>)networkManager);
            }
            networkManager.remove((Object)idManager);
            networkManager.add((Object)idManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"IdManager", 2);
        HashMap<Integer, Array<IdManager>> hashMap = table;
        synchronized (hashMap) {
            out.prop((Object)"table size", table.size());
            for (Array<IdManager> networkMap : table.values()) {
                for (IdManager mgr : networkMap) {
                    if (mgr == null) continue;
                    mgr.spyMgr(out);
                }
            }
        }
        out.endProps();
    }

    public void spyMgr(SpyWriter out) throws Exception {
        out.prop((Object)"server", (Object)this.serverAddress);
        out.prop((Object)"server.hashCode", (Object)Integer.toHexString(this.serverAddress.hash()));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 255; ++i) {
            sb.append(this.ids.get(i) ? (char)'-' : 'X');
            if (i % 64 != 63) continue;
            sb.append(' ');
        }
        out.prop((Object)"avail", (Object)sb.toString());
    }

    private IdManager(BBacnetAddress serverAddress) {
        for (int i = 0; i < 256; ++i) {
            this.ids.set(i);
        }
        this.serverAddress = serverAddress;
    }

    private synchronized int nextId() throws BacnetStackException {
        int index;
        int startIndex = index = this.lastIndex++;
        try {
            do {
                if (++index > 255) {
                    index = 0;
                }
                if (!this.ids.get(index)) continue;
                this.ids.clear(index);
                this.lastIndex = index;
                return index;
            } while (index != startIndex);
            throw new BacnetStackException("No Invoke IDs available");
        }
        catch (Exception e) {
            throw new BacnetStackException("No Invoke IDs available");
        }
    }

    private synchronized void release(int invokeId) {
        if (invokeId > 255 || invokeId < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ids.get(invokeId)) {
            throw new IllegalStateException();
        }
        this.ids.set(invokeId);
    }

    public BBacnetAddress getAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return this.serverAddress.toString(null) + " lst=" + this.lastIndex;
    }

    public void dump() {
        System.out.println("Dump for " + this + " (hc:" + this.serverAddress + ")");
        for (int i = 0; i < 255; ++i) {
            System.out.print(this.ids.get(i) ? (char)'-' : 'X');
            if (i % 64 != 63) continue;
            System.out.println();
        }
        System.out.println();
    }
}

