/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetAbort;
import com.tridium.bacnet.services.BacnetComplexAck;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.IHaveListener;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.server.BEventHandler;
import com.tridium.bacnet.stack.server.BOverrideMode;
import com.tridium.bacnet.stack.server.CovHandler;
import com.tridium.bacnet.stack.server.DeviceHandler;
import com.tridium.bacnet.stack.server.FileHandler;
import com.tridium.bacnet.stack.server.PrivateTransferHandler;
import com.tridium.bacnet.stack.server.PropertyHandler;
import com.tridium.bacnet.stack.server.TimeSyncHandler;
import com.tridium.bacnet.stack.server.object.BObjectHandler;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.bacnet.io.BacnetServiceListener;
import javax.baja.bacnet.io.EventNotificationListener;
import javax.baja.bacnet.io.PrivateTransferListener;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BBacnetWorker;
import javax.baja.bacnet.util.worker.IBacnetAddress;
import javax.baja.file.BIFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="worker", type="BBacnetWorker", defaultValue="new BBacnetWorker(\"BacnetServer:worker\")"), @NiagaraProperty(name="eventHandler", type="BEventHandler", defaultValue="new BEventHandler()"), @NiagaraProperty(name="reinitializeAllowed", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="deviceCommControlAllowed", type="boolean", defaultValue="true"), @NiagaraProperty(name="timeSynchAllowed", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="updateStatusOnCov", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="issueUnicastIHave", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="confirmedWorker", type="BBacnetWorker", defaultValue="new BBacnetWorker(\"BacnetServer:confirmedWorker\")"), @NiagaraProperty(name="objectHandler", type="BObjectHandler", defaultValue="new BObjectHandler()"), @NiagaraProperty(name="overrideMode", type="BOverrideMode", defaultValue="BOverrideMode.legacy", flags=4)})
@NiagaraAction(name="checkBackupComm", flags=4)
public class BBacnetServerLayer
extends BComponent
implements BacnetConfirmedServiceChoice,
BacnetUnconfirmedServiceChoice {
    @Generated
    public static final Property worker = BBacnetServerLayer.newProperty((int)0, (BValue)new BBacnetWorker("BacnetServer:worker"), null);
    @Generated
    public static final Property eventHandler = BBacnetServerLayer.newProperty((int)0, (BValue)new BEventHandler(), null);
    @Generated
    public static final Property reinitializeAllowed = BBacnetServerLayer.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property deviceCommControlAllowed = BBacnetServerLayer.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property timeSynchAllowed = BBacnetServerLayer.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property updateStatusOnCov = BBacnetServerLayer.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property issueUnicastIHave = BBacnetServerLayer.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property confirmedWorker = BBacnetServerLayer.newProperty((int)0, (BValue)new BBacnetWorker("BacnetServer:confirmedWorker"), null);
    @Generated
    public static final Property objectHandler = BBacnetServerLayer.newProperty((int)0, (BValue)new BObjectHandler(), null);
    @Generated
    public static final Property overrideMode = BBacnetServerLayer.newProperty((int)4, (BValue)BOverrideMode.legacy, null);
    @Generated
    public static final Action checkBackupComm = BBacnetServerLayer.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetServerLayer.class);
    public static final String BACNET_USER = "Bacnet";
    public static final int NO_INVOKE_ID = -1;
    private DeviceHandler deviceHandler;
    private PropertyHandler propertyHandler;
    private FileHandler fileHandler;
    private CovHandler covHandler;
    private TimeSyncHandler timeSyncHandler;
    private PrivateTransferHandler privateTransferHandler;
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static BBacnetServerLayer cachedServerLayer;
    Clock.Ticket checkBackupTicket = Clock.expiredTicket;
    long lastBackupRestoreCommTime = 0L;
    private static final Logger logger;

    @Generated
    public BBacnetWorker getWorker() {
        return (BBacnetWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BBacnetWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public BEventHandler getEventHandler() {
        return (BEventHandler)this.get(eventHandler);
    }

    @Generated
    public void setEventHandler(BEventHandler v) {
        this.set(eventHandler, (BValue)v, null);
    }

    @Generated
    public boolean getReinitializeAllowed() {
        return this.getBoolean(reinitializeAllowed);
    }

    @Generated
    public void setReinitializeAllowed(boolean v) {
        this.setBoolean(reinitializeAllowed, v, null);
    }

    @Generated
    public boolean getDeviceCommControlAllowed() {
        return this.getBoolean(deviceCommControlAllowed);
    }

    @Generated
    public void setDeviceCommControlAllowed(boolean v) {
        this.setBoolean(deviceCommControlAllowed, v, null);
    }

    @Generated
    public boolean getTimeSynchAllowed() {
        return this.getBoolean(timeSynchAllowed);
    }

    @Generated
    public void setTimeSynchAllowed(boolean v) {
        this.setBoolean(timeSynchAllowed, v, null);
    }

    @Generated
    public boolean getUpdateStatusOnCov() {
        return this.getBoolean(updateStatusOnCov);
    }

    @Generated
    public void setUpdateStatusOnCov(boolean v) {
        this.setBoolean(updateStatusOnCov, v, null);
    }

    @Generated
    public boolean getIssueUnicastIHave() {
        return this.getBoolean(issueUnicastIHave);
    }

    @Generated
    public void setIssueUnicastIHave(boolean v) {
        this.setBoolean(issueUnicastIHave, v, null);
    }

    @Generated
    public BBacnetWorker getConfirmedWorker() {
        return (BBacnetWorker)this.get(confirmedWorker);
    }

    @Generated
    public void setConfirmedWorker(BBacnetWorker v) {
        this.set(confirmedWorker, (BValue)v, null);
    }

    @Generated
    public BObjectHandler getObjectHandler() {
        return (BObjectHandler)this.get(objectHandler);
    }

    @Generated
    public void setObjectHandler(BObjectHandler v) {
        this.set(objectHandler, (BValue)v, null);
    }

    @Generated
    public BOverrideMode getOverrideMode() {
        return (BOverrideMode)this.get(overrideMode);
    }

    @Generated
    public void setOverrideMode(BOverrideMode v) {
        this.set(overrideMode, (BValue)v, null);
    }

    @Generated
    public void checkBackupComm() {
        this.invoke(checkBackupComm, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBacnetServerLayer getServerLayer() {
        BBacnetServerLayer serverLayer = cachedServerLayer;
        if (serverLayer == null || serverLayer.getComponentSpace() == null || !serverLayer.isRunning()) {
            BBacnetComm comm;
            BBacnetNetwork network = BBacnetNetwork.bacnet();
            BBacnetComm bBacnetComm = comm = network != null ? network.getBacnetComm() : null;
            if (comm instanceof BBacnetStack) {
                cachedServerLayer = serverLayer = ((BBacnetStack)comm).getServer();
            } else {
                serverLayer = null;
                cachedServerLayer = null;
            }
        }
        return serverLayer;
    }

    public void started() {
        boolean deviceCommControlAllowed;
        boolean reinitializeAllowed;
        this.deviceHandler = new DeviceHandler(this);
        this.propertyHandler = new PropertyHandler(this);
        this.fileHandler = new FileHandler(this);
        this.covHandler = new CovHandler();
        this.timeSyncHandler = new TimeSyncHandler(this);
        this.privateTransferHandler = new PrivateTransferHandler(this);
        this.unhideProperty(BBacnetServerLayer.reinitializeAllowed);
        this.unhideProperty(timeSynchAllowed);
        this.unhideProperty(updateStatusOnCov);
        this.unhideProperty(issueUnicastIHave);
        this.unhideProperty(overrideMode);
        BBacnetServerLayer.setServicesSupportedBit(18, false);
        BBacnetServerLayer.setServicesSupportedBit(30, false);
        boolean[] servicesSupported = BBacnetNetwork.localDevice().getProtocolServicesSupported().getBits();
        boolean timeSynchAllowed = this.getTimeSynchAllowed();
        if (servicesSupported[32] != timeSynchAllowed || servicesSupported[36] != timeSynchAllowed) {
            BBacnetServerLayer.setServicesSupportedBit(32, timeSynchAllowed);
            BBacnetServerLayer.setServicesSupportedBit(36, timeSynchAllowed);
        }
        boolean bl = reinitializeAllowed = this.getReinitializeAllowed() && BBacnetNetwork.bacnet().hasServerLicense();
        if (servicesSupported[20] != reinitializeAllowed) {
            BBacnetServerLayer.setServicesSupportedBit(20, reinitializeAllowed);
        }
        if (servicesSupported[17] != (deviceCommControlAllowed = this.getDeviceCommControlAllowed())) {
            BBacnetServerLayer.setServicesSupportedBit(17, deviceCommControlAllowed);
        }
    }

    private void unhideProperty(Property property) {
        if (!Flags.has((BComplex)this, (Slot)property, (int)0x10000000)) {
            Flags.remove((BComponent)this, (Slot)property, null, (int[])new int[]{4});
            Flags.add((BComponent)this, (Slot)property, null, (int[])new int[]{0x10000000});
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(timeSynchAllowed)) {
            BBacnetServerLayer.setServicesSupportedBit(32, this.getTimeSynchAllowed());
            BBacnetServerLayer.setServicesSupportedBit(36, this.getTimeSynchAllowed());
        } else if (p.equals(reinitializeAllowed)) {
            BBacnetServerLayer.setServicesSupportedBit(20, this.getReinitializeAllowed() && BBacnetNetwork.bacnet().hasServerLicense());
        } else if (p.equals(deviceCommControlAllowed)) {
            BBacnetServerLayer.setServicesSupportedBit(17, this.getDeviceCommControlAllowed());
        }
    }

    public void stackStopped() {
        this.deviceHandler = null;
        this.propertyHandler = null;
        this.fileHandler = null;
        this.covHandler = null;
        this.timeSyncHandler = null;
        this.privateTransferHandler = null;
        BBacnetServerLayer.setServicesSupportedBit(18, false);
        BBacnetServerLayer.setServicesSupportedBit(30, false);
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetStack;
    }

    final BBacnetStack stack() {
        return (BBacnetStack)this.getParent();
    }

    void scheduleBackupRestoreFailure() {
        logger.fine("Scheduling new checkBackupTicket");
        this.checkBackupTicket.cancel();
        this.updateLastBackupRestoreCommTime();
        this.checkBackupTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)checkBackupComm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckBackupComm() {
        Object object = this.deviceHandler.backupRestoreStepLock;
        synchronized (object) {
            switch (this.deviceHandler.backupRestoreStep) {
                case FINISHED_BACKUP: 
                case BACKUP_FAILED: 
                case READY_FOR_RESTORE: 
                case RESTORE_FAILED: {
                    BLocalBacnetDevice localDevice;
                    long timeSinceBackupComm = Clock.ticks() - this.lastBackupRestoreCommTime;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Checking backup comm: lastBackupCommTime = " + this.lastBackupRestoreCommTime + "; time since last comm [ms] = " + timeSinceBackupComm);
                    }
                    if (timeSinceBackupComm <= (localDevice = BBacnetNetwork.localDevice()).getBackupFailureTimeout().getMillis()) break;
                    logger.info("Last comm time was " + this.lastBackupRestoreCommTime + " and " + timeSinceBackupComm + " ms ago; Backup_Failure_Timeout is " + localDevice.getBackupFailureTimeout() + "; exiting Backup/Restore mode...");
                    this.checkBackupTicket.cancel();
                    this.cleanupBackupMode();
                    localDevice.setBackupAndRestoreState(BBacnetBackupState.idle);
                    localDevice.restoreSystemStatus();
                    this.deviceHandler.backupRestoreStep = DeviceHandler.BackupRestoreStep.BACKUP_RESTORE_IDLE;
                    break;
                }
                case RUNNING_RESTORE: {
                    this.updateLastBackupRestoreCommTime();
                    break;
                }
                default: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Cancelling checkBackupTicket that should not be active in backupRestoreStep " + (Object)((Object)this.deviceHandler.backupRestoreStep));
                    }
                    this.checkBackupTicket.cancel();
                }
            }
        }
    }

    void updateLastBackupRestoreCommTime() {
        this.lastBackupRestoreCommTime = Clock.ticks();
    }

    public void cleanupBackupMode() {
        BIFile file;
        BComponent parent;
        this.deviceHandler.backupRestoreClient = null;
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        localDevice.getConfigurationFiles().setSize(0);
        BBacnetFileDescriptor fileDesc = this.deviceHandler.backupRestoreFileDesc.getAndSet(null);
        if (fileDesc != null && (parent = (BComponent)fileDesc.getParent()) != null) {
            parent.remove((BComplex)fileDesc);
        }
        if ((file = (BIFile)this.deviceHandler.backupRestoreFile.getAndSet(null)) != null) {
            try {
                AccessController.doPrivileged(() -> {
                    file.delete();
                    return null;
                });
            }
            catch (Exception e) {
                Exception unwrapped = e;
                if (e instanceof PrivilegedActionException) {
                    unwrapped = ((PrivilegedActionException)e).getException();
                }
                logger.log(Level.SEVERE, "Exception occurred while deleting the backup/restore file in cleanupBackupRestore", unwrapped);
            }
        }
    }

    public void iAm() {
        this.iAm(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS);
    }

    public void iAm(BBacnetAddress sourceAddress) {
        if (!this.stack().isCommExecutionEnabled()) {
            return;
        }
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        IAmRequest request = new IAmRequest(local.getObjectId(), local.getMaxAPDULengthAccepted(), local.getSegmentationSupported(), local.getVendorId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Server.Sending I-Am....\n" + request + " to " + sourceAddress);
        }
        try {
            this.transport().sendUnconfirmedRequest(request, sourceAddress, BNetworkPriority.normal);
        }
        catch (BacnetException e) {
            logger.log(Level.SEVERE, "Exception sending I-Am service!", (Throwable)((Object)e));
        }
    }

    public void iHave(BBacnetObjectIdentifier objectId, String objectName, BCharacterSetEncoding encoding) {
        this.iHave(objectId, objectName, encoding, BBacnetAddress.GLOBAL_BROADCAST_ADDRESS);
    }

    public void iHave(BBacnetObjectIdentifier objectId, String objectName, BCharacterSetEncoding encoding, BBacnetAddress sourceAddress) {
        if (!this.stack().isCommInitiationEnabled()) {
            return;
        }
        IHaveRequest request = new IHaveRequest(this.bacnet().getObjectId(), objectId, objectName, encoding);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Server.Sending I-Have....\n" + request);
        }
        try {
            if (!this.getIssueUnicastIHave()) {
                sourceAddress = BBacnetAddress.GLOBAL_BROADCAST_ADDRESS;
            }
            this.transport().sendUnconfirmedRequest(request, sourceAddress, BNetworkPriority.normal);
        }
        catch (BacnetException e) {
            logger.log(Level.SEVERE, "Exception sending I-Have service!", (Throwable)((Object)e));
        }
    }

    public void receiveConfirmedRequest(BBacnetAddress srcAddr, int invokeId, BacnetConfirmedRequest request, BNetworkPriority networkPriority) {
        ServerRequest sr = new ServerRequest(srcAddr, invokeId, request, networkPriority);
        this.getConfirmedWorker().post(sr);
    }

    public void receiveUnconfirmedRequest(BBacnetAddress srcAddr, BacnetUnconfirmedRequest request, BNetworkPriority networkPriority) {
        ServerRequest sr = new ServerRequest(srcAddr, -1, request, networkPriority);
        try {
            this.getWorker().post(sr);
        }
        catch (QueueFullException e) {
            logger.log(Level.SEVERE, "QueueFullException in receiveUnconfirmedRequest", e);
        }
    }

    protected void process(ServerRequest sr) {
        try {
            switch (sr.getType()) {
                case 0: {
                    this.processConfirmedRequest(sr);
                    break;
                }
                case 1: {
                    this.processUnconfirmedRequest(sr);
                    break;
                }
                default: {
                    logger.info("Bacnet server request ignored: " + sr.getType());
                    break;
                }
            }
        }
        catch (RejectException e) {
            this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), new BacnetReject(e.getRejectReason()), sr.getNetworkPriority());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Bacnet Server Error!", e);
        }
    }

    private void processUnconfirmedRequest(ServerRequest sr) {
        if (this.isFromNonBackupRestoreClient(sr) && logger.isLoggable(Level.FINE)) {
            logger.fine("Unconfirmed Request from non-backup client ignored...");
        }
        BacnetUnconfirmedRequest request = (BacnetUnconfirmedRequest)sr.getRequest();
        BacnetUnconfirmedServiceChoice handler = null;
        int serviceChoice = request.getServiceChoice();
        switch (serviceChoice) {
            case 0: 
            case 1: 
            case 7: 
            case 8: {
                handler = this.deviceHandler;
                break;
            }
            case 3: {
                handler = this.getEventHandler();
                break;
            }
            case 2: {
                handler = this.covHandler;
                break;
            }
            case 6: 
            case 9: {
                handler = this.timeSyncHandler;
                break;
            }
            case 4: {
                handler = this.privateTransferHandler;
                break;
            }
            default: {
                logger.info("BBacnetServerLayer: Unknown unconfirmed service choice encountered " + serviceChoice);
            }
        }
        if (handler != null) {
            handler.receiveRequest(serviceChoice, request, sr.getSrcAddr());
        } else {
            logger.warning("BBacnetServerLayer: No handler for unconfirmed service request! " + request);
        }
    }

    private boolean isFromNonBackupRestoreClient(ServerRequest serverRequest) {
        BBacnetAddress backupRestoreClientAddress = this.deviceHandler.backupRestoreClient;
        if (backupRestoreClientAddress != null) {
            BBacnetAddress srcAddr = serverRequest.getSrcAddr();
            return !backupRestoreClientAddress.equals(srcAddr.getNetworkNumber(), srcAddr.getMacAddress().getBytes());
        }
        return false;
    }

    private void processConfirmedRequest(ServerRequest sr) throws RejectException {
        if (this.isFromNonBackupRestoreClient(sr)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Confirmed Request from non-backup client rejected...");
            }
            this.sendConfigurationInProgress(sr);
            return;
        }
        BacnetConfirmedRequest request = (BacnetConfirmedRequest)sr.getRequest();
        int serviceChoice = request.getServiceChoice();
        boolean serviceSupported = BBacnetNetwork.localDevice().getProtocolServicesSupported().getBit(request.getServiceBitIndex());
        if (!serviceSupported) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Throwing reject for unsupported service: " + serviceChoice + " [" + BacnetConfirmedServiceChoice.TAGS[serviceChoice] + ']');
            }
            throw new RejectException(9);
        }
        BacnetConfirmedServiceChoice handler = null;
        switch (serviceChoice) {
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 26: {
                handler = this.propertyHandler;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 29: {
                handler = this.getEventHandler();
                break;
            }
            case 1: 
            case 5: 
            case 28: {
                handler = this.covHandler;
                break;
            }
            case 6: 
            case 7: {
                handler = this.fileHandler;
                break;
            }
            case 17: 
            case 20: {
                handler = this.deviceHandler;
                break;
            }
            case 18: {
                handler = this.privateTransferHandler;
                break;
            }
            case 10: 
            case 11: {
                handler = this.getObjectHandler();
                break;
            }
            default: {
                logger.info("BBacnetServerLayer: Unknown confirmed service choice encountered: " + serviceChoice);
                throw new RejectException(9);
            }
        }
        if (handler == null) {
            logger.warning("BBacnetServerLayer: No handler for confirmed service request! " + request);
        } else {
            BacnetServicePrimitive response = handler.receiveRequest(serviceChoice, request, sr.getSrcAddr());
            switch (response.getServiceType()) {
                case 3: {
                    this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), (BacnetComplexAck)response, sr.getNetworkPriority());
                    break;
                }
                case 2: {
                    this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), (BacnetSimpleAck)response, sr.getNetworkPriority());
                    break;
                }
                case 5: {
                    this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), (BacnetError)response, sr.getNetworkPriority());
                    break;
                }
                case 7: {
                    this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), (BacnetAbort)response, sr.getNetworkPriority());
                    break;
                }
                case 6: {
                    this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), (BacnetReject)response, sr.getNetworkPriority());
                    break;
                }
                default: {
                    logger.severe("BBacnetServerLayer: Unknown response type from handler! " + response.getServiceType());
                }
            }
        }
    }

    private void sendConfigurationInProgress(ServerRequest sr) {
        this.transport().sendConfirmedResponse(sr.getSrcAddr(), sr.getInvokeId(), new SimpleError(sr.getRequest().getServiceChoice(), new NErrorType(0, 2)), sr.getNetworkPriority());
    }

    public void registerBacnetServiceListener(BacnetServiceListener listener, int serviceIndex) {
        if (listener == null) {
            return;
        }
        String serviceName = lex.getText("BacnetServicesSupported.bit" + serviceIndex);
        boolean err = false;
        try {
            switch (serviceIndex) {
                case 2: 
                case 29: {
                    if (listener instanceof EventNotificationListener) {
                        this.getEventHandler().addListener((EventNotificationListener)listener, serviceIndex);
                        break;
                    }
                    err = true;
                    break;
                }
                case 18: 
                case 30: {
                    if (listener instanceof PrivateTransferListener) {
                        this.privateTransferHandler.addListener((PrivateTransferListener)listener, serviceIndex == 18);
                        BBacnetServerLayer.setServicesSupportedBit(serviceIndex, true);
                        break;
                    }
                    err = true;
                    break;
                }
                case 26: {
                    if (listener instanceof IAmListener) {
                        this.deviceHandler.addIAmListener((IAmListener)listener);
                        break;
                    }
                    err = true;
                    break;
                }
                case 27: {
                    if (listener instanceof IHaveListener) {
                        this.deviceHandler.addIHaveListener((IHaveListener)listener);
                        break;
                    }
                    err = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to register " + listener.getClass() + " for service " + serviceName + ":" + e, e);
        }
        if (err) {
            logger.warning("Listener/Service mismatch: attempt to register " + listener.getClass() + " for service " + serviceName);
        } else {
            logger.info("Listener " + listener + " registered for service:" + serviceName);
        }
    }

    public void unregisterBacnetServiceListener(BacnetServiceListener listener, int serviceIndex) {
        if (listener == null) {
            return;
        }
        String serviceName = lex.getText("BacnetServicesSupported.bit" + serviceIndex);
        boolean err = false;
        switch (serviceIndex) {
            case 2: 
            case 29: {
                if (listener instanceof EventNotificationListener) {
                    this.getEventHandler().removeListener((EventNotificationListener)listener, serviceIndex);
                    break;
                }
                err = true;
                break;
            }
            case 18: {
                if (listener instanceof PrivateTransferListener) {
                    this.privateTransferHandler.removeListener((PrivateTransferListener)listener, true);
                    BBacnetServerLayer.setServicesSupportedBit(serviceIndex, !this.privateTransferHandler.confirmedListeners.isEmpty());
                    break;
                }
                err = true;
                break;
            }
            case 30: {
                if (listener instanceof PrivateTransferListener) {
                    this.privateTransferHandler.removeListener((PrivateTransferListener)listener, false);
                    BBacnetServerLayer.setServicesSupportedBit(serviceIndex, !this.privateTransferHandler.unconfirmedListeners.isEmpty());
                    break;
                }
                err = true;
                break;
            }
            case 26: {
                if (listener instanceof IAmListener) {
                    this.deviceHandler.removeIAmListener((IAmListener)listener);
                    break;
                }
                err = true;
                break;
            }
            case 27: {
                if (listener instanceof IHaveListener) {
                    this.deviceHandler.removeIHaveListener((IHaveListener)listener);
                    break;
                }
                err = true;
                break;
            }
        }
        if (err) {
            logger.warning("Listener/Service mismatch: attempt to unregister " + listener.getClass() + " for service " + serviceName);
        } else {
            logger.info("Listener " + listener + " unregistered for service:" + serviceName);
        }
    }

    private static void setServicesSupportedBit(int index, boolean newState) {
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        BBacnetBitString newBitString = BBacnetBitString.make(localDevice.getProtocolServicesSupported(), index, newState);
        localDevice.setProtocolServicesSupported(newBitString);
    }

    @Deprecated
    public void registerPrivateTransferListener(PrivateTransferListener listener) {
        logger.warning("This method is deprecated! Use registerBacnetServiceListener() instead.");
    }

    @Deprecated
    public void unregisterPrivateTransferListener(PrivateTransferListener listener) {
        logger.warning("This method is deprecated! Use unregisterBacnetServiceListener() instead.");
    }

    public void registerIAmListener(IAmListener listener) {
        this.deviceHandler.addIAmListener(listener);
    }

    public void unregisterIAmListener(IAmListener listener) {
        this.deviceHandler.removeIAmListener(listener);
    }

    public void registerIHaveListener(IHaveListener listener) {
        this.deviceHandler.addIHaveListener(listener);
    }

    public void unregisterIHaveListener(IHaveListener listener) {
        this.deviceHandler.removeIHaveListener(listener);
    }

    BBacnetNetwork bacnet() {
        return (BBacnetNetwork)this.getParent().getParent();
    }

    private BBacnetTransportLayer transport() {
        return ((BBacnetStack)this.getParent()).getTransport();
    }

    public void spy(SpyWriter out) throws Exception {
        Object o;
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetServerLayer", 2);
        out.prop((Object)"deviceHandler", (Object)this.deviceHandler);
        out.prop((Object)"propertyHandler", (Object)this.propertyHandler);
        out.prop((Object)"fileHandler", (Object)this.fileHandler);
        out.prop((Object)"covHandler", (Object)this.covHandler);
        out.prop((Object)"timeSyncHandler", (Object)this.timeSyncHandler);
        out.prop((Object)"privateTransferHandler", (Object)this.privateTransferHandler);
        out.trTitle((Object)("Private Transfer ConfirmedListeners:" + this.privateTransferHandler.confirmedListeners.size()), 2);
        IntHashMap.Iterator it = this.privateTransferHandler.confirmedListeners.iterator();
        while (it.hasNext()) {
            o = it.next();
            out.prop((Object)("  " + it.key()), o);
        }
        out.trTitle((Object)("Private Transfer UnconfirmedListeners:" + this.privateTransferHandler.unconfirmedListeners.size()), 2);
        it = this.privateTransferHandler.unconfirmedListeners.iterator();
        while (it.hasNext()) {
            o = it.next();
            out.prop((Object)("  " + it.key()), o);
        }
        out.prop((Object)"backupFileId", (Object)this.getBackupRestoreFileId());
        out.prop((Object)"exitBackupTicket", (Object)this.checkBackupTicket);
        out.prop((Object)"now", (double)Clock.ticks());
        out.prop((Object)"lastBackupCommTime", (double)this.lastBackupRestoreCommTime);
        out.prop((Object)"backupRestoreClientAddress", (Object)this.deviceHandler.backupRestoreClient);
        out.endProps();
    }

    BBacnetObjectIdentifier getBackupRestoreFileId() {
        BBacnetFileDescriptor fileDesc = this.deviceHandler.backupRestoreFileDesc.get();
        return fileDesc == null ? null : fileDesc.getObjectId();
    }

    static {
        logger = Logger.getLogger("bacnet.server");
    }

    private class ServerRequest
    implements IBacnetAddress,
    Runnable {
        private final BBacnetAddress srcAddr;
        private final int invokeId;
        private final BacnetServicePrimitive request;
        private final BNetworkPriority networkPriority;

        public ServerRequest(BBacnetAddress srcAddr, int invokeId, BacnetServicePrimitive request, BNetworkPriority networkPriority) {
            this.srcAddr = srcAddr;
            this.invokeId = invokeId;
            this.request = request;
            this.networkPriority = networkPriority;
        }

        public int getServiceType() {
            return this.getType();
        }

        public int getType() {
            return this.request.getServiceType();
        }

        public BacnetServicePrimitive getRequest() {
            return this.request;
        }

        @Override
        public BBacnetAddress getAddress() {
            return this.srcAddr;
        }

        public BBacnetAddress getSrcAddr() {
            return this.srcAddr;
        }

        public int getInvokeId() {
            return this.invokeId;
        }

        public BNetworkPriority getNetworkPriority() {
            return this.networkPriority;
        }

        @Override
        public void run() {
            BBacnetServerLayer.this.process(this);
        }
    }
}

