/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.BBacnetMultiPoll;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.BLinkLayerChoice;
import com.tridium.bacnet.stack.link.LinkListener;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BRouterStatus;
import com.tridium.bacnet.stack.network.DataAttributes;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.bacnet.stack.network.messages.NetworkNumberIs;
import com.tridium.bacnet.stack.network.wiretap.IncomingWiretap;
import com.tridium.bacnet.stack.network.wiretap.OutgoingWiretap;
import com.tridium.bacnet.stack.network.wiretap.WiretapAware;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.enums.BBacnetNetworkNumberQuality;
import javax.baja.bacnet.export.BBacnetNetworkPortDescriptor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkNumber", type="int", defaultValue="-1"), @NiagaraProperty(name="networkNumberQuality", type="BBacnetNetworkNumberQuality", defaultValue="BBacnetNetworkNumberQuality.DEFAULT", flags=65), @NiagaraProperty(name="link", type="BBacnetLinkLayer", defaultValue="new BBacnetEthernetLinkLayer()"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="multiPoll", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="pollService", type="BBacnetPoll", defaultValue="new BBacnetMultiPoll()"), @NiagaraProperty(name="maxDevices", type="int", defaultValue="Integer.MAX_VALUE", flags=1), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=64), @NiagaraProperty(name="portId", type="int", defaultValue="-1", flags=65), @NiagaraProperty(name="portInfo", type="String", defaultValue="", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="enable"), @NiagaraAction(name="disable"), @NiagaraAction(name="sendNetworkNumberIs", flags=4)})
public class BNetworkPort
extends BComponent
implements LinkListener,
BacnetConst,
WiretapAware {
    @Generated
    public static final Property networkNumber = BNetworkPort.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property networkNumberQuality = BNetworkPort.newProperty((int)65, (BValue)BBacnetNetworkNumberQuality.DEFAULT, null);
    @Generated
    public static final Property link = BNetworkPort.newProperty((int)0, (BValue)new BBacnetEthernetLinkLayer(), null);
    @Generated
    public static final Property status = BNetworkPort.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BNetworkPort.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property multiPoll = BNetworkPort.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property pollService = BNetworkPort.newProperty((int)0, (BValue)new BBacnetMultiPoll(), null);
    @Generated
    public static final Property maxDevices = BNetworkPort.newProperty((int)1, (int)Integer.MAX_VALUE, null);
    @Generated
    public static final Property enabled = BNetworkPort.newProperty((int)64, (boolean)false, null);
    @Generated
    public static final Property portId = BNetworkPort.newProperty((int)65, (int)-1, null);
    @Generated
    public static final Property portInfo = BNetworkPort.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action enable = BNetworkPort.newAction((int)0, null);
    @Generated
    public static final Action disable = BNetworkPort.newAction((int)0, null);
    @Generated
    public static final Action sendNetworkNumberIs = BNetworkPort.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNetworkPort.class);
    private boolean fatalFault = false;
    private String fault = null;
    protected static final Logger logger = Logger.getLogger("bacnet.network");
    private Set<OutgoingWiretap> wiretaps = Collections.synchronizedSet(new HashSet());
    private static int portIds = 1;
    private volatile BBacnetAddress address = null;
    private boolean ready = false;
    private int oldNetworkNumber = -1;
    private int oldStatus = 0;
    private final AtomicReference<Clock.Ticket> networkNumberIsTicket = new AtomicReference();

    @Generated
    public int getNetworkNumber() {
        return this.getInt(networkNumber);
    }

    @Generated
    public void setNetworkNumber(int v) {
        this.setInt(networkNumber, v, null);
    }

    @Generated
    public BBacnetNetworkNumberQuality getNetworkNumberQuality() {
        return (BBacnetNetworkNumberQuality)this.get(networkNumberQuality);
    }

    @Generated
    public void setNetworkNumberQuality(BBacnetNetworkNumberQuality v) {
        this.set(networkNumberQuality, (BValue)v, null);
    }

    @Generated
    public BBacnetLinkLayer getLink() {
        return (BBacnetLinkLayer)this.get(link);
    }

    @Generated
    public void setLink(BBacnetLinkLayer v) {
        this.set(link, (BValue)v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getMultiPoll() {
        return this.getBoolean(multiPoll);
    }

    @Generated
    public void setMultiPoll(boolean v) {
        this.setBoolean(multiPoll, v, null);
    }

    @Generated
    public BBacnetPoll getPollService() {
        return (BBacnetPoll)this.get(pollService);
    }

    @Generated
    public void setPollService(BBacnetPoll v) {
        this.set(pollService, (BValue)v, null);
    }

    @Generated
    public int getMaxDevices() {
        return this.getInt(maxDevices);
    }

    @Generated
    public void setMaxDevices(int v) {
        this.setInt(maxDevices, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public int getPortId() {
        return this.getInt(portId);
    }

    @Generated
    public void setPortId(int v) {
        this.setInt(portId, v, null);
    }

    @Generated
    public String getPortInfo() {
        return this.getString(portInfo);
    }

    @Generated
    public void setPortInfo(String v) {
        this.setString(portInfo, v, null);
    }

    @Generated
    public void enable() {
        this.invoke(enable, null, null);
    }

    @Generated
    public void disable() {
        this.invoke(disable, null, null);
    }

    @Generated
    public void sendNetworkNumberIs() {
        this.invoke(sendNetworkNumberIs, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BNetworkPort make(int networkNumber, BLinkLayerChoice linkLayer) {
        BNetworkPort port = new BNetworkPort();
        port.setNetworkNumber(networkNumber);
        switch (linkLayer.getOrdinal()) {
            case 0: {
                port.setLink(new BBacnetIpLinkLayer());
                port.setPortInfo("Annex J IP");
                return port;
            }
            case 1: {
                port.setLink(new BBacnetEthernetLinkLayer());
                port.setPortInfo("Ethernet");
                return port;
            }
            case 3: {
                port.setLink(new BBacnetMstpLinkLayer());
                port.setPortInfo("MS/TP");
                return port;
            }
            case 7: {
                port.setLink(new BScLinkLayer());
                port.setPortInfo("Secure Connect");
                return port;
            }
        }
        throw new IllegalArgumentException("Unsupported Link Layer Choice!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEnable() {
        if (!this.isRunning()) {
            return;
        }
        BBacnetNetworkLayer networkLayer = this.getNetworkLayer();
        int networkNumber = this.getNetworkNumber();
        if (this.fatalFault || !networkLayer.isValidNetworkNumber(networkNumber)) {
            this.setBoolean(enabled, false, noWrite);
            return;
        }
        try {
            this.getLink().linkInit();
            this.getLink().addLinkListener(this);
            this.getLink().linkStart();
            networkLayer.updateRouterAddress(networkNumber, networkNumber, this.getLink().getMacAddress(), BRouterStatus.ok, this.getPortInfo());
            this.getPollService().pollStart();
            networkLayer.issueIAmRouterToNetworks();
            this.sendToLink(null, new NetworkNumberIs(networkNumber));
            BBacnetNetwork.localDevice().sendIAm();
            this.set(enabled, (BValue)BBoolean.TRUE, noWrite);
            this.ok();
        }
        catch (BajaRuntimeException e) {
            logger.log(Level.WARNING, "Exception enabling BACnet network port: " + this + ":" + (Object)((Object)e), e);
            this.fault(e.getMessage() != null ? e.getMessage() : "Null Exception Cause");
            this.doDisable();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot enable BACnet network port: " + this + ":" + e, e);
            this.fault(e.toString());
            this.doDisable();
        }
        finally {
            this.updateStatus();
        }
    }

    public void doDisable() {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.set(enabled, (BValue)BBoolean.FALSE, noWrite);
            this.getPollService().pollStop();
            this.getNetworkLayer().getRouterTable().removeRouterByPortId(this.getPortId());
            this.getLink().removeLinkListener(this);
            this.getLink().linkStop();
            this.getLink().linkCleanup();
        }
        catch (Exception e) {
            logger.warning("Exception disabling BACnet network port: " + this + ":" + e);
        }
        finally {
            this.updateStatus();
        }
    }

    public void doSendNetworkNumberIs() {
        int networkNumber = this.getNetworkNumber();
        if (BNetworkPort.isConfiguredNetworkNumber(networkNumber)) {
            this.sendToLink(null, new NetworkNumberIs(networkNumber, this.isNetworkNumberConfigured()));
        }
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        Type pollServiceType = this.getPollService().getType();
        if (this.getMultiPoll() || this.getLink().getType().is(BBacnetMstpLinkLayer.TYPE)) {
            if (!pollServiceType.is(BBacnetMultiPoll.TYPE)) {
                this.setPollService(new BBacnetMultiPoll());
            }
        } else if (pollServiceType.is(BBacnetMultiPoll.TYPE)) {
            this.setPollService(new BBacnetPoll());
        }
        this.setPortId(portIds++);
        this.oldNetworkNumber = this.getNetworkNumber();
        if (!BNetworkPort.isConfiguredNetworkNumber(this.oldNetworkNumber)) {
            this.setNetworkNumberQuality(BBacnetNetworkNumberQuality.unknown);
        } else if (this.getNetworkNumberQuality().equals((Object)BBacnetNetworkNumberQuality.unknown)) {
            this.setNetworkNumberQuality(BBacnetNetworkNumberQuality.configured);
        }
        this.updateStatus();
        if (Sys.atSteadyState()) {
            this.ready = true;
        }
        if (!this.fatalFault && this.getEnabled() && this.getNetworkLayer().isValidNetworkNumber(this.oldNetworkNumber)) {
            this.getLink().linkInit();
        }
        if (!this.fatalFault && Sys.isStationStarted()) {
            this.manageDescriptorAtStarted();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (!this.fatalFault) {
            this.manageDescriptorAtStarted();
        }
    }

    private void manageDescriptorAtStarted() {
        if (this.isFrozenIpPort() && !this.getEnabled()) {
            BBacnetNetworkPortDescriptor descriptor = this.findDescriptor();
            if (descriptor != null) {
                this.updateDescriptor(descriptor);
            }
        } else {
            this.addOrUpdateDescriptor();
        }
    }

    private boolean isFrozenIpPort() {
        return BBacnetNetworkLayer.ipPort.equals(this.getPropertyInParent());
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        BValue o = null;
        o = this.get(p);
        if (o instanceof IncomingWiretap) {
            this.getLink().addLinkListener((IncomingWiretap)o);
        }
        if (o instanceof OutgoingWiretap) {
            this.wiretaps.add((OutgoingWiretap)o);
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        super.removed(p, oldValue, cx);
        if (oldValue instanceof IncomingWiretap) {
            this.getLink().removeLinkListener((IncomingWiretap)oldValue);
        }
        if (oldValue instanceof OutgoingWiretap) {
            this.wiretaps.remove((OutgoingWiretap)oldValue);
        }
    }

    public void stopped() {
        this.stackStopped();
        if (Sys.getStation().isRunning()) {
            this.removeDescriptor();
        }
    }

    public void stackStopped() {
        try {
            if (this.getEnabled()) {
                this.getPollService().pollStop();
                this.getNetworkLayer().getRouterTable().removeRouterByPortId(this.getPortId());
                this.getLink().removeLinkListener(this);
                this.getLink().linkStop();
                this.getLink().linkCleanup();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to stop NetworkPort", e);
        }
    }

    public void changed(Property p, Context cx) {
        BBacnetNetworkPortDescriptor descriptor;
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(networkNumber)) {
            int newNetworkNumber;
            BBacnetNetworkLayer networkLayer = this.getNetworkLayer();
            if (!networkLayer.isValidNetworkNumber(newNetworkNumber = this.getNetworkNumber())) {
                if (this.getEnabled()) {
                    logger.severe("Invalid network number " + newNetworkNumber + "! Because port is enabled, resetting to old value " + this.oldNetworkNumber + "...");
                    this.setInt(networkNumber, this.oldNetworkNumber, fallback);
                } else {
                    this.oldNetworkNumber = newNetworkNumber;
                    this.updateNetworkNumberQuality(newNetworkNumber);
                    this.updateStatus();
                }
            } else {
                int count = 0;
                for (BNetworkPort port : networkLayer.getPorts()) {
                    if (port.getNetworkNumber() != newNetworkNumber) continue;
                    ++count;
                }
                if (count > 1) {
                    logger.severe("Duplicate network number! Resetting to old DNET " + this.oldNetworkNumber + "...");
                    this.setInt(networkNumber, this.oldNetworkNumber, fallback);
                } else {
                    networkLayer.getRouterTable().removeRouterByDnet(this.oldNetworkNumber);
                    if (this.getEnabled()) {
                        networkLayer.updateRouterAddress(newNetworkNumber, newNetworkNumber, this.getLink().getMacAddress(), BRouterStatus.ok, this.getPortInfo());
                    }
                    this.oldNetworkNumber = newNetworkNumber;
                    this.updateNetworkNumberQuality(newNetworkNumber);
                    this.updateStatus();
                }
            }
        } else if (p.equals(enabled) && cx != noWrite) {
            if (this.getEnabled()) {
                this.enable();
                if (this.isFrozenIpPort()) {
                    this.addOrUpdateDescriptor();
                }
            } else {
                this.disable();
            }
        } else if (p.equals(portId) && (descriptor = this.findDescriptor()) != null) {
            descriptor.setObjectId(BBacnetNetworkPortDescriptor.makeObjectId(this.getPortId()));
        }
    }

    private void updateNetworkNumberQuality(int newNetworkNumber) {
        if (BNetworkPort.isConfiguredNetworkNumber(newNetworkNumber)) {
            this.setNetworkNumberQuality(BBacnetNetworkNumberQuality.configured);
        } else {
            this.setNetworkNumberQuality(BBacnetNetworkNumberQuality.unknown);
        }
    }

    static boolean isConfiguredNetworkNumber(int networkNumber) {
        return networkNumber > 0 && networkNumber < 65535;
    }

    public boolean isNetworkNumberConfigured() {
        BBacnetNetworkNumberQuality quality = this.getNetworkNumberQuality();
        return quality.equals((Object)BBacnetNetworkNumberQuality.learnedConfigured) || quality.equals((Object)BBacnetNetworkNumberQuality.configured);
    }

    void scheduleNetworkNumberIs() {
        if (!this.isRunning()) {
            return;
        }
        this.cancelNetworkNumberIs();
        this.networkNumberIsTicket.set(Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)sendNetworkNumberIs, null));
    }

    void cancelNetworkNumberIs() {
        Clock.Ticket ticket = this.networkNumberIsTicket.getAndSet(null);
        if (ticket != null) {
            ticket.cancel();
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetNetworkLayer;
    }

    public void sendToLink(byte[] destAddress, NetworkPdu npdu) {
        if (this.ready && this.getStatus().isValid()) {
            this.getLink().sendRequest(destAddress, npdu);
            for (OutgoingWiretap tap : this.wiretaps) {
                try {
                    tap.sendRequest(destAddress, npdu);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void rcvIndication(byte[] srcMacAddress, byte[] destMacAddress, BacnetInputStream is, boolean isBroadcast) {
        this.rcvIndication(srcMacAddress, destMacAddress, is, isBroadcast, null);
    }

    @Override
    public void rcvIndication(byte[] srcMacAddress, byte[] destMacAddress, BacnetInputStream is, boolean isBroadcast, DataAttributes dataAttributes) {
        try {
            NetworkPdu npdu = NetworkPdu.parseNetworkBytes(srcMacAddress, destMacAddress, this.getNetworkNumber(), is, isBroadcast);
            if (npdu != null && this.ready && this.getStatus().isValid()) {
                npdu.setSourcePort(this);
                npdu.setDataAttributes(dataAttributes);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(npdu.toString());
                }
                this.getNetworkLayer().receiveNpdu(npdu);
            }
        }
        catch (BacnetStackException e) {
            logger.log(Level.SEVERE, "Unable to parse Bacnet Npdu!", (Throwable)((Object)e));
            is.release();
        }
        catch (QueueFullException e) {
            logger.log(Level.SEVERE, "Network layer message queue overflow!", e);
            is.release();
        }
    }

    public BBacnetAddress getAddress() {
        int networkNumber = this.getNetworkNumber();
        byte[] macAddress = this.getLink().getMacAddress();
        if (this.address == null || networkNumber != this.address.getNetworkNumber() || !this.address.macEquals(macAddress)) {
            this.address = new BBacnetAddress(networkNumber, macAddress);
        }
        return this.address;
    }

    private BBacnetNetworkLayer getNetworkLayer() {
        return (BBacnetNetworkLayer)this.getParent();
    }

    void networkReady() {
        this.ready = true;
        try {
            BBacnetNetworkLayer networkLayer = this.getNetworkLayer();
            int networkNumber = this.getNetworkNumber();
            if (!this.fatalFault && this.getEnabled() && networkLayer.isValidNetworkNumber(networkNumber)) {
                this.getLink().addLinkListener(this);
                this.getLink().linkStart();
                if (this.getNetworkLayer().isRouterActive() && this.isNetworkNumberConfigured()) {
                    this.sendToLink(null, new NetworkNumberIs(networkNumber));
                }
                networkLayer.updateRouterAddress(networkNumber, networkNumber, this.getLink().getMacAddress(), BRouterStatus.ok, this.getPortInfo());
            }
        }
        catch (Exception e) {
            this.fault(e.toString());
        }
        this.updateStatus();
        if (this.getEnabled()) {
            this.getPollService().pollStart();
        }
    }

    public String toString(Context cx) {
        return "NetworkPort: id=" + this.getPortId() + " net=" + this.getNetworkNumber() + (this.getEnabled() ? " enabled" : " disabled") + " max=" + this.getMaxDevices() + " link=" + (Object)((Object)this.getLink());
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"NetworkPort", 2);
        out.prop((Object)"portIds (static)", portIds);
        out.prop((Object)"ready", this.ready);
        out.prop((Object)"oldDnet", this.oldNetworkNumber);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)"oldStatus", this.oldStatus);
        out.endProps();
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void fault(String cause) {
        this.fault = cause;
        this.updateStatus();
    }

    public final void ok() {
        this.fault = null;
        this.updateStatus();
    }

    public final void fatalFault(String faultCause) {
        this.fatalFault = true;
        this.setFaultCause(faultCause);
        this.updateStatus();
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        newStatus = !this.getEnabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        if (this.fatalFault) {
            newStatus |= 2;
        } else {
            int networkNumber = this.getNetworkNumber();
            if (!this.getNetworkLayer().isValidNetworkNumber(networkNumber)) {
                newStatus |= 2;
                this.setFaultCause("Invalid network number: " + networkNumber);
            } else if (this.fault != null) {
                newStatus |= 2;
                this.setFaultCause(this.fault);
            } else {
                newStatus &= 0xFFFFFFFD;
                this.setFaultCause("");
            }
        }
        if (newStatus == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
        BBacnetNetworkPortDescriptor descriptor = this.findDescriptor();
        if (descriptor != null) {
            descriptor.setStatus(BStatus.makeDisabled((BStatus)descriptor.getStatus(), (boolean)this.getStatus().isDisabled()));
            descriptor.updateReliability();
        }
    }

    private void checkFatalFault() {
        this.getLink().checkFatalFault();
    }

    private void addOrUpdateDescriptor() {
        BBacnetNetworkPortDescriptor descriptor = this.findDescriptor();
        if (descriptor == null) {
            this.addDescriptor();
        } else {
            this.updateDescriptor(descriptor);
        }
    }

    private void addDescriptor() {
        BBacnetNetworkPortDescriptor descriptor = this.getLink().makeNetworkPortDescriptor();
        descriptor.setNetworkPortOrd(this.getHandleOrd());
        descriptor.setObjectId(BBacnetNetworkPortDescriptor.makeObjectId(this.getPortId()));
        descriptor.setObjectName(this.getName());
        BBacnetNetwork.localDevice().getExportTable().add(BBacnetNetworkPortDescriptor.makeDescriptorName(this.getName()), (BValue)descriptor);
    }

    private void updateDescriptor(BBacnetNetworkPortDescriptor descriptor) {
        int portId = this.getPortId();
        if (descriptor.getObjectId().getInstanceNumber() != portId) {
            descriptor.set(BBacnetNetworkPortDescriptor.objectId, (BValue)BBacnetNetworkPortDescriptor.makeObjectId(portId), BBacnetNetworkPortDescriptor.atStarted);
        }
        descriptor.checkConfiguration();
    }

    private void removeDescriptor() {
        BBacnetNetworkPortDescriptor descriptor = this.findDescriptor();
        if (descriptor != null) {
            BBacnetNetwork.localDevice().getExportTable().remove((BComplex)descriptor);
        }
    }

    public BBacnetNetworkPortDescriptor findDescriptor() {
        BComponent exportTable = BBacnetNetwork.localDevice().getExportTable();
        for (BBacnetNetworkPortDescriptor descriptor : (BBacnetNetworkPortDescriptor[])exportTable.getChildren(BBacnetNetworkPortDescriptor.class)) {
            if (descriptor.getObject() != this) continue;
            return descriptor;
        }
        return null;
    }
}

