/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BBacnetRouterEntry;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.network.BRouterStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addRouter", parameterType="BBacnetRouterEntry", defaultValue="new BBacnetRouterEntry()"), @NiagaraAction(name="removeRouter", parameterType="BInteger", defaultValue="BInteger.make(-1)"), @NiagaraAction(name="purgeExpiredEntries", flags=4), @NiagaraAction(name="purgeAllEntries", flags=128)})
public class BBacnetRouterTable
extends BComponent {
    @Generated
    public static final Action addRouter = BBacnetRouterTable.newAction((int)0, (BValue)new BBacnetRouterEntry(), null);
    @Generated
    public static final Action removeRouter = BBacnetRouterTable.newAction((int)0, (BValue)BInteger.make((int)-1), null);
    @Generated
    public static final Action purgeExpiredEntries = BBacnetRouterTable.newAction((int)4, null);
    @Generated
    public static final Action purgeAllEntries = BBacnetRouterTable.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetRouterTable.class);
    Clock.Ticket routerEntryRemovalTicket = null;
    private static final Log logger = Log.getLog((String)"bacnet.network");

    @Generated
    public void addRouter(BBacnetRouterEntry parameter) {
        this.invoke(addRouter, (BValue)parameter, null);
    }

    @Generated
    public void removeRouter(BInteger parameter) {
        this.invoke(removeRouter, (BValue)parameter, null);
    }

    @Generated
    public void purgeExpiredEntries() {
        this.invoke(purgeExpiredEntries, null, null);
    }

    @Generated
    public void purgeAllEntries() {
        this.invoke(purgeAllEntries, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.routerEntryRemovalTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)1), (Action)purgeExpiredEntries, null);
    }

    public void added(Property p, Context cx) {
        if (this.isRunning() && cx != Context.decoding) {
            this.validate();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning() && cx != Context.decoding) {
            this.validate();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetNetworkLayer;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        long ticks = Clock.ticks();
        BAbsTime now = BAbsTime.make((long)ticks);
        out.prop((Object)"ticks", (Object)("" + ticks));
        out.prop((Object)"->now", (Object)now);
        out.prop((Object)"routerEntryRemovalTicket", (Object)this.routerEntryRemovalTicket);
        SlotCursor sc = this.getProperties();
        while (sc.next(BBacnetRouterEntry.class)) {
            BBacnetRouterEntry e = (BBacnetRouterEntry)sc.get();
            out.prop((Object)e.getName(), (Object)("lastUpdateTicks=" + e.lastUpdateTicks));
        }
        out.endProps();
    }

    public void doAddRouter(BBacnetRouterEntry e) {
        BNetworkPort port = this.net().getPortByNetwork(e.getRouterAddress().getNetworkNumber());
        if (port != null) {
            e.setPortId(port.getPortId());
        }
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetRouterEntry.class)) {
            long now;
            BBacnetRouterEntry cur = (BBacnetRouterEntry)c.get();
            if (e.getDnet() != cur.getDnet()) continue;
            cur.copyFrom((BComplex)e);
            cur.lastUpdateTicks = now = Clock.ticks();
            return;
        }
        this.add("dnet" + e.getDnet(), (BValue)e);
    }

    public void doRemoveRouter(BInteger dnet) {
        BBacnetRouterEntry e = this.getRouterByDnet(dnet.getInt());
        if (e != null) {
            this.remove((BComplex)e);
        }
    }

    public void doPurgeExpiredEntries() {
        long lifetime;
        long now = Clock.ticks();
        long tooOldTime = now - (lifetime = this.net().getRouterEntryLifetime().getMillis());
        if (tooOldTime < 0L) {
            tooOldTime = 0L;
        }
        if (BBacnetNetworkLayer.logger.isLoggable(Level.FINE)) {
            BBacnetNetworkLayer.logger.fine("Purging expired router entries: now=" + now + " lifetime=" + lifetime + " tooOldTime=" + tooOldTime);
        }
        BBacnetRouterEntry[] entries = (BBacnetRouterEntry[])this.getChildren(BBacnetRouterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            BBacnetRouterEntry e = entries[i];
            if (this.net().isDirectlyConnectedNetwork(e.getDnet()) || e.lastUpdateTicks >= tooOldTime) continue;
            this.remove((BComplex)e);
        }
    }

    public void doPurgeAllEntries() {
        BBacnetNetworkLayer.logger.info("Purging all router table entries (except local ports)...");
        BBacnetRouterEntry[] entries = (BBacnetRouterEntry[])this.getChildren(BBacnetRouterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            BBacnetRouterEntry e = entries[i];
            if (this.net().isDirectlyConnectedNetwork(e.getDnet())) continue;
            this.remove((BComplex)e);
        }
    }

    public void removeRouterByDnet(int dnet) {
        this.removeRouter(BInteger.make((int)dnet));
    }

    public void removeRouterByPortId(int portId) {
        BBacnetRouterEntry[] list = (BBacnetRouterEntry[])this.getChildren(BBacnetRouterEntry.class);
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getPortId() != portId) continue;
            this.remove((BComplex)list[i]);
        }
    }

    private BBacnetNetworkLayer net() {
        return (BBacnetNetworkLayer)this.getParent();
    }

    public BBacnetRouterEntry getRouterByDnet(int dnet) {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetRouterEntry.class)) {
            BBacnetRouterEntry e = (BBacnetRouterEntry)c.get();
            if (e.getDnet() != dnet) continue;
            return e;
        }
        return null;
    }

    public Vector<BBacnetRouterEntry> getRoutersByAddress(int networkNumber, byte[] macAddress) {
        Vector<BBacnetRouterEntry> v = new Vector<BBacnetRouterEntry>();
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetRouterEntry.class)) {
            BBacnetRouterEntry e = (BBacnetRouterEntry)c.get();
            if (!e.getRouterAddress().equals(networkNumber, macAddress)) continue;
            v.addElement(e);
        }
        return v;
    }

    public int[] getDnets(int excludedPortId) {
        this.loadSlots();
        ArrayList<Integer> v = new ArrayList<Integer>();
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetRouterEntry.class)) {
            BBacnetRouterEntry e = (BBacnetRouterEntry)c.get();
            e.loadSlots();
            if (e.getPortId() == excludedPortId) continue;
            v.add(e.getDnet());
        }
        int[] dnets = new int[v.size()];
        for (int i = 0; i < dnets.length; ++i) {
            dnets[i] = (Integer)v.get(i);
        }
        return dnets;
    }

    public void updateRouter(int dnet, int routerNetworkNumber, byte[] routerMacAddress, int portId, String portInfo, BRouterStatus routerStatus) {
        this.updateRouter(dnet, routerNetworkNumber, routerMacAddress, portId, portInfo, routerStatus, -1);
    }

    public void updateRouter(int dnet, int routerNetworkNumber, byte[] routerMacAddress, int portId, String portInfo, BRouterStatus routerStatus, int performanceIndex) {
        BBacnetRouterEntry e = this.getRouterByDnet(dnet);
        if (e == null) {
            e = new BBacnetRouterEntry(dnet, new BBacnetAddress(routerNetworkNumber, routerMacAddress), portId, portInfo, routerStatus, performanceIndex);
            if (logger.isLoggable(0)) {
                logger.trace("Adding new router entry: " + (Object)((Object)e));
            }
            this.addRouter(e);
        } else {
            if (!(!logger.isLoggable(0) || e.getRouterAddress().getNetworkNumber() == routerNetworkNumber && Arrays.equals(e.getRouterAddress().getMacAddress().getBytes(), routerMacAddress) && e.getPortId() == portId && e.getRouterStatus().equals((Object)routerStatus))) {
                logger.trace("Updating router entry: " + (Object)((Object)e) + "; new networkNumber: " + routerNetworkNumber + "; new address: " + ByteArrayUtil.toHexString((byte[])routerMacAddress) + "; new port ID: " + portId + "; new port info: " + portInfo + "; new router status: " + (Object)((Object)routerStatus));
            }
            e.getRouterAddress().setNetworkNumber(routerNetworkNumber);
            e.getRouterAddress().setMac(routerMacAddress, null);
            e.setPortId(portId);
            if (portInfo != null) {
                e.setPortInfo(portInfo);
            }
            e.setRouterStatus(routerStatus);
            if (performanceIndex >= 0) {
                e.setPerformanceIndex(performanceIndex);
            }
        }
        if (!this.net().isDirectlyConnectedNetwork(dnet)) {
            e.lastUpdateTicks = Clock.ticks();
        }
    }

    public synchronized void validate() {
        if (logger.isTraceOn()) {
            logger.trace("Validating router table (sc=" + this.getSlotCount() + ")");
        }
        boolean tableOk = true;
        int numPasses = 0;
        if (this.getSlotCount() < 6) {
            return;
        }
        block0: do {
            BBacnetRouterEntry[] rt = (BBacnetRouterEntry[])this.getChildren(BBacnetRouterEntry.class);
            for (int i = 0; i < rt.length; ++i) {
                for (int j = i + 1; j < rt.length; ++j) {
                    if (rt[i].getDnet() != rt[j].getRouterAddress().getNetworkNumber() || rt[i].getRouterAddress().getNetworkNumber() != rt[j].getDnet()) continue;
                    logger.error("Conflict detected between router table entries " + i + " and " + j + "- removing entry " + j + "...");
                    tableOk = false;
                    this.remove((BComplex)rt[j]);
                    break;
                }
                if (!tableOk) continue block0;
            }
        } while (!tableOk && ++numPasses < this.getSlotCount());
    }
}

