/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.connection;

import com.tridium.bacnet.stack.link.sc.BHubConnector;
import com.tridium.bacnet.stack.link.sc.BHubFunction;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.VmacUtil;
import com.tridium.bacnet.stack.link.sc.connection.BInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BInitiatingConnectionState;
import com.tridium.bacnet.stack.link.sc.connection.IScConnectionInitiator;
import com.tridium.bacnet.stack.link.sc.message.ScBvlcMessage;
import com.tridium.bacnet.stack.link.sc.message.ScBvlcResult;
import com.tridium.bacnet.stack.link.sc.message.ScMessageUtil;
import com.tridium.bacnet.stack.link.sc.message.ScNpdu;
import com.tridium.bacnet.stack.link.sc.message.ScReadMessageException;
import com.tridium.bacnet.stack.link.sc.message.ScSendMessageException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="state", type="BBacnetScConnectionState", defaultValue="BBacnetScConnectionState.notConnected", flags=259), @NiagaraProperty(name="subState", type="BInitiatingConnectionState", defaultValue="BInitiatingConnectionState.DEFAULT", flags=259), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="hubUriAddress", type="BInternetAddress", defaultValue="new BInternetAddress(\"example.com\")"), @NiagaraProperty(name="hubUriPath", type="String", defaultValue="BHubFunction.DEFAULT_SERVLET_NAME"), @NiagaraProperty(name="hubUriQuery", type="String", defaultValue=""), @NiagaraProperty(name="hubAddress", type="BInternetAddress", defaultValue="new BInternetAddress(\"null\")", flags=3), @NiagaraProperty(name="hubVmac", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT", flags=3), @NiagaraProperty(name="hubUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=3), @NiagaraProperty(name="lastConnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastDisconnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastFailureToConnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="error", type="BErrorType", defaultValue="new BErrorType(-1, -1)", flags=1), @NiagaraProperty(name="errorDetails", type="String", defaultValue="", flags=1)})
@NiagaraAction(name="forceDisconnect")
public final class BHubInitiatingConnection
extends BInitiatingConnection
implements BIRestrictedComponent,
IPropertyValidator {
    @Generated
    public static final Property state = BHubInitiatingConnection.newProperty((int)259, (BValue)BBacnetScConnectionState.notConnected, null);
    @Generated
    public static final Property subState = BHubInitiatingConnection.newProperty((int)259, (BValue)BInitiatingConnectionState.DEFAULT, null);
    @Generated
    public static final Property enabled = BHubInitiatingConnection.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property hubUriAddress = BHubInitiatingConnection.newProperty((int)0, (BValue)new BInternetAddress("example.com"), null);
    @Generated
    public static final Property hubUriPath = BHubInitiatingConnection.newProperty((int)0, (String)"hub", null);
    @Generated
    public static final Property hubUriQuery = BHubInitiatingConnection.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property hubAddress = BHubInitiatingConnection.newProperty((int)3, (BValue)new BInternetAddress("null"), null);
    @Generated
    public static final Property hubVmac = BHubInitiatingConnection.newProperty((int)3, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property hubUuid = BHubInitiatingConnection.newProperty((int)3, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property lastConnect = BHubInitiatingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastDisconnect = BHubInitiatingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastFailureToConnect = BHubInitiatingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property error = BHubInitiatingConnection.newProperty((int)1, (BValue)new BErrorType(-1, -1), null);
    @Generated
    public static final Property errorDetails = BHubInitiatingConnection.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action forceDisconnect = BHubInitiatingConnection.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHubInitiatingConnection.class);
    private static final Logger logger = Logger.getLogger("bacnet.sc.hubConnector");
    private BHubConnector hubConnector;

    @Override
    @Generated
    public BBacnetScConnectionState getState() {
        return (BBacnetScConnectionState)this.get(state);
    }

    @Override
    @Generated
    public void setState(BBacnetScConnectionState v) {
        this.set(state, (BValue)v, null);
    }

    @Override
    @Generated
    public BInitiatingConnectionState getSubState() {
        return (BInitiatingConnectionState)this.get(subState);
    }

    @Override
    @Generated
    public void setSubState(BInitiatingConnectionState v) {
        this.set(subState, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BInternetAddress getHubUriAddress() {
        return (BInternetAddress)this.get(hubUriAddress);
    }

    @Generated
    public void setHubUriAddress(BInternetAddress v) {
        this.set(hubUriAddress, (BValue)v, null);
    }

    @Generated
    public String getHubUriPath() {
        return this.getString(hubUriPath);
    }

    @Generated
    public void setHubUriPath(String v) {
        this.setString(hubUriPath, v, null);
    }

    @Generated
    public String getHubUriQuery() {
        return this.getString(hubUriQuery);
    }

    @Generated
    public void setHubUriQuery(String v) {
        this.setString(hubUriQuery, v, null);
    }

    @Generated
    public BInternetAddress getHubAddress() {
        return (BInternetAddress)this.get(hubAddress);
    }

    @Generated
    public void setHubAddress(BInternetAddress v) {
        this.set(hubAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getHubVmac() {
        return (BBacnetOctetString)this.get(hubVmac);
    }

    @Generated
    public void setHubVmac(BBacnetOctetString v) {
        this.set(hubVmac, (BValue)v, null);
    }

    @Generated
    public BUuid getHubUuid() {
        return (BUuid)this.get(hubUuid);
    }

    @Generated
    public void setHubUuid(BUuid v) {
        this.set(hubUuid, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastConnect() {
        return (BAbsTime)this.get(lastConnect);
    }

    @Override
    @Generated
    public void setLastConnect(BAbsTime v) {
        this.set(lastConnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastDisconnect() {
        return (BAbsTime)this.get(lastDisconnect);
    }

    @Override
    @Generated
    public void setLastDisconnect(BAbsTime v) {
        this.set(lastDisconnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastFailureToConnect() {
        return (BAbsTime)this.get(lastFailureToConnect);
    }

    @Override
    @Generated
    public void setLastFailureToConnect(BAbsTime v) {
        this.set(lastFailureToConnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    @Override
    @Generated
    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    @Override
    @Generated
    public String getErrorDetails() {
        return this.getString(errorDetails);
    }

    @Override
    @Generated
    public void setErrorDetails(String v) {
        this.setString(errorDetails, v, null);
    }

    @Generated
    public void forceDisconnect() {
        this.invoke(forceDisconnect, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BHubInitiatingConnection make(BInternetAddress address, String path, boolean enabled) {
        BHubInitiatingConnection connection = new BHubInitiatingConnection();
        connection.setHubUriAddress(address);
        connection.setHubUriPath(path);
        connection.setEnabled(enabled);
        return connection;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.hubConnector = (BHubConnector)this.getParent();
    }

    @Override
    protected void setRemoteAddress(BInternetAddress address) {
        this.setHubAddress(address);
    }

    @Override
    protected void setRemoteVmac(long vmac) {
        this.setHubVmac(VmacUtil.vmacToOctetString(vmac));
    }

    @Override
    protected void setRemoteUuid(UUID uuid) {
        this.setHubUuid(BUuid.make((UUID)uuid));
    }

    @Override
    protected void setRemoteMaxBvlcLength(int maxBvlcLength) {
    }

    @Override
    protected void setRemoteMaxNpduLength(int maxNpduLength) {
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return BHubInitiatingConnection.makeURI(this.getHubUriAddress(), this.getHubUriPath().trim(), this.getHubUriQuery().trim());
    }

    @Override
    protected IScConnectionInitiator getConnectionInitiator() {
        return this.hubConnector;
    }

    @Override
    public String getLocalConnectionToken() {
        BHubFunction hubFunction = this.scLinkLayer.getHubFunction();
        if (hubFunction == null) {
            return null;
        }
        return hubFunction.generateLocalConnectionToken(this);
    }

    @Override
    public void clearLocalConnectionToken() {
        BHubFunction hubFunction = this.scLinkLayer.getHubFunction();
        if (hubFunction != null) {
            hubFunction.clearLocalConnectionToken();
        }
    }

    @Override
    protected void checkMessageSendSize(byte[] bytes) throws ScSendMessageException {
        if (bytes.length > 65535) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Send message length ").append(bytes.length).append(" exceeds the maximum BVLC message length of ").append(65535).append("; message: ").append(this.messageToString(bytes)).toString());
            }
            throw new ScSendMessageException("Send message length " + bytes.length + " exceeds the maximum BVLC message length of " + 65535);
        }
    }

    @Override
    protected void handleUnicastAddressedMessage(int function, byte[] payload, int offset, int len) throws ScReadMessageException, ScSendMessageException {
        if (ScMessageUtil.hasDestinationVmac(ScBvlcMessage.readControlFlags(payload, offset, len))) {
            throw new ScReadMessageException("Destination VMAC for a unicast addressed message must be absent", BBacnetErrorCode.inconsistentParameters);
        }
        this.handleUnicastAddressedMessage(function, ScBvlcMessage.readOriginatingVmac(payload, offset, len), payload, offset, len);
    }

    @Override
    protected void handleEncapsulatedNpdu(byte[] payload, int offset, int len) throws ScReadMessageException, ScSendMessageException {
        long destinationVmac = ScBvlcMessage.readDestinationVmac(payload, offset, len);
        if (destinationVmac == -1L) {
            destinationVmac = this.localVmac;
        } else if (destinationVmac != 0xFFFFFFFFFFFFL) {
            throw new ScReadMessageException("Destination VMAC for encapsulated NPDU may only be absent or broadcast", BBacnetErrorCode.inconsistentParameters);
        }
        ScNpdu scNpdu = (ScNpdu)this.readMessage(payload, offset, len);
        this.checkNpduLength(scNpdu);
        this.forwardNpdu(ScBvlcMessage.readOriginatingVmac(payload, offset, len), destinationVmac, scNpdu);
    }

    @Override
    protected void handleBvlcResult(byte[] payload, int offset, int len) throws ScReadMessageException, ScSendMessageException {
        if (ScMessageUtil.hasDestinationVmac(ScBvlcMessage.readControlFlags(payload, offset, len))) {
            throw new ScReadMessageException("Destination VMAC for a BVLC result message must be absent", BBacnetErrorCode.inconsistentParameters);
        }
        int resultFunction = ScBvlcMessage.readResultFunction(payload, offset, len);
        if (resultFunction == 2 || resultFunction == 5) {
            this.handleBvlcResult(resultFunction, ScBvlcMessage.readOriginatingVmac(payload, offset, len), payload, offset, len);
            return;
        }
        this.logIgnoredBvlcResult(payload, offset, len);
    }

    @Override
    protected void sendBvlcResultNak(byte[] payload, int offset, int len, ScBvlcResult bvlcResultNak) throws Exception {
        long originatingVmac;
        block12: {
            if (!ScBvlcMessage.isAddressedMessage(bvlcResultNak.getResultFunction())) {
                this.send(bvlcResultNak);
                return;
            }
            long destinationVmac = -1L;
            try {
                destinationVmac = ScBvlcMessage.readDestinationVmac(payload, offset, len);
            }
            catch (ScReadMessageException scReadMessageException) {
                // empty catch block
            }
            if (destinationVmac == 0xFFFFFFFFFFFFL) {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine(this.getLogInfo().append(": Cannot send a read message exception BVLC-Result-NAK in response to a broadcast message").toString());
                }
                return;
            }
            if (destinationVmac != -1L) {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine(this.getLogInfo().append(": Sending read message exception BVLC-Result-NAK for non-null destination VMAC back to hub").toString());
                }
                this.send(bvlcResultNak);
                return;
            }
            originatingVmac = -1L;
            try {
                originatingVmac = ScBvlcMessage.readOriginatingVmac(payload, offset, len);
            }
            catch (ScReadMessageException e) {
                if (!this.getLogger().isLoggable(Level.FINE)) break block12;
                this.getLogger().log(Level.FINE, this.getLogInfo().append(": Read message exception BVLC-Result-NAK in response to an addressed message contains an invalid originating VMAC").toString(), (Throwable)((Object)e));
            }
        }
        if (VmacUtil.isDeviceVmac(originatingVmac)) {
            this.scLinkLayer.getNodeSwitch().sendMessage(originatingVmac, bvlcResultNak);
        } else {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Cannot send a read message exception BVLC-Result-NAK in response to an addressed message with a non-device originating VMAC: [").append(VmacUtil.vmacToString(originatingVmac)).append("]; sending to peer node (hub) instead").toString());
            }
            this.send(bvlcResultNak);
        }
    }

    public String toString(Context cx) {
        if (!this.getEnabled()) {
            return ScLinkLayerUtil.LEXICON.getText("disabled", cx);
        }
        StringBuilder builder = new StringBuilder(this.getState().getDisplayTag(cx)).append(" (wss://").append(this.getHubUriAddress());
        String path = this.getHubUriPath().trim();
        if (!path.startsWith("/")) {
            builder.append('/');
        }
        builder.append(path);
        String query = this.getHubUriQuery().trim();
        if (!query.isEmpty()) {
            builder.append('?').append(query);
        }
        builder.append(')');
        return builder.toString();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(enabled)) {
            if (this.getEnabled()) {
                try {
                    this.hubConnector.doForceConnect();
                }
                catch (Exception exception) {}
            } else {
                this.disconnect();
            }
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentType((Type)TYPE, (Type)parent.getType(), (Type[])new Type[]{BHubConnector.TYPE});
        BIRestrictedComponent.checkForTooMany((BComponent)this, (BComponent)parent, (int)2);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property.equals(hubUriQuery)) {
            return this;
        }
        return super.getPropertyValidator(property, context);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        for (Property property : properties) {
            if (!property.equals(hubUriQuery)) continue;
            return this;
        }
        return super.getPropertyValidator(properties, context);
    }

    public void validateSet(Validatable validatable, Context context) {
        for (Property property : validatable.getModifiedProperties()) {
            if (!property.equals(hubUriQuery)) continue;
            BHubInitiatingConnection.checkUriQuery(((BString)validatable.getProposedValue(property)).getString());
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (property.equals(hubUriQuery)) {
            BHubInitiatingConnection.checkUriQuery(((BString)newValue).getString());
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public StringBuilder getLogInfo() {
        return this.hubConnector.isPrimary(this) ? new StringBuilder("Primary Hub Connection") : new StringBuilder("Failover Hub Connection");
    }
}

