/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.authn.BAuthenticationService;
import com.tridium.bacnet.stack.link.sc.BScCredentials;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticationScheme;
import com.tridium.bacnet.stack.link.sc.authentication.BCrlDescriptor;
import com.tridium.driver.crl.BCaCertAndCrl;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="issuerCertificate", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(value="BFacets.make(\"warningText\", \"%lexicon(bacnet:issuerCertEditor.warningText)%\")")}, override=true), @NiagaraProperty(name="useCrlDistributionPointInIssuer", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.SECURITY", value="true")}, override=true), @NiagaraProperty(name="crlDescriptor", type="BCrlDescriptor", defaultValue="new BCrlDescriptor()", override=true), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()", override=true)})
public final class BIssuerCertAndCrl
extends BCaCertAndCrl {
    @Generated
    public static final Property issuerCertificate = BIssuerCertAndCrl.newProperty((int)0, (BValue)BX509Certificate.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"warningText", (String)"%lexicon(bacnet:issuerCertEditor.warningText)%")));
    @Generated
    public static final Property useCrlDistributionPointInIssuer = BIssuerCertAndCrl.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property crlDescriptor = BIssuerCertAndCrl.newProperty((int)0, (BValue)new BCrlDescriptor(), null);
    @Generated
    public static final Property alarmSourceInfo = BIssuerCertAndCrl.newProperty((int)0, (BValue)BIssuerCertAndCrl.initAlarmSourceInfo(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIssuerCertAndCrl.class);
    private static final Logger logger = Logger.getLogger("bacnet.sc.auth");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BScCredentials;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(issuerCertificate)) {
            ScLinkLayerUtil.getScLinkLayer((BComplex)this).trustAnchorsUpdated();
        }
    }

    protected String getCrlSubDir() {
        return LEGACY_BACNET_DIR;
    }

    protected void doCrlSaved() {
        ScLinkLayerUtil.getScLinkLayer((BComplex)this).crlsUpdated();
    }

    protected void doCrlDeleted() {
        ScLinkLayerUtil.getScLinkLayer((BComplex)this).crlsUpdated();
    }

    protected void updateTrustAnchors() {
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo alarmSourceInfo = new BAlarmSourceInfo();
        alarmSourceInfo.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName%.%displayName%"));
        alarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(bacnet:issuerCertAndCrl.crlExpired)%"));
        alarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(bacnet:issuerCertAndCrl.crlNotExpired)%"));
        return alarmSourceInfo;
    }

    protected boolean shouldGenerateAlarmOnExpiration() {
        BAuthenticationService authnService = BAuthenticationService.getService();
        BBacnetScAuthenticationScheme[] bacnetSchemes = (BBacnetScAuthenticationScheme[])authnService.getAuthenticationSchemes().getChildren(BBacnetScAuthenticationScheme.class);
        if (bacnetSchemes.length == 0) {
            return false;
        }
        return bacnetSchemes[0].getGenerateAlarmOnCrlExpiration();
    }

    protected Logger getLogger() {
        return logger;
    }
}

