/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.authentication.BIssuerCertAndCrl;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.driver.crl.BBaseCrlDescriptor;
import com.tridium.util.CompUtil;
import java.util.Optional;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
public final class BCrlDescriptor
extends BBaseCrlDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BCrlDescriptor.class);
    private BNetworkPort networkPort;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        this.networkPort = null;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentType((Type)TYPE, (Type)this.getParent().getType(), (Type[])new Type[]{BIssuerCertAndCrl.TYPE});
        BIRestrictedComponent.checkForDuplicate((BComponent)this, (BComponent)parent);
    }

    public void updateStatus() {
        BStatus portStatus;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = portStatus = this.networkPort == null ? BStatus.fault : this.networkPort.getStatus();
        newStatus = !this.getEnabled() || portStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.isFatalFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) || portStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BBacnetNetwork bacnetNetwork = BBacnetNetwork.bacnet();
        if (bacnetNetwork != null) {
            return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        logger.warning("Cannot execute " + action.getName() + ". Network was not found.");
        this.executeFail("Network not found");
        return null;
    }

    protected boolean doCheckFatalFault() {
        Optional networkPort = CompUtil.closestAncestor((BComplex)this.getParent(), BNetworkPort.class);
        if (!networkPort.isPresent()) {
            this.setFaultCause(ScLinkLayerUtil.LEXICON.getText("crlDescriptor.fault.notUnderPort", null));
            return true;
        }
        this.networkPort = (BNetworkPort)networkPort.get();
        return false;
    }
}

