/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.authentication;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.authentication.BBacnetScAuthenticator;
import com.tridium.bacnet.stack.link.sc.authentication.BacnetScLoginModule;
import com.tridium.crypto.core.io.CRLProvider;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.TrustAnchorProvider;
import java.security.AccessController;
import java.security.cert.CRLException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BIRestrictedComponent;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType
@NiagaraProperty(name="generateAlarmOnCrlExpiration", type="boolean", defaultValue="true")
public final class BBacnetScAuthenticationScheme
extends BAuthenticationScheme
implements BIRestrictedComponent,
TrustAnchorProvider,
CRLProvider {
    @Generated
    public static final Property generateAlarmOnCrlExpiration = BBacnetScAuthenticationScheme.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScAuthenticationScheme.class);
    private Configuration configuration;
    private String trustAnchorProviderId;
    private String crlProviderId;
    public static final String SCHEME_NAME = "bacnetScAuth";

    @Generated
    public boolean getGenerateAlarmOnCrlExpiration() {
        return this.getBoolean(generateAlarmOnCrlExpiration);
    }

    @Generated
    public void setGenerateAlarmOnCrlExpiration(boolean v) {
        this.setBoolean(generateAlarmOnCrlExpiration, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public Configuration getLoginConfiguration() {
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(BacnetScLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        }
        return this.configuration;
    }

    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BBacnetScAuthenticator();
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
        if (!(parent instanceof BAuthenticationSchemeFolder)) {
            throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{this.getType(), parent.getType()});
        }
    }

    public Set<TrustAnchor> getTrustAnchors() {
        List<BBacnetScAuthenticator> scAuthenticators = BBacnetScAuthenticationScheme.findScAuthenticators();
        if (scAuthenticators.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TrustAnchor> allTrustAnchors = new HashSet<TrustAnchor>();
        for (BBacnetScAuthenticator scAuthenticator : scAuthenticators) {
            Set<TrustAnchor> userTrustAnchors = scAuthenticator.getTrustAnchors();
            if (BBacnetScAuthenticationScheme.containsDuplicates(allTrustAnchors, userTrustAnchors)) {
                BBacnetScAuthenticationScheme.setTrustAnchorFault(scAuthenticators, ScLinkLayerUtil.LEXICON.getText("abstractConnectionManager.duplicateIssuerCerts", null));
                return Collections.emptySet();
            }
            allTrustAnchors.addAll(userTrustAnchors);
        }
        BBacnetScAuthenticationScheme.setTrustAnchorFault(scAuthenticators, null);
        return allTrustAnchors;
    }

    public static List<BBacnetScAuthenticator> findScAuthenticators() {
        BUser[] users;
        try {
            users = BUserService.getService().getUsers();
        }
        catch (ServiceNotFoundException e) {
            return Collections.emptyList();
        }
        ArrayList<BBacnetScAuthenticator> scAuthenticators = new ArrayList<BBacnetScAuthenticator>();
        for (BUser user : users) {
            BAbstractAuthenticator authenticator = user.getAuthenticator();
            if (!authenticator.isRunning() || !(authenticator instanceof BBacnetScAuthenticator)) continue;
            scAuthenticators.add((BBacnetScAuthenticator)authenticator);
        }
        return scAuthenticators;
    }

    private static boolean containsDuplicates(Set<TrustAnchor> allTrustAnchors, Set<TrustAnchor> userTrustAnchors) {
        for (TrustAnchor userTrustAnchor : userTrustAnchors) {
            for (TrustAnchor trustAnchor : allTrustAnchors) {
                if (!trustAnchor.getTrustedCert().equals(userTrustAnchor.getTrustedCert())) continue;
                return true;
            }
        }
        return false;
    }

    private static void setTrustAnchorFault(List<BBacnetScAuthenticator> scAuthenticators, String faultCause) {
        for (BBacnetScAuthenticator scAuthenticator : scAuthenticators) {
            scAuthenticator.setTrustAnchorFault(faultCause);
        }
    }

    public static Optional<BBacnetScAuthenticationScheme> getBacnetScScheme() {
        BAuthenticationService authService = BAuthenticationService.getService();
        BBacnetScAuthenticationScheme[] bacnetSchemes = (BBacnetScAuthenticationScheme[])authService.getAuthenticationSchemes().getChildren(BBacnetScAuthenticationScheme.class);
        if (bacnetSchemes.length > 0) {
            return Optional.of(bacnetSchemes[0]);
        }
        return Optional.empty();
    }

    public void trustAnchorsUpdated() {
        this.getTrustAnchors();
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().trustAnchorsUpdated(this.trustAnchorProviderId);
            return null;
        });
    }

    public void crlsUpdated() {
        this.getTrustAnchors();
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().crlsUpdated(this.crlProviderId);
            return null;
        });
    }

    public Set<X509CRL> getCRLs() throws CRLException {
        List<BBacnetScAuthenticator> scAuthenticators = BBacnetScAuthenticationScheme.findScAuthenticators();
        if (scAuthenticators.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<X509CRL> crls = new HashSet<X509CRL>();
        for (BBacnetScAuthenticator scAuthenticator : scAuthenticators) {
            scAuthenticator.addCRLs(crls);
        }
        return crls;
    }

    public void started() throws Exception {
        super.started();
        this.getTrustAnchors();
        AccessController.doPrivileged(() -> {
            CoreCryptoManager manager = CoreCryptoManager.get();
            this.trustAnchorProviderId = manager.registerTrustAnchorProvider((TrustAnchorProvider)this);
            this.crlProviderId = manager.registerCRLProvider((CRLProvider)this);
            return null;
        });
    }

    public void stopped() throws Exception {
        AccessController.doPrivileged(() -> {
            CoreCryptoManager manager = CoreCryptoManager.get();
            manager.unregisterTrustAnchorProvider(this.trustAnchorProviderId);
            manager.unregisterCRLProvider(this.crlProviderId);
            return null;
        });
        BBacnetScAuthenticationScheme.setTrustAnchorFault(BBacnetScAuthenticationScheme.findScAuthenticators(), ScLinkLayerUtil.LEXICON.getText("abstractConnectionManager.missingScScheme", null));
        super.stopped();
    }
}

