/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc;

import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.authentication.BIssuerCertAndCrl;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="operationalCertificate", type="String", defaultValue="", facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:CertificateAliasFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"webEditors:CertificateAliasEditor\""), @Facet(value="BFacets.make(\"purposeId\", \"\")")}, deprecated=true), @NiagaraProperty(name="operationalCertificateAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="issuerCertificate1", type="BIssuerCertAndCrl", defaultValue="new BIssuerCertAndCrl()", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="issuerCertificate2", type="BIssuerCertAndCrl", defaultValue="new BIssuerCertAndCrl()", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeHours(12)))")})
@NiagaraAction(name="retryFailedCrlRetrievals")
public class BScCredentials
extends BComponent
implements BIRestrictedComponent {
    @Deprecated
    @Generated
    public static final Property operationalCertificate = BScCredentials.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"webEditors:CertificateAliasEditor")), (BFacets)BFacets.make((String)"purposeId", (String)"")));
    @Generated
    public static final Property operationalCertificateAliasAndPassword = BScCredentials.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property issuerCertificate1 = BScCredentials.newProperty((int)0, (BValue)new BIssuerCertAndCrl(), (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property issuerCertificate2 = BScCredentials.newProperty((int)0, (BValue)new BIssuerCertAndCrl(), (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property retryTrigger = BScCredentials.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeHours((int)12))), null);
    @Generated
    public static final Action retryFailedCrlRetrievals = BScCredentials.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScCredentials.class);
    private static final Logger LOG = Logger.getLogger("bacnet.sc.linkLayer");
    private Subscriber portSubscriber;

    @Deprecated
    @Generated
    public String getOperationalCertificate() {
        return this.getString(operationalCertificate);
    }

    @Deprecated
    @Generated
    public void setOperationalCertificate(String v) {
        this.setString(operationalCertificate, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getOperationalCertificateAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(operationalCertificateAliasAndPassword);
    }

    @Generated
    public void setOperationalCertificateAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(operationalCertificateAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public BIssuerCertAndCrl getIssuerCertificate1() {
        return (BIssuerCertAndCrl)this.get(issuerCertificate1);
    }

    @Generated
    public void setIssuerCertificate1(BIssuerCertAndCrl v) {
        this.set(issuerCertificate1, (BValue)v, null);
    }

    @Generated
    public BIssuerCertAndCrl getIssuerCertificate2() {
        return (BIssuerCertAndCrl)this.get(issuerCertificate2);
    }

    @Generated
    public void setIssuerCertificate2(BIssuerCertAndCrl v) {
        this.set(issuerCertificate2, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getRetryTrigger() {
        return (BTimeTrigger)this.get(retryTrigger);
    }

    @Generated
    public void setRetryTrigger(BTimeTrigger v) {
        this.set(retryTrigger, (BValue)v, null);
    }

    @Generated
    public void retryFailedCrlRetrievals() {
        this.invoke(retryFailedCrlRetrievals, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (!Flags.has((BComplex)this, (Slot)operationalCertificate, (int)0x10000000)) {
            this.getOperationalCertificateAliasAndPassword().setAlias(this.getOperationalCertificate());
            this.getOperationalCertificateAliasAndPassword().setPassword(BPassword.DEFAULT);
            Flags.add((BComponent)this, (Slot)operationalCertificate, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)operationalCertificateAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)operationalCertificateAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)operationalCertificateAliasAndPassword, this.getFlags((Slot)operationalCertificateAliasAndPassword) & 0xFFFFFFFB);
            this.getOperationalCertificateAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)""));
        }
    }

    public void started() throws Exception {
        super.started();
        this.linkTo("retryLink", (BComponent)this.getRetryTrigger(), (Slot)BTimeTrigger.fireTrigger, (Slot)retryFailedCrlRetrievals);
        this.portSubscriber = Subscriber.make((Consumer)new NetworkPortEventConsumer());
        this.portSubscriber.subscribe(this.getParent().getParent().asComponent());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BScLinkLayer linkLayer = (BScLinkLayer)this.getParent();
        if (issuerCertificate1.equals(property) || issuerCertificate2.equals(property)) {
            if (BScLinkLayer.logger.isLoggable(Level.FINE)) {
                BScLinkLayer.logger.fine(property.getName() + " has been changed in SC port " + linkLayer.getParent().getName() + ": signaling that trust anchors have been updated");
            }
            linkLayer.trustAnchorsUpdated();
        } else if (operationalCertificateAliasAndPassword.equals(property)) {
            if (BScLinkLayer.logger.isLoggable(Level.FINE)) {
                BScLinkLayer.logger.fine("Operational certificate/password has been changed in SC port " + linkLayer.getParent().getName() + ": restarting web socket initiator");
            }
            linkLayer.restartWebSocketInitiator();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
        if (this.portSubscriber != null) {
            this.portSubscriber.unsubscribeAll();
        }
    }

    public boolean isChildLegal(BComponent child) {
        if (child instanceof BIssuerCertAndCrl) {
            try {
                BIRestrictedComponent.checkForTooMany((BComponent)child, (BComponent)this, (int)2);
                return true;
            }
            catch (Exception e) {
                ScLinkLayerUtil.logException(LOG, new StringBuilder("Could not add Issuer Cert And CRL to ").append(this.getName()), e);
                return false;
            }
        }
        return true;
    }

    public void doRetryFailedCrlRetrievals() {
        for (BIssuerCertAndCrl certAndCrl : (BIssuerCertAndCrl[])this.getChildren(BIssuerCertAndCrl.class)) {
            if (!certAndCrl.getCrlDescriptor().isFault()) continue;
            certAndCrl.getCrlDescriptor().execute();
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!(parent instanceof BScLinkLayer)) {
            throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{this.getType(), parent.getType()});
        }
        BIRestrictedComponent.checkForDuplicate((BComponent)this, (BComponent)parent);
    }

    private class NetworkPortEventConsumer
    implements Consumer<BComponentEvent> {
        private NetworkPortEventConsumer() {
        }

        @Override
        public void accept(BComponentEvent event) {
            if (event.getId() == 0 && "enabled".equals(event.getSlotName())) {
                BIssuerCertAndCrl[] issuerCertAndCrls;
                for (BIssuerCertAndCrl issuerCertAndCrl : issuerCertAndCrls = (BIssuerCertAndCrl[])BScCredentials.this.getChildren(BIssuerCertAndCrl.class)) {
                    issuerCertAndCrl.getCrlDescriptor().updateStatus();
                }
            }
        }
    }
}

