/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc;

import com.tridium.bacnet.stack.link.sc.BHubConnectorHealth;
import com.tridium.bacnet.stack.link.sc.BHubConnectorSubState;
import com.tridium.bacnet.stack.link.sc.BScHubConnectorState;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.link.sc.NoConnectionException;
import com.tridium.bacnet.stack.link.sc.VmacUtil;
import com.tridium.bacnet.stack.link.sc.connection.BAbstractConnection;
import com.tridium.bacnet.stack.link.sc.connection.BHubInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.connection.IScConnectionInitiator;
import com.tridium.bacnet.stack.link.sc.message.AddressedMessage;
import com.tridium.bacnet.stack.link.sc.message.ScNpdu;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.network.messages.NetworkNumberIs;
import java.security.AccessController;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.down", flags=67), @NiagaraProperty(name="state", type="BScHubConnectorState", defaultValue="BScHubConnectorState.noHubConnection", flags=259), @NiagaraProperty(name="subState", type="BHubConnectorSubState", defaultValue="noHubConnection", flags=259), @NiagaraProperty(name="health", type="BHubConnectorHealth", defaultValue="BHubConnectorHealth.make()"), @NiagaraProperty(name="primaryConnection", type="BHubInitiatingConnection", defaultValue="BHubInitiatingConnection.make(new BInternetAddress(\"primary.example.com\"), \"hub\", true)"), @NiagaraProperty(name="failoverConnection", type="BHubInitiatingConnection", defaultValue="BHubInitiatingConnection.make(new BInternetAddress(\"failover.example.com\"), \"hub\", false)")})
@NiagaraActions(value={@NiagaraAction(name="forceConnect", flags=128), @NiagaraAction(name="forceDisconnect", flags=128), @NiagaraAction(name="activatePrimary", flags=20), @NiagaraAction(name="deactivatePrimary", flags=20), @NiagaraAction(name="activateFailover", flags=20), @NiagaraAction(name="deactivateFailover", flags=20), @NiagaraAction(name="waitTimedOut", flags=4)})
public final class BHubConnector
extends BComponent
implements IScConnectionInitiator,
BIRestrictedComponent,
BIStatus {
    @Generated
    public static final Property status = BHubConnector.newProperty((int)67, (BValue)BStatus.down, null);
    @Generated
    public static final Property state = BHubConnector.newProperty((int)259, (BValue)BScHubConnectorState.noHubConnection, null);
    @Generated
    public static final Property subState = BHubConnector.newProperty((int)259, (BValue)BHubConnectorSubState.noHubConnection, null);
    @Generated
    public static final Property health = BHubConnector.newProperty((int)0, (BValue)BHubConnectorHealth.make(), null);
    @Generated
    public static final Property primaryConnection = BHubConnector.newProperty((int)0, (BValue)BHubInitiatingConnection.make(new BInternetAddress("primary.example.com"), "hub", true), null);
    @Generated
    public static final Property failoverConnection = BHubConnector.newProperty((int)0, (BValue)BHubInitiatingConnection.make(new BInternetAddress("failover.example.com"), "hub", false), null);
    @Generated
    public static final Action forceConnect = BHubConnector.newAction((int)128, null);
    @Generated
    public static final Action forceDisconnect = BHubConnector.newAction((int)128, null);
    @Generated
    public static final Action activatePrimary = BHubConnector.newAction((int)20, null);
    @Generated
    public static final Action deactivatePrimary = BHubConnector.newAction((int)20, null);
    @Generated
    public static final Action activateFailover = BHubConnector.newAction((int)20, null);
    @Generated
    public static final Action deactivateFailover = BHubConnector.newAction((int)20, null);
    @Generated
    public static final Action waitTimedOut = BHubConnector.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHubConnector.class);
    private static final Logger logger = Logger.getLogger("bacnet.sc.hubConnector");
    private BScLinkLayer scLinkLayer;
    private Clock.Ticket waitTicket;
    private BRelTime reconnectTimeout;
    private final AtomicBoolean linkCommStarting = new AtomicBoolean();

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BScHubConnectorState getState() {
        return (BScHubConnectorState)this.get(state);
    }

    @Generated
    public void setState(BScHubConnectorState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BHubConnectorSubState getSubState() {
        return (BHubConnectorSubState)this.get(subState);
    }

    @Generated
    public void setSubState(BHubConnectorSubState v) {
        this.set(subState, (BValue)v, null);
    }

    @Generated
    public BHubConnectorHealth getHealth() {
        return (BHubConnectorHealth)this.get(health);
    }

    @Generated
    public void setHealth(BHubConnectorHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Generated
    public BHubInitiatingConnection getPrimaryConnection() {
        return (BHubInitiatingConnection)this.get(primaryConnection);
    }

    @Generated
    public void setPrimaryConnection(BHubInitiatingConnection v) {
        this.set(primaryConnection, (BValue)v, null);
    }

    @Generated
    public BHubInitiatingConnection getFailoverConnection() {
        return (BHubInitiatingConnection)this.get(failoverConnection);
    }

    @Generated
    public void setFailoverConnection(BHubInitiatingConnection v) {
        this.set(failoverConnection, (BValue)v, null);
    }

    @Generated
    public void forceConnect() {
        this.invoke(forceConnect, null, null);
    }

    @Generated
    public void forceDisconnect() {
        this.invoke(forceDisconnect, null, null);
    }

    @Generated
    public void activatePrimary() {
        this.invoke(activatePrimary, null, null);
    }

    @Generated
    public void deactivatePrimary() {
        this.invoke(deactivatePrimary, null, null);
    }

    @Generated
    public void activateFailover() {
        this.invoke(activateFailover, null, null);
    }

    @Generated
    public void deactivateFailover() {
        this.invoke(deactivateFailover, null, null);
    }

    @Generated
    public void waitTimedOut() {
        this.invoke(waitTimedOut, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doForceConnect() {
        if (!this.isRunning()) {
            return;
        }
        this.scLinkLayer.checkNetworkPortIsEnabled();
        if (!this.scLinkLayer.isCommStarted()) {
            throw new LocalizableRuntimeException("bacnet", "hubConnector.forceConnect.scLinkLayerStopped");
        }
        BHubConnector bHubConnector = this;
        synchronized (bHubConnector) {
            block10: {
                block9: {
                    this.cancelWaitTicket();
                    if (!this.getPrimaryConnection().getEnabled()) break block9;
                    switch (this.getSubState().getOrdinal()) {
                        case 0: {
                            this.changeState(BHubConnectorSubState.connectingToPrimary);
                            BHubConnector.connect(this.getPrimaryConnection());
                            break block10;
                        }
                        case 4: {
                            this.changeState(BHubConnectorSubState.reconnectingToPrimary);
                            BHubConnector.connect(this.getPrimaryConnection());
                            break block10;
                        }
                        default: {
                            throw new LocalizableRuntimeException("bacnet", "hubConnector.forceConnect.improperState", (Object[])new String[]{this.getSubState().getDisplayTag(null)});
                        }
                    }
                }
                if (!this.getFailoverConnection().getEnabled()) throw new LocalizableRuntimeException("bacnet", "hubConnector.forceConnect.bothConnectionsDisabled");
                if (this.getSubState().getOrdinal() != 0) throw new LocalizableRuntimeException("bacnet", "hubConnector.forceConnect.improperState", (Object[])new String[]{this.getSubState().getDisplayTag(null)});
                this.changeState(BHubConnectorSubState.connectingToFailover);
                BHubConnector.connect(this.getFailoverConnection());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doForceDisconnect() {
        if (!this.isRunning()) {
            return;
        }
        BHubConnector bHubConnector = this;
        synchronized (bHubConnector) {
            if (this.getPrimaryConnection().isConnected()) {
                this.getPrimaryConnection().disconnect();
            }
            if (this.getFailoverConnection().isConnected()) {
                this.getFailoverConnection().disconnect();
            }
        }
    }

    public synchronized void doActivatePrimary() {
        if (!this.isRunning()) {
            return;
        }
        int subState = this.getSubState().getOrdinal();
        switch (subState) {
            case 1: 
            case 5: {
                if (subState == 5) {
                    this.getFailoverConnection().disconnect();
                }
                this.getHealth().primaryConnectionActivated();
                this.resetReconnectTimeout();
                this.changeState(BHubConnectorSubState.connectedToPrimary);
                this.sendNetworkReadyMessages();
                break;
            }
            default: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Unexpected call to doActivatePrimary while in improper state " + this.getSubState().getTag() + "; disconnecting from primary");
                }
                this.getPrimaryConnection().disconnect();
            }
        }
    }

    public synchronized void doDeactivatePrimary() {
        if (!this.isRunning()) {
            return;
        }
        switch (this.getSubState().getOrdinal()) {
            case 2: {
                this.getHealth().primaryConnectionFailed();
                this.incrementReconnectTimeout();
                this.changeState(BHubConnectorSubState.noHubConnection);
                this.startTimer();
                break;
            }
            case 1: {
                this.getHealth().primaryConnectionFailed();
                this.incrementReconnectTimeout();
                if (this.getFailoverConnection().getEnabled()) {
                    this.changeState(BHubConnectorSubState.connectingToFailover);
                    BHubConnector.connect(this.getFailoverConnection());
                    break;
                }
                this.changeState(BHubConnectorSubState.noHubConnection);
                this.startTimer();
                break;
            }
            case 5: {
                this.getHealth().primaryConnectionFailed();
                this.incrementReconnectTimeout();
                this.changeState(BHubConnectorSubState.connectedToFailover);
                this.startTimer();
                break;
            }
            default: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Unexpected call to doDeactivatePrimary while in improper state " + this.getSubState().getTag());
            }
        }
    }

    public synchronized void doActivateFailover() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getSubState().getOrdinal() == 3) {
            this.getHealth().failoverConnectionActivated();
            this.changeState(BHubConnectorSubState.connectedToFailover);
            this.sendNetworkReadyMessages();
            if (this.getPrimaryConnection().getEnabled()) {
                this.startTimer();
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unexpected call to doActivateFailover while in improper state " + this.getSubState().getTag() + "; disconnecting from failover");
            }
            this.getFailoverConnection().disconnect();
        }
    }

    public synchronized void doDeactivateFailover() {
        if (!this.isRunning()) {
            return;
        }
        switch (this.getSubState().getOrdinal()) {
            case 3: 
            case 4: {
                this.getHealth().failoverConnectionFailed();
                this.changeState(BHubConnectorSubState.noHubConnection);
                this.startTimer();
                break;
            }
            case 5: {
                this.getHealth().failoverConnectionFailed();
                this.changeState(BHubConnectorSubState.connectingToPrimary);
                break;
            }
            default: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Unexpected call to doDeactivateFailover while in improper state " + this.getSubState().getTag());
            }
        }
    }

    public synchronized void doWaitTimedOut() {
        if (!this.isRunning()) {
            return;
        }
        this.cancelWaitTicket();
        if (!this.scLinkLayer.isCommStarted()) {
            logger.fine("Wait timeout expiration ignored because the HubConnector's ScLinkLayer is not started");
            return;
        }
        switch (this.getSubState().getOrdinal()) {
            case 0: {
                if (this.getPrimaryConnection().getEnabled()) {
                    this.changeState(BHubConnectorSubState.connectingToPrimary);
                    BHubConnector.connect(this.getPrimaryConnection());
                    break;
                }
                this.getHealth().primaryConnectionDisabled();
                if (!this.getFailoverConnection().getEnabled()) break;
                this.changeState(BHubConnectorSubState.connectingToFailover);
                this.incrementReconnectTimeout();
                BHubConnector.connect(this.getFailoverConnection());
                break;
            }
            case 4: {
                if (this.getPrimaryConnection().getEnabled()) {
                    this.changeState(BHubConnectorSubState.reconnectingToPrimary);
                    BHubConnector.connect(this.getPrimaryConnection());
                    break;
                }
                this.getHealth().primaryConnectionDisabled();
                break;
            }
            default: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Wait timeout expired while in improper state " + this.getSubState().getTag());
            }
        }
    }

    public void sendMessage(long destinationVmac, AddressedMessage message) throws BacnetException {
        BHubInitiatingConnection connection = this.getActiveConnection();
        if (connection == null) {
            if (this.linkCommStarting.get()) {
                return;
            }
            throw new NoConnectionException("Hub Connector under Network Port " + this.scLinkLayer.getParent().getName() + " is not connected to a primary or failover hub.");
        }
        VmacUtil.checkIsDestinationVmac(destinationVmac);
        Objects.requireNonNull(message, "message parameter");
        message.setDestinationVmac(destinationVmac);
        message.clearOriginatingVmac();
        connection.sendMessage(message);
    }

    public void started() throws Exception {
        super.started();
        this.scLinkLayer = (BScLinkLayer)this.getParent();
    }

    @Override
    public String getSubProtocol() {
        return "hub.bsc.bacnet.org";
    }

    @Override
    public void initiatedConnectionFailed(BInitiatingConnection connection) {
        if (this.isPrimary(connection)) {
            this.deactivatePrimary();
        } else if (this.isFailover(connection)) {
            this.deactivateFailover();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unexpected call to initiatedConnectionFailed with " + this.toString(connection) + " connection in state " + this.getSubState().getTag());
        }
    }

    @Override
    public void activateConnection(BAbstractConnection connection) {
        if (this.isPrimary(connection)) {
            this.activatePrimary();
        } else if (this.isFailover(connection)) {
            this.activateFailover();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unexpected call to activateConnection with " + this.toString(connection) + " connection in state " + this.getSubState().getTag());
        }
    }

    @Override
    public void deactivateConnection(BAbstractConnection connection) {
        if (this.isPrimary(connection)) {
            this.deactivatePrimary();
        } else if (this.isFailover(connection)) {
            this.deactivateFailover();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unexpected call to deactivateConnection with " + this.toString(connection) + " connection in state " + this.getSubState().getTag());
        }
    }

    @Override
    public void forwardNpdu(long originatingVmac, long destinationVmac, ScNpdu npdu) throws Exception {
        this.scLinkLayer.rcvIndication(originatingVmac, destinationVmac, npdu);
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentType((Type)TYPE, (Type)parent.getType(), (Type[])new Type[]{BScLinkLayer.TYPE});
        BIRestrictedComponent.checkForDuplicate((BComponent)this, (BComponent)parent);
    }

    public synchronized void linkCommStart() {
        this.getPrimaryConnection().kill();
        this.getFailoverConnection().kill();
        this.changeState(BHubConnectorSubState.noHubConnection);
        this.resetReconnectTimeout();
        this.linkCommStarting.set(true);
        this.doWaitTimedOut();
    }

    public synchronized void linkCommStop() {
        this.linkCommStarting.set(false);
        this.cancelWaitTicket();
        this.resetReconnectTimeout();
        this.getPrimaryConnection().disconnect();
        this.getFailoverConnection().disconnect();
        this.changeState(BHubConnectorSubState.noHubConnection);
    }

    private static void connect(BHubInitiatingConnection connection) {
        AccessController.doPrivileged(() -> {
            connection.connect();
            return null;
        });
    }

    private BHubInitiatingConnection getActiveConnection() {
        switch (this.getSubState().getOrdinal()) {
            case 2: {
                return this.getPrimaryConnection();
            }
            case 4: 
            case 5: {
                return this.getFailoverConnection();
            }
        }
        return null;
    }

    private void changeState(BHubConnectorSubState subState) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("HubConnector transitioned from " + this.getSubState().getTag() + " to " + subState.getTag());
        }
        this.setSubState(subState);
        switch (subState.getOrdinal()) {
            case 0: {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
                this.setState(BScHubConnectorState.noHubConnection);
                this.linkCommStarting.set(false);
                break;
            }
            case 1: 
            case 3: {
                this.setState(BScHubConnectorState.noHubConnection);
                break;
            }
            case 2: {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
                this.setState(BScHubConnectorState.connectedToPrimary);
                break;
            }
            case 4: {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
                this.setState(BScHubConnectorState.connectedToFailover);
                break;
            }
            case 5: {
                this.setState(BScHubConnectorState.connectedToFailover);
                break;
            }
            default: {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Unexpected call to changeState with subState value " + subState.getTag());
            }
        }
    }

    private void resetReconnectTimeout() {
        this.reconnectTimeout = BRelTime.DEFAULT;
    }

    private void incrementReconnectTimeout() {
        if (this.reconnectTimeout == null) {
            this.resetReconnectTimeout();
        }
        long minMillis = this.scLinkLayer.getConfig().getMinimumReconnectTime().getMillis();
        long millis = Math.max(this.reconnectTimeout.getMillis() * 2L, minMillis);
        long maxMillis = this.scLinkLayer.getConfig().getMaximumReconnectTime().getMillis();
        millis = Math.min(millis, maxMillis);
        this.reconnectTimeout = BRelTime.make((long)millis);
    }

    private void startTimer() {
        if (this.waitTicket == null) {
            if (this.reconnectTimeout == null) {
                this.incrementReconnectTimeout();
            }
            this.waitTicket = Clock.schedule((BComponent)this, (BRelTime)(this.reconnectTimeout.getSeconds() > 0 ? this.reconnectTimeout : BRelTime.SECOND), (Action)waitTimedOut, null);
        }
    }

    private void cancelWaitTicket() {
        if (this.waitTicket != null) {
            this.waitTicket.cancel();
        }
        this.waitTicket = null;
    }

    public boolean isPrimary(BAbstractConnection connection) {
        return this.getPrimaryConnection() == connection;
    }

    private boolean isFailover(BAbstractConnection connection) {
        return this.getFailoverConnection() == connection;
    }

    public String toString(Context cx) {
        return this.getState().getDisplayTag(cx) + ' ' + this.getStatus().toString(cx);
    }

    private String toString(BAbstractConnection connection) {
        return this.isPrimary(connection) ? "primary" : (this.isFailover(connection) ? "failover" : "unknown");
    }

    private void sendNetworkReadyMessages() {
        if (this.linkCommStarting.compareAndSet(true, false)) {
            BNetworkPort networkPort = (BNetworkPort)this.scLinkLayer.getParent();
            BBacnetNetworkLayer networkLayer = (BBacnetNetworkLayer)networkPort.getParent();
            networkLayer.issueIAmRouterToNetworks();
            networkLayer.issueWhoIsRouterToNetwork(-1);
            networkPort.sendToLink(null, new NetworkNumberIs(networkPort.getNetworkNumber()));
            BBacnetNetwork.localDevice().sendIAm();
        }
    }
}

