/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.baja.bacnet.datatypes.BBacnetOctetString;

public final class BacnetIpLinkUtil {
    public static final byte[] EMPTY_BACNET_IP_BYTES = new byte[6];
    public static final BBacnetOctetString EMPTY_BACNET_IP_OCTET_STRING = BBacnetOctetString.make(EMPTY_BACNET_IP_BYTES);
    public static final String NON_ROUTABLE_ADDRESS = "0.0.0.0";
    public static final int IP_MAC_LEN = 6;
    private static final int IPV4_HOST_OCTETS = 4;

    private BacnetIpLinkUtil() {
    }

    public static boolean isSourceLocal(byte[] source, byte[] local, short mask) {
        if (source != null && local != null && source.length == 6 && local.length == 6) {
            int sourceAddress = BacnetIpLinkUtil.convertMacToInt(source);
            int localAddress = BacnetIpLinkUtil.convertMacToInt(local);
            int netmask = BacnetIpLinkUtil.convertNetmask(mask);
            if ((sourceAddress & netmask) == (localAddress & netmask)) {
                return BacnetIpLinkUtil.sameUdpPort(source, local);
            }
        }
        return false;
    }

    public static int convertNetmask(short networkPrefix) {
        if (networkPrefix <= 0) {
            return 0;
        }
        int offset = 32 - networkPrefix;
        int mask = -1 >> offset << offset;
        return mask;
    }

    public static boolean sameUdpPort(byte[] macAddress, byte[] otherMacAddress) {
        return macAddress[4] == otherMacAddress[4] && macAddress[5] == otherMacAddress[5];
    }

    public static int convertMacToInt(byte[] mac) {
        int intMac = 0;
        if (mac.length > 3) {
            intMac = mac[0] << 24 & 0xFF000000 | mac[1] << 16 & 0xFF0000 | mac[2] << 8 & 0xFF00 | mac[3] & 0xFF;
        }
        return intMac;
    }

    public static byte[] convertIntToAddress(int address) {
        byte[] b = new byte[]{(byte)(0xFF & address >> 24), (byte)(0xFF & address >> 16), (byte)(0xFF & address >> 8), (byte)(0xFF & address)};
        return b;
    }

    public static byte[] getBacnetIpBytes(String bacnetIpAddress) {
        if (bacnetIpAddress == null || bacnetIpAddress.isEmpty() || bacnetIpAddress.equalsIgnoreCase("null")) {
            return null;
        }
        try {
            byte[] bytes = new byte[6];
            if (bacnetIpAddress.contains(".")) {
                String[] hostNPort = bacnetIpAddress.split(":");
                if (hostNPort.length != 2) {
                    return null;
                }
                if (BacnetIpLinkUtil.containsDotsAndDigitsOnly(hostNPort[0])) {
                    String[] ipOctets = hostNPort[0].split("\\.");
                    if (ipOctets.length != 4) {
                        return null;
                    }
                    for (int i = 0; i < 4; ++i) {
                        int value = Integer.decode(ipOctets[i]);
                        if (value < 0 || value > 255) {
                            return null;
                        }
                        bytes[i] = (byte)value;
                    }
                } else {
                    try {
                        byte[] hostAddress = InetAddress.getByName(hostNPort[0]).getAddress();
                        if (hostAddress.length != 4) {
                            return null;
                        }
                        System.arraycopy(hostAddress, 0, bytes, 0, 4);
                    }
                    catch (UnknownHostException e) {
                        return null;
                    }
                }
                int port = Integer.decode(hostNPort[1]);
                bytes[4] = (byte)(port >> 8 & 0xFF);
                bytes[5] = (byte)(port & 0xFF);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(bacnetIpAddress, " :");
                if (tokenizer.countTokens() < 6) {
                    return null;
                }
                for (int i = 0; i < 6; ++i) {
                    int value = Integer.parseInt(tokenizer.nextToken(), 16);
                    if (value < 0 || value > 255) {
                        return null;
                    }
                    bytes[i] = (byte)value;
                }
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean containsDotsAndDigitsOnly(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        for (int i = 0; i < host.length(); ++i) {
            char c = host.charAt(i);
            if (c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static byte[] parseIpBytes(String address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(address, ".");
            if (tokenizer.countTokens() != 4) {
                return null;
            }
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                int value = Integer.decode(tokenizer.nextToken());
                if (value < 0 || value > 255) {
                    return null;
                }
                bytes[i] = (byte)value;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getPortFromBacnetIpBytes(byte[] bacnetIpBytes) {
        if (bacnetIpBytes == null || bacnetIpBytes.length != 6) {
            throw new IllegalArgumentException("bacnetIpBytes cannot be null and must be length of 6");
        }
        return ((bacnetIpBytes[4] & 0xFF) << 8) + (bacnetIpBytes[5] & 0xFF);
    }

    public static void validateAddressLength(byte[] addressBytes, int expectedLength) {
        if (addressBytes == null) {
            throw new IllegalArgumentException("addressBytes cannot be null");
        }
        if (addressBytes.length != expectedLength) {
            throw new IllegalArgumentException("addressBytes must be length of " + expectedLength);
        }
    }

    public static byte[] getBroadcastAddress(byte[] address, short networkPrefix) {
        return BacnetIpLinkUtil.convertIntToAddress(BacnetIpLinkUtil.convertMacToInt(address) | ~BacnetIpLinkUtil.convertNetmask(networkPrefix));
    }
}

