/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.stack.link.ip.BFdtEntry;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="removeEntry", parameterType="BFdtEntry", defaultValue="new BFdtEntry()", flags=4)
public class BForeignDeviceTable
extends BComponent {
    @Generated
    public static final Action removeEntry = BForeignDeviceTable.newAction((int)4, (BValue)new BFdtEntry(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BForeignDeviceTable.class);
    private HashMap<String, Clock.Ticket> tickets = new HashMap();
    private static final Logger logger = Logger.getLogger("bacnet.link.ip");

    @Generated
    public void removeEntry(BFdtEntry parameter) {
        this.invoke(removeEntry, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    void addEntry(byte[] bIPAddr, int timeToLive) {
        SlotCursor c = this.getProperties();
        String bacnetIpAddress = BBacnetAddress.bytesToString(2, bIPAddr);
        int timeRemaining = timeToLive + 30;
        if (timeRemaining > 65535) {
            timeRemaining = 65535;
        }
        while (c.next(BFdtEntry.class)) {
            BFdtEntry e = (BFdtEntry)c.get();
            if (!e.getBacnetIPAddress().equals(bacnetIpAddress)) continue;
            Clock.Ticket t = this.tickets.get(bacnetIpAddress);
            if (t != null) {
                t.cancel();
            }
            e.setTimeToLive(timeToLive);
            BRelTime regLife = BRelTime.make((long)((long)timeRemaining * 1000L));
            e.setPurgeTime(BAbsTime.make().add(regLife));
            this.tickets.put(bacnetIpAddress, Clock.schedule((BComponent)this, (BRelTime)regLife, (Action)removeEntry, (BValue)e));
            return;
        }
        BRelTime regLife = BRelTime.make((long)((long)timeRemaining * 1000L));
        BFdtEntry newEntry = new BFdtEntry(bacnetIpAddress, timeToLive, BAbsTime.make().add(regLife));
        this.add(SlotPath.escape((String)("FD" + bacnetIpAddress)), (BValue)newEntry, 2);
        this.tickets.put(bacnetIpAddress, Clock.schedule((BComponent)this, (BRelTime)regLife, (Action)removeEntry, (BValue)newEntry));
    }

    boolean deleteEntry(byte[] bIPAddr) {
        return this.deleteEntry(BBacnetAddress.bytesToString(2, bIPAddr));
    }

    boolean deleteEntry(String bIPAddr) {
        String fdName;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deleting Foreign Device Entry at " + bIPAddr);
        }
        if (this.get(fdName = SlotPath.escape((String)("FD" + bIPAddr))) == null) {
            return false;
        }
        try {
            this.remove(fdName);
            Clock.Ticket t = this.tickets.get(bIPAddr);
            if (t != null) {
                t.cancel();
            }
            this.tickets.remove(bIPAddr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void doRemoveEntry(BFdtEntry entry) {
        if (entry.getTimeToLive() < 0) {
            return;
        }
        this.deleteEntry(entry.getBacnetIPAddress());
    }

    public void deleteEntry(int index) {
        BFdtEntry[] kids = (BFdtEntry[])this.getChildren(BFdtEntry.class);
        if (kids != null && kids.length > index) {
            this.remove((BComplex)kids[index]);
        }
    }

    public void modifyEntry(int index, BFdtEntry newEntry) {
        BFdtEntry[] kids = (BFdtEntry[])this.getChildren(BFdtEntry.class);
        if (kids != null && kids.length > index) {
            kids[index].copyFrom((BComplex)newEntry);
        }
    }
}

