/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.stack.link.ip.util.BacnetIpLinkUtil;
import java.net.InetAddress;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bacnetIPAddress", type="String", defaultValue=""), @NiagaraProperty(name="broadcastDistributionMask", type="String", defaultValue="")})
public class BBdtEntry
extends BStruct {
    @Generated
    public static final Property bacnetIPAddress = BBdtEntry.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property broadcastDistributionMask = BBdtEntry.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBdtEntry.class);

    @Generated
    public String getBacnetIPAddress() {
        return this.getString(bacnetIPAddress);
    }

    @Generated
    public void setBacnetIPAddress(String v) {
        this.setString(bacnetIPAddress, v, null);
    }

    @Generated
    public String getBroadcastDistributionMask() {
        return this.getString(broadcastDistributionMask);
    }

    @Generated
    public void setBroadcastDistributionMask(String v) {
        this.setString(broadcastDistributionMask, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBdtEntry() {
    }

    public BBdtEntry(byte[] addr, byte[] bdMask) {
        this.setBIpAddr(addr);
        this.setBdMask(bdMask);
    }

    public BBdtEntry(String addr, String bdMask) {
        this.setBacnetIPAddress(addr);
        this.setBroadcastDistributionMask(bdMask);
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append("B/IP addr:" + this.getBacnetIPAddress());
        sb.append("  BDMask:" + this.getBroadcastDistributionMask());
        return sb.toString();
    }

    public byte[] getBIpAddr() {
        byte[] hostAddress;
        String[] hostNPort = this.getBacnetIPAddress().split(":");
        if (hostNPort.length != 2) {
            throw new IllegalArgumentException(Lexicon.make((String)"bacnet").getText("IllegalArgumentException.badBacnetAddressString"));
        }
        if (BacnetIpLinkUtil.containsDotsAndDigitsOnly(hostNPort[0])) {
            return BBacnetAddress.stringToBytes(2, 5, this.getBacnetIPAddress());
        }
        try {
            hostAddress = InetAddress.getByName(hostNPort[0]).getAddress();
            if (hostAddress.length != 4) {
                return (byte[])BacnetIpLinkUtil.EMPTY_BACNET_IP_BYTES.clone();
            }
        }
        catch (Exception ignored) {
            return (byte[])BacnetIpLinkUtil.EMPTY_BACNET_IP_BYTES.clone();
        }
        int port = Integer.decode(hostNPort[1]);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("bacnetIpAddress string with named host must have port value 0-65535: " + port);
        }
        byte[] bytes = new byte[6];
        System.arraycopy(hostAddress, 0, bytes, 0, 4);
        bytes[4] = (byte)(port >> 8 & 0xFF);
        bytes[5] = (byte)(port & 0xFF);
        return bytes;
    }

    public byte[] getBdMask() {
        return BBacnetAddress.stringToBytes(2, 4, this.getBroadcastDistributionMask());
    }

    public void setBIpAddr(byte[] bipAddr) {
        this.setBacnetIPAddress(BBacnetAddress.bytesToString(2, bipAddr));
    }

    public void setBdMask(byte[] bdMask) {
        this.setBroadcastDistributionMask(BBacnetAddress.bytesToString(2, bdMask));
    }

    public byte[] getDistributionAddress() {
        byte[] bdtAddr = new byte[6];
        byte[] bIPAddr = this.getBIpAddr();
        System.arraycopy(bIPAddr, 0, bdtAddr, 0, 6);
        byte[] bdtMask = this.getBdMask();
        for (int i = 0; i < 4; ++i) {
            int n = i;
            bdtAddr[n] = (byte)(bdtAddr[n] | (byte)(~bdtMask[i]));
        }
        return bdtAddr;
    }

    public boolean ipEquals(byte[] ip) {
        return this.getBacnetIPAddress().equals(BBacnetAddress.bytesToString(2, ip));
    }

    public boolean isAddressValid() {
        try {
            this.getBIpAddr();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isMaskValid() {
        try {
            this.getBdMask();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDirectedBroadcast() {
        byte[] bdm = this.getBdMask();
        if (bdm == null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if ((bdm[i] & 0xFF) == 255) continue;
            return true;
        }
        return false;
    }
}

