/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.nre.firewall.IpProtocol;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.firewall.BServerPort;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="publicServerPort", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}, override=true)
public class BBacnetIpServerPort
extends BServerPort {
    @Generated
    public static final Property publicServerPort = BBacnetIpServerPort.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)65535)), (BFacets)BFacets.make((String)"radix", (int)10)));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetIpServerPort.class);
    private static final Set<Slot> UNLINKABLE_TARGET_SLOTS = Collections.unmodifiableSet(Stream.of(publicServerPort, localServerPort).collect(Collectors.toSet()));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetIpServerPort() {
    }

    public BBacnetIpServerPort(int publicServerPort, IpProtocol protocol) {
        super(publicServerPort, protocol);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetIpLinkLayer;
    }

    public Set<Slot> getUnlinkableTargetSlots(Context context) {
        return UNLINKABLE_TARGET_SLOTS;
    }

    public void started() throws Exception {
    }

    public void stopped() throws Exception {
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(publicServerPort) || property.equals(localServerPort) || property.equals(adapter) || property.equals(ipProtocol)) {
            BBacnetIpLinkLayer linkLayer = (BBacnetIpLinkLayer)this.getParent();
            if (this.getNetworkPort().getEnabled()) {
                this.updateFirewallRules();
                linkLayer.updatePeerFirewallRules();
            }
            linkLayer.changed(this.getPropertyInParent(), context);
        }
    }

    protected String getRuleHint() {
        return "BACnet." + this.getNetworkPort().getName();
    }

    public void updateFirewallRules() {
        super.updateFirewallRules();
    }

    public void removeFirewallRules() {
        super.removeFirewallRules();
    }

    private BNetworkPort getNetworkPort() {
        BBacnetIpLinkLayer linkLayer = (BBacnetIpLinkLayer)this.getParent();
        return (BNetworkPort)linkLayer.getParent();
    }
}

