/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.MultiPollThread;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.baja.bacnet.util.PollList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxDibsPolls", type="int", defaultValue="5", flags=4), @NiagaraProperty(name="numberOfThreads", type="int", defaultValue="2", flags=1)})
public class BBacnetMultiPoll
extends BBacnetPoll {
    @Generated
    public static final Property maxDibsPolls = BBacnetMultiPoll.newProperty((int)4, (int)5, null);
    @Generated
    public static final Property numberOfThreads = BBacnetMultiPoll.newProperty((int)1, (int)2, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMultiPoll.class);
    static final DecimalFormat avgCntFormat = new DecimalFormat("0.0#");
    private static boolean RECORD_POLL_STATISTICS = Boolean.valueOf(System.getProperty("niagara.bacnet.poll.statistics", "true"));
    long stats;
    MultiPollThread[] pollThreads;
    private int dibsPolls = 0;
    private long sleep;
    private BBacnetPoll.BacnetBucket nextBucket;

    @Generated
    public int getMaxDibsPolls() {
        return this.getInt(maxDibsPolls);
    }

    @Generated
    public void setMaxDibsPolls(int v) {
        this.setInt(maxDibsPolls, v, null);
    }

    @Override
    @Generated
    public int getNumberOfThreads() {
        return this.getInt(numberOfThreads);
    }

    @Generated
    public void setNumberOfThreads(int v) {
        this.setInt(numberOfThreads, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String toString(Context cx) {
        if (this.isRunning()) {
            return "BacnetMultiPoll in " + this.getParent().getName();
        }
        return "BacnetMultiPoll";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pollStart() {
        Object object = this.lock;
        synchronized (object) {
            this.initializeBuckets();
            this.fast.nextBucket = this.norm;
            this.norm.nextBucket = this.slow;
            this.slow.nextBucket = this.fast;
            this.nextBucket = this.fast;
            int numThds = this.getNumberOfThreads();
            this.pollStop();
            this.isAlive = true;
            this.pollThreads = new MultiPollThread[numThds];
            this.dibsPolls = 0;
            this.doResetStatistics();
            this.stats = Clock.ticks() + 10000L;
            for (int i = 0; i < numThds; ++i) {
                this.pollThreads[i] = new MultiPollThread(this, "BnMP" + ((BNetworkPort)this.getParent()).getPortId() + ":" + this.getParent().getName() + ":", i);
                this.pollThreads[i].start();
            }
        }
    }

    @Override
    public void pollStop() {
        this.isAlive = false;
        if (this.pollThreads == null) {
            return;
        }
        for (int i = 0; i < this.pollThreads.length; ++i) {
            if (this.pollThreads[i] == null) continue;
            this.pollThreads[i].stop();
            this.pollThreads[i] = null;
        }
        this.pollThreads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(numberOfThreads) && this.isAlive) {
            this.pollStop();
            ((BBacnetNetworkLayer)this.getParent().getParent()).initializeAsnInputPool();
            Object object = this.lock;
            synchronized (object) {
                this.fast.resetDone();
                this.norm.resetDone();
                this.slow.resetDone();
            }
            this.pollStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollList next() {
        PollList next = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.dibs.isEmpty() && this.dibsPolls < this.getMaxDibsPolls()) {
                next = (PollList)this.dibs.pop();
                ++this.dibsPollTotal;
                ++this.dibsPolls;
                next.setSleep(this.computeSleep());
                return next;
            }
            this.dibsPolls = 0;
            next = this.checkBuckets();
            long now = (Long)ticksSupplier.get();
            if (now >= this.stats) {
                this.checkBucketConfig();
                if (RECORD_POLL_STATISTICS) {
                    this.updateStats(now, false);
                }
                this.stats = now + 10000L;
            }
            if (next != null) {
                next.setSleep(this.computeSleep());
            }
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollList checkBuckets() {
        Object object = this.lock;
        synchronized (object) {
            PollList next;
            int i;
            for (i = 0; i < 3; ++i) {
                next = this.checkBucket(this.nextBucket, false);
                if (next == null) continue;
                return next;
            }
            for (i = 0; i < 3; ++i) {
                next = this.checkBucket(this.nextBucket, true);
                if (next == null) continue;
                return next;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollList checkBucket(BBacnetPoll.BacnetBucket bucket, boolean isBusyOk) {
        Object object = this.lock;
        synchronized (object) {
            long rate;
            this.nextBucket = bucket.nextBucket;
            if (bucket.nextTicks > Clock.ticks() + 5L) {
                return null;
            }
            PollList pl = null;
            int index = bucket.index;
            int size = bucket.q.size();
            if (size > 0) {
                if (index >= size) {
                    index = 0;
                }
                int nodesChecked = 0;
                while (nodesChecked++ < size) {
                    PollList p1 = bucket.q.get(index);
                    if (!(p1.isPolling() || !isBusyOk && p1.getDevice().isPolling() || p1.isDone())) {
                        pl = p1;
                        bucket.index = index + 1;
                        break;
                    }
                    index = (index + 1) % size;
                }
                if (bucket.donePolling()) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Reset bucket " + bucket + " on thd " + Thread.currentThread().getName());
                    }
                    ++bucket.cycleTotal;
                    bucket.pollCount = 0;
                    bucket.resetDone();
                    if (this.getTimeToRepack()) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Repacking bucket: " + bucket);
                        }
                        this.setLastRepackTime(Clock.ticks());
                        this.initializeBuckets();
                    }
                }
            } else {
                ++bucket.cycleTotal;
            }
            if (pl != null) {
                ++bucket.pollCount;
                ++bucket.pollTotal;
                pl.setIsPolling(true);
                pl.setDone(true);
            }
            long slep = rate = ((BRelTime)this.get(bucket.rateProp)).getMillis();
            if (size > 0) {
                double dRate = rate;
                double dSize = size;
                slep = (long)((dRate - dSize * (double)this.lastPollTime) / dSize);
            } else {
                slep = 1000L;
            }
            bucket.nextTicks = Clock.ticks() + slep;
            return pl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long computeSleep() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.dibs.isEmpty()) {
                return 0L;
            }
            long now = Clock.ticks();
            long fnt = this.fast.nextTicks - now;
            long nnt = this.norm.nextTicks - now;
            long snt = this.slow.nextTicks - now;
            this.sleep = 10000L;
            if (fnt < this.sleep) {
                this.sleep = fnt;
                this.nextBucket = this.fast;
            }
            if (nnt < this.sleep) {
                this.sleep = nnt;
                this.nextBucket = this.norm;
            }
            if (snt < this.sleep) {
                this.sleep = snt;
                this.nextBucket = this.slow;
            }
            return this.sleep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doResetStatistics() {
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.average = 0.0;
        this.statsCount = 0;
        this.dibsPollTotal = 0;
        this.dibsSizeTotal = 0;
        Object object = this.lock;
        synchronized (object) {
            this.fast.reset();
            this.norm.reset();
            this.slow.reset();
            this.start = Clock.ticks();
            this.updateStats(this.start, true);
        }
    }

    @Override
    protected String toCount(int current, int total) {
        return "current=" + current + " average=" + avgCntFormat.format((double)total / (double)this.statsCount);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetMultiPoll", 2);
        out.prop((Object)"dibsPolls", this.dibsPolls);
        out.prop((Object)"stats", (Object)BLong.make((long)this.stats));
        out.prop((Object)"sleep", (Object)BLong.make((long)this.sleep));
        out.prop((Object)"nextBucket", (Object)this.nextBucket);
        if (this.isAlive) {
            out.prop((Object)"pollThreads", this.pollThreads.length);
            for (int i = 0; i < this.pollThreads.length; ++i) {
                out.prop((Object)("  " + i), (Object)this.pollThreads[i].getName());
                this.pollThreads[i].spyImpl(out);
            }
        }
        out.endProps();
    }
}

