/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.bacnet.schedule.BBacnetScheduleImportExt;
import com.tridium.bacnet.schedule.ScheduleSupport16;
import com.tridium.bacnet.schedule.ScheduleSupport4;
import com.tridium.bacnet.schedule.ScheduleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetCalendarDescriptor;
import javax.baja.bacnet.io.AsnDataTypeNotSupportedException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.DataTypeNotSupportedException;
import javax.baja.bacnet.io.DuplicateEntryException;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public class ScheduleSupport0
implements AsnConst {
    static final BFacets SCHEDULE_CALENDAR_OBJECT_ID_FACETS = BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{17, 6}, (String[])new String[]{BBacnetObjectType.tag(17), BBacnetObjectType.tag(6)}));
    private static final BacnetScheduleComparator scheduleOrder = new BacnetScheduleComparator();
    public static final String BACNET_IDX = "bacnetIdx";
    private static final BDateSchedule ALWAYS_EFFECTIVE_DATE_SCHEDULE = new BDateSchedule();
    private static final boolean CALCULATE_WEEKDAY = true;
    protected BBacnetScheduleDeviceExt devext = null;
    private static final Log logger = Log.getLog((String)"bacnet.schedule");

    public ScheduleSupport0() {
    }

    public ScheduleSupport0(BBacnetScheduleDeviceExt ext) {
        this.devext = ext;
    }

    public static ScheduleSupport0 makeForProtocolRevision(int protocolRevision, ScheduleSupport0 current) {
        if (protocolRevision >= 16) {
            if (!current.getClass().equals(ScheduleSupport16.class)) {
                return new ScheduleSupport16();
            }
        } else if (protocolRevision >= 4) {
            if (!current.getClass().equals(ScheduleSupport4.class)) {
                return new ScheduleSupport4();
            }
        } else if (!current.getClass().equals(ScheduleSupport0.class)) {
            return new ScheduleSupport0();
        }
        return current;
    }

    public String getVersion() {
        return "ScheduleSupport 1.0";
    }

    public BAbstractSchedule decodeCalendarEntry(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (in.isValueTag(0)) {
            return this.decodeDate(0, in);
        }
        if (in.isOpeningTag(1)) {
            return this.decodeDateRange(1, in);
        }
        if (in.isValueTag(2)) {
            return this.decodeWeekAndDay(2, in);
        }
        throw new AsnException("Invalid tag: " + tag);
    }

    public BDaySchedule decodeDailySchedule(BStatusValue defaultValue, AsnInput in, int asnType) throws AsnException {
        TimeValue[] tvs = this.decodeTimeValues(0, in, defaultValue, asnType);
        return this.makeDay(tvs, this.bajaToJavaNullOk(defaultValue));
    }

    public BDateSchedule decodeDate(AsnInput in) throws AsnException {
        return this.decodeDate(in.readDate());
    }

    public BDateSchedule decodeDate(int contextTag, AsnInput in) throws AsnException {
        return this.decodeDate(in.readDate(contextTag));
    }

    public BDateSchedule decodeDate(BBacnetDate date) {
        BDateSchedule schedule = new BDateSchedule();
        schedule.setYear(date.getYear());
        schedule.setMonth(date.isMonthUnspecified() ? date.getMonth() : date.getMonth() - 1);
        schedule.setDay(ScheduleSupport0.bacnetDayOfMonthToBajaScheduleDay(date.getDayOfMonth()));
        if (!date.isDayOfWeekUnspecified()) {
            schedule.setWeekday(date.getBWeekday().getOrdinal());
        }
        return schedule;
    }

    public BCalendarSchedule decodeDateList(AsnInput in) throws AsnException {
        BCalendarSchedule ret = new BCalendarSchedule();
        while (in.peekTag() != -1) {
            ret.add(this.decodeCalendarEntry(in));
        }
        return ret;
    }

    public BDateRangeSchedule decodeDateRange(AsnInput in) throws AsnException {
        BDateRangeSchedule ret = new BDateRangeSchedule();
        ret.setStart(this.decodeDate(in));
        ret.setEnd(this.decodeDate(in));
        ScheduleSupport0.checkForSpecialValuesInDateRange(ret);
        return ret;
    }

    public BDateRangeSchedule decodeDateRange(int contextTag, AsnInput in) throws AsnException {
        BDateRangeSchedule ret = new BDateRangeSchedule();
        in.skipTag();
        ret.setStart(this.decodeDate(in));
        ret.setEnd(this.decodeDate(in));
        in.skipTag();
        ScheduleSupport0.checkForSpecialValuesInDateRange(ret);
        return ret;
    }

    private static void checkForSpecialValuesInDateRange(BDateRangeSchedule dateRange) throws OutOfRangeException {
        BDateSchedule start = dateRange.getStart();
        BDateSchedule end = dateRange.getEnd();
        if (ScheduleSupport0.allValuesInDateScheduleAreUnspecified(start) && ScheduleSupport0.noneInDateScheduleAreSpecialValues(end) || ScheduleSupport0.noneInDateScheduleAreSpecialValues(start) && ScheduleSupport0.allValuesInDateScheduleAreUnspecified(end) || ScheduleSupport0.allValuesInDateScheduleAreUnspecified(start) && ScheduleSupport0.allValuesInDateScheduleAreUnspecified(end)) {
            return;
        }
        if (start.getYear() == -1 || end.getYear() == -1 || ScheduleSupport0.monthHasSpecialValue(start.getMonth()) || ScheduleSupport0.monthHasSpecialValue(end.getMonth()) || ScheduleSupport0.dayHasSpecialValue(start.getDay()) || ScheduleSupport0.dayHasSpecialValue(end.getDay()) || start.getWeekday() == -1 || end.getWeekday() == -1) {
            throw new OutOfRangeException("Date contains Special Values.");
        }
    }

    private static boolean monthHasSpecialValue(int month) {
        return month == -1 || month == 12 || month == 13;
    }

    private static boolean dayHasSpecialValue(int day) {
        return day == -1 || day == 32 || day == 33 || day == 34 || day == 35;
    }

    private static boolean allValuesInDateScheduleAreUnspecified(BDateSchedule dateSchedule) {
        return dateSchedule.getYear() == -1 && dateSchedule.getMonth() == -1 && dateSchedule.getDay() == -1 && dateSchedule.getWeekday() == -1;
    }

    private static boolean noneInDateScheduleAreSpecialValues(BDateSchedule dateSchedule) {
        return dateSchedule.getYear() != -1 && !ScheduleSupport0.monthHasSpecialValue(dateSchedule.getMonth()) && !ScheduleSupport0.dayHasSpecialValue(dateSchedule.getDay()) && dateSchedule.getWeekday() != -1;
    }

    private static boolean allValuesInTimeAreUnspecified(BBacnetTime t) {
        return t.isHourUnspecified() && t.isMinuteUnspecified() && t.isSecondUnspecified() && t.isHundredthUnspecified();
    }

    public BCompositeSchedule decodeExceptionSchedule(BStatusValue defaultValue, AsnInput in, BBacnetObjectIdentifier deviceId, int asnType) throws AsnException {
        BCompositeSchedule ret = new BCompositeSchedule();
        Array arr = new Array(BDailySchedule.class);
        int tag = in.peekTag();
        int ndx = 0;
        while (tag != -1) {
            BDailySchedule mdsch = this.decodeSpecialEvent(defaultValue, in, deviceId, asnType, ndx++);
            int eventPriority = ((BInteger)mdsch.get("priority")).getInt();
            boolean inserted = false;
            for (int i = 0; i < arr.size(); ++i) {
                BDailySchedule existing = (BDailySchedule)arr.get(i);
                Property p = existing.getProperty("priority");
                int existingPriority = 1;
                if (p != null) {
                    existingPriority = existing.getInt(p);
                }
                if (eventPriority >= existingPriority) continue;
                arr.add(i, (Object)mdsch);
                inserted = true;
                break;
            }
            if (!inserted) {
                arr.add((Object)mdsch);
            }
            tag = in.peekTag();
        }
        ListIterator it = arr.iterator();
        while (it.hasNext()) {
            ret.add(null, (BValue)it.next());
        }
        return ret;
    }

    public BAbstractSchedule decodePeriod(AsnInput in, BBacnetObjectIdentifier deviceId) throws AsnException {
        int tag = in.peekTag();
        if (in.isOpeningTag(0)) {
            in.skipTag();
            BAbstractSchedule ret = this.decodeCalendarEntry(in);
            in.skipTag();
            return ret;
        }
        if (in.isValueTag(1)) {
            BScheduleReference ret = new BScheduleReference();
            BBacnetObjectIdentifier objectId = in.readObjectIdentifier(1);
            try {
                BBacnetDevice device = BBacnetNetwork.bacnet().doLookupDeviceById(deviceId);
                if (device == null) {
                    if (BBacnetNetwork.localDevice().getObjectId().equals((Object)deviceId)) {
                        BBacnetCalendarDescriptor calXport = (BBacnetCalendarDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(objectId);
                        if (calXport != null) {
                            ret.setRef(calXport.getObject().asComponent().getSlotPathOrd());
                        }
                    } else {
                        ScheduleSupport0.log().message("Unable to find BACnet device for deviceId " + (Object)((Object)deviceId) + "!!! Calendar Reference could fail...");
                        ret.setRef((BOrd)BOrd.NULL.decodeFromString("bac:" + deviceId.toString() + ";" + objectId.toString() + "{" + "schedule" + "}"));
                    }
                } else {
                    BAbstractSchedule cal = (BAbstractSchedule)device.lookupBacnetObject(objectId, -1, -1, "schedule");
                    if (cal != null) {
                        ret.setRef(cal.getSlotPathOrd());
                    } else {
                        ScheduleSupport0.log().message("Unable to find BACnet calendar " + (Object)((Object)objectId) + " in device " + (Object)((Object)deviceId) + "!!! Calendar Reference could fail...");
                        ret.setRef((BOrd)BOrd.NULL.decodeFromString("bac:" + deviceId.toString() + ";" + objectId.toString() + "{" + "schedule" + "}"));
                    }
                }
            }
            catch (Exception e) {
                ScheduleSupport0.log().error("Exception decoding schedule reference:" + (Object)((Object)objectId), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            return ret;
        }
        throw new AsnException("Invalid tag: " + tag);
    }

    public BStatusValue decodeScheduleDefault(BStatusValue defaultValue, AsnInput in, int asnType) throws AsnException {
        Type t = defaultValue.getType();
        if (t.is(BStatusBoolean.TYPE)) {
            return this.decodeScheduleDefaultBoolean((BStatusBoolean)defaultValue, in);
        }
        if (t.is(BStatusNumeric.TYPE)) {
            return this.decodeScheduleDefaultNumeric((BStatusNumeric)defaultValue, in);
        }
        if (t.is(BStatusEnum.TYPE)) {
            return this.decodeScheduleDefaultEnum((BStatusEnum)defaultValue, in, asnType);
        }
        if (t.is(BStatusString.TYPE)) {
            return this.decodeScheduleDefaultString((BStatusString)defaultValue, in);
        }
        throw new IllegalArgumentException(defaultValue.getClass().toString());
    }

    public BDailySchedule decodeSpecialEvent(BStatusValue defaultValue, AsnInput in, BBacnetObjectIdentifier deviceId, int asnType, int ndx) throws AsnException {
        BDailySchedule ret = new BDailySchedule(this.decodePeriod(in, deviceId));
        TimeValue[] tvs = this.decodeTimeValues(2, in, defaultValue, asnType);
        ret.setDay(this.makeDay(tvs, this.bajaToJavaNullOk(defaultValue)));
        ret.add("priority", (BValue)BInteger.make((int)in.readUnsignedInt(3)));
        ret.add(BACNET_IDX, (BValue)BInteger.make((int)ndx));
        return ret;
    }

    public BWeekAndDaySchedule decodeWeekAndDay(int contextTag, AsnInput in) throws AsnException {
        BWeekAndDaySchedule ret = new BWeekAndDaySchedule();
        byte[] wnd = in.readOctetString(contextTag);
        byte i = wnd[0];
        ret.setMonth(i <= 0 || i > 14 ? -1 : i - 1);
        i = wnd[1];
        ret.setWeek((int)i);
        i = wnd[2];
        switch (i) {
            case 7: {
                ret.setWeekday(0);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                ret.setWeekday((int)i);
                break;
            }
            default: {
                ret.setWeekday(-1);
            }
        }
        return ret;
    }

    public void encodeCalendarEntry(BAbstractSchedule sch, AsnOutput out) {
        if (sch instanceof BDateSchedule) {
            this.encodeDate((BDateSchedule)sch, 0, out);
        } else if (sch instanceof BDateRangeSchedule) {
            this.encodeDateRange((BDateRangeSchedule)sch, 1, out);
        } else if (sch instanceof BWeekAndDaySchedule) {
            this.encodeWeekAndDay((BWeekAndDaySchedule)sch, 2, out);
        } else if (sch instanceof BCustomSchedule) {
            BAbsTime start = BAbsTime.make();
            BAbsTime finish = start.nextYear();
            int numEvents = 0;
            BAbsTime next = sch.nextEvent(start);
            while (numEvents < 10 && next.isBefore(finish)) {
                if (sch.isEffective(next)) {
                    this.encodeDate(next, 0, out);
                    ++numEvents;
                }
                next = sch.nextEvent(next);
            }
        } else {
            throw new IllegalArgumentException("Invalid calendar entry: " + sch.getClass());
        }
    }

    public void encodeDailySchedule(BDaySchedule dsch, BStatusValue defaultValue, AsnOutput out, int asnType) {
        TimeValue[] tvs = this.makeDay(dsch, this.bajaToJava(defaultValue));
        this.encodeTimeValues(tvs, 0, out, asnType);
    }

    public void encodeDate(BDateSchedule dsch, AsnOutput out) {
        this.encodeDate(dsch, out, false);
    }

    public void encodeDate(BDateSchedule dsch, AsnOutput out, boolean calculateWeekDay) {
        int year = dsch.getYear();
        int month = dsch.getMonth();
        int day = ScheduleSupport0.bajaScheduleDayToBacnetDayOfMonth(dsch.getDay());
        int weekDay = dsch.getWeekday();
        if (calculateWeekDay && month >= 0 && year >= 0 && day >= 0) {
            weekDay = BAbsTime.getWeekday((int)year, (BMonth)BMonth.make((int)month), (int)day).getOrdinal();
        }
        out.writeDate(year < 0 ? 255 : year - 1900, month < 0 ? month : month + 1, day, weekDay == 0 ? 7 : weekDay);
    }

    public void encodeDate(BDateSchedule dsch, int contextTag, AsnOutput out) {
        int y = dsch.getYear();
        int m = dsch.getMonth();
        int d = ScheduleSupport0.bajaScheduleDayToBacnetDayOfMonth(dsch.getDay());
        int weekDay = dsch.getWeekday();
        out.writeDate(contextTag, y < 0 ? 255 : y - 1900, m < 0 ? m : m + 1, d, weekDay == 0 ? 7 : weekDay);
    }

    public void encodeDate(BAbsTime date, int contextTag, AsnOutput out) {
        int y = date.getYear();
        int m = date.getMonth().getOrdinal();
        int d = date.getDay();
        int w = date.getWeekday().getOrdinal();
        out.writeDate(contextTag, y - 1900, m + 1, d, w == 0 ? 7 : w);
    }

    public void encodeDateList(BCalendarSchedule cal, AsnOutput out) {
        SlotCursor c = cal.getProperties();
        while (c.next(BAbstractSchedule.class)) {
            this.encodeCalendarEntry((BAbstractSchedule)c.get(), out);
        }
    }

    public void encodeDateRange(BDateRangeSchedule drsch, AsnOutput out) {
        if (drsch.getAlwaysEffective()) {
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, out);
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, out);
        } else {
            this.encodeDate(drsch.getStart(), out, true);
            this.encodeDate(drsch.getEnd(), out, true);
        }
    }

    public void encodeDateRange(BDateRangeSchedule drsch, int contextTag, AsnOutput out) {
        out.writeOpeningTag(contextTag);
        if (drsch.getAlwaysEffective()) {
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, out);
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, out);
        } else {
            this.encodeDate(drsch.getStart(), out, true);
            this.encodeDate(drsch.getEnd(), out, true);
        }
        out.writeClosingTag(contextTag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeEntry(BAbstractSchedule sch, AsnOutput out, BBacnetObjectIdentifier deviceId) {
        if (sch instanceof BScheduleReference) {
            BBacnetObjectIdentifier defObjectId = BBacnetObjectIdentifier.make(6);
            BOrd ord = ((BScheduleReference)sch).getRef();
            if (BBacnetNetwork.localDevice().getObjectId().equals((Object)deviceId)) {
                BBacnetObjectIdentifier objectId = BBacnetNetwork.localDevice().lookupBacnetObjectId(ord);
                out.writeObjectIdentifier(1, objectId != null ? objectId : defObjectId);
                return;
            } else {
                BObject o = ord.get((BObject)sch.getComponentSpace());
                if (o == null) {
                    throw new IllegalArgumentException("Invalid calendar reference: ref=" + ord + "; unresolved!");
                }
                if (!(o instanceof BCalendarSchedule)) throw new IllegalArgumentException("Invalid calendar reference: ref=" + ord + "; o=" + o + " [" + o.getType() + "]");
                BCalendarSchedule cal = (BCalendarSchedule)o;
                BBacnetScheduleImportExt importExt = BBacnetScheduleDeviceExt.getBacnetImportExt((BAbstractSchedule)cal);
                if (importExt != null) {
                    out.writeObjectIdentifier(1, importExt.getObjectId());
                    return;
                } else {
                    if (this.devext == null) throw new IllegalArgumentException("ScheduleSupport device extension reference not set!");
                    BBacnetScheduleExport export = this.devext.getBacnetExportExt((BAbstractSchedule)cal);
                    if (export == null) throw new IllegalArgumentException("No schedule import or export is available for calendar:" + ord);
                    out.writeObjectIdentifier(1, export.getObjectId());
                }
            }
            return;
        } else {
            out.writeOpeningTag(0);
            this.encodeCalendarEntry(sch, out);
            out.writeClosingTag(0);
        }
    }

    public void encodeExceptionScheduleWithIdx(BCompositeSchedule csch, BStatusValue defaultValue, AsnOutput out, int asnType, BBacnetObjectIdentifier deviceId) {
        List<BDailySchedule> specialEvents = ScheduleSupport0.sortSpecialEvents(csch);
        for (int i = 0; i < specialEvents.size(); ++i) {
            this.encodeSpecialEvent(specialEvents.get(i), defaultValue, out, asnType, deviceId);
        }
    }

    public void encodeExceptionSchedule(BCompositeSchedule csch, BStatusValue defaultValue, AsnOutput out, int asnType, BBacnetObjectIdentifier deviceId) {
        SlotCursor c = csch.getProperties();
        while (c.next(BDailySchedule.class)) {
            BDailySchedule mdsch = (BDailySchedule)c.get();
            this.encodeSpecialEvent(mdsch, defaultValue, out, asnType, deviceId);
        }
    }

    public void encodeScheduleDefault(BStatusValue defaultOutput, AsnOutput out, int asnType) {
        Type t = defaultOutput.getType();
        if (t.is(BStatusBoolean.TYPE)) {
            this.encodeScheduleDefault((BStatusBoolean)defaultOutput, out, asnType);
            return;
        }
        if (t.is(BStatusNumeric.TYPE)) {
            this.encodeScheduleDefault((BStatusNumeric)defaultOutput, out, asnType);
            return;
        }
        if (t.is(BStatusEnum.TYPE)) {
            this.encodeScheduleDefault((BStatusEnum)defaultOutput, out, asnType);
            return;
        }
        if (t.is(BStatusString.TYPE)) {
            this.encodeScheduleDefault((BStatusString)defaultOutput, out, asnType);
            return;
        }
        throw new IllegalArgumentException(defaultOutput.getClass().toString());
    }

    public void encodeSpecialEvent(BDailySchedule mdsch, BStatusValue defaultValue, AsnOutput out, int asnType, BBacnetObjectIdentifier deviceId) {
        this.encodeEntry(mdsch.getDays(), out, deviceId);
        TimeValue[] tvs = this.makeDay(mdsch.getDay(), this.bajaToJava(defaultValue));
        this.encodeTimeValues(tvs, 2, out, asnType);
        Property p = mdsch.getProperty("priority");
        out.writeUnsignedInteger(3, p != null ? (long)mdsch.getInt(p) : 16L);
    }

    public void encodeSpecialEvent(int index, BCompositeSchedule csch, BStatusValue defaultValue, AsnOutput out, int asnType, BBacnetObjectIdentifier deviceId) {
        if (index <= 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        SlotCursor c = csch.getProperties();
        while (index-- > 0) {
            if (c.next(BDailySchedule.class)) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.encodeSpecialEvent((BDailySchedule)c.get(), defaultValue, out, asnType, deviceId);
    }

    public void encodeWeekAndDay(BWeekAndDaySchedule wndsch, int contextTag, AsnOutput out) {
        byte[] octetString = new byte[3];
        int m = wndsch.getMonth();
        int w = wndsch.getWeek();
        int d = wndsch.getWeekday();
        octetString[0] = m == -1 ? -1 : (byte)(m + 1);
        octetString[1] = (byte)w;
        switch (d) {
            case -1: {
                octetString[2] = -1;
                break;
            }
            case 0: {
                octetString[2] = 7;
                break;
            }
            default: {
                octetString[2] = (byte)d;
            }
        }
        out.writeOctetString(contextTag, octetString);
    }

    protected TimeValue[] makeDay(BDaySchedule dsch, Object defaultValue) {
        TimeValue v;
        BTimeSchedule t;
        if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("makeDay(1.0): daySch=");
            BBacnetScheduleDeviceExt.dump(dsch);
        }
        TreeSet<Object> set = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((TimeValue)o1).compareTo(o2);
            }
        });
        TimeValue lastFinish = null;
        BTimeSchedule[] times = dsch.getTimesInOrder();
        if (times.length > 0) {
            t = times[0];
            v = new TimeValue(t.getStart(), this.bajaToJava(t.getEffectiveValue()));
            set.add(v);
            if (v.millis() > 0) {
                v = new TimeValue(BTime.make((int)0, (int)0, (int)0, (int)0), defaultValue);
                set.add(v);
            }
            lastFinish = new TimeValue(t.getFinish(), defaultValue);
        } else {
            set.add(new TimeValue(BTime.make((int)0, (int)0, (int)0, (int)0), defaultValue));
        }
        for (int i = 1; i < times.length; ++i) {
            t = times[i];
            v = new TimeValue(t.getStart(), this.bajaToJava(t.getEffectiveValue()));
            set.add(v);
            if (lastFinish.millis() != v.millis()) {
                set.add(lastFinish);
            }
            lastFinish = new TimeValue(t.getFinish(), defaultValue);
        }
        if (lastFinish != null && lastFinish.millis() > 0) {
            set.add(lastFinish);
        }
        TimeValue[] ret = new TimeValue[set.size()];
        Iterator<Object> it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = (TimeValue)it.next();
        }
        if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("TimeValue[] return array:");
            for (int j = 0; j < ret.length; ++j) {
                ScheduleSupport0.log().trace("ret[" + j + "]:" + ret[j]);
            }
        }
        return ret;
    }

    protected BDaySchedule makeDay(TimeValue[] tvs, Object defaultValue) throws DuplicateEntryException {
        if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("makeDay(1.0): tvs=");
            for (int i = 0; i < tvs.length; ++i) {
                ScheduleSupport0.log().trace("tvs[" + i + "]:" + tvs[i]);
            }
        }
        BDaySchedule ret = new BDaySchedule();
        for (int i = 0; i < tvs.length; ++i) {
            BTimeSchedule tsch = new BTimeSchedule();
            tsch.setStart(this.makeTime(tvs[i], true));
            if (i + 1 >= tvs.length) {
                tsch.setFinish(BTime.make((int)0, (int)0, (int)0, (int)0));
            } else {
                tsch.setFinish(this.makeTime(tvs[i + 1], true));
            }
            tsch.setEffectiveValue(this.javaToBaja(tvs[i].value, defaultValue));
            ret.add(tsch);
        }
        if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("ret daySch=");
            BBacnetScheduleDeviceExt.dump(ret);
        }
        return ret;
    }

    public void setDeviceExt(BBacnetScheduleDeviceExt ext) {
        this.devext = ext;
    }

    public ScheduleType getScheduleType(int contextTag, AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (!in.isOpeningTag(contextTag)) {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipTag();
        tag = in.peekTag();
        while (!in.isClosingTag(contextTag)) {
            if (tag == -1) {
                throw new AsnException("Invalid tag: " + tag);
            }
            in.readTime();
            tag = in.peekApplicationTag();
            switch (tag) {
                case 0: {
                    break;
                }
                case 1: {
                    return new ScheduleType(BBooleanSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 2: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 3: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 4: {
                    return new ScheduleType(BNumericSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 5: {
                    return new ScheduleType(BNumericSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 6: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 7: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 8: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 9: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 10: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 11: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
                case 12: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(tag));
                }
            }
            tag = in.peekTag();
        }
        tag = in.peekTag();
        return null;
    }

    protected final BTime makeTime(TimeValue t, boolean zero) {
        return BTime.make((int)(t.hour < 0 || t.hour > 23 ? (zero ? 0 : 23) : t.hour), (int)(t.minute < 0 || t.minute > 59 ? (zero ? 0 : 59) : t.minute), (int)(t.second < 0 || t.second > 59 ? (zero ? 0 : 59) : t.second), (int)(t.millis < 0 || t.millis > 999 ? (zero ? 0 : 999) : t.millis));
    }

    protected Object bajaToJava(BStatusValue s) {
        if (s == null || s.getStatus().isNull()) {
            return null;
        }
        if (s instanceof BStatusBoolean) {
            return ((BStatusBoolean)s).getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (s instanceof BStatusNumeric) {
            return ((BStatusNumeric)s).getValue();
        }
        if (s instanceof BStatusEnum) {
            return ((BStatusEnum)s).getValue().getOrdinal();
        }
        if (s instanceof BStatusString) {
            return ((BStatusString)s).getValue();
        }
        throw new IllegalArgumentException("Invalid BStatusValue: " + s.getClass());
    }

    protected Object bajaToJavaNullOk(BStatusValue sv) {
        if (sv == null) {
            return null;
        }
        if (sv instanceof BStatusBoolean) {
            return ((BStatusBoolean)sv).getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (sv instanceof BStatusNumeric) {
            return ((BStatusNumeric)sv).getValue();
        }
        if (sv instanceof BStatusEnum) {
            return ((BStatusEnum)sv).getValue().getOrdinal();
        }
        if (sv instanceof BStatusString) {
            return ((BStatusString)sv).getValue();
        }
        throw new IllegalArgumentException("Invalid BStatusValue:" + sv + " {" + sv.getType() + "}");
    }

    protected BStatusValue javaToBaja(Object src, Object def) {
        BStatusBoolean ret = null;
        Object o = src;
        if (o == null) {
            o = def;
        }
        if (o instanceof Boolean) {
            ret = new BStatusBoolean(((Boolean)o).booleanValue());
        } else if (o instanceof Double) {
            ret = new BStatusNumeric(((Double)o).doubleValue());
        } else if (o instanceof Integer) {
            ret = new BStatusEnum((BEnum)BDynamicEnum.make((int)((Integer)o)));
        } else if (o instanceof String) {
            ret = new BStatusString((String)o);
        } else {
            throw new IllegalStateException("Unexpected output type: " + o.getClass());
        }
        if (src == null) {
            ret.setStatusNull(true);
        }
        return ret;
    }

    protected BStatusValue javaToBaja(Object src, BStatusValue def) {
        BStatusBoolean ret = null;
        Object o = src;
        if (o == null) {
            return def;
        }
        if (o instanceof Boolean) {
            ret = new BStatusBoolean(((Boolean)o).booleanValue());
        } else if (o instanceof Double) {
            ret = new BStatusNumeric(((Double)o).doubleValue());
        } else if (o instanceof Integer) {
            ret = new BStatusEnum((BEnum)BDynamicEnum.make((int)((Integer)o)));
        } else if (o instanceof String) {
            ret = new BStatusString((String)o);
        } else {
            throw new IllegalStateException("Unexpected output type: " + o.getClass());
        }
        if (src == null) {
            ret.setStatusNull(true);
        }
        return ret;
    }

    private static int bajaScheduleDayToBacnetDayOfMonth(int bajaDay) {
        if (bajaDay >= 1 && bajaDay <= 31) {
            return bajaDay;
        }
        switch (bajaDay) {
            case -1: {
                return -1;
            }
            case 32: {
                return 32;
            }
            case 33: {
                throw new IllegalArgumentException("Baja special value 'last 7 days' cannot be converted to a BACnet day-of-month value.");
            }
            case 34: {
                return 33;
            }
            case 35: {
                return 34;
            }
        }
        throw new IllegalArgumentException("Invalid baja day-of-month value: " + bajaDay);
    }

    private static int bacnetDayOfMonthToBajaScheduleDay(int bacnetDay) {
        if (bacnetDay >= 1 && bacnetDay <= 31) {
            return bacnetDay;
        }
        switch (bacnetDay) {
            case -1: {
                return -1;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 34;
            }
            case 34: {
                return 35;
            }
        }
        throw new IllegalArgumentException("Invalid BACnet day value: " + bacnetDay);
    }

    public static List<BDailySchedule> sortSpecialEvents(BCompositeSchedule csch) {
        ArrayList<BDailySchedule> specialEvents = new ArrayList<BDailySchedule>();
        SlotCursor c = csch.getProperties();
        while (c.next(BDailySchedule.class)) {
            BDailySchedule mdsch = (BDailySchedule)c.get();
            specialEvents.add((BDailySchedule)mdsch.newCopy());
        }
        if (specialEvents.size() > 0) {
            Collections.sort(specialEvents, scheduleOrder);
        }
        return specialEvents;
    }

    private BStatusValue decodeScheduleDefaultBoolean(BStatusBoolean defaultValue, AsnInput in) throws AsnException {
        int tag = in.peekApplicationTag();
        switch (tag) {
            case 0: {
                return defaultValue;
            }
            case 1: {
                return new BStatusBoolean(in.readBoolean());
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + tag);
    }

    private BStatusValue decodeScheduleDefaultNumeric(BStatusNumeric defaultValue, AsnInput in) throws AsnException {
        int tag = in.peekApplicationTag();
        switch (tag) {
            case 0: {
                return defaultValue;
            }
            case 4: {
                return new BStatusNumeric((double)in.readReal());
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + tag);
    }

    private BStatusValue decodeScheduleDefaultEnum(BStatusEnum defaultValue, AsnInput in, int asnType) throws AsnException {
        BEnumRange r = defaultValue.getValue().getRange();
        int tag = in.peekApplicationTag();
        switch (tag) {
            case 0: {
                return defaultValue;
            }
            case 2: {
                if (asnType < 0 || asnType == tag) {
                    return new BStatusEnum(r.get(in.readUnsignedInt()));
                }
                throw new AsnException("Invalid tag: " + tag);
            }
            case 3: {
                if (asnType < 0 || asnType == tag) {
                    return new BStatusEnum(r.get(in.readSignedInteger()));
                }
                throw new AsnException("Invalid tag: " + tag);
            }
            case 9: {
                if (asnType < 0 || asnType == tag) {
                    return new BStatusEnum(r.get(in.readEnumerated()));
                }
                throw new AsnException("Invalid tag: " + tag);
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + tag);
    }

    private BStatusValue decodeScheduleDefaultString(BStatusString defaultValue, AsnInput in) throws AsnException {
        int tag = in.peekApplicationTag();
        switch (tag) {
            case 0: {
                return defaultValue;
            }
            case 7: {
                return new BStatusString(in.readCharacterString());
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + tag);
    }

    private TimeValue decodeTimeValue(AsnInput in, BStatusValue defaultValue, int asnType) throws AsnException {
        Type t = defaultValue.getType();
        if (t.is(BStatusBoolean.TYPE)) {
            return this.decodeTimeValueBoolean(in, (BStatusBoolean)defaultValue, asnType);
        }
        if (t.is(BStatusNumeric.TYPE)) {
            return this.decodeTimeValueNumeric(in, (BStatusNumeric)defaultValue);
        }
        if (t.is(BStatusEnum.TYPE)) {
            return this.decodeTimeValueEnum(in, (BStatusEnum)defaultValue, asnType);
        }
        if (t.is(BStatusString.TYPE)) {
            return this.decodeTimeValueString(in, (BStatusString)defaultValue);
        }
        throw new IllegalArgumentException(defaultValue.getClass().toString());
    }

    private void checkForUnspecified(BBacnetTime t) throws AsnException {
        if ((t.isHourUnspecified() || t.isMinuteUnspecified() || t.isSecondUnspecified() || t.isHundredthUnspecified()) && !ScheduleSupport0.allValuesInTimeAreUnspecified(t)) {
            throw new OutOfRangeException("Time contains Special Values.");
        }
    }

    private TimeValue decodeTimeValueBoolean(AsnInput in, BStatusBoolean defaultValue, int expAsnType) throws AsnException {
        BBacnetTime t = in.readTime();
        int tag = in.peekApplicationTag();
        boolean b = false;
        this.checkForUnspecified(t);
        switch (tag) {
            case 0: {
                in.readNull();
                return new TimeValue(t, null);
            }
            case 1: {
                if (expAsnType == -1 || expAsnType == 1) {
                    b = in.readBoolean();
                    break;
                }
                throw new DataTypeNotSupportedException("Invalid tag: " + tag);
            }
            case 9: {
                if (expAsnType == -1 || expAsnType == 9) {
                    int value = in.readEnumerated();
                    boolean bl = b = value != 0;
                    if (value <= 1) break;
                    throw new OutOfRangeException("Invalid BacnetBinaryPv value" + value);
                }
                throw new DataTypeNotSupportedException("Invalid tag: " + tag);
            }
            default: {
                throw new AsnDataTypeNotSupportedException(tag, "Invalid tag: " + tag);
            }
        }
        return new TimeValue(t, (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    private TimeValue decodeTimeValueNumeric(AsnInput in, BStatusNumeric defaultValue) throws AsnException {
        BBacnetTime t = in.readTime();
        this.checkForUnspecified(t);
        int tag = in.peekApplicationTag();
        double d = 0.0;
        switch (tag) {
            case 0: {
                in.readNull();
                return new TimeValue(t, null);
            }
            case 4: {
                d = in.readReal();
                break;
            }
            default: {
                throw new AsnDataTypeNotSupportedException(tag, "Invalid tag: " + tag);
            }
        }
        return new TimeValue(t, (Object)d);
    }

    private TimeValue decodeTimeValueEnum(AsnInput in, BStatusEnum defaultValue, int asnType) throws AsnException {
        BBacnetTime t = in.readTime();
        this.checkForUnspecified(t);
        int tag = in.peekApplicationTag();
        int i = 0;
        switch (tag) {
            case 0: {
                in.readNull();
                return new TimeValue(t, null);
            }
            case 2: {
                if (asnType == -1 || asnType == tag) {
                    i = in.readUnsignedInt();
                    break;
                }
                throw new AsnException("Invalid tag: " + tag);
            }
            case 3: {
                if (asnType == -1 || asnType == tag) {
                    i = in.readSignedInteger();
                    break;
                }
                throw new AsnException("Invalid tag: " + tag);
            }
            case 9: {
                if (asnType == -1 || asnType == tag) {
                    i = in.readEnumerated();
                    break;
                }
                throw new AsnException("Invalid tag: " + tag);
            }
            default: {
                throw new AsnDataTypeNotSupportedException(tag, "Invalid tag: " + tag);
            }
        }
        return new TimeValue(t, (Object)i);
    }

    private TimeValue decodeTimeValueString(AsnInput in, BStatusString defaultValue) throws AsnException {
        String s;
        BBacnetTime t = in.readTime();
        this.checkForUnspecified(t);
        int tag = in.peekApplicationTag();
        switch (tag) {
            case 0: {
                in.readNull();
                return new TimeValue(t, null);
            }
            case 7: {
                s = in.readCharacterString();
                break;
            }
            default: {
                throw new AsnDataTypeNotSupportedException(tag, "Invalid tag: " + tag);
            }
        }
        return new TimeValue(t, (Object)s);
    }

    private TimeValue[] decodeTimeValues(int contextTag, AsnInput in, BStatusValue defaultValue, int asnType) throws AsnException {
        int tag = in.peekTag();
        if (!in.isOpeningTag(contextTag)) {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipTag();
        tag = in.peekTag();
        ArrayList<TimeValue> v = new ArrayList<TimeValue>();
        while (!in.isClosingTag(contextTag)) {
            if (tag == -1) {
                throw new AsnException("Invalid tag: " + tag);
            }
            v.add(this.decodeTimeValue(in, defaultValue, asnType));
            tag = in.peekTag();
        }
        in.skipTag();
        return v.toArray(new TimeValue[0]);
    }

    private void encodeScheduleDefault(BStatusBoolean defaultOutput, AsnOutput out, int asnType) {
        if (defaultOutput == null || defaultOutput.getStatus().isNull()) {
            out.writeNull();
        } else {
            boolean b = defaultOutput.getValue();
            switch (asnType) {
                case 1: {
                    out.writeBoolean(b);
                    break;
                }
                case 2: {
                    out.writeUnsignedInteger(b ? 1L : 0L);
                    break;
                }
                case 3: {
                    out.writeSignedInteger(b ? 1 : 0);
                    break;
                }
                case 4: {
                    out.writeReal(b ? 1.0 : 0.0);
                    break;
                }
                case 5: {
                    out.writeDouble(b ? 1.0 : 0.0);
                    break;
                }
                case 6: {
                    out.writeOctetString(new byte[]{(byte)(b ? 1 : 0)});
                    break;
                }
                case 7: {
                    out.writeCharacterString(String.valueOf(b));
                    break;
                }
                case 9: {
                    out.writeEnumerated(b ? 1 : 0);
                    break;
                }
                default: {
                    out.writeNull();
                }
            }
        }
    }

    private void encodeScheduleDefault(BStatusNumeric defaultOutput, AsnOutput out, int asnType) {
        if (defaultOutput == null || defaultOutput.getStatus().isNull()) {
            out.writeNull();
        } else {
            double d = defaultOutput.getValue();
            switch (asnType) {
                case 1: {
                    out.writeBoolean(BDouble.equals((double)d, (double)0.0));
                    break;
                }
                case 2: {
                    out.writeUnsignedInteger((int)d & Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    out.writeSignedInteger((int)d);
                    break;
                }
                case 4: {
                    out.writeReal((float)d);
                    break;
                }
                case 5: {
                    out.writeDouble(d);
                    break;
                }
                case 6: {
                    out.writeOctetString(new byte[]{(byte)d});
                    break;
                }
                case 7: {
                    out.writeCharacterString(String.valueOf(d));
                    break;
                }
                case 9: {
                    out.writeEnumerated((int)d);
                    break;
                }
                default: {
                    out.writeNull();
                }
            }
        }
    }

    private void encodeScheduleDefault(BStatusEnum defaultOutput, AsnOutput out, int asnType) {
        if (defaultOutput == null || defaultOutput.getStatus().isNull()) {
            out.writeNull();
        } else {
            int i = defaultOutput.getValue().getOrdinal();
            BEnumRange r = defaultOutput.getValue().getRange();
            switch (asnType) {
                case 1: {
                    out.writeBoolean(i != 0);
                    break;
                }
                case 2: {
                    out.writeUnsignedInteger(i & Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    out.writeSignedInteger(i);
                    break;
                }
                case 4: {
                    out.writeReal(i);
                    break;
                }
                case 5: {
                    out.writeDouble(i);
                    break;
                }
                case 6: {
                    out.writeOctetString(new byte[]{(byte)i});
                    break;
                }
                case 7: {
                    out.writeCharacterString(r.getTag(i));
                    break;
                }
                case 9: {
                    out.writeEnumerated(i);
                    break;
                }
                default: {
                    out.writeNull();
                }
            }
        }
    }

    private void encodeScheduleDefault(BStatusString defaultOutput, AsnOutput out, int asnType) {
        if (defaultOutput == null || defaultOutput.getStatus().isNull()) {
            out.writeNull();
        } else {
            String s = defaultOutput.getValue();
            switch (asnType) {
                case 1: {
                    out.writeBoolean(s.equalsIgnoreCase("true"));
                    break;
                }
                case 2: {
                    out.writeUnsignedInteger(Long.parseLong(s) & Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    out.writeSignedInteger(Integer.parseInt(s));
                    break;
                }
                case 4: {
                    out.writeReal(Float.parseFloat(s));
                    break;
                }
                case 5: {
                    out.writeDouble(Double.parseDouble(s));
                    break;
                }
                case 6: {
                    out.writeOctetString(new byte[]{Byte.parseByte(s)});
                    break;
                }
                case 7: {
                    out.writeCharacterString(s);
                    break;
                }
                case 9: {
                    out.writeEnumerated(Integer.parseInt(s));
                    break;
                }
                default: {
                    out.writeNull();
                }
            }
        }
    }

    private void encodeTimeValue(TimeValue tv, AsnOutput out, int asnType) {
        out.writeTime(tv.hour, tv.minute, tv.second, tv.hund());
        if (tv.value == null) {
            out.writeNull();
        } else if (tv.value instanceof Boolean) {
            this.encodeValue((Boolean)tv.value, out, asnType);
        } else if (tv.value instanceof Double) {
            this.encodeValue((Double)tv.value, out, asnType);
        } else if (tv.value instanceof Integer) {
            this.encodeValue((Integer)tv.value, out, asnType);
        } else if (tv.value instanceof String) {
            this.encodeValue((String)tv.value, out, asnType);
        } else if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("tv value=" + tv.value + (tv.value != null ? " " + tv.value.getClass() : ""));
        }
    }

    private void encodeTimeValues(TimeValue[] tvs, int contextTag, AsnOutput out, int asnType) {
        if (tvs == null) {
            return;
        }
        out.writeOpeningTag(contextTag);
        for (int i = 0; i < tvs.length; ++i) {
            this.encodeTimeValue(tvs[i], out, asnType);
        }
        out.writeClosingTag(contextTag);
    }

    private void encodeValue(Boolean b, AsnOutput out, int asnType) {
        switch (asnType) {
            case 1: {
                out.writeBoolean(b);
                break;
            }
            case 2: {
                out.writeUnsignedInteger(b != false ? 1L : 0L);
                break;
            }
            case 3: {
                out.writeSignedInteger(b != false ? 1 : 0);
                break;
            }
            case 4: {
                out.writeReal(b != false ? 1.0 : 0.0);
                break;
            }
            case 5: {
                out.writeDouble(b != false ? 1.0 : 0.0);
                break;
            }
            case 6: {
                out.writeOctetString(new byte[]{(byte)(b != false ? 1 : 0)});
                break;
            }
            case 7: {
                out.writeCharacterString(b.toString());
                break;
            }
            case 9: {
                out.writeEnumerated(b != false ? 1 : 0);
                break;
            }
            default: {
                out.writeBoolean(b);
            }
        }
    }

    private void encodeValue(Double d, AsnOutput out, int asnType) {
        switch (asnType) {
            case 1: {
                out.writeBoolean(!BDouble.equals((double)d, (double)0.0));
                break;
            }
            case 2: {
                out.writeUnsignedInteger((int)d.doubleValue());
                break;
            }
            case 3: {
                out.writeSignedInteger((int)d.doubleValue());
                break;
            }
            case 4: {
                out.writeReal((float)d.doubleValue());
                break;
            }
            case 5: {
                out.writeDouble(d);
                break;
            }
            case 6: {
                out.writeOctetString(new byte[]{(byte)d.doubleValue()});
                break;
            }
            case 7: {
                out.writeCharacterString(d.toString());
                break;
            }
            case 9: {
                out.writeEnumerated((int)d.doubleValue());
                break;
            }
            default: {
                out.writeReal((float)d.doubleValue());
            }
        }
    }

    private void encodeValue(Integer i, AsnOutput out, int asnType) {
        switch (asnType) {
            case 1: {
                out.writeBoolean(i != 0);
                break;
            }
            case 2: {
                out.writeUnsignedInteger((long)(i & Integer.MAX_VALUE));
                break;
            }
            case 3: {
                out.writeSignedInteger(i);
                break;
            }
            case 4: {
                out.writeReal(i.intValue());
                break;
            }
            case 5: {
                out.writeDouble(i.intValue());
                break;
            }
            case 6: {
                out.writeOctetString(new byte[]{(byte)i.intValue()});
                break;
            }
            case 7: {
                out.writeCharacterString(i.toString());
                break;
            }
            case 9: {
                out.writeEnumerated(i);
                break;
            }
            default: {
                out.writeUnsignedInteger((long)(i & Integer.MAX_VALUE));
            }
        }
    }

    private void encodeValue(String s, AsnOutput out, int asnType) {
        switch (asnType) {
            case 1: {
                out.writeBoolean(s.equalsIgnoreCase("true"));
                break;
            }
            case 2: {
                out.writeUnsignedInteger(Long.parseLong(s) & Integer.MAX_VALUE);
                break;
            }
            case 3: {
                out.writeSignedInteger(Integer.parseInt(s));
                break;
            }
            case 4: {
                out.writeReal(Float.parseFloat(s));
                break;
            }
            case 5: {
                out.writeDouble(Double.parseDouble(s));
                break;
            }
            case 6: {
                out.writeOctetString(new byte[]{Byte.parseByte(s)});
                break;
            }
            case 7: {
                out.writeCharacterString(s);
                break;
            }
            case 9: {
                out.writeEnumerated(Integer.parseInt(s));
                break;
            }
            default: {
                out.writeCharacterString(s);
            }
        }
    }

    static Log log() {
        return logger;
    }

    static class TimeValue {
        public int hour;
        public int minute;
        public int second;
        public int millis;
        public Object value;

        public TimeValue() {
        }

        public TimeValue(BTime t, Object v) {
            this.hour = t.getHour();
            this.minute = t.getMinute();
            this.second = t.getSecond();
            this.millis = t.getMillisecond();
            this.value = v;
        }

        public TimeValue(BBacnetTime t, Object v) {
            this.hour = t.getHour();
            this.minute = t.getMinute();
            this.second = t.getSecond();
            this.millis = t.getHundredth();
            if (this.millis > 0) {
                this.millis *= 10;
            }
            this.value = v;
        }

        public int compareTo(Object o) {
            int him;
            int me = this.millis();
            if (me < (him = ((TimeValue)o).millis())) {
                return -1;
            }
            if (me > him) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof TimeValue) {
                return this.millis() == ((TimeValue)o).millis();
            }
            return false;
        }

        public int hashCode() {
            return this.hour << 24 | this.minute << 16 | this.second << 8 | this.millis;
        }

        public int millis() {
            int ret = this.second * 1000;
            ret += this.minute * 60000;
            ret += this.hour * 3600000;
            return ret += this.millis;
        }

        public int hund() {
            return this.millis < 0 ? this.millis : this.millis / 10;
        }

        public String toString() {
            return this.hour + ":" + this.minute + ":" + this.second + "." + this.millis + ", " + this.value;
        }
    }

    private static class BacnetScheduleComparator
    implements Comparator<Object> {
        private BacnetScheduleComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 != null && o2 != null && o1 instanceof BDailySchedule && o2 instanceof BDailySchedule) {
                BDailySchedule dailySchedule1 = (BDailySchedule)o1;
                BDailySchedule dailySchedule2 = (BDailySchedule)o2;
                BValue idx1 = dailySchedule1.get(ScheduleSupport0.BACNET_IDX);
                BValue idx2 = dailySchedule2.get(ScheduleSupport0.BACNET_IDX);
                if (idx1 != null && idx2 != null && idx1 instanceof BInteger && idx2 instanceof BInteger) {
                    BInteger int1 = (BInteger)idx1;
                    BInteger int2 = (BInteger)idx2;
                    return int1.getInt() - int2.getInt();
                }
            }
            return 0;
        }
    }
}

