/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.BacnetQuery;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetDiscoverSchedulesJob;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.bacnet.schedule.BBacnetScheduleImportExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.schedule.ScheduleSupport16;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.data.BIDataValue;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleExport;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="skipWriteOnError", type="boolean", defaultValue="false")
@NiagaraAction(name="submitScheduleDiscoveryJob", returnType="BOrd", flags=4)
public class BBacnetScheduleDeviceExt
extends BScheduleDeviceExt
implements BacnetConst,
BIBacnetObjectContainer {
    @Generated
    public static final Property skipWriteOnError = BBacnetScheduleDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action submitScheduleDiscoveryJob = BBacnetScheduleDeviceExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScheduleDeviceExt.class);
    boolean loaded = false;
    private static Comparator<Object> specialEventComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException();
            }
            if (o1 instanceof BDailySchedule && o2 instanceof BDailySchedule) {
                BDailySchedule ds1 = (BDailySchedule)o1;
                BDailySchedule ds2 = (BDailySchedule)o2;
                Property p1 = ds1.getProperty("priority");
                Property p2 = ds2.getProperty("priority");
                if (p1 != null && p2 != null) {
                    return ds1.getInt(p1) - ds2.getInt(p2);
                }
                return 0;
            }
            throw new ClassCastException("Cannot compare " + o1.getClass() + " and " + o2.getClass());
        }
    };
    private static final Context dumpCx = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    public static final String[] skipWritesProps0 = new String[]{BBacnetPropertyIdentifier.weeklySchedule.getTag(), BBacnetPropertyIdentifier.exceptionSchedule.getTag(), BBacnetPropertyIdentifier.effectivePeriod.getTag(), BBacnetPropertyIdentifier.priorityForWriting.getTag()};
    public static final String[] skipWritesProps4 = new String[]{BBacnetPropertyIdentifier.scheduleDefault.getTag(), BBacnetPropertyIdentifier.weeklySchedule.getTag(), BBacnetPropertyIdentifier.exceptionSchedule.getTag(), BBacnetPropertyIdentifier.effectivePeriod.getTag(), BBacnetPropertyIdentifier.priorityForWriting.getTag()};
    public static final BIDataValue[] skipWritesVals0 = new BIDataValue[]{BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE};
    public static final BIDataValue[] skipWritesVals4 = new BIDataValue[]{BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE, BBoolean.FALSE};
    public static final BFacets skipWrites0 = BFacets.make((String[])skipWritesProps0, (BIDataValue[])skipWritesVals0);
    public static final BFacets skipWrites4 = BFacets.make((String[])skipWritesProps4, (BIDataValue[])skipWritesVals4);
    private static final Logger logger = Logger.getLogger("bacnet.schedule");
    private ScheduleSupport0 supp = new ScheduleSupport16(this);

    @Generated
    public boolean getSkipWriteOnError() {
        return this.getBoolean(skipWriteOnError);
    }

    @Generated
    public void setSkipWriteOnError(boolean v) {
        this.setBoolean(skipWriteOnError, v, null);
    }

    @Generated
    public BOrd submitScheduleDiscoveryJob() {
        return (BOrd)this.invoke(submitScheduleDiscoveryJob, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public ScheduleSupport0 getSupport() {
        return this.supp;
    }

    public void setSupport(int protocolRevision) {
        this.supp = ScheduleSupport0.makeForProtocolRevision(protocolRevision, this.supp);
        this.supp.setDeviceExt(this);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Client schedule support for " + this.device() + " is now " + this.supp.getVersion());
        }
    }

    public void doSetSupp(BInteger pr) {
        this.setSupport(pr.getInt());
    }

    public BOrd doSubmitScheduleDiscoveryJob(Context cx) {
        if (this.device().isFatalFault()) {
            return null;
        }
        return new BBacnetDiscoverSchedulesJob(this).submit(cx);
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (this.get(p).getType().is(BBacnetScheduleExport.TYPE)) {
            BBacnetScheduleExport export = (BBacnetScheduleExport)this.get(p);
            if (this.device().getProtocolRevision() >= 4) {
                export.setSkipWrites(skipWrites4);
            } else {
                export.setSkipWrites(skipWrites0);
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetDevice;
    }

    public BScheduleExport makeExport(String supervisorId) {
        return new BBacnetScheduleExport(supervisorId);
    }

    public BScheduleImportExt makeImportExt() {
        return new BBacnetScheduleImportExt();
    }

    final BBacnetDevice device() {
        return (BBacnetDevice)this.getDevice();
    }

    BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    @Deprecated
    public static final BBacnetScheduleImportExt getBacnetExt(BAbstractSchedule sch) {
        return BBacnetScheduleDeviceExt.getBacnetImportExt(sch);
    }

    public static final BBacnetScheduleImportExt getBacnetImportExt(BAbstractSchedule sch) {
        BValue o = sch.get("ext");
        if (o != null && o instanceof BBacnetScheduleImportExt) {
            return (BBacnetScheduleImportExt)o;
        }
        SlotCursor c = sch.getProperties();
        if (c.next(BBacnetScheduleImportExt.class)) {
            return (BBacnetScheduleImportExt)c.get();
        }
        return null;
    }

    public final BBacnetScheduleExport getBacnetExportExt(BAbstractSchedule sch) {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetScheduleExport.class)) {
            BBacnetScheduleExport e = (BBacnetScheduleExport)c.get();
            if (sch != e.getSupervisor()) continue;
            return e;
        }
        return null;
    }

    @Override
    public BObject lookupBacnetObject(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex, String domain) {
        if (objectId == null) {
            return null;
        }
        if (!this.isRunning() && !this.loaded) {
            this.getComponentSpace().update((BComponent)this, Integer.MAX_VALUE);
            this.loaded = true;
        }
        SlotCursor sc = this.getProperties();
        while (sc.nextComponent()) {
            BBacnetScheduleImportExt imp;
            BComponent o = sc.get().asComponent();
            if (o instanceof BBacnetScheduleExport) {
                BBacnetScheduleExport exp = (BBacnetScheduleExport)o;
                if (!objectId.equals((Object)exp.getObjectId())) continue;
                return exp.getSupervisor();
            }
            if (!(o instanceof BAbstractSchedule) || (imp = (BBacnetScheduleImportExt)o.get("ext")) == null || !objectId.equals((Object)imp.getObjectId())) continue;
            return o;
        }
        return null;
    }

    public BBacnetScheduleImportExt lookupImport(BBacnetObjectIdentifier objectId) {
        if (objectId == null) {
            return null;
        }
        SlotCursor sc = this.getProperties();
        while (sc.next(BAbstractSchedule.class)) {
            BAbstractSchedule sch = (BAbstractSchedule)sc.get();
            BBacnetScheduleImportExt imp = (BBacnetScheduleImportExt)sch.get("ext");
            if (imp == null || !objectId.equals((Object)imp.getObjectId())) continue;
            return imp;
        }
        return null;
    }

    public BBacnetScheduleExport lookupExport(BBacnetObjectIdentifier objectId) {
        if (objectId == null) {
            return null;
        }
        SlotCursor sc = this.getProperties();
        while (sc.next(BBacnetScheduleExport.class)) {
            BBacnetScheduleExport exp = (BBacnetScheduleExport)sc.get();
            if (!objectId.equals((Object)exp.getObjectId())) continue;
            return exp;
        }
        return null;
    }

    BAbstractSchedule readRemote(BBacnetScheduleImportExt local) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("readRemote(" + (Object)((Object)local) + ")");
        }
        BAbstractSchedule c = local.getSubordinate();
        Object ret = null;
        ret = c instanceof BCalendarSchedule ? this.readCalendar(local.getObjectId()) : this.readSchedule((BComplex)local, c.getType());
        this.validate((BAbstractSchedule)ret);
        return ret;
    }

    BAbstractSchedule readRemote(BBacnetScheduleExport local) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("readRemote(" + (Object)((Object)local) + ")");
        }
        BAbstractSchedule c = local.getSupervisor();
        Object ret = null;
        ret = c instanceof BCalendarSchedule ? this.readCalendar(local.getObjectId()) : this.readSchedule((BComplex)local, c.getType());
        this.validate((BAbstractSchedule)ret);
        return ret;
    }

    void writeRemote(BBacnetScheduleExport local) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("writeRemote(" + (Object)((Object)local) + ")");
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BAbstractSchedule c = local.getSupervisor();
        if (c instanceof BCalendarSchedule) {
            this.sendCalendar(local, (BCalendarSchedule)c);
        } else {
            BBacnetScheduleDeviceExt.setPrioritiesByOrder(((BWeeklySchedule)c).getSpecialEvents());
            this.sendSchedule(local, (BWeeklySchedule)c);
        }
    }

    private void validate(BAbstractSchedule s) throws BacnetException {
        if (s == null) {
            throw new IllegalArgumentException("Return schedule is null!");
        }
        if (!(s instanceof BCalendarSchedule)) {
            BWeeklySchedule w = (BWeeklySchedule)s;
            this.checkForCalendarReferences(w.getSpecialEvents());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BCalendarSchedule readCalendar(BBacnetObjectIdentifier objectId) throws BacnetException {
        byte[] encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 23);
        AsnInputStream asnIn = AsnInputStream.make(encodedValue);
        try {
            BCalendarSchedule bCalendarSchedule = this.supp.decodeDateList(asnIn);
            return bCalendarSchedule;
        }
        finally {
            asnIn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private BWeeklySchedule readSchedule(BComplex local, Type t) throws BacnetException {
        objectId = (BBacnetObjectIdentifier)local.get("objectId");
        sch = (BWeeklySchedule)t.getInstance();
        encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 85);
        if (encodedValue != null) {
            asnIn = AsnInputStream.make(encodedValue);
            try {
                tag = asnIn.peekApplicationTag();
                switch (tag) {
                    case 0: {
                        ** break;
lbl11:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        if (t.is(BBooleanSchedule.TYPE)) ** break;
                        BBacnetScheduleDeviceExt.logger.warning(MessageFormat.format(BBacnetScheduleDeviceExt.lex.getText("wrongClientScheduleType"), new Object[]{t, "BOOLEAN"}));
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        if (t.is(BNumericSchedule.TYPE)) ** break;
                        BBacnetScheduleDeviceExt.logger.warning(MessageFormat.format(BBacnetScheduleDeviceExt.lex.getText("wrongClientScheduleType"), new Object[]{t, "REAL"}));
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    case 9: {
                        if (t.is(BEnumSchedule.TYPE)) ** break;
                        BBacnetScheduleDeviceExt.logger.warning(MessageFormat.format(BBacnetScheduleDeviceExt.lex.getText("wrongClientScheduleType"), new Object[]{t, "Enumerated"}));
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    ** default:
lbl28:
                    // 1 sources

                    break;
                }
            }
            finally {
                asnIn.release();
            }
        }
        if (this.device().getProtocolRevision() >= 4) {
            encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 111);
            if (encodedValue != null) {
                ((BStatusValue)sch.get("out")).setStatus(AsnUtil.asnStatusFlagsToBStatus(encodedValue));
            }
            if ((encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 174)) != null) {
                asnIn = AsnInputStream.make(encodedValue);
                try {
                    sch.setDefaultOutput(this.supp.decodeScheduleDefault(sch.getDefaultOutput(), asnIn, -1));
                }
                finally {
                    asnIn.release();
                }
            }
        }
        weeklyOk = false;
        excOk = false;
        exceptionSchedule = null;
        if (this.device().getSegmentationSupported().isSegmentedTransmit()) {
            try {
                encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 123);
                if (encodedValue != null) {
                    asnIn = AsnInputStream.make(encodedValue);
                    try {
                        for (i = 1; i <= 7; ++i) {
                            ((BDailySchedule)sch.getWeek().get(BWeekday.make((int)(i % 7)).getTag())).setDay(this.supp.decodeDailySchedule(sch.getDefaultOutput(), asnIn, -1));
                        }
                    }
                    finally {
                        asnIn.release();
                    }
                }
                weeklyOk = true;
            }
            catch (BacnetException e) {
                BBacnetScheduleDeviceExt.logger.info("Unable to retrieve Weekly_Schedule from " + (Object)objectId + " in bulk:" + (Object)e);
            }
            try {
                encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 38);
                if (encodedValue != null) {
                    asnIn = AsnInputStream.make(encodedValue);
                    try {
                        exceptionSchedule = this.supp.decodeExceptionSchedule(sch.getDefaultOutput(), asnIn, this.device().getObjectId(), -1);
                        BBacnetScheduleDeviceExt.sortEventsByPriority(exceptionSchedule);
                        sch.getSchedule().set("specialEvents", (BValue)exceptionSchedule);
                    }
                    finally {
                        asnIn.release();
                    }
                }
                excOk = true;
            }
            catch (BacnetException e) {
                BBacnetScheduleDeviceExt.logger.info("Unable to retrieve Exception_Schedule from " + (Object)objectId + " in bulk:" + (Object)e);
            }
        }
        if (!weeklyOk) {
            try {
                for (i = 1; i <= 7; ++i) {
                    encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 123, i);
                    if (encodedValue == null) continue;
                    asnIn = AsnInputStream.make(encodedValue);
                    try {
                        ((BDailySchedule)sch.getWeek().get(BWeekday.make((int)(i % 7)).getTag())).setDay(this.supp.decodeDailySchedule(sch.getDefaultOutput(), asnIn, -1));
                        continue;
                    }
                    finally {
                        asnIn.release();
                    }
                }
            }
            catch (BacnetException e) {
                BBacnetScheduleDeviceExt.logger.info("Unable to retrieve Weekly_Schedule from " + (Object)objectId + " individually:" + (Object)e);
            }
        }
        if (!excOk) {
            try {
                encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 38, 0);
                len = AsnUtil.fromAsnUnsignedInt(encodedValue);
                events = new BDailySchedule[len];
                exceptionSchedule = new BCompositeSchedule();
                for (i = 0; i < len; ++i) {
                    encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 38, i + 1);
                    if (encodedValue == null) continue;
                    event = null;
                    asnIn = AsnInputStream.make(encodedValue);
                    try {
                        event = this.supp.decodeSpecialEvent(sch.getDefaultOutput(), asnIn, this.device().getObjectId(), -1, i);
                    }
                    finally {
                        asnIn.release();
                    }
                    if (event == null) continue;
                    eventPriority = ((BInteger)event.get("priority")).getInt();
                    inserted = false;
                    for (j = 0; j < i; ++j) {
                        existing = events[j];
                        p = existing.getProperty("priority");
                        existingPriority = 1;
                        if (p != null) {
                            existingPriority = existing.getInt(p);
                        }
                        if (eventPriority >= existingPriority) continue;
                        for (k = i; k > j; --k) {
                            events[k] = events[k - 1];
                        }
                        events[j] = event;
                        inserted = true;
                        break;
                    }
                    if (inserted) continue;
                    events[i] = event;
                }
                for (i = 0; i < len; ++i) {
                    if (events[i] == null) continue;
                    exceptionSchedule.add((BAbstractSchedule)events[i]);
                }
                sch.getSchedule().set("specialEvents", (BValue)exceptionSchedule);
            }
            catch (BacnetException e) {
                BBacnetScheduleDeviceExt.logger.info("Unable to retrieve Exception_Schedule from " + (Object)objectId + " individually:" + (Object)e);
            }
        }
        this.checkForCalendarReferences(exceptionSchedule);
        encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 32);
        if (encodedValue != null) {
            asnIn = AsnInputStream.make(encodedValue);
            try {
                sch.setEffective(this.supp.decodeDateRange(asnIn));
            }
            finally {
                asnIn.release();
            }
        }
        if ((encodedValue = this.client().readProperty(this.device().getAddress(), objectId, 88)) != null) {
            local.set("priorityForWriting", (BValue)BInteger.make((int)AsnUtil.fromAsnUnsignedInt(encodedValue)));
        }
        return sch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCalendar(BBacnetScheduleExport local, BCalendarSchedule cal) throws BacnetException {
        byte[] encodedValue;
        BBacnetObjectIdentifier objectId = local.getObjectId();
        local.writeProperty = BBacnetPropertyIdentifier.dateList;
        AsnOutputStream asnOut = AsnOutputStream.make();
        try {
            this.supp.encodeDateList(cal, asnOut);
            encodedValue = asnOut.toByteArray();
        }
        finally {
            asnOut.release();
        }
        this.client().writeProperty(this.device().getAddress(), objectId, 23, encodedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSchedule(BBacnetScheduleExport local, BWeeklySchedule schedule) throws BacnetException {
        BacnetException err;
        block77: {
            byte[] encodedValue;
            BBacnetObjectIdentifier objectId;
            block75: {
                block68: {
                    err = null;
                    objectId = local.getObjectId();
                    if (this.device().getProtocolRevision() >= 4 && !BBacnetScheduleDeviceExt.isSkipWrite(local, (BEnum)BBacnetPropertyIdentifier.scheduleDefault)) {
                        local.writeProperty = BBacnetPropertyIdentifier.scheduleDefault;
                        AsnOutputStream asnOut = AsnOutputStream.make();
                        try {
                            this.supp.encodeScheduleDefault(schedule.getDefaultOutput(), (AsnOutput)asnOut, local.getAsnType());
                            encodedValue = asnOut.toByteArray();
                        }
                        finally {
                            asnOut.release();
                        }
                        try {
                            this.client().writeProperty(this.device().getAddress(), objectId, 174, encodedValue);
                        }
                        catch (BacnetStackException e) {
                            err = e;
                        }
                        catch (BacnetException e) {
                            err = e;
                            if (!this.getSkipWriteOnError()) break block68;
                            BBacnetScheduleDeviceExt.setSkipWrites(local, (BEnum)BBacnetPropertyIdentifier.scheduleDefault, true);
                        }
                    }
                }
                boolean weeklyOk = false;
                boolean excOk = false;
                if (!BBacnetScheduleDeviceExt.isSkipWrite(local, (BEnum)BBacnetPropertyIdentifier.weeklySchedule)) {
                    local.writeProperty = BBacnetPropertyIdentifier.weeklySchedule;
                    if (!BBacnetScheduleDeviceExt.isSkipWrite(local, "weeklyScheduleEntire")) {
                        try {
                            AsnOutputStream asnOut = AsnOutputStream.make();
                            try {
                                for (int i = 1; i <= 7; ++i) {
                                    this.supp.encodeDailySchedule(schedule.get(BWeekday.make((int)(i % 7))), schedule.getDefaultOutput(), asnOut, local.getAsnType());
                                }
                                encodedValue = asnOut.toByteArray();
                            }
                            finally {
                                asnOut.release();
                            }
                            this.client().writeProperty(this.device().getAddress(), objectId, 123, encodedValue);
                            weeklyOk = true;
                        }
                        catch (BacnetStackException e) {
                            logger.info("Unable to send Weekly_Schedule to " + (Object)((Object)objectId) + " in bulk:" + e);
                        }
                        catch (BacnetException e) {
                            logger.info("Unable to send Weekly_Schedule to " + (Object)((Object)objectId) + " in bulk:" + (Object)((Object)e));
                            BBacnetScheduleDeviceExt.setSkipWrites(local, "weeklyScheduleEntire", true);
                        }
                    }
                    if (!weeklyOk) {
                        for (int i = 1; i <= 7; ++i) {
                            AsnOutputStream asnOut = AsnOutputStream.make();
                            try {
                                this.supp.encodeDailySchedule(schedule.get(BWeekday.make((int)(i % 7))), schedule.getDefaultOutput(), asnOut, local.getAsnType());
                                encodedValue = asnOut.toByteArray();
                            }
                            finally {
                                asnOut.release();
                            }
                            try {
                                this.client().writeProperty(this.device().getAddress(), objectId, 123, i, encodedValue);
                                continue;
                            }
                            catch (BacnetStackException e) {
                                if (err != null) break;
                                err = e;
                                break;
                            }
                            catch (BacnetException e) {
                                if (err == null) {
                                    err = e;
                                }
                                if (!this.getSkipWriteOnError()) break;
                                BBacnetScheduleDeviceExt.setSkipWrites(local, (BEnum)BBacnetPropertyIdentifier.weeklySchedule, true);
                                break;
                            }
                        }
                    }
                }
                if (!BBacnetScheduleDeviceExt.isSkipWrite(local, (BEnum)BBacnetPropertyIdentifier.exceptionSchedule)) {
                    local.writeProperty = BBacnetPropertyIdentifier.exceptionSchedule;
                    if (!BBacnetScheduleDeviceExt.isSkipWrite(local, "exceptionScheduleEntire")) {
                        try {
                            AsnOutputStream asnOut = AsnOutputStream.make();
                            try {
                                this.supp.encodeExceptionSchedule(schedule.getSpecialEvents(), schedule.getDefaultOutput(), asnOut, local.getAsnType(), this.device().getObjectId());
                                encodedValue = asnOut.toByteArray();
                            }
                            finally {
                                asnOut.release();
                            }
                            this.client().writeProperty(this.device().getAddress(), objectId, 38, encodedValue);
                            excOk = true;
                        }
                        catch (BacnetStackException e) {
                            logger.info("Unable to send Exception_Schedule to " + (Object)((Object)objectId) + " in bulk:" + e);
                        }
                        catch (BacnetException e) {
                            logger.info("Unable to send Exception_Schedule to " + (Object)((Object)objectId) + " in bulk:" + (Object)((Object)e));
                            BBacnetScheduleDeviceExt.setSkipWrites(local, "exceptionScheduleEntire", true);
                        }
                    }
                    if (!excOk) {
                        boolean resizeOk;
                        block72: {
                            int excSchedSize = ((BDailySchedule[])schedule.getSpecialEvents().getChildren(BDailySchedule.class)).length;
                            resizeOk = false;
                            try {
                                this.client().writeProperty(this.device().getAddress(), objectId, 38, 0, AsnUtil.toAsnUnsigned(excSchedSize));
                                resizeOk = true;
                            }
                            catch (BacnetStackException e) {
                                if (err == null) {
                                    err = e;
                                }
                            }
                            catch (BacnetException e) {
                                if (err == null) {
                                    err = e;
                                }
                                if (!this.getSkipWriteOnError()) break block72;
                                BBacnetScheduleDeviceExt.setSkipWrites(local, (BEnum)BBacnetPropertyIdentifier.exceptionSchedule, true);
                            }
                        }
                        if (resizeOk) {
                            SlotCursor c = schedule.getSpecialEvents().getProperties();
                            int index = 0;
                            while (c.next(BDailySchedule.class)) {
                                AsnOutputStream asnOut = AsnOutputStream.make();
                                try {
                                    this.supp.encodeSpecialEvent((BDailySchedule)c.get(), schedule.getDefaultOutput(), asnOut, local.getAsnType(), this.device().getObjectId());
                                    encodedValue = asnOut.toByteArray();
                                }
                                finally {
                                    asnOut.release();
                                }
                                try {
                                    this.client().writeProperty(this.device().getAddress(), objectId, 38, ++index, encodedValue);
                                }
                                catch (BacnetStackException e) {
                                    if (err != null) break;
                                    err = e;
                                    break;
                                }
                                catch (BacnetException e) {
                                    if (err == null) {
                                        err = e;
                                    }
                                    if (!this.getSkipWriteOnError()) break;
                                    BBacnetScheduleDeviceExt.setSkipWrites(local, (BEnum)BBacnetPropertyIdentifier.exceptionSchedule, true);
                                    break;
                                }
                            }
                        }
                    }
                }
                if (!BBacnetScheduleDeviceExt.isSkipWrite(local, (BEnum)BBacnetPropertyIdentifier.effectivePeriod)) {
                    local.writeProperty = BBacnetPropertyIdentifier.effectivePeriod;
                    AsnOutputStream asnOut = AsnOutputStream.make();
                    try {
                        this.supp.encodeDateRange(schedule.getEffective(), asnOut);
                        encodedValue = asnOut.toByteArray();
                    }
                    finally {
                        asnOut.release();
                    }
                    try {
                        this.client().writeProperty(this.device().getAddress(), objectId, 32, encodedValue);
                    }
                    catch (BacnetStackException e) {
                        if (err == null) {
                            err = e;
                        }
                    }
                    catch (BacnetException e) {
                        if (err == null) {
                            err = e;
                        }
                        if (!this.getSkipWriteOnError()) break block75;
                        BBacnetScheduleDeviceExt.setSkipWrites(local, (BEnum)BBacnetPropertyIdentifier.effectivePeriod, true);
                    }
                }
            }
            if (!BBacnetScheduleDeviceExt.isSkipWrite(local, (BEnum)BBacnetPropertyIdentifier.priorityForWriting)) {
                local.writeProperty = BBacnetPropertyIdentifier.priorityForWriting;
                AsnOutputStream asnOut = AsnOutputStream.make();
                try {
                    asnOut.writeUnsignedInteger(local.getPriorityForWriting());
                    encodedValue = asnOut.toByteArray();
                }
                finally {
                    asnOut.release();
                }
                try {
                    this.client().writeProperty(this.device().getAddress(), objectId, 88, encodedValue);
                }
                catch (BacnetStackException e) {
                    if (err == null) {
                        err = e;
                    }
                }
                catch (BacnetException e) {
                    if (err == null) {
                        err = e;
                    }
                    if (!this.getSkipWriteOnError()) break block77;
                    BBacnetScheduleDeviceExt.setSkipWrites(local, (BEnum)BBacnetPropertyIdentifier.priorityForWriting, true);
                }
            }
        }
        local.writeProperty = null;
        if (err != null) {
            throw err;
        }
    }

    private void checkForCalendarReferences(BCompositeSchedule excSch) throws BacnetException {
        if (excSch == null) {
            return;
        }
        BDailySchedule[] events = (BDailySchedule[])excSch.getChildren(BDailySchedule.class);
        for (int i = 0; i < events.length; ++i) {
            BAbstractSchedule days = events[i].getDays();
            if (!(days instanceof BScheduleReference)) continue;
            BOrd ref = ((BScheduleReference)days).getRef();
            OrdQuery[] oqs = ref.parse();
            int len = oqs.length;
            OrdQuery oq = oqs[len - 1];
            BBacnetObjectIdentifier objectId = null;
            if (!(oq instanceof BacnetQuery)) continue;
            BacnetQuery query = (BacnetQuery)oq;
            try {
                objectId = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(query.getObject());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BBacnetScheduleImportExt imp = this.lookupImport(objectId);
            BBacnetScheduleExport exp = this.lookupExport(objectId);
            if (objectId == null || imp != null || exp != null) continue;
            this.addCalendarImport(objectId);
        }
    }

    private void addCalendarImport(BBacnetObjectIdentifier objectId) throws BacnetException {
        String calName = AsnUtil.fromAsnCharacterString(this.client().readProperty(this.device().getAddress(), objectId, 77));
        BCalendarSchedule cal = new BCalendarSchedule();
        BBacnetScheduleImportExt ext = new BBacnetScheduleImportExt();
        ext.setObjectId(objectId);
        cal.add("ext", (BValue)ext);
        this.add(SlotPath.escape((String)calName), (BValue)cal);
    }

    private static boolean isSkipWrite(BBacnetScheduleExport export, BEnum prop) {
        BObject dv = export.getSkipWrites().getFacet(prop.getTag());
        if (dv == null || dv.getType() != BBoolean.TYPE) {
            return false;
        }
        return ((BBoolean)dv).getBoolean();
    }

    public static void setPrioritiesByOrder(BCompositeSchedule exc) {
        BDailySchedule[] events = (BDailySchedule[])exc.getChildren(BDailySchedule.class);
        int len = events.length;
        int pri = 1;
        for (int i = 0; i < len; ++i) {
            BacUtil.setOrAdd((BComponent)events[i], "priority", (BValue)BInteger.make((int)pri), null);
            if (pri >= 16) continue;
            ++pri;
        }
    }

    public static void sortEventsByPriority(BCompositeSchedule exc) {
        int i;
        BDailySchedule[] events = (BDailySchedule[])exc.getChildren(BDailySchedule.class);
        Arrays.sort(events, specialEventComparator);
        String[] names = new String[events.length];
        for (i = 0; i < names.length; ++i) {
            names[i] = events[i].getName();
        }
        for (i = 0; i < events.length; ++i) {
            exc.remove((BComplex)events[i]);
            exc.add(names[i], (BValue)events[i]);
        }
    }

    private static boolean isSkipWrite(BBacnetScheduleExport export, String facetName) {
        BObject dv = export.getSkipWrites().getFacet(facetName);
        if (dv == null || dv.getType() != BBoolean.TYPE) {
            return false;
        }
        return ((BBoolean)dv).getBoolean();
    }

    private static void setSkipWrites(BBacnetScheduleExport export, BEnum prop, boolean skip) {
        BFacets f = export.getSkipWrites();
        export.setSkipWrites(BFacets.make((BFacets)f, (String)prop.getTag(), (BIDataValue)BBoolean.make((boolean)skip)));
    }

    private static void setSkipWrites(BBacnetScheduleExport export, String facetName, boolean skip) {
        BFacets f = export.getSkipWrites();
        export.setSkipWrites(BFacets.make((BFacets)f, (String)facetName, (BIDataValue)BBoolean.make((boolean)skip)));
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetScheduleDeviceExt", 2);
        out.prop((Object)"support", (Object)this.supp.getVersion());
        out.endProps();
    }

    private static void d(String s) {
        System.out.println(s);
    }

    private static void dd(String s) {
        System.out.print(s);
    }

    void dumpSchedule(BWeeklySchedule s) {
        BBacnetScheduleDeviceExt.d("NiagaraSchedule dump:");
        BBacnetScheduleDeviceExt.d(" type:" + s.getType());
        SlotCursor sc = s.getProperties();
        while (sc.next()) {
            BBacnetScheduleDeviceExt.dd(sc.property().getName() + "[" + sc.property().getType() + "]:");
            BBacnetScheduleDeviceExt.dump((BObject)sc.get());
        }
    }

    static void dump(BAbstractSchedule s) {
        SlotCursor sc = s.getProperties();
        while (sc.next()) {
            BBacnetScheduleDeviceExt.dd(sc.property().getName() + "[" + sc.property().getType() + "]:");
            BBacnetScheduleDeviceExt.dump((BObject)sc.get());
        }
    }

    static void dump(BObject o) {
        BBacnetScheduleDeviceExt.d(o.toString());
    }

    static void dump(BDateRangeSchedule s) {
        BBacnetScheduleDeviceExt.dd("start:");
        BBacnetScheduleDeviceExt.dump(s.getStart());
        BBacnetScheduleDeviceExt.dd("end:");
        BBacnetScheduleDeviceExt.dump(s.getEnd());
    }

    static void dump(BDateSchedule s) {
        BBacnetScheduleDeviceExt.dd("" + s.getYear() + "-" + s.getMonth() + "-" + s.getDay() + " " + s.getWeekday());
    }

    static void dump(BDailySchedule s) {
        BBacnetScheduleDeviceExt.d("DailySchedule dump:");
        BBacnetScheduleDeviceExt.dd("day:");
        BBacnetScheduleDeviceExt.dump(s.getDay());
        BBacnetScheduleDeviceExt.dd("days:");
        BBacnetScheduleDeviceExt.dump(s.getDays());
        Property pri = s.getProperty("priority");
        if (pri != null) {
            BBacnetScheduleDeviceExt.d("priority:" + s.getInt(pri));
        }
    }

    static void dump(BDaySchedule s) {
        BBacnetScheduleDeviceExt.d("DaySchedule dump:");
        SlotCursor c = s.getProperties();
        int i = 0;
        while (c.next(BTimeSchedule.class)) {
            BTimeSchedule ts = (BTimeSchedule)c.get();
            BBacnetScheduleDeviceExt.dd("timeSched " + i++ + ":");
            BBacnetScheduleDeviceExt.dump(ts);
        }
    }

    static void dump(BTimeSchedule s) {
        BBacnetScheduleDeviceExt.d(s.getStart().toString(dumpCx) + " - " + s.getFinish().toString(dumpCx) + " = " + s.getEffectiveValue());
    }
}

