/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BDeviceDiscoveryConfig;
import com.tridium.bacnet.datatypes.BDiscoveryNetworks;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetDiscoverDevicesJob
extends BDeviceManagerJob
implements IAmListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDiscoverDevicesJob.class);
    private BDeviceDiscoveryConfig params;
    private ArrayList<IAmDevice> iAmDevices = new ArrayList();
    private int count;
    private static final Log logger = Log.getLog((String)"bacnet.client");
    private static final int DUPLICATE_MAC = -2;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetDiscoverDevicesJob() {
    }

    public BBacnetDiscoverDevicesJob(BBacnetNetwork bacnet, BDeviceDiscoveryConfig params) {
        super(bacnet);
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        this.log().start(lex.getText("deviceManager.begin"));
        String s = null;
        this.server().registerIAmListener(this);
        BDiscoveryNetworks networks = this.params.getNetworks();
        if (networks.isAllNetworks()) {
            BBacnetAddress addr = BBacnetAddress.GLOBAL_BROADCAST_ADDRESS;
            s = lex.getText("deviceManager.params.global");
            try {
                if (this.params.isDefaultRange()) {
                    this.log().message(s + lex.getText("deviceManager.params.all"));
                    this.client().whoIs(addr);
                }
                s = s + MessageFormat.format(lex.getText("deviceManager.params.range"), this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                this.log().message(s);
                this.client().whoIs(addr, this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
            }
            catch (Exception e) {
                this.log().failed(lex.getText("deviceManager.failed") + "\n  " + e);
                logger.error("Exception sending " + s + ": " + e, (Throwable)e);
                return;
            }
        } else {
            s = lex.getText("deviceManager.params.local");
            try {
                int[] nets = networks.getNetworks();
                for (int i = 0; i < nets.length; ++i) {
                    BBacnetAddress addr = new BBacnetAddress(nets[i], (BBacnetOctetString)null);
                    if (this.params.isDefaultRange()) {
                        this.log().message(s + lex.getText("deviceManager.params.all"));
                        this.client().whoIs(addr);
                        continue;
                    }
                    String rangeMessage = s + MessageFormat.format(lex.getText("deviceManager.params.range"), this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                    this.log().message(rangeMessage);
                    this.client().whoIs(addr, this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                }
            }
            catch (Exception e) {
                this.log().failed(lex.getText("deviceManager.failed") + "\n  " + e);
                logger.error("Exception sending " + s + ": " + e, (Throwable)e);
                return;
            }
        }
        BAbsTime start = BAbsTime.make();
        long startMillis = start.getMillis();
        BRelTime wait = BRelTime.makeSeconds((int)this.params.getWaitResponseTime());
        BAbsTime end = start.add(wait);
        double waitMillis = end.getMillis() - startMillis;
        BAbsTime now = BAbsTime.make();
        this.count = 0;
        int iAmSize = 0;
        IAmDevice iAmDev = null;
        ArrayList<BBacnetObjectIdentifier> dups = new ArrayList<BBacnetObjectIdentifier>();
        ArrayList<IAmDevice> arrayList = this.iAmDevices;
        synchronized (arrayList) {
            iAmSize = this.iAmDevices.size();
        }
        while ((now.isBefore(end) || this.count < iAmSize) && this.isAlive()) {
            int oldProgress;
            if (this.count == iAmSize) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                arrayList = this.iAmDevices;
                synchronized (arrayList) {
                    iAmDev = this.iAmDevices.get(this.count);
                }
                int deviceId = iAmDev.iAm.getObjectId().getInstanceNumber();
                if (this.params.isDefaultRange() || deviceId >= this.params.getDeviceLowLimit() && deviceId <= this.params.getDeviceHighLimit()) {
                    this.log().message("Reading parameters for " + (Object)((Object)iAmDev.iAm.getObjectId()) + ", " + (this.count + 1) + " of " + iAmSize);
                    BDiscoveryDevice dd = this.discoverDevice(iAmDev);
                    if (iAmDev.dup) {
                        dd.setDuplicate(true);
                        dups.add(iAmDev.iAm.getObjectId());
                    }
                    this.add(null, (BValue)dd);
                }
                ++this.count;
            }
            now = BAbsTime.make();
            int timeProgress = (int)((double)(now.getMillis() - startMillis) / waitMillis * 100.0);
            int deviceProgress = (int)((double)this.count * 100.0 / (double)iAmSize);
            int progres = oldProgress = this.getProgress();
            if (timeProgress < deviceProgress) {
                if (timeProgress > progres) {
                    progres = timeProgress;
                }
            } else {
                if (deviceProgress > progres) {
                    progres = deviceProgress;
                }
                if (deviceProgress == 0) {
                    progres = timeProgress;
                }
            }
            if (progres > 100) {
                progres = 100;
                this.log().message(lex.getText("deviceManager.finishing"));
            }
            this.progress(progres);
            ArrayList<IAmDevice> arrayList2 = this.iAmDevices;
            synchronized (arrayList2) {
                iAmSize = this.iAmDevices.size();
            }
        }
        for (BBacnetObjectIdentifier id : dups) {
            BDiscoveryDevice[] dupdevs = this.getDuplicateDevices(id);
            if (dupdevs.length <= 1) continue;
            for (int i = 0; i < dupdevs.length; ++i) {
                dupdevs[i].setDuplicate(true);
            }
        }
        this.log().success(lex.getText("deviceManager.end"));
        this.server().unregisterIAmListener(this);
    }

    private BDiscoveryDevice discoverDevice(IAmDevice iAmDev) {
        IAmRequest request = iAmDev.iAm;
        BBacnetAddress sourceAddress = iAmDev.addr;
        BBacnetObjectIdentifier deviceId = request.getObjectId();
        String name = deviceId.toString(BacnetConst.nameContext);
        BCharacterSetEncoding encoding = BCharacterSetEncoding.unknown;
        int listSize = -1;
        BBacnetBitString servicesSupported = BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported"));
        String vendorName = lex.getText("deviceManager.unknown");
        String modelName = lex.getText("deviceManager.unknown");
        int protocolRevision = -1;
        String firmwareRevision = lex.getText("deviceManager.unknown");
        String applicationSoftwareVersion = lex.getText("deviceManager.unknown");
        try {
            byte[] b = this.client().readProperty(sourceAddress, deviceId, 77);
            if (b != null) {
                encoding = AsnUtil.getCharacterSetEncoding(b);
                name = AsnUtil.fromAsnCharacterString(b);
                if (!this.isValidName(name)) {
                    name = "";
                }
            }
            if ((b = this.client().readProperty(sourceAddress, deviceId, 76, 0)) != null) {
                listSize = AsnUtil.fromAsnUnsignedInt(b);
            }
            if ((b = this.client().readProperty(sourceAddress, deviceId, 97)) != null) {
                servicesSupported = AsnUtil.fromAsnBitString(b);
            }
            if ((b = this.client().readProperty(sourceAddress, deviceId, 121)) != null) {
                vendorName = AsnUtil.fromAsnCharacterString(b);
            }
            if ((b = this.client().readProperty(sourceAddress, deviceId, 70)) != null) {
                modelName = AsnUtil.fromAsnCharacterString(b);
            }
            if ((b = this.readProperty(this.client(), sourceAddress, deviceId, 139)) != null) {
                protocolRevision = AsnUtil.fromAsnUnsigned(b).getInt();
            }
            if ((b = this.client().readProperty(sourceAddress, deviceId, 44)) != null) {
                firmwareRevision = AsnUtil.fromAsnCharacterString(b);
            }
            if ((b = this.client().readProperty(sourceAddress, deviceId, 12)) != null) {
                applicationSoftwareVersion = AsnUtil.fromAsnCharacterString(b);
            }
        }
        catch (AsnException e) {
            this.log().failed("Unable to convert device name/listSize for " + name + ":" + (Object)((Object)e));
        }
        catch (BacnetException e) {
            this.log().failed("BacnetException " + (Object)((Object)e) + " trying to read device parameters for " + (Object)((Object)deviceId));
            logger.error("BacnetException trying to read device parameters: " + (Object)((Object)e), (Throwable)((Object)e));
        }
        catch (Exception e) {
            this.log().failed("Unable to read device parameters for " + name + " [" + (Object)((Object)deviceId) + "]:" + e);
        }
        BDiscoveryDevice dd = new BDiscoveryDevice(name, request, sourceAddress, listSize, encoding, servicesSupported, vendorName, modelName, protocolRevision, firmwareRevision, applicationSoftwareVersion);
        return dd;
    }

    private byte[] readProperty(BBacnetClientLayer client, BBacnetAddress sourceAddress, BBacnetObjectIdentifier deviceId, int propertyId) throws BacnetException {
        try {
            return client.readProperty(sourceAddress, deviceId, propertyId);
        }
        catch (ErrorException e) {
            ErrorType error;
            if (propertyId == 139 && (error = e.getErrorType()).getErrorClass() == 2 && error.getErrorCode() == 32) {
                return AsnUtil.toAsnUnsigned(0L);
            }
            throw e;
        }
    }

    BDiscoveryDevice[] getDuplicateDevices(BBacnetObjectIdentifier objectId) {
        Array a = new Array(BDiscoveryDevice.class);
        SlotCursor sc = this.getProperties();
        while (sc.next(BDiscoveryDevice.class)) {
            BDiscoveryDevice d = (BDiscoveryDevice)sc.get();
            if (!d.getObjectId().equals((Object)objectId)) continue;
            a.add((Object)d);
        }
        return (BDiscoveryDevice[])a.trim();
    }

    @Override
    public void receiveIAm(IAmRequest request, BBacnetAddress sourceAddress) {
        int inst = request.getObjectId().getInstanceNumber();
        if (this.identifierInRange(this.params, inst) && this.networkInRange(this.params, sourceAddress.getNetworkNumber())) {
            this.setLinkLayer(sourceAddress);
            this.addDevice(request, sourceAddress);
        }
    }

    private void setLinkLayer(BBacnetAddress sourceAddress) {
        BNetworkPort port = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork().getPortByNetwork(sourceAddress.getNetworkNumber());
        if (port != null && port.getNetworkNumber() == sourceAddress.getNetworkNumber()) {
            BBacnetLinkLayer link = port.getLink();
            if (link instanceof BBacnetIpLinkLayer) {
                sourceAddress.setInt(BBacnetAddress.addressType, 2, BacnetConst.noWrite);
            } else if (link instanceof BBacnetEthernetLinkLayer) {
                sourceAddress.setInt(BBacnetAddress.addressType, 1, BacnetConst.noWrite);
            } else if (link instanceof BBacnetMstpLinkLayer) {
                sourceAddress.setInt(BBacnetAddress.addressType, 3, BacnetConst.noWrite);
            } else if (link instanceof BScLinkLayer) {
                sourceAddress.setInt(BBacnetAddress.addressType, 4, BacnetConst.noWrite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDevice(IAmRequest request, BBacnetAddress sourceAddress) {
        IAmDevice dev = new IAmDevice(request, sourceAddress);
        String message = null;
        ArrayList<IAmDevice> arrayList = this.iAmDevices;
        synchronized (arrayList) {
            int index = this.index(this.iAmDevices, request.getObjectId().getInstanceNumber(), sourceAddress);
            if (index < 0) {
                if (index != -2) {
                    this.iAmDevices.add(dev);
                }
                message = MessageFormat.format(lex.getText("deviceManager.found"), new Object[]{request.getObjectId(), sourceAddress});
            } else {
                dev.dup = true;
                this.iAmDevices.add(dev);
            }
        }
        if (message != null) {
            this.log().message(message);
        }
    }

    private boolean identifierInRange(BDeviceDiscoveryConfig params, int instanceId) {
        if (params.isDefaultRange()) {
            return true;
        }
        return instanceId >= params.getDeviceLowLimit() && instanceId <= params.getDeviceHighLimit();
    }

    private boolean networkInRange(BDeviceDiscoveryConfig params, int networkNumber) {
        BDiscoveryNetworks networks = params.getNetworks();
        if (networks.isAllNetworks()) {
            return true;
        }
        return networks.contains(networkNumber);
    }

    private int index(ArrayList<IAmDevice> v, int inst, BBacnetAddress sourceAddress) {
        for (int i = 0; i < v.size(); ++i) {
            IAmDevice iad = v.get(i);
            if (iad.iAm.getObjectId().getInstanceNumber() != inst) continue;
            if (iad.addr.getMacAddress().equals((Object)sourceAddress.getMacAddress())) {
                return -2;
            }
            return i;
        }
        return -1;
    }

    private boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0) {
            return false;
        }
        if (name.trim().length() == 0) {
            return false;
        }
        return name.length() != 1 || SlotPath.isValidName((String)name);
    }

    static class IAmDevice {
        IAmRequest iAm;
        BBacnetAddress addr;
        boolean dup;

        IAmDevice(IAmRequest iAm, BBacnetAddress addr) {
            this.iAm = iAm;
            this.addr = addr;
        }
    }
}

