/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetTimerState;
import javax.baja.bacnet.enums.BBacnetTimerTransition;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class ChangeOfTimer
extends BacnetNotificationParameters {
    public static final int NEW_STATE_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    public static final int UPDATE_TIME_TAG = 2;
    public static final int LAST_STATE_CHANGE_TAG = 3;
    public static final int INITIAL_TIMEOUT_TAG = 4;
    public static final int EXPIRATION_TIME_TAG = 5;
    private BBacnetTimerState newState;
    private BBacnetBitString statusFlags;
    private BBacnetDateTime updateTime;
    private BBacnetTimerTransition lastStateChange;
    private BBacnetUnsigned initialTimeout;
    private BBacnetDateTime expirationTime;

    public ChangeOfTimer() {
    }

    public ChangeOfTimer(BBacnetTimerState newState, BBacnetBitString statusFlags, BBacnetDateTime updateTime, BBacnetTimerTransition lastStateChange, BBacnetUnsigned initialTimeout, BBacnetDateTime expirationTime) {
        this.newState = newState;
        this.statusFlags = statusFlags;
        this.updateTime = updateTime;
        this.lastStateChange = lastStateChange;
        this.initialTimeout = initialTimeout;
        this.expirationTime = expirationTime;
    }

    @Override
    public int getChoiceType() {
        return 22;
    }

    public BBacnetTimerState getNewState() {
        return this.newState;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public BBacnetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public BBacnetTimerTransition getLastStateChange() {
        return this.lastStateChange;
    }

    public BBacnetUnsigned getInitialTimeout() {
        return this.initialTimeout;
    }

    public BBacnetDateTime getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void addAlarmData(HashMap<String, ? super BIDataValue> map) {
        map.put("newState", (BIDataValue)BString.make((String)this.newState.getTag()));
        map.put("statusFlags", (BIDataValue)BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
        map.put("updateTime", (BIDataValue)BString.make((String)this.updateTime.toString(null)));
        map.put("lastStateChange", (BIDataValue)BString.make((String)(this.lastStateChange == null ? "null" : this.lastStateChange.getTag())));
        map.put("initialTimeout", (BIDataValue)BString.make((String)(this.initialTimeout == null ? "null" : this.initialTimeout.toString(null))));
        map.put("expirationTime", (BIDataValue)BString.make((String)(this.expirationTime == null ? "null" : this.expirationTime.toString(null))));
    }

    @Override
    public void writeEncoded(AsnOutputStream out) {
        out.writeOpeningTag(22);
        out.writeEnumerated(0, (BEnum)this.newState);
        out.writeBitString(1, this.statusFlags);
        out.writeOpeningTag(2);
        this.updateTime.writeAsn(out);
        out.writeClosingTag(2);
        if (this.lastStateChange != null) {
            out.writeEnumerated(3, (BEnum)this.lastStateChange);
        }
        if (this.initialTimeout != null) {
            out.writeUnsigned(4, this.initialTimeout);
        }
        if (this.expirationTime != null) {
            out.writeOpeningTag(5);
            this.expirationTime.writeAsn(out);
            out.writeClosingTag(5);
        }
        out.writeClosingTag(22);
    }

    @Override
    public void readEncoded(BBacnetObjectIdentifier deviceId, AsnInputStream in) throws AsnException {
        in.skipOpeningTag(22);
        BBacnetTimerState newState = BBacnetTimerState.make(in.readEnumerated(0));
        BBacnetBitString statusFlags = in.readBitString(1);
        in.skipOpeningTag(2);
        BBacnetDateTime updateTime = new BBacnetDateTime();
        updateTime.readAsn(in);
        in.skipClosingTag(2);
        BBacnetTimerTransition lastStateChange = null;
        in.peekTag();
        if (in.isContextTag(3)) {
            lastStateChange = BBacnetTimerTransition.make(in.readEnumerated(3));
            in.peekTag();
        }
        BBacnetUnsigned initialTimeout = null;
        if (in.isContextTag(4)) {
            initialTimeout = in.readUnsigned(4);
            in.peekTag();
        }
        BBacnetDateTime expirationTime = null;
        if (in.isOpeningTag(5)) {
            in.skipTag();
            expirationTime = new BBacnetDateTime();
            expirationTime.readAsn(in);
            in.skipClosingTag(5);
        }
        in.skipClosingTag(22);
        this.newState = newState;
        this.statusFlags = statusFlags;
        this.updateTime = updateTime;
        this.lastStateChange = lastStateChange;
        this.initialTimeout = initialTimeout;
        this.expirationTime = expirationTime;
    }

    @Override
    public void readEncoded(AsnInputStream inputStream) throws AsnException {
        this.readEncoded(null, inputStream);
    }

    @Override
    public String toString(Context cx) {
        if (BacnetConst.facetsContext.equals(cx)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        return "  change-of-timer\n    " + (Object)((Object)this.newState) + "    " + (Object)((Object)this.statusFlags) + "    " + this.updateTime + (this.lastStateChange == null ? "" : "    " + (Object)((Object)this.lastStateChange)) + (this.initialTimeout == null ? "" : "    " + (Object)((Object)this.initialTimeout)) + (this.expirationTime == null ? "" : "    " + this.expirationTime);
    }

    @Override
    public String toFacetString() {
        return "evtVals.newState." + (Object)((Object)this.newState) + ".status." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags) + ".updateTime." + this.updateTime.toString(facetsContext) + ".lastStateChange." + (this.lastStateChange == null ? "null" : this.lastStateChange.toString(facetsContext)) + ".initialTimeout." + (this.initialTimeout == null ? "null" : this.initialTimeout.toString(facetsContext)) + ".expirationTime." + (this.expirationTime == null ? "null" : this.expirationTime.toString(facetsContext));
    }
}

