/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetShedState;
import javax.baja.bacnet.enums.BBacnetWriteStatus;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.enums.access.BBacnetAuthenticationStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorSecuredStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.access.BBacnetLockStatus;
import javax.baja.bacnet.enums.lighting.BBacnetLightingInProgress;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;
import javax.baja.sys.Context;

public class NBacnetPropertyStates {
    private static final String[] choiceNames = new String[]{"booleanValue", "binaryValue", "eventType", "polarity", "programChange", "programState", "programError", "reliability", "state", "systemStatus", "units", "unsignedValue", "lifeSafetyMode", "lifeSafetyState", "restartReason", "doorAlarmState", "action", "doorSecuredStatus", "doorStatus", "doorValue", "fileAccessMethod", "lockStatus", "lifeSafetyOperation", "maintenance", "nodeType", "notifyType", "securityLevel", "shedState", "silencedState", "reserved29", "accessEvent", "zoneOccupancyState", "accessCredentialDisableReason", "accessCredentialDisable", "authenticationStatus", "reserved35", "backupState", "writeStatus", "lightingInProgress", "lightingOperation", "lightingTransition", "integerValue", "binaryLightingValue"};
    private static final String ASHRAE_CHOICE_NAME = "ashrae";
    private static final String EXTENDED_VALUE_NAME = "extended";
    private static final String PROPRIETARY_CHOICE_NAME = "proprietary";
    private static final String INVALID_CHOICE_NAME = "invalid";
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int BINARY_VALUE_TAG = 1;
    public static final int EVENT_TYPE_TAG = 2;
    public static final int POLARITY_TAG = 3;
    public static final int PROGRAM_CHANGE_TAG = 4;
    public static final int PROGRAM_STATE_TAG = 5;
    public static final int REASON_FOR_HALT_TAG = 6;
    public static final int RELIABILITY_TAG = 7;
    public static final int STATE_TAG = 8;
    public static final int SYSTEM_STATUS_TAG = 9;
    public static final int UNITS_TAG = 10;
    public static final int UNSIGNED_VALUE_TAG = 11;
    public static final int LIFE_SAFETY_MODE_TAG = 12;
    public static final int LIFE_SAFETY_STATE_TAG = 13;
    private static final int EXTENDED_VALUE_TAG = 63;
    private static final int MAX_CHOICE_TAG = 254;
    int choiceType;
    private boolean booleanValue;
    private long unsignedValue;
    private BEnum enumValue;

    public NBacnetPropertyStates() {
    }

    public NBacnetPropertyStates(boolean booleanValue) {
        this.choiceType = 0;
        this.booleanValue = booleanValue;
    }

    public NBacnetPropertyStates(BBacnetBinaryPv binaryValue) {
        this(1, (BEnum)binaryValue);
    }

    public NBacnetPropertyStates(BBacnetEventType eventType) {
        this(2, (BEnum)eventType);
    }

    public NBacnetPropertyStates(BBacnetPolarity polarity) {
        this(3, (BEnum)polarity);
    }

    public NBacnetPropertyStates(BBacnetProgramRequest programChange) {
        this(4, (BEnum)programChange);
    }

    public NBacnetPropertyStates(BBacnetProgramState programState) {
        this(5, (BEnum)programState);
    }

    public NBacnetPropertyStates(BBacnetProgramError reasonForHalt) {
        this(6, (BEnum)reasonForHalt);
    }

    public NBacnetPropertyStates(BBacnetReliability reliability) {
        this(7, (BEnum)reliability);
    }

    public NBacnetPropertyStates(BBacnetEventState state) {
        this(8, (BEnum)state);
    }

    public NBacnetPropertyStates(BBacnetDeviceStatus systemStatus) {
        this(9, (BEnum)systemStatus);
    }

    public NBacnetPropertyStates(BBacnetEngineeringUnits units) {
        this(10, (BEnum)units);
    }

    public NBacnetPropertyStates(long unsignedValue) {
        this.choiceType = 11;
        this.unsignedValue = unsignedValue;
    }

    public NBacnetPropertyStates(BBacnetLifeSafetyMode lifeSafetyMode) {
        this(12, (BEnum)lifeSafetyMode);
    }

    public NBacnetPropertyStates(BBacnetLifeSafetyState lifeSafetyState) {
        this(13, (BEnum)lifeSafetyState);
    }

    private NBacnetPropertyStates(int choice, BEnum e) {
        this.choiceType = choice;
        this.enumValue = e;
    }

    public int getChoiceType() {
        return this.choiceType;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public BBacnetBinaryPv getBinaryValue() {
        return (BBacnetBinaryPv)this.enumValue;
    }

    public BEnum getEventType() {
        return this.enumValue;
    }

    public BBacnetPolarity getPolarity() {
        return (BBacnetPolarity)this.enumValue;
    }

    public BEnum getProgramRequest() {
        return this.enumValue;
    }

    public BEnum getProgramState() {
        return this.enumValue;
    }

    public BEnum getProgramError() {
        return this.enumValue;
    }

    public BEnum getReliability() {
        return this.enumValue;
    }

    public BEnum getEventState() {
        return this.enumValue;
    }

    public BEnum getSystemStatus() {
        return this.enumValue;
    }

    public BEnum getUnits() {
        return this.enumValue;
    }

    public long getUnsignedValue() {
        return this.unsignedValue;
    }

    public BEnum getLifeSafetyMode() {
        return this.enumValue;
    }

    public BEnum getLifeSafetyState() {
        return this.enumValue;
    }

    public void writeEncoded(AsnOutputStream outputStream) {
        if (this.choiceType < 0 || this.choiceType > 254) {
            throw new IllegalStateException("Invalid BACnetPropertyStates choice: " + this.choiceType);
        }
        switch (this.choiceType) {
            case 0: {
                outputStream.writeBoolean(0, this.booleanValue);
                break;
            }
            case 11: {
                outputStream.writeUnsignedInteger(11, this.unsignedValue);
                break;
            }
            case 41: {
                outputStream.writeSignedInteger(41, (int)this.unsignedValue);
                break;
            }
            default: {
                if (this.isDefined(this.choiceType)) {
                    outputStream.writeEnumerated(this.choiceType, this.enumValue.getOrdinal());
                    break;
                }
                outputStream.writeEnumerated(this.choiceType, (int)this.unsignedValue);
            }
        }
    }

    public void readEncoded(AsnInputStream inputStream) throws AsnException {
        this.readEncoded(null, inputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier deviceId, AsnInputStream inputStream) throws AsnException {
        this.choiceType = inputStream.peekTag();
        if (this.choiceType < 0 || this.choiceType > 254) {
            throw new AsnException("Invalid tag: " + this.choiceType);
        }
        switch (this.choiceType) {
            case 0: {
                this.booleanValue = inputStream.readBoolean(0);
                break;
            }
            case 11: {
                this.unsignedValue = inputStream.readUnsignedInteger(11);
                break;
            }
            case 41: {
                this.unsignedValue = inputStream.readSignedInteger(41);
                break;
            }
            case 1: {
                this.enumValue = BBacnetBinaryPv.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 2: {
                this.enumValue = this.getEnumList(deviceId).getEventType().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 3: {
                this.enumValue = BBacnetPolarity.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 4: {
                this.enumValue = BBacnetProgramRequest.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 5: {
                this.enumValue = BBacnetProgramState.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 6: {
                this.enumValue = this.getEnumList(deviceId).getProgramError().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 7: {
                this.enumValue = this.getEnumList(deviceId).getReliability().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 8: {
                this.enumValue = this.getEnumList(deviceId).getEventState().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 9: {
                this.enumValue = this.getEnumList(deviceId).getDeviceStatus().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 10: {
                this.enumValue = this.getEnumList(deviceId).getEngineeringUnits().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 12: {
                this.enumValue = this.getEnumList(deviceId).getLifeSafetyMode().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 13: {
                this.enumValue = this.getEnumList(deviceId).getLifeSafetyState().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 14: {
                this.enumValue = this.getEnumList(deviceId).getRestartReason().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 15: {
                this.enumValue = this.getEnumList(deviceId).getDoorAlarmState().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 16: {
                this.enumValue = BBacnetAction.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 17: {
                this.enumValue = BBacnetDoorSecuredStatus.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 18: {
                this.enumValue = this.getEnumList(deviceId).getDoorStatus().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 19: {
                this.enumValue = BBacnetDoorValue.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 20: {
                this.enumValue = BBacnetFileAccessMethod.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 21: {
                this.enumValue = BBacnetLockStatus.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 22: {
                this.enumValue = this.getEnumList(deviceId).getLifeSafetyOperation().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 23: {
                this.enumValue = this.getEnumList(deviceId).getMaintenance().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 24: {
                this.enumValue = BBacnetNodeType.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 25: {
                this.enumValue = BBacnetNotifyType.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 27: {
                this.enumValue = BBacnetShedState.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 28: {
                this.enumValue = this.getEnumList(deviceId).getSilencedState().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 30: {
                this.enumValue = this.getEnumList(deviceId).getAccessEvent().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 31: {
                this.enumValue = this.getEnumList(deviceId).getAccessZoneOccupancyState().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 32: {
                this.enumValue = this.getEnumList(deviceId).getAccessCredentialDisableReason().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 33: {
                this.enumValue = this.getEnumList(deviceId).getAccessCredentialDisable().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 34: {
                this.enumValue = BBacnetAuthenticationStatus.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 36: {
                this.enumValue = BBacnetBackupState.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 37: {
                this.enumValue = BBacnetWriteStatus.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 38: {
                this.enumValue = BBacnetLightingInProgress.make(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 39: {
                this.enumValue = this.getEnumList(deviceId).getLightingOperation().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 40: {
                this.enumValue = this.getEnumList(deviceId).getLightingTransition().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            case 42: {
                this.enumValue = this.getEnumList(deviceId).getBinaryLightingPv().getRange().get(inputStream.readEnumerated(this.choiceType));
                break;
            }
            default: {
                this.unsignedValue = inputStream.readEnumerated(this.choiceType);
            }
        }
    }

    private BExtensibleEnumList getEnumList(BBacnetObjectIdentifier deviceId) {
        BBacnetDevice device = BBacnetNetwork.bacnet().doLookupDeviceById(deviceId);
        BExtensibleEnumList enumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (device != null) {
            enumList = device.getEnumerationList();
        }
        return enumList;
    }

    public String toString(Context cx) {
        if (cx != null && cx.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.choiceType) {
            case 0: {
                sb.append(choiceNames[0]).append(": ").append(this.booleanValue);
                break;
            }
            case 11: {
                sb.append(choiceNames[11]).append(": ").append(this.unsignedValue);
                break;
            }
            case 41: {
                sb.append(choiceNames[41]).append(": ").append(this.unsignedValue);
                break;
            }
            default: {
                if (this.choiceType < 0 || this.choiceType > 254) {
                    sb.append(INVALID_CHOICE_NAME).append(": ").append(this.choiceType);
                    break;
                }
                if (this.isDefined(this.choiceType)) {
                    sb.append(choiceNames[this.choiceType]).append(": ").append(this.enumValue.getTag());
                    break;
                }
                if (this.choiceType < 63) {
                    sb.append(ASHRAE_CHOICE_NAME).append(": tag:").append(this.choiceType).append(",value:").append(this.unsignedValue);
                    break;
                }
                if (this.choiceType == 63) {
                    long extendedTag = this.unsignedValue / 100000L;
                    long extendedValue = this.unsignedValue - extendedTag * 100000L;
                    sb.append(EXTENDED_VALUE_NAME).append(": tag:").append(extendedTag).append(",value:").append(extendedValue);
                    break;
                }
                sb.append(PROPRIETARY_CHOICE_NAME).append(": tag:").append(this.choiceType).append(",value:").append(this.unsignedValue);
            }
        }
        return sb.toString();
    }

    public String toFacetString() {
        StringBuilder sb = new StringBuilder();
        switch (this.choiceType) {
            case 0: {
                sb.append(choiceNames[0]).append('-').append(this.booleanValue);
                break;
            }
            case 11: {
                sb.append(choiceNames[11]).append('-').append(this.unsignedValue);
                break;
            }
            case 41: {
                sb.append(choiceNames[41]).append('-').append(this.unsignedValue);
                break;
            }
            default: {
                if (this.choiceType < 0 || this.choiceType > 254) {
                    sb.append(INVALID_CHOICE_NAME).append('-').append(this.choiceType);
                    break;
                }
                if (this.isDefined(this.choiceType)) {
                    sb.append(choiceNames[this.choiceType]).append('-').append(this.enumValue.getTag());
                    break;
                }
                if (this.choiceType < 63) {
                    sb.append(ASHRAE_CHOICE_NAME).append("-tag-").append(this.choiceType).append("-value-").append(this.unsignedValue);
                    break;
                }
                if (this.choiceType == 63) {
                    long extendedTag = this.unsignedValue / 100000L;
                    long extendedValue = this.unsignedValue - extendedTag * 100000L;
                    sb.append(EXTENDED_VALUE_NAME).append("-tag-").append(extendedTag).append("-value-").append(extendedValue);
                    break;
                }
                sb.append(PROPRIETARY_CHOICE_NAME).append("-tag-").append(this.choiceType).append("-value-").append(this.unsignedValue);
            }
        }
        return sb.toString();
    }

    private boolean isDefined(int choiceType) {
        switch (choiceType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                return true;
            }
        }
        return false;
    }
}

