/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet;

import java.util.Arrays;
import java.util.List;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetNetwork"})})
public class BBacnetSecurityDashboardProvider
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetSecurityDashboardProvider.class);
    private static final LexiconFormatInfo DEVICE_COMM_CONTROL_INFO = LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.bacnet.deviceCommControl.summary.info");
    private static final LexiconFormatInfo DEVICE_COMM_CONTROL_WARNING = LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.bacnet.deviceCommControl.summary.warning");
    private static final LexiconFormatInfo DEVICE_COMM_CONTROL_DESCRIPTION = LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.bacnet.deviceCommControl.description");
    private static final LexiconFormatInfo REINIT_DEVICE_INFO = LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.bacnet.reinitDevice.summary.info");
    private static final LexiconFormatInfo REINIT_DEVICE_WARNING = LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.bacnet.reinitDevice.summary.warning");
    private static final LexiconFormatInfo REINIT_DEVICE_DESCRIPTION = LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.bacnet.reinitDevice.description");
    private BBacnetNetwork bacnetNetwork;
    private SecurityDashboardItemBuilder builder;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.bacnetNetwork = (BBacnetNetwork)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)BBacnetNetwork.TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.bacnetNetwork.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        BLocalBacnetDevice localDevice = this.bacnetNetwork.getLocalDevice();
        BBacnetBitString servicesSupported = localDevice.getProtocolServicesSupported();
        return Arrays.asList(this.makeDeviceCommunicationControlItem(servicesSupported), this.makeReinitializeDeviceItem(servicesSupported));
    }

    private SecurityDashboardItem makeDeviceCommunicationControlItem(BBacnetBitString servicesSupported) {
        if (servicesSupported.getBit(17)) {
            return this.builder.makeWarning().withSummary(DEVICE_COMM_CONTROL_WARNING).withDescription(DEVICE_COMM_CONTROL_DESCRIPTION);
        }
        return this.builder.makeInfo().withSummary(DEVICE_COMM_CONTROL_INFO).withDescription(DEVICE_COMM_CONTROL_DESCRIPTION);
    }

    private SecurityDashboardItem makeReinitializeDeviceItem(BBacnetBitString servicesSupported) {
        if (servicesSupported.getBit(20)) {
            return this.builder.makeWarning().withSummary(REINIT_DEVICE_WARNING).withDescription(REINIT_DEVICE_DESCRIPTION);
        }
        return this.builder.makeInfo().withSummary(REINIT_DEVICE_INFO).withDescription(REINIT_DEVICE_DESCRIPTION);
    }
}

