/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BLatticeCell;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BPane;

@NiagaraType
public class BLatticePane
extends BPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BLatticePane.class);
    public int cols = 1;
    public int rows = 1;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLatticePane() {
    }

    public BLatticePane(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
    }

    public BLatticeCell add(BWidget widget, int col, int colSpan, int row, int rowSpan) {
        BLatticeCell cell = new BLatticeCell(widget, col, colSpan, row, rowSpan);
        this.add(null, (BValue)cell);
        return cell;
    }

    public BLatticeCell add(BWidget widget) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.cellAt(c, r) != null) continue;
                return this.add(widget, c, 1, r, 1);
            }
        }
        return null;
    }

    public BLatticeCell cellAt(int col, int row) {
        BWidget[] kids = this.getChildWidgets();
        int i = kids.length;
        while (--i >= 0) {
            BLatticeCell cell = (BLatticeCell)kids[i];
            if (!cell.spans(col, row)) continue;
            return cell;
        }
        return null;
    }

    public void computePreferredSize() {
        int w = 0;
        int h = 0;
        BWidget[] kids = this.getChildWidgets();
        int i = kids.length;
        while (--i >= 0) {
            BLatticeCell cell = (BLatticeCell)kids[i];
            cell.computePreferredSize();
            w = Math.max(w, cell.preferredColumnWidth());
            h = Math.max(h, cell.preferredRowHeight());
        }
        this.setPreferredSize(w * this.cols, h * this.rows);
    }

    public void doLayout(BWidget[] kids) {
        double myw = this.getWidth();
        double myh = this.getHeight();
        double cellWidth = myw / (double)this.cols;
        double cellHeight = myh / (double)this.rows;
        int row = 0;
        int col = 0;
        int i = kids.length;
        while (--i >= 0) {
            BLatticeCell cell = (BLatticeCell)kids[i];
            col = cell.col;
            row = cell.row;
            double x = Math.floor((double)col * cellWidth);
            double y = (double)row * cellHeight;
            double w = col + cell.colspan == this.cols ? myw - x : (double)cell.colspan * cellWidth;
            double h = row + cell.rowspan == this.rows ? myh - y : (double)cell.rowspan * cellHeight;
            cell.setBounds(x, y, w, h);
            cell.layout();
        }
    }
}

