/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleView;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BCalendarWidget;
import com.tridium.schedule.ui.BCompositeAdd;
import com.tridium.schedule.ui.BDayEd;
import com.tridium.schedule.ui.BScheduleFE;
import com.tridium.schedule.ui.Utils;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="add"), @NiagaraAction(name="delete"), @NiagaraAction(name="down"), @NiagaraAction(name="edit"), @NiagaraAction(name="rename"), @NiagaraAction(name="selected"), @NiagaraAction(name="setModified"), @NiagaraAction(name="up")})
public class BCompositeEd
extends BAbstractScheduleWidget {
    @Generated
    public static final Action add = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action delete = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action down = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action edit = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action rename = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action selected = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action setModified = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Action up = BCompositeEd.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeEd.class);
    private boolean controlSchedule;
    boolean showCalendar = true;
    BAbstractSchedule absSched;
    BButton addButton;
    BCalendarWidget calendar;
    Context context;
    BAbstractSchedule current;
    BDayEd daySlider;
    BButton deleteButton;
    BButton downButton;
    BEdgePane edgePane;
    BButton editButton;
    String lastSelected = "";
    BButton renameButton;
    BCompositeSchedule schedule;
    BTable table;
    BButton upButton;

    @Generated
    public void add() {
        this.invoke(add, null, null);
    }

    @Generated
    public void delete() {
        this.invoke(delete, null, null);
    }

    @Generated
    public void down() {
        this.invoke(down, null, null);
    }

    @Generated
    public void edit() {
        this.invoke(edit, null, null);
    }

    @Generated
    public void rename() {
        this.invoke(rename, null, null);
    }

    @Generated
    public void selected() {
        this.invoke(selected, null, null);
    }

    @Generated
    public void setModified() {
        this.invoke(setModified, null, null);
    }

    @Generated
    public void up() {
        this.invoke(up, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCompositeEd(boolean controlSchedule) {
        this(controlSchedule, true);
    }

    public BCompositeEd(boolean controlSchedule, boolean showCalendar) {
        this.controlSchedule = controlSchedule;
        this.showCalendar = showCalendar;
        this.edgePane = new BEdgePane();
        this.edgePane.setCenter((BWidget)new BBorderPane(this.makeTable(), 10.0, 0.0, 0.0, 0.0));
        if (showCalendar) {
            this.calendar = new BCalendarWidget(false);
            this.edgePane.setTop((BWidget)this.calendar);
        }
        if (controlSchedule) {
            this.daySlider = new BDayEd(true);
            this.linkTo((BComponent)this.daySlider, (Slot)BDayEd.modified, (Slot)setModified);
            this.edgePane.setRight((BWidget)new BBorderPane((BWidget)this.daySlider, 10.0, 0.0, 0.0, 10.0));
        }
        this.setContent((BWidget)this.edgePane);
    }

    public void doAdd() {
        BCompositeAdd diagContent = new BCompositeAdd(this, this.generateName("Event"), this.controlSchedule, this.context);
        block2: while (true) {
            try {
                int result;
                while ((result = BDialog.open((BWidget)this, (String)this.lex("composite.add"), (Object)((Object)diagContent), (int)3, null)) == 1) {
                    diagContent.validate();
                    String name = diagContent.name();
                    String nameEncoded = SlotPath.escape((String)name);
                    if (name == null || name.trim().isEmpty()) {
                        BDialog.error((BWidget)this, (Object)this.lex("composite.enterName"));
                        continue;
                    }
                    if (this.schedule.get(nameEncoded) != null) {
                        BDialog.error((BWidget)this, (Object)this.lex("composite.nameAlreadyInUse"));
                        continue;
                    }
                    BAbstractSchedule sch = diagContent.getSchedule();
                    String encodedName = SlotPath.escape((String)name) + "?";
                    Property newProp = this.schedule.add(encodedName, (BValue)sch);
                    this.schedule.reorderToTop(newProp);
                    BAbstractSchedule[] ary = this.schedule.getSchedules();
                    this.table.getSelection().select(0, true);
                    this.table.sizeColumnsToFit();
                    this.fireModified(null);
                    break block2;
                }
                this.updateButtons();
            }
            catch (Exception x) {
                BDialog.error((BWidget)this, (Object)x.getMessage());
                continue;
            }
            break;
        }
    }

    public void doDelete() {
        int result = BDialog.confirm((BWidget)this, (Object)(this.lex("composite.delete") + " \"" + SlotPath.unescape((String)this.current.getName()) + "\""));
        if (result == 4) {
            int index = this.table.getSelection().getRow();
            this.schedule.remove((BComplex)this.current);
            this.current = null;
            this.table.getModel().updateTable();
            BAbstractSchedule[] ary = this.schedule.getSchedules();
            int size = ary.length;
            if (size == 0) {
                this.table.getSelection().deselectAll();
            } else if (index >= size) {
                this.table.getSelection().select(size - 1, true);
            } else {
                this.table.getSelection().select(index);
            }
            if (this.calendar != null) {
                this.calendar.setSchedule((BAbstractSchedule)this.schedule);
            }
            this.table.sizeColumnsToFit();
            this.fireModified(null);
        }
        this.updateButtons();
    }

    public void doDown() {
        this.move(false);
        this.updateButtons();
    }

    public void doEdit() {
        int r = this.table.getSelection().getRow();
        BAbstractSchedule[] ary = this.schedule.getSchedules();
        BAbstractSchedule sch = ary[r];
        BAbstractSchedule restore = (BAbstractSchedule)sch.newCopy(true);
        if (sch instanceof BDailySchedule) {
            sch = ((BDailySchedule)sch).getDays();
        }
        BScheduleFE fe = new BScheduleFE(this.getView().getBase(), true);
        fe.setReadonly(this.isReadonly());
        fe.loadValue((BObject)sch, this.context);
        this.linkTo((BComponent)fe, (Slot)BScheduleFE.pluginModified, (Slot)setModified);
        int result = 1;
        boolean valid = false;
        while (!valid) {
            try {
                result = BDialog.open((BWidget)this, (String)this.lastSelected, (Object)((Object)fe), (int)3, null);
                if (result == 1) {
                    fe.validate();
                    valid = true;
                    this.setModified();
                    continue;
                }
                this.current = restore;
                this.schedule.set(SlotPath.escape((String)this.lastSelected), (BValue)restore);
                return;
            }
            catch (Exception x) {
                BDialog.error((BWidget)this, (Object)x.getMessage());
            }
        }
    }

    public void doRename() {
        String newNameEncoded;
        int index = this.table.getSelection().getRow();
        String orig = (String)this.table.getModel().getValueAt(index, 0);
        BLabel l = new BLabel(this.lex("composite.enterName"));
        BTextField input = new BTextField(orig, 40);
        BGridPane gp = new BGridPane(2);
        gp.add(null, (BValue)l);
        gp.add(null, (BValue)input);
        while (true) {
            int result;
            if ((result = BDialog.open((BWidget)this, (String)this.lex("composite.rename"), (Object)gp, (int)3, (BImage)BDialog.QUESTION_ICON)) == 2) {
                return;
            }
            String newName = input.getText();
            newNameEncoded = SlotPath.escape((String)newName);
            if (this.schedule.get(newNameEncoded) == null) break;
            BDialog.error((BWidget)this, (Object)this.lex("composite.nameAlreadyInUse"));
        }
        String origEncoded = SlotPath.escape((String)orig);
        Property p = this.schedule.getProperty(origEncoded);
        this.schedule.rename(p, newNameEncoded, null);
        this.table.getModel().updateTable();
        this.table.sizeColumnsToFit();
        this.fireModified(null);
        this.updateButtons();
    }

    public void doSelected() {
        int row = this.table.getSelection().getRow();
        if (row < 0 || this.table.getModel().getRowCount() <= 0) {
            this.current = null;
            if (this.controlSchedule) {
                this.setSlider(null);
            }
            if (this.calendar != null) {
                this.calendar.setSchedule((BAbstractSchedule)this.schedule);
            }
            this.updateButtons();
            this.lastSelected = "";
            return;
        }
        String name = (String)this.table.getModel().getValueAt(row, 0);
        if (name == null) {
            this.current = null;
            if (this.controlSchedule) {
                this.setSlider(null);
            }
            if (this.calendar != null) {
                this.calendar.setSchedule((BAbstractSchedule)this.schedule);
            }
            this.updateButtons();
            this.lastSelected = "";
            return;
        }
        if (name.equals(this.lastSelected)) {
            return;
        }
        this.lastSelected = name;
        this.current = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)name));
        if (this.controlSchedule) {
            BDailySchedule m = (BDailySchedule)this.current;
            this.setSlider(m.getDay());
        }
        if (this.calendar != null) {
            this.calendar.setSchedule(this.current);
        }
        this.updateButtons();
    }

    public void doSetModified() {
        if (this.calendar != null) {
            this.calendar.setSchedule(this.current);
            this.table.getModel().updateTable();
        }
        this.fireModified(null);
    }

    public void doUp() {
        this.move(true);
        this.updateButtons();
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        this.updateButtons();
        if (this.daySlider != null) {
            this.daySlider.setReadonly(ro);
        }
    }

    private String generateName(String base) {
        String gen = base;
        int i = 0;
        while (this.schedule.getProperty(gen) != null) {
            gen = base + ++i;
        }
        return gen;
    }

    private Property[] getDynamicProperties() {
        Array ret = new Array(Property.class);
        SlotCursor c = this.schedule.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.isDynamic()) continue;
            ret.add((Object)p);
        }
        return (Property[])ret.trim();
    }

    private int indexOf(Property[] props, String name) {
        int i = props.length;
        while (--i >= 0) {
            if (!props[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void move(boolean up) {
        int row = this.table.getSelection().getRow();
        String sel = (String)this.table.getModel().getValueAt(row, 0);
        Property[] dyn = this.getDynamicProperties();
        int idx = this.indexOf(dyn, SlotPath.escape((String)sel));
        int newIdx = up ? idx - 1 : idx + 1;
        Property tmp = dyn[idx];
        dyn[idx] = dyn[newIdx];
        dyn[newIdx] = tmp;
        this.schedule.reorder(dyn);
        this.table.getModel().updateTable();
        this.table.getSelection().select(up ? --row : ++row, true);
        this.fireModified(null);
    }

    private BWidget makeTable() {
        BEdgePane ret = new BEdgePane();
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setMultipleSelection(false);
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selected);
        this.editButton = new BButton(Utils.imgAdd, this.lex("composite.edit"));
        this.linkTo((BComponent)this.editButton, (Slot)BButton.actionPerformed, (Slot)edit);
        this.addButton = new BButton(Utils.imgAdd, this.lex("composite.add"));
        this.linkTo((BComponent)this.addButton, (Slot)BButton.actionPerformed, (Slot)add);
        this.upButton = new BButton(Utils.imgUp, this.lex("composite.precedence"));
        this.linkTo((BComponent)this.upButton, (Slot)BButton.actionPerformed, (Slot)up);
        this.downButton = new BButton(Utils.imgDown, this.lex("composite.precedence"));
        this.linkTo((BComponent)this.downButton, (Slot)BButton.actionPerformed, (Slot)down);
        this.renameButton = new BButton(Utils.imgRename, this.lex("composite.rename"));
        this.linkTo((BComponent)this.renameButton, (Slot)BButton.actionPerformed, (Slot)rename);
        this.deleteButton = new BButton(Utils.imgDelete, this.lex("composite.delete"));
        this.linkTo((BComponent)this.deleteButton, (Slot)BButton.actionPerformed, (Slot)delete);
        BGridPane gp = new BGridPane(6);
        gp.setUniformColumnWidth(true);
        gp.setColumnAlign(BHalign.fill);
        this.editButton.setButtonStyle(BButtonStyle.toolBar);
        this.addButton.setButtonStyle(BButtonStyle.toolBar);
        this.upButton.setButtonStyle(BButtonStyle.toolBar);
        this.downButton.setButtonStyle(BButtonStyle.toolBar);
        this.renameButton.setButtonStyle(BButtonStyle.toolBar);
        this.deleteButton.setButtonStyle(BButtonStyle.toolBar);
        gp.add(null, (BValue)this.addButton);
        gp.add(null, (BValue)this.editButton);
        gp.add(null, (BValue)this.upButton);
        gp.add(null, (BValue)this.downButton);
        gp.add(null, (BValue)this.renameButton);
        gp.add(null, (BValue)this.deleteButton);
        ret.setCenter((BWidget)this.table);
        ret.setBottom((BWidget)new BBorderPane((BWidget)gp, 10.0, 0.0, 0.0, 0.0));
        this.updateButtons();
        return ret;
    }

    void setSlider(BDaySchedule sch) {
        if (sch == null) {
            this.daySlider.setDaySchedule(this.absSched, new BDaySchedule());
        } else {
            this.daySlider.setDaySchedule(this.absSched, sch);
        }
        this.daySlider.setReadonly(this.isReadonly() || sch == null);
        this.daySlider.relayout();
    }

    private void updateButtons() {
        this.editButton.setEnabled(!this.isReadonly() && this.current != null);
        this.addButton.setEnabled(!this.isReadonly());
        this.deleteButton.setEnabled(!this.isReadonly() && this.current != null);
        this.renameButton.setEnabled(!this.isReadonly() && this.current != null);
        int idx = this.table.getSelection().getRow();
        this.upButton.setEnabled(!this.isReadonly() && idx > 0);
        if (idx < 0 || idx == this.table.getModel().getRowCount() - 1) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(!this.isReadonly());
        }
    }

    class Model
    extends TableModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return BCompositeEd.this.lex("composite.name");
            }
            return BCompositeEd.this.lex("composite.summary");
        }

        public int getRowCount() {
            if (BCompositeEd.this.schedule == null) {
                return 0;
            }
            return BCompositeEd.this.schedule.getSchedules().length;
        }

        public Object getValueAt(int row, int col) {
            Context cx;
            BAbstractScheduleView v;
            BAbstractSchedule[] ary = BCompositeEd.this.schedule.getSchedules();
            BAbstractSchedule s = ary[row];
            if (col == 0) {
                return SlotPath.unescape((String)s.getName());
            }
            if (BCompositeEd.this.controlSchedule && s instanceof BDailySchedule) {
                BDailySchedule sch = (BDailySchedule)s;
                s = sch.getDays();
            }
            if (BCompositeEd.this.context == null && (v = BCompositeEd.this.getView()) != null) {
                BCompositeEd.this.context = v.context;
            }
            if ((cx = BCompositeEd.this.context) != null) {
                cx = new BasicContext(cx.getUser(), cx.getLanguage());
            }
            return s.toString(cx);
        }
    }

    private class CmdUp
    extends Command {
        CmdUp() {
            super((BWidget)BCompositeEd.this, BCompositeEd.this.lex("composite.precedence"), Utils.imgUp, null, null);
        }

        public CommandArtifact doInvoke() {
            BCompositeEd.this.doUp();
            return null;
        }
    }

    private class CmdRename
    extends Command {
        CmdRename() {
            super((BWidget)BCompositeEd.this, BCompositeEd.this.lex("composite.rename"), Utils.imgRename, null, null);
        }

        public CommandArtifact doInvoke() {
            BCompositeEd.this.doRename();
            return null;
        }
    }

    private class CmdEdit
    extends Command {
        CmdEdit() {
            super((BWidget)BCompositeEd.this, BCompositeEd.this.lex("composite.edit"), Utils.imgEdit, null, null);
        }

        public CommandArtifact doInvoke() {
            BCompositeEd.this.doEdit();
            return null;
        }
    }

    private class CmdDown
    extends Command {
        CmdDown() {
            super((BWidget)BCompositeEd.this, BCompositeEd.this.lex("composite.precedence"), Utils.imgDown, null, null);
        }

        public CommandArtifact doInvoke() {
            BCompositeEd.this.doDown();
            return null;
        }
    }

    private class CmdDelete
    extends Command {
        CmdDelete() {
            super((BWidget)BCompositeEd.this, BCompositeEd.this.lex("composite.delete"), Utils.imgDelete, null, null);
        }

        public CommandArtifact doInvoke() {
            BCompositeEd.this.doDelete();
            return null;
        }
    }

    private class CmdAdd
    extends Command {
        CmdAdd() {
            super((BWidget)BCompositeEd.this, BCompositeEd.this.lex("composite.add"), Utils.imgAdd, null, null);
        }

        public CommandArtifact doInvoke() {
            BCompositeEd.this.doAdd();
            return null;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void backgroundPopup(BMouseEvent e) {
            if (BCompositeEd.this.isReadonly()) {
                return;
            }
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CmdAdd());
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }

        protected void cellDoubleClicked(BMouseEvent e, int r, int c) {
            BCompositeEd.this.edit();
        }

        protected void cellPopup(BMouseEvent e, int row, int column) {
            if (BCompositeEd.this.isReadonly()) {
                return;
            }
            BMenu menu = new BMenu();
            menu.add(null, (Command)new CmdAdd());
            if (BCompositeEd.this.current != null) {
                menu.add(null, (Command)new CmdEdit());
                menu.add(null, (Command)new CmdRename());
                if (row > 0) {
                    menu.add(null, (Command)new CmdUp());
                }
                if (row < this.getTable().getModel().getRowCount() - 1) {
                    menu.add(null, (Command)new CmdDown());
                }
                menu.add(null, (Command)new CmdDelete());
            }
            menu.open((BWidget)this.getTable(), e.getX(), e.getY());
        }
    }
}

