/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.logging.LogSettings;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.log.AbstractLogger;

public final class NiagaraLogger
extends AbstractLogger {
    private final String loggerName;
    private final Logger logger;
    private static final String defaultLoggerName = "web.jetty";
    static final org.eclipse.jetty.util.log.Logger defaultLogger = new NiagaraLogger("web.jetty", Logger.getLogger("web.jetty"));
    private static final Map<String, Optional<org.eclipse.jetty.util.log.Logger>> loggerMap = Collections.synchronizedMap(new HashMap());
    private static Set<String> availableLogNames;
    private static final Logger jettyLoggerNames;

    private NiagaraLogger(String loggerName, Logger logger) {
        this.loggerName = loggerName;
        this.logger = logger;
    }

    public org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        if ((fullname = Objects.toString(fullname, "")).isEmpty()) {
            return defaultLogger;
        }
        if (jettyLoggerNames.isLoggable(Level.FINE)) {
            jettyLoggerNames.fine(fullname);
        }
        Optional log = loggerMap.computeIfAbsent(fullname, fname -> {
            if (availableLogNames == null) {
                availableLogNames = new HashSet<String>(new LogSettings().getDeclaredLogs());
            }
            String niagaraLogName = "web.jetty." + fname;
            return availableLogNames.stream().filter(s -> !s.isEmpty()).filter(niagaraLogName::startsWith).sorted(Comparator.reverseOrder()).findFirst().map(logName -> {
                if (jettyLoggerNames.isLoggable(Level.FINER)) {
                    jettyLoggerNames.finer("Using log " + logName + " for " + niagaraLogName);
                }
                return new NiagaraLogger((String)fname, Logger.getLogger(logName));
            });
        });
        return log.orElse(defaultLogger);
    }

    public String getName() {
        return this.loggerName;
    }

    public void warn(String msg, Object ... args) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, NiagaraLogger.format(msg, args));
        }
    }

    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    public void warn(String msg, Throwable thrown) {
        if (thrown instanceof Error) {
            this.logger.log(Level.SEVERE, msg, thrown);
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, msg, thrown);
        }
    }

    public void info(String msg, Object ... args) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, NiagaraLogger.format(msg, args));
        }
    }

    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    public void info(String msg, Throwable thrown) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, msg, thrown);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.logger.setLevel(Level.FINE);
        } else {
            this.logger.setLevel(Level.INFO);
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, NiagaraLogger.format(msg, args));
        }
    }

    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    public void debug(String msg, Throwable thrown) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, msg, thrown);
        }
    }

    public void ignore(Throwable ignored) {
    }

    private static String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        Thread currentThread = Thread.currentThread();
        if (currentThread != null) {
            builder.append(String.format("[%s/%s] ", currentThread.getName(), currentThread.getId()));
        }
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }

    static {
        jettyLoggerNames = Logger.getLogger("web.jettyLoggerNames");
    }
}

