/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.Session;

public class JettyDiagUtil {
    public static Map<String, Object> getProperties(HttpSession httpSession) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (httpSession != null) {
            valueMap.put("id", httpSession.getId());
            valueMap.put("servletContext", JettyDiagUtil.getProperties(httpSession.getServletContext()));
            if (httpSession instanceof Session) {
                Session session = (Session)httpSession;
                valueMap.put("contextPath", session.getContextPath());
                valueMap.put("valid", session.isValid());
                if (session.isValid()) {
                    valueMap.put("attributes", JettyDiagUtil.getEnumProperties(session.getAttributeNames(), arg_0 -> ((Session)session).getAttribute(arg_0)));
                }
            }
        }
        return valueMap;
    }

    private static Map<String, Object> getProperties(ServletContext servletContext) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (servletContext != null) {
            valueMap.put("servletContextName", servletContext.getServletContextName());
            valueMap.put("contextPath", servletContext.getContextPath());
            valueMap.put("attributes", JettyDiagUtil.getEnumProperties(servletContext.getAttributeNames(), arg_0 -> ((ServletContext)servletContext).getAttribute(arg_0)));
            valueMap.put("initParameters", JettyDiagUtil.getEnumProperties(servletContext.getInitParameterNames(), arg_0 -> ((ServletContext)servletContext).getInitParameter(arg_0)));
            valueMap.put("serverInfo", servletContext.getServerInfo());
            valueMap.put("sessionCookieConfig", servletContext.getSessionCookieConfig());
        }
        return valueMap;
    }

    private static Map<String, Object> getEnumProperties(Enumeration<String> keyEnum, Function<String, Object> valueFunction) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        while (keyEnum.hasMoreElements()) {
            String name = keyEnum.nextElement();
            valueMap.put(name, valueFunction.apply(name));
        }
        return valueMap;
    }
}

