/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.config;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
public final class BDataRecoveryPersistenceCapacity
extends BSimple {
    private static final int RESTRICT_NONE = 0;
    private static final int RESTRICT_STORAGE_SIZE = 1;
    public static final BDataRecoveryPersistenceCapacity UNLIMITED;
    public static final BDataRecoveryPersistenceCapacity DEFAULT;
    public static final Type TYPE;
    private static final LexiconText unlimitedTxt;
    private final int restrictBy;
    private final long max;
    private int hashCode = -1;

    public Type getType() {
        return TYPE;
    }

    public static BDataRecoveryPersistenceCapacity makeByStorageSize(long maxSize) {
        return (BDataRecoveryPersistenceCapacity)new BDataRecoveryPersistenceCapacity(1, maxSize).intern();
    }

    public static BDataRecoveryPersistenceCapacity makeUnlimited() {
        return UNLIMITED;
    }

    private BDataRecoveryPersistenceCapacity(int restrictBy, long maxBytes) {
        if (maxBytes < 0L) {
            throw new DataRecoveryException("Can not specify negative value for persistent storage capacity");
        }
        this.restrictBy = restrictBy;
        this.max = maxBytes;
    }

    public boolean isUnlimited() {
        return this.restrictBy == 0;
    }

    public boolean isByStorageSize() {
        return this.restrictBy == 1;
    }

    public long getMaxStorage() {
        if (this.restrictBy == 0) {
            return -1L;
        }
        return this.max;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + (long)this.restrictBy;
            hash = hash * 37L + this.max;
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BDataRecoveryPersistenceCapacity)) {
            return false;
        }
        BDataRecoveryPersistenceCapacity other = (BDataRecoveryPersistenceCapacity)((Object)o);
        return this.restrictBy == other.restrictBy && this.max == other.max;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.restrictBy);
        out.writeLong(this.max);
    }

    public BObject decode(DataInput in) throws IOException {
        int restrictBy = in.readInt();
        long max = in.readLong();
        return new BDataRecoveryPersistenceCapacity(restrictBy, max).intern();
    }

    public String encodeToString() {
        return String.valueOf(this.restrictBy) + ':' + this.max;
    }

    public BObject decodeFromString(String s) {
        int colon = s.indexOf(58);
        int restrictBy = Integer.parseInt(s.substring(0, colon));
        long max = Long.parseLong(s.substring(colon + 1));
        return new BDataRecoveryPersistenceCapacity(restrictBy, max).intern();
    }

    public String toString(Context cx) {
        if (this.restrictBy == 0) {
            return unlimitedTxt.getText(cx);
        }
        if (this.restrictBy == 1) {
            if (this.max >= 1024L) {
                return this.max / 1024L + " KB";
            }
            return this.max + " B";
        }
        return Long.toString(this.max);
    }

    static {
        DEFAULT = UNLIMITED = new BDataRecoveryPersistenceCapacity(0, 0L);
        TYPE = Sys.loadType(BDataRecoveryPersistenceCapacity.class);
        unlimitedTxt = LexiconText.make((String)"platDataRecovery", (String)"unlimited");
    }
}

