/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.cellrouter;

import com.lynxspring.cellrouter.BCellRouterService;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import java.io.File;
import java.util.concurrent.TimeoutException;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModemFirmwareUpdateJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BModemFirmwareUpdateJob.class);
    private BCellRouterService cellRouterService = null;
    private static final String UPDATE_TMP_DIR_ABS_PATH = "/tmp/onyxxPortForwardingResources/";
    private static final String MODEM_FIRMWARE_UPDATE_DIR = "ModemFirmware/";
    public static final Log log = Log.getLog((String)"Modem Firmware Update");

    public Type getType() {
        return TYPE;
    }

    public BModemFirmwareUpdateJob() {
    }

    public BModemFirmwareUpdateJob(BCellRouterService service) {
        this.cellRouterService = service;
    }

    public void doCancel(Context context) {
    }

    private void message(String msg) {
        this.log().message(msg);
        log.message(msg);
    }

    private void message(String msg, String detail) {
        this.log().message(msg, detail);
        log.message(msg);
    }

    public void run(Context context) throws Exception {
        String[] EXECUTABLE_FILE_NAMES = new String[]{"CheckForSerialPort.bash", "ModemFirmwareUpdate.bash", "glinswup_APLx"};
        int FINAL_MODEM_REBOOT_TIME_INCREMENT = 10000;
        int FINAL_MODEM_REBOOT_TIMEOUT = 600000;
        int FIRMWARE_UTIL_TIME_INCREMENT = 10000;
        int FIRMWARE_UTIL_TIMEOUT = 600000;
        int INITIAL_MODEM_REBOOT_TIME_INCREMENT = 10000;
        int INITIAL_MODEM_REBOOT_TIMEOUT = 60000;
        int stepNumber = 0;
        int numSteps = 0;
        String cmd = "";
        File initialRebootCompleteFile = null;
        String initialRebootCompleteStr = null;
        File percentCompleteFile = null;
        int percentCompleteInt = 0;
        String percentCompleteStr = null;
        int totalWaitTime = 0;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        this.setProgress(0);
        log.message("");
        log.message("---------------------------------------------------------------------------------");
        log.message("======                !! MODEM FIRMWARE UPDATE NEED DETECTED !!                --");
        log.message("======   The modem firmware was found to need an update.                       --");
        log.message("======   Job progress will be displayed below and output lines are             --");
        log.message("======   signified by \"======\".                                                --");
        log.message("---------------------------------------------------------------------------------");
        if (BCellRouterService.update_running) {
            Exception exception = new Exception("Modem firmware update is already running.");
            this.log().failed("Update already running", (Throwable)exception);
            log.message("======   ---> Modem Firmware Update: Update is already running; exiting now.");
            throw exception;
        }
        BCellRouterService.update_running = true;
        this.setProgress(5);
        log.message("======   ---> Modem Firmware Update Progress:  " + this.getProgress() + "%   --  Modem Firmware Upgrade Started...");
        ++stepNumber;
        this.transferTarBall();
        for (String name : EXECUTABLE_FILE_NAMES) {
            cmd = "chmod 755 /tmp/onyxxPortForwardingResources/ModemFirmware/" + name;
            this.cellRouterService.runCommand(cmd);
        }
        this.setProgress(100 / numSteps * stepNumber);
        log.message("======   ---> Modem Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Needed Files have been Unzipped...");
        this.log().success("Needed Files have been unzipped for modem firmware update");
        cmd = this.cellRouterService.running_on_Debian() ? "systemctl stop onyxx_cell.service" : "/etc/init.d/S96cell_daemon stop";
        this.cellRouterService.runCommand(cmd);
        Thread.sleep(5000L);
        this.setProgress(100 / numSteps * ++stepNumber);
        log.message("======   ---> Modem Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Cell Service Stopped...");
        this.log().success("Cell service stopped");
        ++stepNumber;
        log.message("======   ---> Power-cycling modem to prepare for update...");
        cmd = "/opt/lynxspring/bin/sm_shutdown_modem_power.sh";
        this.cellRouterService.runCommand(cmd);
        Thread.sleep(30000L);
        cmd = "/opt/lynxspring/bin/sm_startup_modem_power.sh";
        this.cellRouterService.runCommand(cmd);
        if (!this.cellRouterService.running_on_Debian()) {
            Thread.sleep(5000L);
            cmd = "/opt/lynxspring/bin/sm_activate_modem.sh";
            this.cellRouterService.runCommand(cmd);
        }
        cmd = "rm /home/niagara/shared/cell_daemon/modemip";
        this.cellRouterService.runCommand(cmd);
        cmd = "rm /home/niagara/shared/cell_daemon/modem_firmware_version";
        this.cellRouterService.runCommand(cmd);
        initialRebootCompleteFile = new File("/tmp/onyxxPortForwardingResources/ModemFirmware/modem_update_initial_reboot_complete");
        cmd = "nohup /bin/bash /tmp/onyxxPortForwardingResources/ModemFirmware/CheckForSerialPort.bash 60 " + initialRebootCompleteFile;
        this.cellRouterService.runCommand(cmd);
        for (totalWaitTime = 0; !initialRebootCompleteFile.exists() && totalWaitTime < 60000; totalWaitTime += 10000) {
            if (totalWaitTime > 0) {
                log.message("======     Still running, checking again in 10 seconds...");
            }
            Thread.sleep(10000L);
        }
        if (initialRebootCompleteFile.exists()) {
            initialRebootCompleteStr = OnyxxFileAccess.FileIO((String)initialRebootCompleteFile.getParent(), (String)initialRebootCompleteFile.getName(), (String)"", (boolean)false);
            if (initialRebootCompleteStr.equalsIgnoreCase("error")) {
                Exception exception = new Exception("An error occurred during the modem reboot.");
                this.log().failed("Error while waiting for modem to reboot", (Throwable)exception);
                log.message("======   #### ERROR:  MODEM FIRMWARE UPDATE FAILED!!! ####");
                log.message("======   #### Exiting Update Job... ####");
                BCellRouterService.update_running = false;
                throw exception;
            }
        } else if (totalWaitTime >= 60000) {
            TimeoutException timeoutException = new TimeoutException("Modem reboot exceeded allotted time.");
            this.log().failed("Modem did not reboot in the expected time", (Throwable)timeoutException);
            log.message("======   #### ERROR:  MODEM FIRMWARE UPDATE FAILED!!! ####");
            log.message("======   #### Exiting Update Job... ####");
            BCellRouterService.update_running = false;
            throw timeoutException;
        }
        this.setProgress(100 / numSteps * stepNumber);
        log.message("======   ---> Modem Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Modem Prepared for Update...");
        this.log().success("Modem prepared for update");
        ++stepNumber;
        cmd = "nohup /bin/bash /tmp/onyxxPortForwardingResources/ModemFirmware/ModemFirmwareUpdate.bash &";
        this.cellRouterService.runCommand(cmd);
        percentCompleteFile = new File("/tmp/onyxxPortForwardingResources/ModemFirmware/modem_update_percent_complete");
        log.message("======     ---> Initiating update process...");
        for (totalWaitTime = 0; !percentCompleteFile.exists() && totalWaitTime < 600000; totalWaitTime += 10000) {
            if (totalWaitTime > 0) {
                log.message("======     Still running, checking again in 10 seconds...");
            }
            Thread.sleep(10000L);
        }
        while (totalWaitTime < 600000) {
            try {
                percentCompleteStr = OnyxxFileAccess.FileIO((String)percentCompleteFile.getParent(), (String)percentCompleteFile.getName(), (String)"", (boolean)false);
                if (percentCompleteStr.equalsIgnoreCase("error")) {
                    Exception exception = new Exception("An error occurred while loading firmware onto the modem.");
                    this.log().failed("Error loading new firmware onto modem", (Throwable)exception);
                    log.message("======   #### ERROR:  MODEM FIRMWARE UPDATE FAILED!!! ####");
                    log.message("======   #### Exiting Update Job... ####");
                    BCellRouterService.update_running = false;
                    throw exception;
                }
                percentCompleteInt = Integer.parseInt(percentCompleteStr.trim());
                log.message("======     Modem update " + percentCompleteInt + " percent complete.");
                if (percentCompleteInt >= 100) {
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Thread.sleep(10000L);
            totalWaitTime += 10000;
        }
        if (totalWaitTime >= 600000) {
            TimeoutException timeoutException = new TimeoutException("Modem firmware load exceeded allotted time.");
            this.log().failed("Firmware upload to modem did not complete in the expected time", (Throwable)timeoutException);
            log.message("======   #### ERROR:  MODEM FIRMWARE UPDATE FAILED!!! ####");
            log.message("======   #### Exiting Update Job... ####");
            BCellRouterService.update_running = false;
            throw timeoutException;
        }
        this.setProgress(100 / numSteps * stepNumber);
        log.message("======   ---> Modem Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Firmware Loaded onto modem...");
        this.log().success("New firmware loaded onto modem");
        ++stepNumber;
        Thread.sleep(5000L);
        File file = new File("/tmp/onyxxPortForwardingResources/ModemFirmware/modem_update_complete");
        log.message("======   ---> Waiting for modem to reboot to complete update...");
        cmd = "nohup /bin/bash /tmp/onyxxPortForwardingResources/ModemFirmware/CheckForSerialPort.bash 600 " + file;
        this.cellRouterService.runCommand(cmd);
        for (totalWaitTime = 0; !file.exists() && totalWaitTime < 600000; totalWaitTime += 10000) {
            if (totalWaitTime > 0) {
                log.message("======     Still waiting, checking again in 10 seconds...");
            }
            Thread.sleep(10000L);
        }
        if (file.exists()) {
            String updateCompleteStr = OnyxxFileAccess.FileIO((String)file.getParent(), (String)file.getName(), (String)"", (boolean)false);
            if (updateCompleteStr.equalsIgnoreCase("error")) {
                Exception exception4 = new Exception("An error occurred during the modem reboot.");
                this.log().failed("Error while waiting for modem to reboot", (Throwable)exception4);
                log.message("======   #### ERROR:  MODEM FIRMWARE UPDATE FAILED!!! ####");
                log.message("======   #### Exiting Update Job... ####");
                BCellRouterService.update_running = false;
                throw exception4;
            }
        } else if (totalWaitTime >= 600000) {
            TimeoutException exception5 = new TimeoutException("Modem reboot exceeded allotted time.");
            this.log().failed("Modem did not reboot in the expected time", (Throwable)exception5);
            log.message("======   #### ERROR:  MODEM FIRMWARE UPDATE FAILED!!! ####");
            log.message("======   #### Exiting Update Job... ####");
            BCellRouterService.update_running = false;
            throw exception5;
        }
        this.setProgress(100 / numSteps * stepNumber);
        log.message("======   ---> Modem Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Modem has rebooted...");
        this.log().success("Modem has rebooted");
        cmd = this.cellRouterService.running_on_Debian() ? "systemctl restart onyxx_cell.service" : "/etc/init.d/S96cell_daemon start";
        this.cellRouterService.runCommand(cmd);
        this.setProgress(100 / numSteps * ++stepNumber);
        log.message("--------------------------------------------------------------------------------------");
        log.message("======                  ~~ MODEM FIRMWARE UPDATE HAS FINISHED ~~                    --");
        log.message("====== The modem is now rebooting in order to re-establish the cellular connection. --");
        log.message("====== Please navigate to the CellRouterService and verify that the new firmware    --");
        log.message("====== version is correct.                                                          --");
        log.message("--------------------------------------------------------------------------------------");
        log.message("");
        log.message("");
        this.log().success("Cell service restarted");
        BCellRouterService.update_running = false;
    }

    private void transferTarBall() {
        String cmd = null;
        String jarPath = "/opt/niagara/modules/onyxxPortForwarding-rt.jar";
        String resourcesPath = "/home/niagara/stations/" + Sys.getStation().getStationName() + "/resources";
        cmd = "rm -rf /tmp/onyxxPortForwardingResources/";
        this.cellRouterService.runCommand(cmd);
        cmd = "mkdir -p /tmp/onyxxPortForwardingResources/ModemFirmware/";
        this.cellRouterService.runCommand(cmd);
        cmd = this.cellRouterService.running_on_Debian() ? "/usr/lib/jvm/jdk1.8.0_101/bin/jar xf " + jarPath + " resources/" : "unzip -q -d . " + jarPath + " resources/*";
        this.cellRouterService.runCommand(cmd);
        cmd = "mv " + resourcesPath + "/* " + UPDATE_TMP_DIR_ABS_PATH;
        this.cellRouterService.runCommand(cmd);
        cmd = "tar xfz /tmp/onyxxPortForwardingResources/OnyxxUpdate_N4_ModemFirmwareJob.tar.gz -C /tmp/onyxxPortForwardingResources/ModemFirmware/";
        this.cellRouterService.runCommand(cmd);
        cmd = "rm -rf /opt/niagara/lib/updateLogs/ModemFirmware/";
        this.cellRouterService.runCommand(cmd);
        cmd = "mkdir -p /opt/niagara/lib/updateLogs/ModemFirmware/";
        this.cellRouterService.runCommand(cmd);
    }
}

