/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.cellrouter;

import com.lynxspring.cellrouter.BModemFirmwareUpdateJob;
import com.lynxspring.cellrouter.BRouteRule;
import com.lynxspring.cellrouter.whitelist.BAllowedIpAddress;
import com.lynxspring.cellrouter.whitelist.BWhitelistFolder;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.platOnyxx.BOnyxxPlatformService;
import com.tridium.fox.sys.BFoxService;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseManager;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="signalStrength", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="cellularIpAddress", type="String", defaultValue="\"\"", flags=3), @NiagaraProperty(name="activeApn", type="String", defaultValue="\"\"", flags=3), @NiagaraProperty(name="apnList", type="String", defaultValue="\"\"", flags=6, facets={@Facet(name="BFacets.MULTI_LINE", value="true"), @Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"onyxxPortForwarding:ApnListFE\")")}), @NiagaraProperty(name="apnListFileUpdateTime", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=7), @NiagaraProperty(name="allowControllerReboot", type="boolean", defaultValue="false", flags=2), @NiagaraProperty(name="fileSystemPollingInterval", type="BRelTime", defaultValue="BRelTime.make(10000)", flags=4), @NiagaraProperty(name="modemFirmwareVersion", type="String", defaultValue="\"\"", flags=3), @NiagaraProperty(name="whitelistEntries", type="BWhitelistFolder", defaultValue="new BWhitelistFolder()"), @NiagaraProperty(name="whitelistActive", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="runningOnHelixx", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="showWhitelistManagerOnHelixx", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="addRoute", parameterType="BRouteRule", defaultValue="new BRouteRule()"), @NiagaraAction(name="removeRoute", parameterType="BRouteRule", defaultValue="new BRouteRule()"), @NiagaraAction(name="addIpAddressToWhitelist", parameterType="BAllowedIpAddress", defaultValue="new BAllowedIpAddress()"), @NiagaraAction(name="removeIpAddressFromWhitelist", parameterType="BAllowedIpAddress", defaultValue="new BAllowedIpAddress()"), @NiagaraAction(name="enableIpWhitelist", flags=4), @NiagaraAction(name="disableIpWhitelist", flags=4), @NiagaraAction(name="licenseCheck", returnType="BBoolean", flags=4), @NiagaraAction(name="whitelistCheck", returnType="BBoolean", flags=4), @NiagaraAction(name="runModemFirmwareUpdate", flags=20)})
public final class BCellRouterService
extends BPlatformService {
    public static final Property signalStrength = BCellRouterService.newProperty((int)3, (int)0, null);
    public static final Property cellularIpAddress = BCellRouterService.newProperty((int)3, (String)"", null);
    public static final Property activeApn = BCellRouterService.newProperty((int)3, (String)"", null);
    public static final Property apnList = BCellRouterService.newProperty((int)6, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"multiLine", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"onyxxPortForwarding:ApnListFE"))));
    public static final Property apnListFileUpdateTime = BCellRouterService.newProperty((int)7, (BValue)BAbsTime.make((long)0L), null);
    public static final Property allowControllerReboot = BCellRouterService.newProperty((int)2, (boolean)false, null);
    public static final Property fileSystemPollingInterval = BCellRouterService.newProperty((int)4, (BValue)BRelTime.make((long)10000L), null);
    public static final Property modemFirmwareVersion = BCellRouterService.newProperty((int)3, (String)"", null);
    public static final Property whitelistEntries = BCellRouterService.newProperty((int)0, (BValue)new BWhitelistFolder(), null);
    public static final Property whitelistActive = BCellRouterService.newProperty((int)1, (boolean)false, null);
    public static final Property runningOnHelixx = BCellRouterService.newProperty((int)7, (boolean)false, null);
    public static final Property showWhitelistManagerOnHelixx = BCellRouterService.newProperty((int)4, (boolean)false, null);
    public static final Action addRoute = BCellRouterService.newAction((int)0, (BValue)new BRouteRule(), null);
    public static final Action removeRoute = BCellRouterService.newAction((int)0, (BValue)new BRouteRule(), null);
    public static final Action addIpAddressToWhitelist = BCellRouterService.newAction((int)0, (BValue)new BAllowedIpAddress(), null);
    public static final Action removeIpAddressFromWhitelist = BCellRouterService.newAction((int)0, (BValue)new BAllowedIpAddress(), null);
    public static final Action enableIpWhitelist = BCellRouterService.newAction((int)4, null);
    public static final Action disableIpWhitelist = BCellRouterService.newAction((int)4, null);
    public static final Action licenseCheck = BCellRouterService.newAction((int)4, null);
    public static final Action whitelistCheck = BCellRouterService.newAction((int)4, null);
    public static final Action runModemFirmwareUpdate = BCellRouterService.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BCellRouterService.class);
    final String ACTION_ADD = "-A";
    final String ACTION_INSERT = "-I";
    final String ACTION_REMOVE = "-D";
    final String PROTO_TCP = "tcp";
    final String PROTO_UDP = "udp";
    final String IPTABLES_SAVE_FILE = "/etc/iptables/rules.v4";
    public static final String[] NIAGARA_PORT_ARRAY = new String[]{"No", "Platform", "PlatformSSL", "Fox", "Foxs", "Http", "Https", "SSH"};
    final int MAX_RULES = 1000;
    public static final Lexicon lex = Lexicon.make(BCellRouterService.class);
    public static final String MODEM_IP_ADDRESS = "192.168.15.1";
    public static final String DAEMON_CONFIG_DIR_PATH = "/home/niagara/shared/cell_daemon/";
    public static final String APN_DEFAULT_LIST_FILE_NAME = "default_apnList";
    public static final String APN_LIST_FILE_NAME = "apnList";
    public static final String IP_ADDRESS_FILE_NAME = "modemip";
    public static final String MODEM_FIRMWARE_VERSION_FILE_NAME = "modem_firmware_version";
    public static final String REBOOT_CONFIG_FILE_NAME = "reboot.conf";
    public static final String SIGNAL_STRENGTH_FILE_NAME = "signal_strength_bars";
    public static final String CURRENT_MODEM_FIRMWARE_VERSION = "40869";
    static boolean update_running = false;
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BCellRouterService.class).getModuleName());
    public static Log COMM_LOG = Log.getLog((String)(Sys.getModuleForClass(BCellRouterService.class).getModuleName() + "Comm"));

    public int getSignalStrength() {
        return this.getInt(signalStrength);
    }

    public void setSignalStrength(int v) {
        this.setInt(signalStrength, v, null);
    }

    public String getCellularIpAddress() {
        return this.getString(cellularIpAddress);
    }

    public void setCellularIpAddress(String v) {
        this.setString(cellularIpAddress, v, null);
    }

    public String getActiveApn() {
        return this.getString(activeApn);
    }

    public void setActiveApn(String v) {
        this.setString(activeApn, v, null);
    }

    public String getApnList() {
        return this.getString(apnList);
    }

    public void setApnList(String v) {
        this.setString(apnList, v, null);
    }

    public BAbsTime getApnListFileUpdateTime() {
        return (BAbsTime)this.get(apnListFileUpdateTime);
    }

    public void setApnListFileUpdateTime(BAbsTime v) {
        this.set(apnListFileUpdateTime, (BValue)v, null);
    }

    public boolean getAllowControllerReboot() {
        return this.getBoolean(allowControllerReboot);
    }

    public void setAllowControllerReboot(boolean v) {
        this.setBoolean(allowControllerReboot, v, null);
    }

    public BRelTime getFileSystemPollingInterval() {
        return (BRelTime)this.get(fileSystemPollingInterval);
    }

    public void setFileSystemPollingInterval(BRelTime v) {
        this.set(fileSystemPollingInterval, (BValue)v, null);
    }

    public String getModemFirmwareVersion() {
        return this.getString(modemFirmwareVersion);
    }

    public void setModemFirmwareVersion(String v) {
        this.setString(modemFirmwareVersion, v, null);
    }

    public BWhitelistFolder getWhitelistEntries() {
        return (BWhitelistFolder)this.get(whitelistEntries);
    }

    public void setWhitelistEntries(BWhitelistFolder v) {
        this.set(whitelistEntries, (BValue)v, null);
    }

    public boolean getWhitelistActive() {
        return this.getBoolean(whitelistActive);
    }

    public void setWhitelistActive(boolean v) {
        this.setBoolean(whitelistActive, v, null);
    }

    public boolean getRunningOnHelixx() {
        return this.getBoolean(runningOnHelixx);
    }

    public void setRunningOnHelixx(boolean v) {
        this.setBoolean(runningOnHelixx, v, null);
    }

    public boolean getShowWhitelistManagerOnHelixx() {
        return this.getBoolean(showWhitelistManagerOnHelixx);
    }

    public void setShowWhitelistManagerOnHelixx(boolean v) {
        this.setBoolean(showWhitelistManagerOnHelixx, v, null);
    }

    public void addRoute(BRouteRule parameter) {
        this.invoke(addRoute, (BValue)parameter, null);
    }

    public void removeRoute(BRouteRule parameter) {
        this.invoke(removeRoute, (BValue)parameter, null);
    }

    public void addIpAddressToWhitelist(BAllowedIpAddress parameter) {
        this.invoke(addIpAddressToWhitelist, (BValue)parameter, null);
    }

    public void removeIpAddressFromWhitelist(BAllowedIpAddress parameter) {
        this.invoke(removeIpAddressFromWhitelist, (BValue)parameter, null);
    }

    public void enableIpWhitelist() {
        this.invoke(enableIpWhitelist, null, null);
    }

    public void disableIpWhitelist() {
        this.invoke(disableIpWhitelist, null, null);
    }

    public BBoolean licenseCheck() {
        return (BBoolean)this.invoke(licenseCheck, null, null);
    }

    public BBoolean whitelistCheck() {
        return (BBoolean)this.invoke(whitelistCheck, null, null);
    }

    public void runModemFirmwareUpdate() {
        this.invoke(runModemFirmwareUpdate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getLicenseVendor() {
        return "Lynxspring";
    }

    public String getLicenseFeature() {
        return BCellRouterService.lex.module.getModuleName();
    }

    public BBoolean doLicenseCheck() {
        return BBoolean.make((boolean)this.checkLicense());
    }

    public boolean checkLicense() {
        LicenseManager license = Sys.getLicenseManager();
        boolean licensed = false;
        try {
            license.checkFeature("Lynxspring", BCellRouterService.lex.module.getModuleName());
            licensed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return licensed;
    }

    public BBoolean doWhitelistCheck() {
        return BBoolean.make((boolean)this.getWhitelistActive());
    }

    public void serviceStarted() throws Exception {
        this.setPlatformServiceDescription("Lynxspring Cell Router Service");
        if (!this.checkLicense()) {
            super.serviceStopped();
            throw new FeatureNotLicensedException();
        }
        super.serviceStarted();
        this.setRunningOnHelixx(!this.running_on_Debian());
    }

    public void started() throws Exception {
        super.started();
        AccessController.doPrivileged(() -> {
            try {
                System.loadLibrary("onyxxportforwarding");
            }
            catch (Throwable e) {
                System.out.println("Unable to load npsdkjni native library");
                e.printStackTrace();
            }
            return null;
        });
        this.setAllowControllerReboot(this.readRebootConfig());
    }

    public boolean validateIpAddressFormat(String ipAddress) {
        String ipAddressRegex = "^(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}$";
        return ipAddress.matches(ipAddressRegex);
    }

    public void doAddRoute(BRouteRule newRoute) throws Exception {
        int niagaraPort;
        if (!this.isServiceStarted()) {
            throw new Exception("Service not started!");
        }
        int newPrivatePort = newRoute.getPrivatePort();
        int newPublicPort = newRoute.getPublicPort();
        String newDestinationIp = newRoute.getDestinationIp();
        if (!this.validateIpAddressFormat(newDestinationIp)) {
            throw new CannotValidateException("Failed to add route: " + newDestinationIp + " is not a valid IP address.");
        }
        if (newPrivatePort < 0) {
            newPrivatePort = newPublicPort;
        }
        if ((niagaraPort = this.isNiagaraPort(newRoute)) > 0) {
            String error = "Failed to add route: Public port matches the " + NIAGARA_PORT_ARRAY[niagaraPort] + " port.";
            throw new Exception(error);
        }
        if (this.checkRouteDuplicate(newRoute)) {
            String error = "Failed to add route: Conflicts with an existing route.";
            throw new Exception(error);
        }
        this.add(SlotPath.escape((String)newRoute.getRouteName()), (BValue)newRoute);
        String addRuleCmd = this.getIpTablesCommand("-A", "" + newPublicPort, newDestinationIp, "" + newPrivatePort);
        if (!this.runCommand(addRuleCmd)) {
            String error = "Error adding route: " + newDestinationIp + " --- Private Port: " + newPrivatePort + " --- Public Port: " + newPublicPort + "\n";
            throw new Exception(error);
        }
        this.saveIpTables();
    }

    public void doRemoveRoute(BRouteRule routeToRemove) throws Exception {
        if (!this.isServiceStarted()) {
            throw new Exception("Service not started!");
        }
        int publicPort = routeToRemove.getPublicPort();
        int privatePort = routeToRemove.getPrivatePort();
        String destinationIp = routeToRemove.getDestinationIp();
        if (!this.validateIpAddressFormat(destinationIp)) {
            throw new CannotValidateException("Failed to remove route: " + destinationIp + " is not a valid IP address.");
        }
        String deleteRuleCmd = this.getIpTablesCommand("-D", "" + publicPort, destinationIp, "" + privatePort);
        if (this.runCommand(deleteRuleCmd)) {
            this.lease();
            BValue val = this.get(SlotPath.escape((String)routeToRemove.getRouteName()));
            if (val != null && val.getType().is(BRouteRule.TYPE)) {
                ((BRouteRule)val).setRemovedViaAction(true);
                this.remove(SlotPath.escape((String)routeToRemove.getRouteName()));
            }
        } else {
            String error = "Failed to remove route.";
            throw new Exception(error);
        }
        this.saveIpTables();
    }

    public void doEnableIpWhitelist() throws Exception {
        this.setWhitelistActive(true);
        if (!this.getRunningOnHelixx()) {
            String command = this.getIpTablesPath() + " -A INPUT -i usb1 -j DROP && " + this.getIpTablesPath() + " -A FORWARD -i usb1 -j DROP";
            this.addAllWhitelistEntries();
            this.addWhitelistEntryToTable(MODEM_IP_ADDRESS, "22");
            if (!this.runCommand(command)) {
                String error = "Error enabling the Ip Address Whitelist.\n";
                throw new Exception(error);
            }
            this.saveIpTables();
        }
    }

    public void doDisableIpWhitelist() throws Exception {
        this.setWhitelistActive(false);
        if (!this.getRunningOnHelixx()) {
            String command = this.getIpTablesPath() + " -D INPUT -i usb1 -j DROP && " + this.getIpTablesPath() + " -D FORWARD -i usb1 -j DROP";
            this.removeAllWhitelistEntries();
            this.removeWhitelistEntryFromTable(MODEM_IP_ADDRESS, "22");
            if (!this.runCommand(command)) {
                String error = "Error disabling the Ip Address Whitelist.\n";
                throw new Exception(error);
            }
            this.saveIpTables();
        }
    }

    public void doAddIpAddressToWhitelist(BAllowedIpAddress newEntry) throws Exception {
        if (!this.isServiceStarted()) {
            throw new Exception("Service not started!");
        }
        String newAllowedIpAddress = newEntry.getAllowedIpAddress().trim();
        if (!this.validateIpAddressFormat(newAllowedIpAddress)) {
            throw new CannotValidateException("Failed to add route: " + newAllowedIpAddress + " is not a valid IP address.");
        }
        if (this.checkEntryDuplicate(newEntry)) {
            String error = "Failed to add entry: Conflicts with an existing whitelist entry.";
            throw new Exception(error);
        }
        this.getWhitelistEntries().add(newEntry.getAddressName(), (BValue)newEntry);
        if (this.getWhitelistActive() && !this.getRunningOnHelixx()) {
            this.addWhitelistEntryToTable(newAllowedIpAddress);
            this.saveIpTables();
        }
    }

    public void doRemoveIpAddressFromWhitelist(BAllowedIpAddress oldEntry) throws Exception {
        if (!this.isServiceStarted()) {
            throw new Exception("Service not started!");
        }
        String oldAllowedIpAddress = oldEntry.getAllowedIpAddress();
        if (!this.validateIpAddressFormat(oldAllowedIpAddress)) {
            throw new CannotValidateException("Failed to remove route: " + oldAllowedIpAddress + " is not a valid IP address.");
        }
        this.lease(2);
        BValue val = this.getWhitelistEntries().get(oldEntry.getAddressName());
        if (val != null && val.getType().is(BAllowedIpAddress.TYPE)) {
            ((BAllowedIpAddress)val).setRemovedViaAction(true);
            this.getWhitelistEntries().remove(oldEntry.getAddressName());
        }
        if (this.getWhitelistActive() && !this.getRunningOnHelixx()) {
            this.removeWhitelistEntryFromTable(oldAllowedIpAddress);
            this.saveIpTables();
        }
    }

    private void saveIpTables() {
        if (this.runCommand(this.getIpTablesSavePath() + " > " + "/etc/iptables/rules.v4")) {
            if (this.runCommand("sync")) {
                Sys.getStation().save();
                LOG.trace("IP Table Sync successful.");
            } else {
                LOG.error("Ip Table sync failed.");
            }
        } else {
            LOG.error("Ip Table failed to save.");
        }
    }

    private void addAllWhitelistEntries() throws Exception {
        BAllowedIpAddress[] entryArray;
        this.lease(3);
        for (BAllowedIpAddress entry : entryArray = (BAllowedIpAddress[])this.getWhitelistEntries().getChildren(BAllowedIpAddress.class)) {
            this.addWhitelistEntryToTable(entry.getAllowedIpAddress());
        }
    }

    private void removeAllWhitelistEntries() throws Exception {
        BAllowedIpAddress[] entryArray;
        this.lease(3);
        for (BAllowedIpAddress entry : entryArray = (BAllowedIpAddress[])this.getWhitelistEntries().getChildren(BAllowedIpAddress.class)) {
            this.removeWhitelistEntryFromTable(entry.getAllowedIpAddress());
        }
    }

    private void addWhitelistEntryToTable(String newEntry) throws Exception {
        this.addWhitelistEntryToTable(newEntry, "");
    }

    private void addWhitelistEntryToTable(String newEntry, String sport) throws Exception {
        String addEntryCmd = this.getIpWhitelistCommand("-I", newEntry, sport);
        if (!this.runCommand(addEntryCmd)) {
            String error = "Error adding whitelist entry: " + newEntry + (!sport.isEmpty() ? ":" + sport : "") + "\n";
            throw new Exception(error);
        }
    }

    private void removeWhitelistEntryFromTable(String oldIpAddress) throws Exception {
        this.removeWhitelistEntryFromTable(oldIpAddress, "");
    }

    private void removeWhitelistEntryFromTable(String oldIpAddress, String sport) throws Exception {
        String removeEntryCmd = this.getIpWhitelistCommand("-D", oldIpAddress, sport);
        if (!this.runCommand(removeEntryCmd)) {
            String error = "Failed to remove route.";
            throw new Exception(error);
        }
    }

    public String getIpTablesPath() {
        if (!this.getRunningOnHelixx()) {
            return "/sbin/iptables";
        }
        return "/usr/sbin/iptables";
    }

    public String getIpTablesSavePath() {
        if (!this.getRunningOnHelixx()) {
            return "/sbin/iptables-save";
        }
        return "/usr/sbin/iptables-save";
    }

    public String getIpTablesCommand(String action, String sport, String ip, String dport) {
        return this.getRouteCommand(action, "tcp", sport, ip, dport) + " && " + this.getRouteCommand(action, "udp", sport, ip, dport);
    }

    public String getRouteCommand(String action, String proto, String sport, String ip, String dport) {
        return this.getIpTablesPath() + " -t nat " + action + " PREROUTING -i usb1 -p " + proto + " --dport " + sport + " -j DNAT --to " + ip + (!dport.isEmpty() ? ":" + dport : "");
    }

    public String getIpWhitelistCommand(String action, String ip, String sport) {
        String sportSubstring = !sport.isEmpty() ? "-p tcp --source-port " + sport + " " : "";
        return this.getIpTablesPath() + " " + action + " INPUT -i usb1 -s " + ip + " " + sportSubstring + "-j ACCEPT && " + this.getIpTablesPath() + " " + action + " FORWARD -i usb1 -s " + ip + " " + sportSubstring + "-j ACCEPT";
    }

    protected boolean runCommand(String cmd) {
        try {
            if (this.processStringInput0(cmd) < 0) {
                throw new Exception();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                BOnyxxPlatformService service = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
                service.getClass().getMethod("doFwSndCmd", String.class).invoke((Object)service, cmd);
            }
            catch (Exception e) {
                COMM_LOG.trace("Error when trying to run Linux command", (Throwable)e);
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when running the command: " + cmd);
            e.printStackTrace();
            return false;
        }
        COMM_LOG.trace("Executed Linux command: " + cmd);
        return true;
    }

    public boolean checkRouteDuplicate(BRouteRule routeRuleToCheck) {
        BRouteRule[] routeArray;
        for (BRouteRule route : routeArray = (BRouteRule[])this.getChildren(BRouteRule.class)) {
            if (route.getPublicPort() != routeRuleToCheck.getPublicPort()) continue;
            return true;
        }
        return false;
    }

    public boolean checkEntryDuplicate(BAllowedIpAddress whitelistEntryToCheck) {
        BAllowedIpAddress[] entryArray;
        for (BAllowedIpAddress entry : entryArray = (BAllowedIpAddress[])this.getWhitelistEntries().getChildren(BAllowedIpAddress.class)) {
            if (entry.getAllowedIpAddress() != whitelistEntryToCheck.getAllowedIpAddress()) continue;
            return true;
        }
        return false;
    }

    public int isNiagaraPort(BRouteRule routeRuleToCheck) {
        BPlatformServiceContainer psc = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        BSystemPlatformService sps = (BSystemPlatformService)psc.get("SystemService");
        BFoxService fs = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        BWebService ws = (BWebService)Sys.getService((Type)BWebService.TYPE);
        int publicPort = routeRuleToCheck.getPublicPort();
        if (sps != null) {
            if (publicPort == sps.getLocalDaemonPort()) {
                return 1;
            }
            if (publicPort == sps.getLocalDaemonSslPort()) {
                return 2;
            }
        }
        if (fs != null) {
            if (publicPort == fs.getFoxPort().getPublicServerPort()) {
                return 3;
            }
            if (publicPort == fs.getFoxsPort().getPublicServerPort()) {
                return 4;
            }
        }
        if (ws != null) {
            if (publicPort == ws.getHttpPort().getPublicServerPort()) {
                return 5;
            }
            if (publicPort == ws.getHttpsPort().getPublicServerPort()) {
                return 6;
            }
        }
        if (publicPort == 22) {
            return 7;
        }
        return 0;
    }

    protected boolean startPollTimerOnSubscribe() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) return;
        if (prop == apnList) {
            String modifiedApnListStr = BCellRouterService.sanitizeApnList(this.getApnList());
            if (modifiedApnListStr.isEmpty()) {
                try {
                    modifiedApnListStr = this.readApnListFile(new File(DAEMON_CONFIG_DIR_PATH, APN_DEFAULT_LIST_FILE_NAME));
                }
                catch (Exception e) {
                    COMM_LOG.error("Error setting default APN list to default: ", (Throwable)e);
                    return;
                }
            }
            if (!modifiedApnListStr.equals(this.getApnList())) {
                this.setApnList(modifiedApnListStr);
                return;
            } else {
                try {
                    String currentApnListFileContents = this.readApnListFile();
                    if (currentApnListFileContents == null || this.getApnList().trim().equals(currentApnListFileContents.trim())) return;
                    OnyxxFileAccess.FileIO((String)DAEMON_CONFIG_DIR_PATH, (String)APN_LIST_FILE_NAME, (String)modifiedApnListStr, (boolean)true);
                    this.setActiveApn(modifiedApnListStr.split("\n")[0]);
                    this.runCommand("systemctl restart onyxx_cell.service");
                    return;
                }
                catch (Exception e) {
                    COMM_LOG.error("Error when updating APN list: ", (Throwable)e);
                    return;
                }
            }
        }
        if (prop != allowControllerReboot) return;
        try {
            if (this.getAllowControllerReboot()) {
                OnyxxFileAccess.FileIO((String)DAEMON_CONFIG_DIR_PATH, (String)REBOOT_CONFIG_FILE_NAME, (String)"1", (boolean)true);
                return;
            } else {
                OnyxxFileAccess.FileIO((String)DAEMON_CONFIG_DIR_PATH, (String)REBOOT_CONFIG_FILE_NAME, (String)"0", (boolean)true);
            }
            return;
        }
        catch (Exception e) {
            COMM_LOG.error("Error when updating reboot configuration: ", (Throwable)e);
        }
    }

    public static String sanitizeApnList(String incomingApnList) {
        String[] apnListArray = null;
        StringBuilder modifiedApnListBuilder = null;
        String trimmedApnStr = null;
        apnListArray = incomingApnList.split("\n");
        modifiedApnListBuilder = new StringBuilder();
        for (int i = 0; i < apnListArray.length; ++i) {
            trimmedApnStr = apnListArray[i].trim();
            modifiedApnListBuilder.append(trimmedApnStr);
            if (trimmedApnStr.length() <= 0) continue;
            modifiedApnListBuilder.append("\n");
        }
        return modifiedApnListBuilder.toString();
    }

    private String readApnListFile() throws Exception {
        return this.readApnListFile(new File(DAEMON_CONFIG_DIR_PATH, APN_LIST_FILE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readApnListFile(File apnListFile) throws Exception {
        BufferedReader br = null;
        StringBuffer strBuf = new StringBuffer();
        String strFromFile = null;
        try {
            if (apnListFile.exists()) {
                br = new BufferedReader(new FileReader(apnListFile));
                strFromFile = br.readLine();
                int i = 0;
                while (strFromFile != null) {
                    if (strBuf.length() != 0) {
                        strBuf.append("\n");
                    }
                    strBuf.append(strFromFile);
                    ++i;
                    strFromFile = br.readLine();
                }
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when reading APN list: ", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occurred during buffered reader close method");
            }
        }
        return strBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readRebootConfig() throws Exception {
        BufferedReader br = null;
        StringBuffer strBuf = new StringBuffer();
        String strFromFile = null;
        boolean result = false;
        try {
            block13: {
                File rebootConfigFile = new File(DAEMON_CONFIG_DIR_PATH, REBOOT_CONFIG_FILE_NAME);
                if (!rebootConfigFile.exists()) break block13;
                br = new BufferedReader(new FileReader(rebootConfigFile));
                strFromFile = br.readLine();
                if (strFromFile == null) break;
                if (strFromFile.trim().equals("1")) {
                    result = true;
                    return result;
                }
                break;
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when reading reboot config: ", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occurred during buffered reader close method");
            }
            return result;
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning() && property.getType().is(BRouteRule.TYPE)) {
            BRouteRule routeRule = (BRouteRule)oldValue;
            routeRule.lease();
            if (!routeRule.getRemovedViaAction()) {
                this.invoke(removeRoute, (BValue)routeRule);
            }
        }
        super.removed(property, oldValue, context);
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) || parent.getType().is(BFolder.TYPE) && !this.isRunning();
    }

    public void doPoll(Context cx) {
        super.doPoll(cx);
        try {
            if (new File(DAEMON_CONFIG_DIR_PATH, SIGNAL_STRENGTH_FILE_NAME).exists()) {
                try {
                    String textValue = OnyxxFileAccess.FileIO((String)DAEMON_CONFIG_DIR_PATH, (String)SIGNAL_STRENGTH_FILE_NAME, (String)"", (boolean)false);
                    this.setSignalStrength(new Integer(textValue));
                }
                catch (NullPointerException npe) {
                    this.setSignalStrength(0);
                    COMM_LOG.error("Error when obtaining signal strength: ", (Throwable)npe);
                    npe.printStackTrace();
                }
            } else {
                this.setSignalStrength(0);
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when obtaining signal strength: ", (Throwable)e);
            e.printStackTrace();
            return;
        }
        try {
            if (new File(DAEMON_CONFIG_DIR_PATH, IP_ADDRESS_FILE_NAME).exists()) {
                try {
                    this.setCellularIpAddress(OnyxxFileAccess.FileIO((String)DAEMON_CONFIG_DIR_PATH, (String)IP_ADDRESS_FILE_NAME, (String)"", (boolean)false));
                }
                catch (NullPointerException e) {}
            } else {
                this.setCellularIpAddress("Loading...");
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when obtaining cellular IP address: ", (Throwable)e);
            e.printStackTrace();
            return;
        }
        try {
            if (new File(DAEMON_CONFIG_DIR_PATH, MODEM_FIRMWARE_VERSION_FILE_NAME).exists()) {
                try {
                    this.setModemFirmwareVersion(OnyxxFileAccess.FileIO((String)DAEMON_CONFIG_DIR_PATH, (String)MODEM_FIRMWARE_VERSION_FILE_NAME, (String)"", (boolean)false));
                }
                catch (NullPointerException e) {}
            } else {
                this.setModemFirmwareVersion("Loading...");
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when obtaining cellular IP address: ", (Throwable)e);
            e.printStackTrace();
            return;
        }
        try {
            File apnListFile = new File(DAEMON_CONFIG_DIR_PATH, APN_LIST_FILE_NAME);
            if (apnListFile.exists()) {
                String newApnListFileContents;
                BAbsTime oldApnListFileUpdateTime = this.getApnListFileUpdateTime();
                this.setApnListFileUpdateTime(BAbsTime.make((long)apnListFile.lastModified()));
                if (this.getApnListFileUpdateTime().compareTo((Object)oldApnListFileUpdateTime) > 0 && (newApnListFileContents = this.readApnListFile()) != null && !this.getApnList().trim().equals(newApnListFileContents.trim())) {
                    this.setActiveApn(newApnListFileContents.split("\n")[0]);
                    this.setApnList(newApnListFileContents);
                }
            }
        }
        catch (Exception e) {
            COMM_LOG.error("Error when checking for changes in APN-list file.");
            e.printStackTrace();
        }
    }

    public BRelTime getPollFrequency() {
        return this.getFileSystemPollingInterval();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public AgentList getAgents(Context cx) {
        AgentList agentList = super.getAgents(cx);
        if (this.getRunningOnHelixx() && !this.getShowWhitelistManagerOnHelixx()) {
            AgentInfo ipWhitelistManagerAgent = null;
            for (AgentInfo ai : agentList) {
                if (!ai.getAgentType().getTypeName().equals("IpWhitelistManager")) continue;
                ipWhitelistManagerAgent = ai;
                break;
            }
            if (ipWhitelistManagerAgent != null) {
                agentList.remove(ipWhitelistManagerAgent);
            }
        }
        return agentList;
    }

    public void doRunModemFirmwareUpdate() {
        if (!this.getModemFirmwareVersion().equals(CURRENT_MODEM_FIRMWARE_VERSION)) {
            BJobService.getService().submit((BJob)new BModemFirmwareUpdateJob(this), this.getSession().getSessionContext());
        } else {
            LOG.message(" ");
            LOG.message("------------------------------------------------------------------------------------------");
            LOG.message("            >>>>>>>>>  No Modem Updates Needed At This Time  <<<<<<<<<");
            LOG.message("------------------------------------------------------------------------------------------");
            LOG.message(" ");
        }
    }

    boolean running_on_Debian() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv("helixx");
            }
        }) == null;
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        if (this.get(property).getType().is(BRouteRule.TYPE)) {
            BRouteRule curRouteRule = (BRouteRule)this.get(property);
            curRouteRule.setRouteName(curRouteRule.getName());
        }
    }

    private native int processStringInput0(String var1);
}

