/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.messages;

import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.maxpro.camera.BMaxproCameraDeviceId;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.Clock;

public class MaxproVideoStreamReq
extends NMessage {
    public static final int[] SLOW_FWD_RWD_FACTOR_ARRAY = new int[]{90, 80, 70, 60, 50, 40, 30, 20, 10, 5};
    public static final int[] FFWD_RWD_FACTOR_ARRAY = new int[]{200, 400, 600, 800, 1000, 3000, 6000, 60000, 120000, 240000};
    protected MaxproPlaybackInputStream playbackInputStream;
    private int requestId = -1;
    protected IVideoDestination videoDestination;
    protected BPlaybackParams playbackParams;
    protected BIVideoSource videoSource;

    public String getMaxproCameraId() {
        return "" + ((BMaxproCameraDeviceId)this.getMaxproCamera().get("videoDeviceId")).getCameraId();
    }

    public BMaxproCamera getMaxproCamera() {
        return (BMaxproCamera)this.getVideoSource();
    }

    public void setPlaybackParams(BPlaybackParams playbackParams) {
        this.playbackParams = playbackParams;
    }

    public BPlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    public void setVideoDestination(IVideoDestination videoDestination) {
        this.videoDestination = videoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource videoSource) {
        this.videoSource = videoSource;
    }

    public class MaxproPlaybackInputStream
    extends InputStream {
        protected InputStream videoSocketInput;
        protected ByteBuffer headerBuf;
        protected int contentLength = -1;
        protected int remainingContentBytes = -1;
        protected long frameMillis = -1L;
        protected long lastRequestedMillis = -1L;
        protected long nextFrameMillis = Long.MIN_VALUE;
        protected long prevFrameMillis = Long.MAX_VALUE;
        protected boolean paused = false;
        protected long ticksBeforeRequestingFrameInPlaybackMode = -1L;
        protected boolean firstHeader = true;
        public long lastDelta = -1L;

        public MaxproPlaybackInputStream() throws IOException {
            this.headerBuf = new ByteBuffer();
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int from, int len) throws IOException {
            if (this.paused) {
                return -1;
            }
            if (this.headerBuf.available() > 0) {
                return this.headerBuf.read(buf, from, len);
            }
            if (this.remainingContentBytes > 0) {
                int n = this.videoSocketInput.read(buf, from, len);
                if (n > 0) {
                    this.remainingContentBytes -= n;
                    if (this.remainingContentBytes <= 0) {
                        this.requestNextFrame();
                    }
                } else {
                    this.requestNextFrame();
                }
                return n;
            }
            this.readVideoFrameHeader();
            return this.headerBuf.read(buf, from, len);
        }

        @Override
        public int read() throws IOException {
            if (this.paused) {
                return -1;
            }
            if (this.headerBuf.available() > 0) {
                int retVal = this.headerBuf.read();
                return retVal;
            }
            if (this.remainingContentBytes > 0) {
                if (this.remainingContentBytes == this.contentLength) {
                    // empty if block
                }
                --this.remainingContentBytes;
                int nextJpegByte = this.videoSocketInput.read();
                if (nextJpegByte != -1 && this.remainingContentBytes == 0) {
                    this.requestNextFrame();
                }
                return nextJpegByte;
            }
            this.readVideoFrameHeader();
            int retVal = this.headerBuf.read();
            return retVal;
        }

        public void requestNextFrame() throws IOException {
            long nextMillis = -1L;
            long realTimeSleep = 100L;
            if (this.lastRequestedMillis == -1L) {
                this.lastRequestedMillis = this.frameMillis;
            }
            long rBefore = Clock.ticks();
            if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.play) {
                nextMillis = this.frameMillis + 100L;
                if (nextMillis < this.nextFrameMillis) {
                    nextMillis = this.nextFrameMillis;
                }
                this.ticksBeforeRequestingFrameInPlaybackMode = Clock.ticks();
                realTimeSleep = 0L;
            } else if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.fastFwd) {
                nextMillis = this.frameMillis + (long)FFWD_RWD_FACTOR_ARRAY[MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis < this.nextFrameMillis) {
                    nextMillis = this.nextFrameMillis;
                }
            } else if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.slowFwd) {
                nextMillis = this.lastRequestedMillis + (long)SLOW_FWD_RWD_FACTOR_ARRAY[MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis < this.nextFrameMillis && nextMillis - this.nextFrameMillis > 2000L) {
                    nextMillis = this.nextFrameMillis;
                }
            } else if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.fastRew) {
                nextMillis = this.frameMillis - (long)FFWD_RWD_FACTOR_ARRAY[MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis > this.prevFrameMillis) {
                    nextMillis = this.prevFrameMillis;
                }
            } else if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.slowRew) {
                nextMillis = this.lastRequestedMillis - (long)SLOW_FWD_RWD_FACTOR_ARRAY[MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis > this.prevFrameMillis && nextMillis - this.prevFrameMillis > 2000L) {
                    nextMillis = this.prevFrameMillis;
                }
            } else {
                if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.pause) {
                    this.paused = true;
                    return;
                }
                throw new IllegalStateException("The program should not have flowed to this line of code.");
            }
            String nextXml = "";
            this.lastRequestedMillis = nextMillis;
            long rAfter = Clock.ticks();
            long sleepTime = realTimeSleep - (rAfter - rBefore);
            if (sleepTime > 10L) {
                try {
                    Thread.sleep(realTimeSleep - (rAfter - rBefore));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted while sleeping to simulate the real time Milestone video stream.");
                }
            }
        }

        protected String readHeaderLine() throws IOException {
            int b;
            StringBuilder sb = new StringBuilder();
            int b1 = b = this.videoSocketInput.read();
            int b2 = -1;
            while (b1 != 10 || b2 != 13) {
                if (b == -1) {
                    throw new EOFException("End of video input stream while reading line of text.");
                }
                this.headerBuf.write(b);
                sb.append((char)b);
                b = this.videoSocketInput.read();
                b2 = b1;
                b1 = b;
            }
            this.headerBuf.write(b);
            String retVal = sb.toString().trim();
            return retVal;
        }

        public void readVideoFrameHeader() throws IOException {
            this.contentLength = -1;
            this.remainingContentBytes = -1;
            String nextLine = this.readHeaderLine();
            boolean imageResponseLineFound = false;
            if (this.firstHeader) {
                imageResponseLineFound = true;
                this.firstHeader = false;
            }
            while (!imageResponseLineFound || nextLine != null && nextLine.length() > 0) {
                if (nextLine.startsWith("Content-length:")) {
                    this.remainingContentBytes = this.contentLength = Integer.parseInt(nextLine.substring(15).trim());
                } else if (!imageResponseLineFound && nextLine.startsWith("ImageResponse")) {
                    imageResponseLineFound = true;
                } else if (nextLine.startsWith("Current:")) {
                    this.frameMillis = Long.parseLong(nextLine.substring(8).trim());
                } else if (nextLine.startsWith("Next:")) {
                    this.nextFrameMillis = Long.parseLong(nextLine.substring(5).trim());
                } else if (nextLine.startsWith("Prev:")) {
                    this.prevFrameMillis = Long.parseLong(nextLine.substring(5).trim());
                }
                nextLine = this.readHeaderLine();
            }
            if (MaxproVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.play && this.ticksBeforeRequestingFrameInPlaybackMode >= 0L) {
                try {
                    long transitTime = Clock.ticks() - this.ticksBeforeRequestingFrameInPlaybackMode;
                    long sleepTime = this.frameMillis - this.prevFrameMillis - transitTime;
                    if (sleepTime > 1000L) {
                        sleepTime = 1000L;
                    }
                    if (sleepTime > 10L) {
                        Thread.sleep(Math.round((double)sleepTime * 0.8));
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted while sleeping to simulated Milestone playback timing.");
                }
            }
            if (this.contentLength == -1) {
                throw new IllegalStateException("Error reading milestone image header.");
            }
        }
    }

    public class MaxproPlaybackStream
    implements IVideoStream {
        public void closeVideoStream() throws IOException {
        }

        public InputStream getInputStream() {
            return MaxproVideoStreamReq.this.playbackInputStream;
        }

        public BPlaybackParams getPlaybackParams() {
            return MaxproVideoStreamReq.this.getPlaybackParams();
        }
    }
}

