/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import com.tridium.net.ChunkedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends InputStream {
    private InputStream in;
    private boolean finiteLength;
    private int maxBytes;
    private int bytesRead;

    public HttpInputStream(InputStream in) {
        this(in, false);
    }

    public HttpInputStream(InputStream in, int contentLength) {
        this.in = in;
        this.maxBytes = contentLength;
        this.finiteLength = contentLength >= 0;
    }

    public HttpInputStream(InputStream in, boolean chunked) {
        this.finiteLength = false;
        this.in = chunked ? new ChunkedInputStream(in) : in;
    }

    @Override
    public int read() throws IOException {
        if (this.finiteLength && this.bytesRead == this.maxBytes) {
            return -1;
        }
        int byteVal = this.in.read();
        if (this.finiteLength) {
            ++this.bytesRead;
        }
        return byteVal;
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.finiteLength && this.bytesRead == this.maxBytes) {
            return -1;
        }
        int toRead = len;
        if (this.finiteLength) {
            toRead = Math.min(this.maxBytes - this.bytesRead, toRead);
        }
        int thisRead = this.in.read(buf, offset, toRead);
        if (this.finiteLength) {
            this.bytesRead += thisRead;
        }
        return thisRead;
    }

    @Override
    public void close() {
        this.finiteLength = true;
        this.bytesRead = this.maxBytes;
    }
}

