/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import com.tridium.net.HttpHeader;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final InputStream in;
    private byte[] chunk;
    private int chunkOffset;
    private HttpHeader entityHeaders;
    private boolean eof;

    public ChunkedInputStream(InputStream in) {
        this.in = in;
        this.eof = false;
    }

    @Override
    public int read() throws IOException {
        return this.chunkRead();
    }

    private int consumeChunk(byte[] buf, int offset, int numToRead) {
        int numRemainingBytesInChunk = this.chunk.length - this.chunkOffset;
        if (numRemainingBytesInChunk >= numToRead) {
            System.arraycopy(this.chunk, this.chunkOffset, buf, offset, numToRead);
            if (numRemainingBytesInChunk == numToRead) {
                this.chunk = null;
                this.chunkOffset = 0;
            } else {
                this.chunkOffset += numToRead;
            }
            return numToRead;
        }
        System.arraycopy(this.chunk, this.chunkOffset, buf, offset, numRemainingBytesInChunk);
        this.chunk = null;
        this.chunkOffset = 0;
        return numRemainingBytesInChunk;
    }

    @Override
    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        if (numToRead > 0) {
            if (this.chunk != null) {
                return this.consumeChunk(buf, offset, numToRead);
            }
            int nextByte = this.chunkRead();
            if (nextByte == -1) {
                this.eof = true;
                return -1;
            }
            buf[offset] = (byte)nextByte;
            if (this.chunk == null || this.chunk.length == 1 || numToRead == 1) {
                return 1;
            }
            return 1 + this.consumeChunk(buf, offset + 1, numToRead - 1);
        }
        return 0;
    }

    protected int chunkRead() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.chunk == null) {
            StringBuilder chunkBuilder = new StringBuilder(8);
            int ch = this.in.read();
            while (ch != -1 && ch != 13 && ch != 32) {
                chunkBuilder.append((char)ch);
                ch = this.in.read();
            }
            while (ch == 32) {
                ch = this.in.read();
            }
            ch = this.match(ch, 13);
            this.check(ch, 10);
            int chunkSize = Integer.parseInt(chunkBuilder.toString(), 16);
            this.chunk = new byte[chunkSize];
            this.chunkOffset = 0;
            if (chunkSize != 0) {
                int readBytes;
                int total = 0;
                do {
                    if ((readBytes = this.in.read(this.chunk, total, this.chunk.length - total)) == -1) continue;
                    total += readBytes;
                } while (readBytes != -1 && total < this.chunk.length);
                ch = this.in.read();
                ch = this.match(ch, 13);
                this.check(ch, 10);
            } else {
                this.readFooter();
            }
        }
        if (this.chunkOffset == this.chunk.length) {
            this.eof = true;
            return -1;
        }
        int byteVal = this.chunk[this.chunkOffset++] & 0xFF;
        if (this.chunkOffset == this.chunk.length) {
            this.chunk = null;
        }
        return byteVal;
    }

    protected void readFooter() throws IOException {
        this.entityHeaders = new HttpHeader();
        this.entityHeaders.read(this.in);
    }

    protected int match(int ch, int target) throws IOException {
        if (ch != target) {
            throw new IOException("Expecting " + this.charToString(target) + ".");
        }
        return this.in.read();
    }

    protected void check(int ch, int target) throws IOException {
        if (ch != target) {
            throw new IOException("Expecting " + this.charToString(target) + ".");
        }
    }

    private String charToString(int ch) {
        if (ch == 13) {
            return "\\n";
        }
        if (ch == 10) {
            return "\\r";
        }
        return String.valueOf((char)ch);
    }

    public HttpHeader getEntityHeaders() {
        return this.entityHeaders;
    }
}

