/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.util;

import com.tridium.box.BServerSession;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import java.security.AccessController;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.web.WebOp;

public abstract class UndoableRecord {
    private final String id;
    private static final int DEFAULT_MAX_UNDO_HISTORY_SIZE = 5;
    public static final int MAX_UNDO_HISTORY_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.transfer.maxUndoHistory", 5));
    private static final Random RAND = new Random();

    protected UndoableRecord(BoxOp op) {
        this.id = UndoableRecord.nextId(this, op);
    }

    public abstract void undoTransfer(BoxWriter var1) throws Exception;

    public abstract Set<String> getAffectedSpaceOrds();

    public String getId() {
        return this.id;
    }

    public static Optional<UndoableRecord> get(String id, BoxOp op) {
        return UndoableRecord.getUndoableRecords(op).map(records -> (UndoableRecord)records.get(id));
    }

    private static String nextId(UndoableRecord record, BoxOp op) {
        return UndoableRecord.getUndoableRecords(op).map(records -> ((SizeLimitedUndoMap)records).nextId()).orElseGet(() -> Integer.toHexString(System.identityHashCode(record)));
    }

    public static void put(UndoableRecord record, BoxOp op) {
        UndoableRecord.getUndoableRecords(op).ifPresent(records -> records.put(record.getId(), record));
    }

    public static void del(String key, BoxOp op) {
        UndoableRecord.getUndoableRecords(op).ifPresent(records -> {
            UndoableRecord cfr_ignored_0 = (UndoableRecord)records.remove(key);
        });
    }

    private static Optional<SizeLimitedUndoMap> getUndoableRecords(BoxOp op) {
        BServerSession session = (BServerSession)((Object)op.get("serverSession"));
        if (session == null) {
            return Optional.empty();
        }
        SizeLimitedUndoMap recordMap = (SizeLimitedUndoMap)session.getAttribute("undoableRecords");
        if (recordMap == null) {
            recordMap = new SizeLimitedUndoMap(MAX_UNDO_HISTORY_SIZE);
            session.setAttribute("undoableRecords", recordMap);
        }
        return Optional.of(recordMap);
    }

    protected static Set<String> getComponentSpaceOrds(Mark mark) {
        HashSet<String> spaceOrds = new HashSet<String>();
        for (BObject obj : mark.getValues()) {
            BComponentSpace space = obj.asComponent().getComponentSpace();
            if (space == null) continue;
            spaceOrds.add(space.getAbsoluteOrd().toString());
        }
        return spaceOrds;
    }

    protected static Context getTransferContext(BoxOp boxOp) {
        WebOp webOp = boxOp.getWebOp();
        if (webOp == null) {
            return boxOp;
        }
        return webOp.getBaseOrdTarget();
    }

    private static class SizeLimitedUndoMap
    extends LinkedHashMap<String, UndoableRecord> {
        private static final long serialVersionUID = -1147622130394492037L;
        private final int sizeLimit;

        private SizeLimitedUndoMap(int sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        private synchronized String nextId() {
            String id;
            while (this.containsKey(id = Integer.toHexString(RAND.nextInt()))) {
            }
            return id;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, UndoableRecord> eldest) {
            return this.size() > this.sizeLimit;
        }
    }
}

