/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxService;
import com.tridium.box.BBoxWebSocketAcceptor;
import java.security.AccessController;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.baja.web.WebDev;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public final class BoxWebSocketServlet
extends WebSocketServlet {
    public static final long IDLE_TIMEOUT = AccessController.doPrivileged(() -> Long.getLong("box.ws.idleTimeout", 60000L));
    public static final int MAX_TEXT_MESSAGE_BUFFER_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.ws.maxTextMessageBufferSize", 65536));
    public static final int MAX_TEXT_MESSAGE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.ws.maxTextMessageSize", 262144));
    public static final int MAX_BINARY_MESSAGE_BUFFER_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.ws.maxBinaryMessageBufferSize", 65536));
    public static final int MAX_BINARY_MESSAGE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.ws.maxBinaryMessageSize", 131072));

    public void configure(WebSocketServletFactory factory) {
        WebSocketPolicy policy = factory.getPolicy();
        policy.setIdleTimeout(IDLE_TIMEOUT);
        policy.setMaxTextMessageBufferSize(MAX_TEXT_MESSAGE_BUFFER_SIZE);
        policy.setMaxTextMessageSize(MAX_TEXT_MESSAGE_SIZE);
        policy.setMaxBinaryMessageBufferSize(MAX_BINARY_MESSAGE_BUFFER_SIZE);
        policy.setMaxBinaryMessageSize(MAX_BINARY_MESSAGE_SIZE);
        factory.setCreator((WebSocketCreator)new BoxWebSocketCreator());
    }

    public static boolean isBinary() {
        return !WebDev.get((String)"bajaScript").isEnabled();
    }

    private static class BoxWebSocketCreator
    implements WebSocketCreator {
        private BoxWebSocketCreator() {
        }

        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            try {
                BBoxService boxService = (BBoxService)Sys.getService((Type)BBoxService.TYPE);
                BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
                if (boxService.isOperational() && boxService.getWebSocketAcceptor().isOperational() && (!webService.getHttpsEnabled() || !webService.getHttpsOnly() || req.isSecure())) {
                    return new BBoxWebSocketAcceptor.BoxWebSocket(req.getSession());
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }
}

