/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxService;
import com.tridium.util.SecurableContext;
import java.util.HashMap;
import java.util.Map;
import javax.baja.box.BBoxClientEnv;
import javax.baja.naming.BOrd;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;
import javax.baja.util.Version;
import javax.baja.web.BWebService;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.xml.XWriter;

public final class BoxOp
extends BasicContext
implements SecurableContext {
    private Map<Object, Object> requestMap = null;
    private BBoxClientEnv clientEnv = BBoxService.defaultClientEnv;
    private final boolean isSecure;
    private final String remoteAddr;
    public static final Version boxVersion1 = new Version("1");
    public static final Version boxVersion2 = new Version("2");
    public static final Version boxVersionLatest = new Version("2.4");
    private Version version = boxVersion1;

    public BoxOp(Context cx, boolean isSecure, String remoteAddr) {
        super(cx);
        this.isSecure = isSecure;
        this.remoteAddr = remoteAddr;
    }

    public Object get(Object key) {
        if (this.requestMap == null) {
            return null;
        }
        return this.requestMap.get(key);
    }

    public void put(Object key, Object value) {
        if (this.requestMap == null) {
            this.requestMap = new HashMap<Object, Object>();
        }
        this.requestMap.put(key, value);
    }

    public String getUsername() {
        BUser user = this.getUser();
        return user != null ? user.getUsername() : "";
    }

    public BOrd getHomePage() {
        WebOp webOp = this.getWebOp();
        BUser user = this.getUser();
        if (webOp != null) {
            IWebEnv webEnv = webOp.getWebEnv();
            if (webEnv != null) {
                return webEnv.getHomePage(webOp);
            }
        } else if (user != null) {
            return user.getHomePage();
        }
        return BOrd.NULL;
    }

    public BBoxClientEnv getClientEnv() {
        return this.clientEnv;
    }

    void setClientEnv(BBoxClientEnv clientEnv) {
        this.clientEnv = clientEnv;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isVersion2OrGreater() {
        return this.version.compareTo(boxVersion2) > -1;
    }

    void setVersion(String versionStr) {
        if (versionStr.equals("2.4")) {
            this.version = boxVersionLatest;
        } else {
            try {
                this.version = new Version(versionStr);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(XWriter.safeToString((String)e.getMessage(), (boolean)false));
            }
        }
    }

    public WebOp getWebOp() {
        Context cx;
        for (cx = this.getBase(); cx != null && !(cx instanceof WebOp); cx = cx.getBase()) {
        }
        return cx instanceof WebOp ? (WebOp)cx : null;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getProfileTypeSpec() {
        IWebEnv webEnv;
        String profile = "";
        WebOp webOp = this.getWebOp();
        if (webOp != null && (webEnv = webOp.getWebEnv()) != null) {
            profile = webEnv.getWebProfile(webOp).getType().toString();
        }
        return profile;
    }

    public BWebService getWebService() {
        WebOp webOp = this.getWebOp();
        if (webOp != null) {
            return webOp.getService();
        }
        return BWebService.getMainService();
    }

    public static boolean isWorkbench(BoxOp op) {
        return op.getFacets().getb("isWorkbench", false);
    }
}

